/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.sol;

import dev.jamesyox.kastro.sol.CalculateSolarStateKt;
import dev.jamesyox.kastro.sol.SolarEvent;
import dev.jamesyox.kastro.sol.SolarEventType;
import dev.jamesyox.kastro.util.ExtendedMath;
import dev.jamesyox.kastro.util.JulianDate;
import dev.jamesyox.kastro.util.JulianDateKt;
import dev.jamesyox.kastro.util.QuadraticInterpolation;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0096\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0016\u0010\t\u001a\u00020\nX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001d"}, d2={"Ldev/jamesyox/kastro/sol/NoonAndNadirSequence;", "Lkotlin/sequences/Sequence;", "Ldev/jamesyox/kastro/sol/SolarEvent;", "start", "Lkotlinx/datetime/Instant;", "latitude", "Ldev/jamesyox/kastro/util/Latitude;", "longitude", "Ldev/jamesyox/kastro/util/Longitude;", "limit", "Lkotlin/time/Duration;", "requestedCulminationEvents", "", "Ldev/jamesyox/kastro/sol/SolarEventType$Culmination;", "(Lkotlinx/datetime/Instant;DDJLjava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "isNadirRequested", "", "isNoonRequested", "D", "J", "limitTime", "calculateNextNoonAndNadir", "localStart", "calculateSolHeightRad", "", "jd", "Ldev/jamesyox/kastro/util/JulianDate;", "iterator", "", "kastro"})
@SourceDebugExtension(value={"SMAP\nNoonAndNadirSequence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoonAndNadirSequence.kt\ndev/jamesyox/kastro/sol/NoonAndNadirSequence\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,122:1\n603#2:123\n*S KotlinDebug\n*F\n+ 1 NoonAndNadirSequence.kt\ndev/jamesyox/kastro/sol/NoonAndNadirSequence\n*L\n119#1:123\n*E\n"})
public final class NoonAndNadirSequence
implements Sequence<SolarEvent> {
    @NotNull
    private final Instant start;
    private final double latitude;
    private final double longitude;
    private final long limit;
    @NotNull
    private final List<SolarEventType.Culmination> requestedCulminationEvents;
    @NotNull
    private final Instant limitTime;
    private final boolean isNadirRequested;
    private final boolean isNoonRequested;

    private NoonAndNadirSequence(Instant start, double latitude, double longitude, long limit, List<? extends SolarEventType.Culmination> requestedCulminationEvents) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter(requestedCulminationEvents, (String)"requestedCulminationEvents");
        this.start = start;
        this.latitude = latitude;
        this.longitude = longitude;
        this.limit = limit;
        this.requestedCulminationEvents = requestedCulminationEvents;
        this.limitTime = this.start.plus-LRDsOJo(this.limit);
        this.isNadirRequested = this.requestedCulminationEvents.contains(SolarEvent.Nadir.Companion);
        this.isNoonRequested = this.requestedCulminationEvents.contains(SolarEvent.Noon.Companion);
    }

    @NotNull
    public Iterator<SolarEvent> iterator() {
        if (this.requestedCulminationEvents.isEmpty()) {
            return SequencesKt.emptySequence().iterator();
        }
        return SequencesKt.flatten((Sequence)SequencesKt.generateSequence(this.calculateNextNoonAndNadir(this.start), (Function1)((Function1)new Function1<Sequence<? extends SolarEvent>, Sequence<? extends SolarEvent>>(this){
            final /* synthetic */ NoonAndNadirSequence this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Sequence<SolarEvent> invoke(@NotNull Sequence<? extends SolarEvent> it) {
                Sequence sequence;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                SolarEvent solarEvent = (SolarEvent)SequencesKt.lastOrNull(it);
                if (solarEvent != null && (solarEvent = solarEvent.getTime()) != null) {
                    SolarEvent solarEvent2 = solarEvent;
                    NoonAndNadirSequence noonAndNadirSequence = this.this$0;
                    SolarEvent lastTime = solarEvent2;
                    boolean bl = false;
                    sequence = lastTime.compareTo(NoonAndNadirSequence.access$getStart$p(noonAndNadirSequence).plus-LRDsOJo(NoonAndNadirSequence.access$getLimit$p(noonAndNadirSequence))) <= 0 ? NoonAndNadirSequence.access$calculateNextNoonAndNadir(noonAndNadirSequence, lastTime.plus-LRDsOJo(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS))) : null;
                } else {
                    sequence = null;
                }
                return sequence;
            }
        }))).iterator();
    }

    private final double calculateSolHeightRad(JulianDate jd) {
        return CalculateSolarStateKt.calculateSolarState-sNAg2yY(jd, this.latitude, this.longitude, 0.0).getTrueAltitudeRad$kastro();
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<SolarEvent> calculateNextNoonAndNadir(Instant localStart) {
        void $this$sortedBy$iv;
        QuadraticInterpolation qi;
        JulianDate julianDate = JulianDateKt.getJulianDate(localStart);
        int hour = 0;
        Ref.ObjectRef noon = new Ref.ObjectRef();
        Ref.ObjectRef nadir = new Ref.ObjectRef();
        double limitHours = (double)Duration.getInWholeMilliseconds-impl((long)this.limitTime.minus-5sfh64U(localStart)) / (double)Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS));
        int maxHours = (int)Math.ceil(limitHours);
        double yMinus = this.calculateSolHeightRad(julianDate.atHour((double)hour - 1.0));
        double y0 = this.calculateSolHeightRad(julianDate.atHour(hour));
        double yPlus = this.calculateSolHeightRad(julianDate.atHour((double)hour + 1.0));
        while (hour <= maxHours) {
            double xeHour;
            qi = QuadraticInterpolation.Companion.of(yMinus, y0, yPlus);
            double xeAbs = Math.abs(qi.getXe());
            if (xeAbs <= 1.0 && (xeHour = qi.getXe() + (double)hour) >= 0.0) {
                if (qi.isMaximum()) {
                    if (noon.element == null && this.isNoonRequested) {
                        noon.element = xeHour;
                    }
                } else if (nadir.element == null && this.isNadirRequested) {
                    nadir.element = xeHour;
                }
            }
            if (!(noon.element == null && this.isNoonRequested || nadir.element == null && this.isNadirRequested)) break;
            yMinus = y0;
            y0 = yPlus;
            yPlus = this.calculateSolHeightRad(julianDate.atHour((double)(++hour) + 1.0));
        }
        if (noon.element != null && this.isNoonRequested) {
            noon.element = ExtendedMath.INSTANCE.readjustMax(((Number)noon.element).doubleValue(), 2.0, 14, (Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(this, julianDate){
                final /* synthetic */ NoonAndNadirSequence this$0;
                final /* synthetic */ JulianDate $julianDate;
                {
                    this.this$0 = $receiver;
                    this.$julianDate = $julianDate;
                    super(1);
                }

                @NotNull
                public final Double invoke(double it) {
                    return NoonAndNadirSequence.access$calculateSolHeightRad(this.this$0, this.$julianDate.atHour(it));
                }
            }));
            if (((Number)noon.element).doubleValue() < 0.0 || ((Number)noon.element).doubleValue() >= limitHours) {
                noon.element = null;
            }
        }
        if (nadir.element != null && this.isNadirRequested) {
            nadir.element = ExtendedMath.INSTANCE.readjustMin(((Number)nadir.element).doubleValue(), 2.0, 14, (Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(this, julianDate){
                final /* synthetic */ NoonAndNadirSequence this$0;
                final /* synthetic */ JulianDate $julianDate;
                {
                    this.this$0 = $receiver;
                    this.$julianDate = $julianDate;
                    super(1);
                }

                @NotNull
                public final Double invoke(double it) {
                    return NoonAndNadirSequence.access$calculateSolHeightRad(this.this$0, this.$julianDate.atHour(it));
                }
            }));
            if (((Number)nadir.element).doubleValue() < 0.0 || ((Number)nadir.element).doubleValue() >= limitHours) {
                nadir.element = null;
            }
        }
        qi = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super SolarEvent>, Continuation<? super Unit>, Object>((Ref.ObjectRef<Double>)noon, (Ref.ObjectRef<Double>)nadir, julianDate, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Ref.ObjectRef<Double> $noon;
            final /* synthetic */ Ref.ObjectRef<Double> $nadir;
            final /* synthetic */ JulianDate $julianDate;
            {
                this.$noon = $noon;
                this.$nadir = $nadir;
                this.$julianDate = $julianDate;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                block9: {
                    Object object2;
                    void $result;
                    double it;
                    JulianDate julianDate;
                    Double d;
                    SequenceScope $this$sequence;
                    Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            $this$sequence = (SequenceScope)this.L$0;
                            Double d2 = (Double)this.$noon.element;
                            if (d2 == null) break;
                            d = d2;
                            julianDate = this.$julianDate;
                            it = ((Number)d).doubleValue();
                            boolean bl = false;
                            this.L$0 = $this$sequence;
                            this.L$1 = d;
                            this.label = 1;
                            Object object4 = $this$sequence.yield((Object)new SolarEvent.Noon(JulianDateKt.getInstant(julianDate.atHour(it))), (Continuation)this);
                            if (object4 == object3) {
                                return object3;
                            }
                            break;
                        }
                        case 1: {
                            boolean bl = false;
                            d = (Double)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            break;
                        }
                    }
                    Double d3 = (Double)this.$nadir.element;
                    if (d3 != null) {
                        d = d3;
                        julianDate = this.$julianDate;
                        it = ((Number)d).doubleValue();
                        boolean bl = false;
                        this.L$0 = d;
                        this.L$1 = null;
                        this.label = 2;
                        object2 = $this$sequence.yield((Object)new SolarEvent.Nadir(JulianDateKt.getInstant(julianDate.atHour(it))), (Continuation)this);
                        if (object2 == object3) {
                            return object3;
                        }
                    }
                    break block9;
                    {
                        case 2: {
                            boolean bl = false;
                            Double d4 = (Double)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                        }
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super SolarEvent>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super SolarEvent> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        boolean $i$f$sortedBy = false;
        return SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SolarEvent it = (SolarEvent)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getTime();
                it = (SolarEvent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getTime()));
            }
        });
    }

    public /* synthetic */ NoonAndNadirSequence(Instant start, double latitude, double longitude, long limit, List requestedCulminationEvents, DefaultConstructorMarker $constructor_marker) {
        this(start, latitude, longitude, limit, requestedCulminationEvents);
    }

    public static final /* synthetic */ Instant access$getStart$p(NoonAndNadirSequence $this) {
        return $this.start;
    }

    public static final /* synthetic */ long access$getLimit$p(NoonAndNadirSequence $this) {
        return $this.limit;
    }

    public static final /* synthetic */ Sequence access$calculateNextNoonAndNadir(NoonAndNadirSequence $this, Instant localStart) {
        return $this.calculateNextNoonAndNadir(localStart);
    }

    public static final /* synthetic */ double access$calculateSolHeightRad(NoonAndNadirSequence $this, JulianDate jd) {
        return $this.calculateSolHeightRad(jd);
    }
}

