/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.luna;

import dev.jamesyox.kastro.common.HorizonMovementState;
import dev.jamesyox.kastro.common.HorizonMovementStateKt;
import dev.jamesyox.kastro.common.HorizonState;
import dev.jamesyox.kastro.luna.LunarIllumination;
import dev.jamesyox.kastro.luna.LunarPhase;
import dev.jamesyox.kastro.luna.LunarPosition;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Ldev/jamesyox/kastro/luna/LunarState;", "", "position", "Ldev/jamesyox/kastro/luna/LunarPosition;", "illumination", "Ldev/jamesyox/kastro/luna/LunarIllumination;", "(Ldev/jamesyox/kastro/luna/LunarPosition;Ldev/jamesyox/kastro/luna/LunarIllumination;)V", "horizonMovementState", "Ldev/jamesyox/kastro/common/HorizonMovementState;", "getHorizonMovementState", "()Ldev/jamesyox/kastro/common/HorizonMovementState;", "horizonState", "Ldev/jamesyox/kastro/common/HorizonState;", "getHorizonState", "()Ldev/jamesyox/kastro/common/HorizonState;", "getIllumination", "()Ldev/jamesyox/kastro/luna/LunarIllumination;", "phase", "Ldev/jamesyox/kastro/luna/LunarPhase$Intermediate;", "getPhase", "()Ldev/jamesyox/kastro/luna/LunarPhase$Intermediate;", "getPosition", "()Ldev/jamesyox/kastro/luna/LunarPosition;", "equals", "", "other", "hashCode", "", "toString", "", "kastro"})
public final class LunarState {
    @NotNull
    private final LunarPosition position;
    @NotNull
    private final LunarIllumination illumination;
    @NotNull
    private final LunarPhase.Intermediate phase;
    @NotNull
    private final HorizonState horizonState;
    @NotNull
    private final HorizonMovementState horizonMovementState;

    public LunarState(@NotNull LunarPosition position, @NotNull LunarIllumination illumination) {
        HorizonState horizonState;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)illumination, (String)"illumination");
        this.position = position;
        this.illumination = illumination;
        this.phase = LunarPhase.Companion.lunarPhase(this.illumination.getPhase());
        boolean bl2 = bl = this.position.getAltitude() > 0.0;
        if (bl) {
            horizonState = HorizonState.Up;
        } else if (!bl) {
            horizonState = HorizonState.Down;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.horizonState = horizonState;
        this.horizonMovementState = HorizonMovementStateKt.fromAzimuth(this.position.getAzimuth());
    }

    @NotNull
    public final LunarPosition getPosition() {
        return this.position;
    }

    @NotNull
    public final LunarIllumination getIllumination() {
        return this.illumination;
    }

    @NotNull
    public final LunarPhase.Intermediate getPhase() {
        return this.phase;
    }

    @NotNull
    public final HorizonState getHorizonState() {
        return this.horizonState;
    }

    @NotNull
    public final HorizonMovementState getHorizonMovementState() {
        return this.horizonMovementState;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LunarState cfr_ignored_0 = (LunarState)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)((LunarState)other).position)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.illumination, (Object)((LunarState)other).illumination);
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + this.illumination.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "LunarState(position=" + this.position + ", illumination=" + this.illumination + ", phase=" + this.phase + ", horizonState=" + (Object)((Object)this.horizonState) + ')';
    }
}

