/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.luna;

import dev.jamesyox.kastro.luna.LunarEvent;
import dev.jamesyox.kastro.luna.LunarPhase;
import dev.jamesyox.kastro.luna.LunarPhaseKt;
import dev.jamesyox.kastro.luna.LunarPhaseSequence;
import dev.jamesyox.kastro.util.JulianDate;
import dev.jamesyox.kastro.util.JulianDateKt;
import dev.jamesyox.kastro.util.KUtilsKt;
import dev.jamesyox.kastro.util.Moon;
import dev.jamesyox.kastro.util.Pegasus;
import dev.jamesyox.kastro.util.Sol;
import dev.jamesyox.kastro.util.Vector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\tH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0096\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0013H\u0002R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0016"}, d2={"Ldev/jamesyox/kastro/luna/LunarPhaseSequence;", "Lkotlin/sequences/Sequence;", "Ldev/jamesyox/kastro/luna/LunarEvent$PhaseEvent;", "start", "Lkotlinx/datetime/Instant;", "limit", "Lkotlin/time/Duration;", "requestedLunarPhases", "", "Ldev/jamesyox/kastro/luna/LunarPhase$Primary;", "(Lkotlinx/datetime/Instant;JLjava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "calculateNextLunarPhaseEvent", "phase", "calculateNextLunarPhaseEvents", "startingAt", "iterator", "", "lunarPhase", "", "ephemerisTime", "Companion", "kastro"})
@SourceDebugExtension(value={"SMAP\nLunarPhaseSequence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LunarPhaseSequence.kt\ndev/jamesyox/kastro/luna/LunarPhaseSequence\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1603#2,9:105\n1855#2:114\n1856#2:116\n1612#2:117\n1045#2:118\n1#3:115\n*S KotlinDebug\n*F\n+ 1 LunarPhaseSequence.kt\ndev/jamesyox/kastro/luna/LunarPhaseSequence\n*L\n62#1:105,9\n62#1:114\n62#1:116\n62#1:117\n64#1:118\n62#1:115\n*E\n"})
public final class LunarPhaseSequence
implements Sequence<LunarEvent.PhaseEvent> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant start;
    private final long limit;
    @NotNull
    private final List<LunarPhase.Primary> requestedLunarPhases;
    private static final double SUN_LIGHT_TIME_TAU = 1.5818693436763253E-7;

    private LunarPhaseSequence(Instant start, long limit, List<? extends LunarPhase.Primary> requestedLunarPhases) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter(requestedLunarPhases, (String)"requestedLunarPhases");
        this.start = start;
        this.limit = limit;
        this.requestedLunarPhases = requestedLunarPhases;
    }

    public /* synthetic */ LunarPhaseSequence(Instant instant, long l, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = DurationKt.toDuration((int)365, (DurationUnit)DurationUnit.DAYS);
        }
        if ((n & 4) != 0) {
            list = LunarPhase.Primary.Companion.getAll();
        }
        this(instant, l, list, null);
    }

    @NotNull
    public Iterator<LunarEvent.PhaseEvent> iterator() {
        return SequencesKt.flatMap((Sequence)SequencesKt.generateSequence(this.calculateNextLunarPhaseEvents(this.start), (Function1)((Function1)new Function1<List<? extends LunarEvent.PhaseEvent>, List<? extends LunarEvent.PhaseEvent>>(this){
            final /* synthetic */ LunarPhaseSequence this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final List<LunarEvent.PhaseEvent> invoke(@NotNull List<? extends LunarEvent.PhaseEvent> moonPhaseEvents) {
                List list;
                Intrinsics.checkNotNullParameter(moonPhaseEvents, (String)"moonPhaseEvents");
                LunarEvent.PhaseEvent phaseEvent = (LunarEvent.PhaseEvent)CollectionsKt.lastOrNull(moonPhaseEvents);
                if (phaseEvent != null) {
                    LunarEvent.PhaseEvent phaseEvent2 = phaseEvent;
                    LunarPhaseSequence lunarPhaseSequence = this.this$0;
                    LunarEvent.PhaseEvent last = phaseEvent2;
                    boolean bl = false;
                    list = LunarPhaseSequence.access$calculateNextLunarPhaseEvents(lunarPhaseSequence, last.getTime().plus-LRDsOJo(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)));
                } else {
                    list = null;
                }
                return list;
            }
        })), (Function1)iterator.2.INSTANCE).iterator();
    }

    /*
     * WARNING - void declaration
     */
    private final List<LunarEvent.PhaseEvent> calculateNextLunarPhaseEvents(Instant startingAt) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.requestedLunarPhases;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LunarEvent.PhaseEvent it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            LunarPhase.Primary it = (LunarPhase.Primary)element$iv$iv;
            boolean bl2 = false;
            if (this.calculateNextLunarPhaseEvent(startingAt, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LunarEvent.PhaseEvent it = (LunarEvent.PhaseEvent)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getTime();
                it = (LunarEvent.PhaseEvent)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getTime()));
            }
        });
    }

    private final LunarEvent.PhaseEvent calculateNextLunarPhaseEvent(Instant start, LunarPhase.Primary phase) {
        double dT = 1.916495550992471E-4;
        double accuracy = 9.506426344208685E-9;
        double t0 = JulianDateKt.getJulianDate(start).getJulianCentury$kastro();
        double t1 = t0 + dT;
        double d0 = this.lunarPhase(t0, KUtilsKt.getRadians(phase.getPhase()));
        double d1 = this.lunarPhase(t1, KUtilsKt.getRadians(phase.getPhase()));
        while (d0 * d1 > 0.0 || d1 < d0) {
            t0 = t1;
            d0 = d1;
            d1 = this.lunarPhase(t1 += dT, KUtilsKt.getRadians(phase.getPhase()));
        }
        double tPhase2 = Pegasus.INSTANCE.calculate(t0, t1, accuracy, (Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(this, phase){
            final /* synthetic */ LunarPhaseSequence this$0;
            final /* synthetic */ LunarPhase.Primary $phase;
            {
                this.this$0 = $receiver;
                this.$phase = $phase;
                super(1);
            }

            @NotNull
            public final Double invoke(double it) {
                return LunarPhaseSequence.access$lunarPhase(this.this$0, it, KUtilsKt.getRadians(this.$phase.getPhase()));
            }
        }));
        JulianDate tjd = JulianDateKt.atJulianCentury(tPhase2);
        return JulianDateKt.getInstant(tjd).compareTo(this.start.plus-LRDsOJo(this.limit)) <= 0 ? LunarPhaseKt.phaseInformation(phase, JulianDateKt.getInstant(tjd)) : null;
    }

    private final double lunarPhase(double ephemerisTime, double phase) {
        double diff;
        Vector sun = Sol.INSTANCE.positionEquatorial(JulianDateKt.atJulianCentury(ephemerisTime - 1.5818693436763253E-7));
        Vector moon = Moon.INSTANCE.positionEquatorial(JulianDateKt.atJulianCentury(ephemerisTime));
        for (diff = moon.getPhi() - sun.getPhi() - phase; diff < 0.0; diff += Math.PI * 2) {
        }
        return (diff + Math.PI) % (Math.PI * 2) - Math.PI;
    }

    public /* synthetic */ LunarPhaseSequence(Instant start, long limit, List requestedLunarPhases, DefaultConstructorMarker $constructor_marker) {
        this(start, limit, requestedLunarPhases);
    }

    public static final /* synthetic */ List access$calculateNextLunarPhaseEvents(LunarPhaseSequence $this, Instant startingAt) {
        return $this.calculateNextLunarPhaseEvents(startingAt);
    }

    public static final /* synthetic */ double access$lunarPhase(LunarPhaseSequence $this, double ephemerisTime, double phase) {
        return $this.lunarPhase(ephemerisTime, phase);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldev/jamesyox/kastro/luna/LunarPhaseSequence$Companion;", "", "()V", "SUN_LIGHT_TIME_TAU", "", "kastro"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

