/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.luna;

import dev.jamesyox.kastro.luna.InternalLunarHorizonEvent;
import dev.jamesyox.kastro.luna.LunarEvent;
import dev.jamesyox.kastro.luna.LunarHorizonEventSequence;
import dev.jamesyox.kastro.luna.LunarHorizonEventSequenceKt;
import dev.jamesyox.kastro.luna.SearchMode;
import dev.jamesyox.kastro.util.ExtendedMath;
import dev.jamesyox.kastro.util.JulianDate;
import dev.jamesyox.kastro.util.JulianDateKt;
import dev.jamesyox.kastro.util.LocationKt;
import dev.jamesyox.kastro.util.Moon;
import dev.jamesyox.kastro.util.QuadraticInterpolation;
import dev.jamesyox.kastro.util.Vector;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B=\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0096\u0002R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\b\u001a\u00020\tX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006!"}, d2={"Ldev/jamesyox/kastro/luna/LunarHorizonEventSequence;", "Lkotlin/sequences/Sequence;", "Ldev/jamesyox/kastro/luna/LunarEvent$HorizonEvent;", "start", "Lkotlinx/datetime/Instant;", "location", "Lkotlin/Pair;", "", "limit", "Lkotlin/time/Duration;", "requestedHorizonEvents", "", "Ldev/jamesyox/kastro/luna/LunarEvent$HorizonEvent$HorizonEventType;", "(Lkotlinx/datetime/Instant;Lkotlin/Pair;JLjava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "latitude", "longitude", "(Lkotlinx/datetime/Instant;DDJLjava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "height", "lat", "Ldev/jamesyox/kastro/util/Latitude;", "D", "J", "lon", "Ldev/jamesyox/kastro/util/Longitude;", "refraction", "execute", "Ldev/jamesyox/kastro/luna/InternalLunarHorizonEvent;", "startHour", "", "mode", "Ldev/jamesyox/kastro/luna/SearchMode;", "iterator", "", "kastro"})
public final class LunarHorizonEventSequence
implements Sequence<LunarEvent.HorizonEvent> {
    @NotNull
    private final Instant start;
    private final long limit;
    @NotNull
    private final List<LunarEvent.HorizonEvent.HorizonEventType> requestedHorizonEvents;
    private final double refraction;
    private final double lat;
    private final double lon;
    private final double height;

    private LunarHorizonEventSequence(Instant start, double latitude, double longitude, long limit, List<? extends LunarEvent.HorizonEvent.HorizonEventType> requestedHorizonEvents) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter(requestedHorizonEvents, (String)"requestedHorizonEvents");
        this.start = start;
        this.limit = limit;
        this.requestedHorizonEvents = requestedHorizonEvents;
        this.refraction = ExtendedMath.INSTANCE.apparentRefraction(0.0);
        this.lat = LocationKt.getLatitude(latitude);
        this.lon = LocationKt.getLongitude(longitude);
    }

    public /* synthetic */ LunarHorizonEventSequence(Instant instant, double d, double d2, long l, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = DurationKt.toDuration((int)365, (DurationUnit)DurationUnit.DAYS);
        }
        if ((n & 0x10) != 0) {
            list = LunarEvent.HorizonEvent.Companion.getAll();
        }
        this(instant, d, d2, l, list, null);
    }

    private LunarHorizonEventSequence(Instant start, Pair<Double, Double> location, long limit, List<? extends LunarEvent.HorizonEvent.HorizonEventType> requestedHorizonEvents) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter(location, (String)"location");
        Intrinsics.checkNotNullParameter(requestedHorizonEvents, (String)"requestedHorizonEvents");
        this(start, ((Number)location.getFirst()).doubleValue(), ((Number)location.getSecond()).doubleValue(), limit, requestedHorizonEvents, null);
    }

    public /* synthetic */ LunarHorizonEventSequence(Instant instant, Pair pair, long l, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = DurationKt.toDuration((int)365, (DurationUnit)DurationUnit.DAYS);
        }
        if ((n & 8) != 0) {
            list = LunarEvent.HorizonEvent.Companion.getAll();
        }
        this(instant, pair, l, list, null);
    }

    @NotNull
    public Iterator<LunarEvent.HorizonEvent> iterator() {
        if (this.requestedHorizonEvents.isEmpty()) {
            return SequencesKt.emptySequence().iterator();
        }
        return SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)this.execute(), (Function1)((Function1)new Function1<InternalLunarHorizonEvent, InternalLunarHorizonEvent>(this){
            final /* synthetic */ LunarHorizonEventSequence this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final InternalLunarHorizonEvent invoke(@NotNull InternalLunarHorizonEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LunarHorizonEventSequence.access$execute(this.this$0, it.getHour() + 1, it instanceof InternalLunarHorizonEvent.RiseResult ? SearchMode.SET : SearchMode.RISE);
            }
        })), (Function1)iterator.2.INSTANCE), (Function1)((Function1)new Function1<LunarEvent.HorizonEvent, Boolean>(this){
            final /* synthetic */ LunarHorizonEventSequence this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull LunarEvent.HorizonEvent it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LunarEvent.HorizonEvent horizonEvent = it;
                if (horizonEvent instanceof LunarEvent.HorizonEvent.Moonrise) {
                    bl = LunarHorizonEventSequence.access$getRequestedHorizonEvents$p(this.this$0).contains(LunarEvent.HorizonEvent.Moonrise.Companion);
                } else if (horizonEvent instanceof LunarEvent.HorizonEvent.Moonset) {
                    bl = LunarHorizonEventSequence.access$getRequestedHorizonEvents$p(this.this$0).contains(LunarEvent.HorizonEvent.Moonset.Companion);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return bl;
            }
        })).iterator();
    }

    private final InternalLunarHorizonEvent execute() {
        InternalLunarHorizonEvent internalLunarHorizonEvent;
        InternalLunarHorizonEvent rise = this.execute(0, SearchMode.RISE);
        InternalLunarHorizonEvent set = this.execute(0, SearchMode.SET);
        if (rise != null && set != null) {
            internalLunarHorizonEvent = rise.getHour() < set.getHour() ? rise : set;
        } else {
            internalLunarHorizonEvent = rise;
            if (internalLunarHorizonEvent == null) {
                internalLunarHorizonEvent = set;
            }
        }
        return internalLunarHorizonEvent;
    }

    private final InternalLunarHorizonEvent execute(int startHour, SearchMode mode) {
        JulianDate julianDate = JulianDateKt.getJulianDate(this.start);
        double ye = 0.0;
        int hour = 0;
        hour = startHour;
        double limitHours = (double)Duration.getInWholeMilliseconds-impl((long)this.limit) / 3600000.0;
        int maxHours = (int)Math.ceil(limitHours);
        double yMinus = LunarHorizonEventSequence.execute$correctedLunarHeight(this, julianDate.atHour((double)hour - 1.0));
        double y0 = LunarHorizonEventSequence.execute$correctedLunarHeight(this, julianDate.atHour(hour));
        double yPlus = LunarHorizonEventSequence.execute$correctedLunarHeight(this, julianDate.atHour((double)hour + 1.0));
        while (hour <= maxHours) {
            QuadraticInterpolation qi = QuadraticInterpolation.Companion.of(yMinus, y0, yPlus);
            ye = qi.getYe();
            if (qi.getNumberOfRoots() == 1) {
                double rt = qi.getRoot1() + (double)hour;
                if (yMinus < 0.0) {
                    if (rt >= 0.0 && rt < limitHours && LunarHorizonEventSequenceKt.access$getCheckRise(mode)) {
                        return new InternalLunarHorizonEvent.RiseResult(julianDate, rt, hour);
                    }
                } else if (rt >= 0.0 && rt < limitHours && LunarHorizonEventSequenceKt.access$getCheckSet(mode)) {
                    return new InternalLunarHorizonEvent.SetResult(julianDate, rt, hour);
                }
            } else if (qi.getNumberOfRoots() == 2) {
                double rt = (double)hour + (ye < 0.0 ? qi.getRoot2() : qi.getRoot1());
                boolean bl = false;
                if (rt >= 0.0 && rt < limitHours && LunarHorizonEventSequenceKt.access$getCheckRise(mode)) {
                    return new InternalLunarHorizonEvent.RiseResult(julianDate, rt, hour);
                }
                rt = (double)hour + (ye < 0.0 ? qi.getRoot1() : qi.getRoot2());
                boolean bl2 = false;
                if (rt >= 0.0 && rt < limitHours && LunarHorizonEventSequenceKt.access$getCheckSet(mode)) {
                    return new InternalLunarHorizonEvent.SetResult(julianDate, rt, hour);
                }
            }
            int n = hour;
            hour = n + 1;
            yMinus = y0;
            y0 = yPlus;
            yPlus = LunarHorizonEventSequence.execute$correctedLunarHeight(this, julianDate.atHour((double)hour + 1.0));
        }
        return null;
    }

    private static final double execute$correctedLunarHeight(LunarHorizonEventSequence this$0, JulianDate jd) {
        Vector pos = Moon.INSTANCE.positionHorizontal-1Yd9cXA(jd, this$0.lat, this$0.lon);
        double hc = ExtendedMath.INSTANCE.parallax(this$0.height, pos.getR()) - this$0.refraction - Moon.INSTANCE.angularRadius(pos.getR());
        return pos.getTheta() - hc;
    }

    public /* synthetic */ LunarHorizonEventSequence(Instant start, double latitude, double longitude, long limit, List requestedHorizonEvents, DefaultConstructorMarker $constructor_marker) {
        this(start, latitude, longitude, limit, requestedHorizonEvents);
    }

    public /* synthetic */ LunarHorizonEventSequence(Instant start, Pair location, long limit, List requestedHorizonEvents, DefaultConstructorMarker $constructor_marker) {
        this(start, (Pair<Double, Double>)location, limit, requestedHorizonEvents);
    }

    public static final /* synthetic */ InternalLunarHorizonEvent access$execute(LunarHorizonEventSequence $this, int startHour, SearchMode mode) {
        return $this.execute(startHour, mode);
    }

    public static final /* synthetic */ List access$getRequestedHorizonEvents$p(LunarHorizonEventSequence $this) {
        return $this.requestedHorizonEvents;
    }
}

