/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.luna;

import dev.jamesyox.kastro.luna.CalculateLunarDistanceKt;
import dev.jamesyox.kastro.luna.LunarPosition;
import dev.jamesyox.kastro.util.ExtendedMath;
import dev.jamesyox.kastro.util.JulianDate;
import dev.jamesyox.kastro.util.JulianDateKt;
import dev.jamesyox.kastro.util.KUtilsKt;
import dev.jamesyox.kastro.util.LocationKt;
import dev.jamesyox.kastro.util.Moon;
import dev.jamesyox.kastro.util.Vector;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000e"}, d2={"calculateLunarPosition", "Ldev/jamesyox/kastro/luna/LunarPosition;", "julianDate", "Ldev/jamesyox/kastro/util/JulianDate;", "latitude", "Ldev/jamesyox/kastro/util/Latitude;", "longitude", "Ldev/jamesyox/kastro/util/Longitude;", "calculateLunarPosition-1Yd9cXA", "(Ldev/jamesyox/kastro/util/JulianDate;DD)Ldev/jamesyox/kastro/luna/LunarPosition;", "Lkotlinx/datetime/Instant;", "", "location", "Lkotlin/Pair;", "kastro"})
public final class CalculateLunarPositionKt {
    @NotNull
    public static final LunarPosition calculateLunarPosition(@NotNull Instant $this$calculateLunarPosition, double latitude, double longitude) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateLunarPosition, (String)"<this>");
        return CalculateLunarPositionKt.calculateLunarPosition-1Yd9cXA(JulianDateKt.getJulianDate($this$calculateLunarPosition), LocationKt.getLatitude(latitude), LocationKt.getLongitude(longitude));
    }

    @NotNull
    public static final LunarPosition calculateLunarPosition(@NotNull Instant $this$calculateLunarPosition, @NotNull Pair<Double, Double> location) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateLunarPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter(location, (String)"location");
        return CalculateLunarPositionKt.calculateLunarPosition($this$calculateLunarPosition, ((Number)location.getFirst()).doubleValue(), ((Number)location.getSecond()).doubleValue());
    }

    private static final LunarPosition calculateLunarPosition-1Yd9cXA(JulianDate julianDate, double latitude, double longitude) {
        Vector mc = Moon.INSTANCE.position(julianDate);
        double h = JulianDateKt.getGreenwichMeanSiderealTime(julianDate) + LocationKt.getRadians-mSaymZU(longitude) - mc.getPhi();
        Vector horizontal = ExtendedMath.INSTANCE.equatorialToHorizontal-0GiciWk(h, mc.getTheta(), mc.getR(), latitude);
        double hRef = ExtendedMath.INSTANCE.refraction(horizontal.getTheta());
        double pa = Math.atan2(Math.sin(h), Math.tan(LocationKt.getRadians-zLPoVEA(latitude)) * Math.cos(mc.getTheta()) - Math.sin(mc.getTheta()) * Math.cos(h));
        double d = (KUtilsKt.getDegrees(horizontal.getPhi()) + 180.0) % 360.0;
        double d2 = KUtilsKt.getDegrees(horizontal.getTheta() + hRef);
        double d3 = CalculateLunarDistanceKt.calculateLunarDistance(julianDate);
        return new LunarPosition(d3, d, d2, pa);
    }
}

