/*
 * Decompiled with CFR 0.152.
 */
package dev.jamesyox.kastro.luna;

import dev.jamesyox.kastro.luna.LunarIllumination;
import dev.jamesyox.kastro.util.JulianDate;
import dev.jamesyox.kastro.util.JulianDateKt;
import dev.jamesyox.kastro.util.KUtilsKt;
import dev.jamesyox.kastro.util.Moon;
import dev.jamesyox.kastro.util.Sol;
import dev.jamesyox.kastro.util.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0004\u00a8\u0006\u0005"}, d2={"calculateLunarIllumination", "Ldev/jamesyox/kastro/luna/LunarIllumination;", "jd", "Ldev/jamesyox/kastro/util/JulianDate;", "Lkotlinx/datetime/Instant;", "kastro"})
public final class CalculateLunarIlluminationKt {
    @NotNull
    public static final LunarIllumination calculateLunarIllumination(@NotNull Instant $this$calculateLunarIllumination) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateLunarIllumination, (String)"<this>");
        return CalculateLunarIlluminationKt.calculateLunarIllumination(JulianDateKt.getJulianDate($this$calculateLunarIllumination));
    }

    private static final LunarIllumination calculateLunarIllumination(JulianDate jd) {
        Vector s = Sol.INSTANCE.position(jd);
        Vector m = Moon.INSTANCE.position(jd);
        double phi = Math.PI - Math.acos(m.dot(s) / (m.getR() * s.getR()));
        Vector sunMoon = m.cross(s);
        double angle = Math.atan2(Math.cos(s.getTheta()) * Math.sin(s.getPhi() - m.getPhi()), Math.sin(s.getTheta()) * Math.cos(m.getTheta()) - Math.cos(s.getTheta()) * Math.sin(m.getTheta()) * Math.cos(s.getPhi() - m.getPhi()));
        return new LunarIllumination((1.0 + Math.cos(phi)) / (double)2, KUtilsKt.getDegrees(phi * Math.signum(sunMoon.getTheta())) + 180.0, KUtilsKt.getDegrees(angle));
    }
}

