package app.config;

import eco.m1.annotate.Dependency;
import eco.m1.jdbc.BasicDataSource;
import eco.m1.support.M1Helper;

public class DbConfig {

    public static final String DB = "starter";

    @Dependency
    public BasicDataSource dataSource(){
        String url = "jdbc:h2:tcp://localhost:9092/" + M1Helper.getH2Path(DB);
        BasicDataSource basicDataSource = new BasicDataSource.Builder()
                            .dbName(DB)
                            .driver("org.h2.Driver")
                            .url(url)
                            .username("sa")
                            .password("")
                            .build();
        return basicDataSource;
    }

}
