/*
 * Decompiled with CFR 0.152.
 */
package test;

import eos.annotate.Bind;
import eos.annotate.Service;
import eos.model.web.HttpRequest;
import eos.model.web.HttpResponse;
import eos.util.Support;
import java.util.List;
import test.Todo;
import test.TodoRepo;

@Service
public class TodoService {
    @Bind
    Support support;
    @Bind
    TodoRepo todoRepo;

    public String getList(HttpResponse resp) {
        List<Todo> todos = this.todoRepo.getList();
        resp.set("todos", todos);
        return "/pages/todo/list.htm";
    }

    public String saveTodo(HttpRequest req, HttpResponse resp) {
        Todo todo = (Todo)this.support.get(req, Todo.class);
        this.todoRepo.save(todo);
        resp.set("message", "Successfully added todo!");
        return "[redirect]/todos";
    }

    public String getEdit(Long id, HttpResponse resp) {
        Todo todo = this.todoRepo.getById(id);
        resp.set("todo", todo);
        return "/pages/todo/edit.htm";
    }

    public String updateTodo(Long id, HttpRequest req, HttpResponse resp) {
        Todo todo = this.todoRepo.getById(id);
        todo.setTitle(req.value("title"));
        this.todoRepo.update(todo);
        resp.set("message", "Successfully updated todo!");
        return "[redirect]/todos/edit/" + todo.getId();
    }

    public String deleteTodo(Long id, HttpResponse resp) {
        this.todoRepo.delete(id);
        resp.set("message", "Successfully deleted todo!");
        return "[redirect]/todos";
    }
}

