/*
 * Decompiled with CFR 0.152.
 */
package test;

import eos.annotate.Bind;
import eos.annotate.HttpHandler;
import eos.annotate.Variable;
import eos.annotate.verbs.Get;
import eos.annotate.verbs.Post;
import eos.model.web.HttpRequest;
import eos.model.web.HttpResponse;
import test.TodoService;

@HttpHandler
public class TodoHandler {
    @Bind
    TodoService todoService;

    @Get(value="/")
    public String hi() {
        return "/pages/index.htm";
    }

    @Get(value="/todos")
    public String getList(HttpResponse resp) {
        return this.todoService.getList(resp);
    }

    @Get(value="/todos/create")
    public String getCreate() {
        return "/pages/todo/create.htm";
    }

    @Post(value="/todos/save")
    public String saveTodo(HttpRequest req, HttpResponse resp) {
        return this.todoService.saveTodo(req, resp);
    }

    @Get(value="/todos/edit/{{id}}")
    public String getEdit(HttpResponse resp, @Variable Long id) {
        return this.todoService.getEdit(id, resp);
    }

    @Post(value="/todos/update/{{id}}")
    public String updateTodo(HttpRequest req, HttpResponse resp, @Variable Long id) {
        return this.todoService.updateTodo(id, req, resp);
    }

    @Post(value="/todos/delete/{{id}}")
    public String deleteTodo(HttpResponse resp, @Variable Long id) {
        return this.todoService.deleteTodo(id, resp);
    }
}

