/*
 * Decompiled with CFR 0.152.
 */
package eos.web;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import eos.Eos;
import eos.annotate.Design;
import eos.annotate.JsonOutput;
import eos.annotate.Layout;
import eos.annotate.Media;
import eos.annotate.Plain;
import eos.annotate.Text;
import eos.annotate.Title;
import eos.model.web.EndpointMapping;
import eos.model.web.EndpointPosition;
import eos.model.web.HttpRequest;
import eos.model.web.HttpResponse;
import eos.model.web.HttpSession;
import eos.model.web.UrlBit;
import eos.model.web.UrlBitFeatures;
import eos.processor.UxProcessor;
import eos.util.MimeGetter;
import eos.util.ResourceResponse;
import eos.util.Support;
import eos.util.UriTranslator;
import eos.web.ElementCompiler;
import eos.web.Interceptor;
import eos.web.Pointcut;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpTransmission
implements HttpHandler {
    public static final String REDIRECT = "[redirect]";
    Eos.Cache cache;
    Support support;
    Map<String, HttpSession> sessions;

    public HttpTransmission(Eos.Cache cache) {
        this.cache = cache;
        this.support = new Support();
        this.sessions = new ConcurrentHashMap<String, HttpSession>();
    }

    @Override
    public void handle(HttpExchange httpExchange) {
        OutputStream outputStream = httpExchange.getResponseBody();
        try {
            Object object;
            String methodResponse;
            Title annotation;
            EndpointMapping endpointMapping;
            InputStream is = httpExchange.getRequestBody();
            byte[] payloadBytes = this.support.getPayloadBytes(is);
            ElementCompiler requestCompiler = new ElementCompiler(this.cache, payloadBytes, this.sessions, httpExchange);
            HttpRequest httpRequest = requestCompiler.compile();
            String payload = this.support.getPayload(payloadBytes);
            httpRequest.setRequestBody(payload);
            Map<String, Interceptor> interceptors = this.cache.getInterceptors();
            for (Map.Entry<String, Interceptor> entry : interceptors.entrySet()) {
                Interceptor interceptor = entry.getValue();
                interceptor.intercept(httpRequest, httpExchange);
            }
            UriTranslator transformer = new UriTranslator(this.support, httpExchange);
            String requestUri = transformer.translate();
            httpRequest.setValues(transformer.getParameters());
            String httpVerb = httpExchange.getRequestMethod().toLowerCase();
            if (ResourceResponse.isResource(requestUri, this.cache).booleanValue()) {
                new ResourceResponse.Builder().withCache(this.cache).withRequestUri(requestUri).withHttpVerb(httpVerb).withHttpExchange(httpExchange).make().serve();
                return;
            }
            HttpResponse httpResponse = this.getHttpResponse(httpExchange);
            if (httpRequest.getSession() != null) {
                HttpSession httpSession = httpRequest.getSession();
                HashMap session = new HashMap();
                for (Map.Entry<String, Object> entry : httpSession.data().entrySet()) {
                    String key = entry.getKey();
                    String value = String.valueOf(entry.getValue());
                    httpResponse.set(key, value);
                }
            }
            if ((endpointMapping = this.getHttpMapping(httpVerb, requestUri)) == null) {
                try {
                    String message = "404 not found.";
                    httpExchange.sendResponseHeaders(200, message.length());
                    outputStream.write(message.getBytes());
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            Object[] signature = this.getEndpointParameters(requestUri, httpRequest, httpResponse, endpointMapping, httpExchange);
            Method method = endpointMapping.getMethod();
            method.setAccessible(true);
            String title = "";
            if (method.isAnnotationPresent(Title.class) && (annotation = method.getAnnotation(Title.class)) != null) {
                title = annotation.value();
            }
            String design = null;
            if (method.isAnnotationPresent(Design.class) || method.isAnnotationPresent(Layout.class)) {
                Layout annotation2 = method.getAnnotation(Layout.class);
                if (annotation2 != null) {
                    design = annotation2.value();
                } else {
                    Design annotationDos = method.getAnnotation(Design.class);
                    design = annotationDos.value();
                }
            }
            if ((methodResponse = (String)method.invoke(object = endpointMapping.getClassDetails().getObject(), signature)) == null) {
                throw new Exception("something went wrong when calling " + method);
            }
            if (method.isAnnotationPresent(Text.class) || method.isAnnotationPresent(Plain.class)) {
                Headers headers = httpExchange.getResponseHeaders();
                headers.add("content-type", "text/html");
                httpExchange.sendResponseHeaders(200, methodResponse.length());
                outputStream.write(methodResponse.getBytes());
            } else if (method.isAnnotationPresent(JsonOutput.class)) {
                Headers headers = httpExchange.getResponseHeaders();
                headers.add("content-type", "application/json");
                httpExchange.sendResponseHeaders(200, methodResponse.length());
                outputStream.write(methodResponse.getBytes());
            } else if (method.isAnnotationPresent(Media.class)) {
                MimeGetter mimeGetter = new MimeGetter(requestUri);
                Headers headers = httpExchange.getResponseHeaders();
                headers.add("content-type", mimeGetter.resolve());
                outputStream.write(methodResponse.getBytes());
            } else {
                if (methodResponse.startsWith(REDIRECT)) {
                    httpExchange.setAttribute("message", httpResponse.get("message"));
                    String redirect = this.getRedirect(methodResponse);
                    Headers headers = httpExchange.getResponseHeaders();
                    headers.add("Location", redirect);
                    httpExchange.sendResponseHeaders(302, -1L);
                    httpExchange.close();
                    return;
                }
                if (!this.support.isJar()) {
                    int unelength;
                    String htmlPath;
                    File viewFile;
                    Path webPath = Paths.get("webapp", new String[0]);
                    if (methodResponse.startsWith("/")) {
                        methodResponse = methodResponse.replaceFirst("/", "");
                    }
                    if (!(viewFile = new File(htmlPath = webPath.toFile().getAbsolutePath().concat(File.separator + methodResponse))).exists()) {
                        try {
                            String message = "view " + htmlPath + " cannot be found.";
                            httpExchange.sendResponseHeaders(200, message.length());
                            outputStream.write(message.getBytes());
                            outputStream.flush();
                            outputStream.close();
                            return;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    FileInputStream fis = new FileInputStream(viewFile);
                    ByteArrayOutputStream unebaos = new ByteArrayOutputStream();
                    byte[] bytes = new byte[13312];
                    while ((unelength = ((InputStream)fis).read(bytes)) != -1) {
                        unebaos.write(bytes, 0, unelength);
                    }
                    String pageContent = unebaos.toString(StandardCharsets.UTF_8.name());
                    if (design != null) {
                        int deuxlength;
                        String designPath = webPath.toFile().getAbsolutePath().concat(File.separator + design);
                        File designFile = new File(designPath);
                        if (!designFile.exists()) {
                            try {
                                String message = "design " + designPath + " cannot be found.";
                                httpExchange.sendResponseHeaders(200, message.length());
                                outputStream.write(message.getBytes());
                                outputStream.flush();
                                outputStream.close();
                                return;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        FileInputStream dis = new FileInputStream(designFile);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        while ((deuxlength = ((InputStream)dis).read(bytes)) != -1) {
                            baos.write(bytes, 0, deuxlength);
                        }
                        String designContent = baos.toString(StandardCharsets.UTF_8.name());
                        if (!designContent.contains("<a:content/>")) {
                            try {
                                String message = "Your html template file is missing the <a:content/> tag";
                                httpExchange.sendResponseHeaders(200, message.length());
                                outputStream.write(message.getBytes());
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        String[] bits = designContent.split("<a:content/>");
                        String header = bits[0];
                        String bottom = bits[1];
                        header = header.concat(pageContent);
                        String completePage = header.concat(bottom);
                        completePage = completePage.replace("${title}", title);
                        String designOutput = "";
                        try {
                            UxProcessor uxProcessor = this.cache.getUxProcessor();
                            Map<String, Pointcut> pointcuts = this.cache.getPointCuts();
                            designOutput = uxProcessor.process(pointcuts, completePage, httpResponse, httpRequest, httpExchange);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                String message = "Please check your html template file. " + ex.getMessage();
                                httpExchange.sendResponseHeaders(200, message.length());
                                outputStream.write(message.getBytes());
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        byte[] bs = designOutput.getBytes("utf-8");
                        httpExchange.sendResponseHeaders(200, bs.length);
                        outputStream.write(bs);
                    } else {
                        String pageOutput = "";
                        try {
                            UxProcessor uxProcessor = this.cache.getUxProcessor();
                            Map<String, Pointcut> pointcuts = this.cache.getPointCuts();
                            pageOutput = uxProcessor.process(pointcuts, pageContent, httpResponse, httpRequest, httpExchange);
                            if (!pageOutput.startsWith("<html>")) {
                                pageOutput = "<html>" + pageOutput;
                                pageOutput = pageOutput + "</html>";
                            }
                            httpExchange.sendResponseHeaders(200, pageOutput.length());
                            outputStream.write(pageOutput.getBytes());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                String message = "Please check your html template file. " + ex.getMessage();
                                httpExchange.sendResponseHeaders(200, message.length());
                                outputStream.write(message.getBytes());
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else {
                    int unelength;
                    if (methodResponse.startsWith("/")) {
                        methodResponse = methodResponse.replaceFirst("/", "");
                    }
                    String pagePath = "/webapp/" + methodResponse;
                    InputStream pageInput = this.getClass().getResourceAsStream(pagePath);
                    ByteArrayOutputStream unebaos = new ByteArrayOutputStream();
                    byte[] bytes = new byte[13312];
                    while ((unelength = pageInput.read(bytes)) != -1) {
                        unebaos.write(bytes, 0, unelength);
                    }
                    String pageContent = unebaos.toString(StandardCharsets.UTF_8.name());
                    if (design != null) {
                        int length;
                        String designPath = "/webapp/" + design;
                        InputStream designInput = this.getClass().getResourceAsStream(designPath);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        while ((length = designInput.read(bytes)) != -1) {
                            baos.write(bytes, 0, length);
                        }
                        String designContent = baos.toString(StandardCharsets.UTF_8.name());
                        if (!designContent.contains("<a:content/>")) {
                            try {
                                String message = "Your html template file is missing the <a:content/> tag";
                                httpExchange.sendResponseHeaders(200, message.length());
                                outputStream.write(message.getBytes());
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        String[] bits = designContent.split("<a:content/>");
                        String header = bits[0];
                        String bottom = bits[1];
                        header = header.concat(pageContent);
                        String completePage = header.concat(bottom);
                        completePage = completePage.replace("${title}", title);
                        String designOutput = "";
                        try {
                            UxProcessor uxProcessor = this.cache.getUxProcessor();
                            Map<String, Pointcut> pointcuts = this.cache.getPointCuts();
                            designOutput = uxProcessor.process(pointcuts, completePage, httpResponse, httpRequest, httpExchange);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                String message = "Please check your html template file. " + ex.getMessage();
                                httpExchange.sendResponseHeaders(200, message.length());
                                outputStream.write(message.getBytes());
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        byte[] bs = designOutput.getBytes("utf-8");
                        httpExchange.sendResponseHeaders(200, bs.length);
                        outputStream.write(bs);
                    } else {
                        String pageOutput = "";
                        try {
                            UxProcessor uxProcessor = this.cache.getUxProcessor();
                            Map<String, Pointcut> pointcuts = this.cache.getPointCuts();
                            pageOutput = uxProcessor.process(pointcuts, pageContent, httpResponse, httpRequest, httpExchange);
                            if (!pageOutput.startsWith("<html>")) {
                                pageOutput = "<html>" + pageOutput;
                                pageOutput = pageOutput + "</html>";
                            }
                            httpExchange.sendResponseHeaders(200, pageOutput.length());
                            outputStream.write(pageOutput.getBytes());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                String message = "Please check your html template file. " + ex.getMessage();
                                httpExchange.sendResponseHeaders(200, message.length());
                                outputStream.write(message.getBytes());
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (ClassCastException ccex) {
            System.out.println("Attempted to cast an object at the data layer with an incorrect Class type.");
            ccex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                String message = "Sorry, we must have forgot an ampersand. Let us know so we can track it down";
                httpExchange.sendResponseHeaders(200, message.length());
                outputStream.write(message.getBytes());
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String getRedirect(String uri) {
        String[] redirectBits = uri.split("]");
        if (redirectBits.length > 1) {
            return redirectBits[1];
        }
        return "";
    }

    private Object[] getEndpointParameters(String requestUri, HttpRequest httpRequest, HttpResponse httpResponse, EndpointMapping endpointMapping, HttpExchange httpExchange) {
        List<EndpointPosition> endpointValues = this.getEndpointValues(requestUri, endpointMapping);
        ArrayList<Object> params = new ArrayList<Object>();
        List<String> typeNames = endpointMapping.getTypeNames();
        int idx = 0;
        for (int z = 0; z < typeNames.size(); ++z) {
            String type = typeNames.get(z);
            if (type.equals("com.sun.net.httpserver.HttpExchange")) {
                params.add(httpExchange);
            }
            if (type.equals("eros.model.web.HttpRequest")) {
                params.add(httpRequest);
            }
            if (type.equals("eros.model.web.HttpResponse")) {
                params.add(httpResponse);
            }
            if (type.equals("java.lang.Integer")) {
                params.add(Integer.valueOf(endpointValues.get(idx).getValue()));
                ++idx;
            }
            if (type.equals("java.lang.Long")) {
                params.add(Long.valueOf(endpointValues.get(idx).getValue()));
                ++idx;
            }
            if (type.equals("java.math.BigDecimal")) {
                params.add(new BigDecimal(endpointValues.get(idx).getValue()));
                ++idx;
            }
            if (!type.equals("java.lang.String")) continue;
            params.add(endpointValues.get(idx).getValue());
            ++idx;
        }
        return params.toArray();
    }

    protected List<EndpointPosition> getEndpointValues(String uri, EndpointMapping mapping) {
        List<String> pathParts = this.getPathParts(uri);
        List<String> regexParts = this.getRegexParts(mapping);
        ArrayList<EndpointPosition> httpValues = new ArrayList<EndpointPosition>();
        for (int n = 0; n < regexParts.size(); ++n) {
            String regex = regexParts.get(n);
            if (!regex.contains("A-Za-z0-9")) continue;
            httpValues.add(new EndpointPosition(n, pathParts.get(n)));
        }
        return httpValues;
    }

    protected List<String> getPathParts(String uri) {
        return Arrays.asList(uri.split("/"));
    }

    protected List<String> getRegexParts(EndpointMapping mapping) {
        return Arrays.asList(mapping.getRegexedPath().split("/"));
    }

    protected EndpointMapping getHttpMapping(String verb, String uri) {
        EndpointMapping mapping;
        for (Map.Entry mappingEntry : this.cache.getEndpointMappings().getMappings().entrySet()) {
            mapping = (EndpointMapping)mappingEntry.getValue();
            String mappingUri = mapping.getPath();
            if (!mapping.getPath().startsWith("/")) {
                mappingUri = "/" + mappingUri;
            }
            if (!mappingUri.equals(uri)) continue;
            return mapping;
        }
        for (Map.Entry mappingEntry : this.cache.getEndpointMappings().getMappings().entrySet()) {
            mapping = (EndpointMapping)mappingEntry.getValue();
            Matcher matcher = Pattern.compile(mapping.getRegexedPath()).matcher(uri);
            String mappingUri = mapping.getPath();
            if (!mapping.getPath().startsWith("/")) {
                mappingUri = "/" + mappingUri;
            }
            if (!matcher.matches() || !mapping.getVerb().toLowerCase().equals(verb) || !this.variablesMatchUp(uri, mapping) || !this.lengthMatches(uri, mappingUri)) continue;
            return mapping;
        }
        return null;
    }

    protected boolean lengthMatches(String uri, String mappingUri) {
        String[] mappingBits;
        String[] uriBits = uri.split("/");
        return uriBits.length == (mappingBits = mappingUri.split("/")).length;
    }

    protected boolean variablesMatchUp(String uri, EndpointMapping endpointMapping) {
        List<String> bits = Arrays.asList(uri.split("/"));
        UrlBitFeatures urlBitFeatures = endpointMapping.getUrlBitFeatures();
        List<UrlBit> urlBits = urlBitFeatures.getUrlBits();
        Class[] typeParameters = endpointMapping.getMethod().getParameterTypes();
        List<String> parameterTypes = this.getParameterTypes(typeParameters);
        int idx = 0;
        for (int q = 0; q < urlBits.size(); ++q) {
            UrlBit urlBit = urlBits.get(q);
            if (!urlBit.isVariable().booleanValue()) continue;
            try {
                String methodType = parameterTypes.get(idx);
                String bit = bits.get(q);
                if (!bit.equals("")) {
                    if (methodType.equals("java.lang.Integer")) {
                        Integer.parseInt(bit);
                    }
                    if (methodType.equals("java.lang.Long")) {
                        Long.parseLong(bit);
                    }
                }
                ++idx;
                continue;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    public List<String> getParameterTypes(Class[] clsParamaters) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        for (Class cls : clsParamaters) {
            String type = cls.getTypeName();
            if (type.contains("HttpExchange") || type.contains("HttpRequest") || type.contains("HttpResponse")) continue;
            parameterTypes.add(type);
        }
        return parameterTypes;
    }

    protected HttpResponse getHttpResponse(HttpExchange exchange) {
        HttpResponse httpResponse = new HttpResponse();
        if (exchange.getAttribute("message") != null) {
            httpResponse.set("message", exchange.getAttribute("message"));
            exchange.setAttribute("message", "");
        }
        return httpResponse;
    }
}

