/*
 * Decompiled with CFR 0.152.
 */
package eos.web;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import eos.Eos;
import eos.model.web.FormElement;
import eos.model.web.HttpRequest;
import eos.model.web.HttpSession;
import java.io.ByteArrayOutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ElementCompiler {
    Eos.Cache cache;
    byte[] bytes;
    Map<String, HttpSession> sessions;
    HttpExchange httpExchange;

    public ElementCompiler(Eos.Cache cache, byte[] bytes, Map<String, HttpSession> sessions, HttpExchange httpExchange) {
        this.cache = cache;
        this.bytes = bytes;
        this.sessions = sessions;
        this.httpExchange = httpExchange;
    }

    public HttpRequest compile() {
        HttpRequest httpRequest;
        block7: {
            block8: {
                Headers headers = this.httpExchange.getRequestHeaders();
                httpRequest = new HttpRequest(this.sessions, this.httpExchange);
                String contentType = headers.getFirst("Content-Type");
                String delimeter = "";
                if (contentType == null) break block7;
                String[] bits = contentType.split("boundary=");
                if (bits.length <= 1) break block8;
                delimeter = bits[1];
                StringBuilder sb = new StringBuilder();
                for (byte b : this.bytes) {
                    sb.append((char)b);
                }
                String payload = sb.toString();
                List<FormElement> data = this.getElements(delimeter, payload);
                for (FormElement formElement : data) {
                    String key = formElement.getName();
                    httpRequest.set(key, formElement);
                }
                break block7;
            }
            if (this.bytes.length <= 0) break block7;
            String query = "";
            try {
                query = new String(this.bytes, "utf-8");
                query = URLDecoder.decode(query, StandardCharsets.UTF_8.name());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            for (String entry : query.split("&")) {
                FormElement element = new FormElement();
                String[] keyValue = entry.split("=", 2);
                String key = keyValue[0];
                if (keyValue.length > 1) {
                    String value = keyValue[1];
                    element.setName(key);
                    element.setValue(value);
                } else {
                    element.setName(key);
                    element.setValue("");
                }
                httpRequest.data().put(key, element);
            }
        }
        return httpRequest;
    }

    protected List<FormElement> getElements(String delimeter, String payload) {
        ArrayList<FormElement> formData = new ArrayList<FormElement>();
        Integer index = payload.indexOf("name=\"");
        FormElement data = this.getData(index, delimeter, payload);
        formData.add(data);
        while (index >= 0) {
            if ((index = Integer.valueOf(payload.indexOf("name=\"", index + 1))) < 0) continue;
            FormElement dataDos = this.getData(index, delimeter, payload);
            formData.add(dataDos);
        }
        return formData;
    }

    protected FormElement getData(int index, String delimeter, String payload) {
        FormElement formElement = new FormElement();
        Integer startName = payload.indexOf("\"", index + 1);
        Integer endName = payload.indexOf("\"", startName + 1);
        String name = payload.substring(startName + 1, endName);
        formElement.setName(name);
        Integer fileIdx = payload.indexOf("filename=", endName + 1);
        if (fileIdx - endName == 3) {
            Integer startFile = payload.indexOf("\"", fileIdx + 1);
            Integer endFile = payload.indexOf("\"", startFile + 1);
            String fileName = payload.substring(startFile + 1, endFile);
            formElement.setFileName(fileName);
            Integer startContent = payload.indexOf("Content-Type", endFile + 1);
            Integer startType = payload.indexOf(":", startContent + 1);
            Integer endType = payload.indexOf("\r\n", startType + 1);
            String type = payload.substring(startType + 1, endType).trim();
            formElement.setContentType(type);
            Integer startBytes = payload.indexOf("\r\n", endType + 1);
            Integer endBytes = payload.indexOf(delimeter, startBytes + 4);
            String value = payload.substring(startBytes, endBytes);
            Integer startValue = startBytes + 2;
            Integer endValue = endBytes;
            if (value.endsWith("--")) {
                endValue = endBytes - 2;
            }
            endValue = endValue - 2;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int z = startValue.intValue(); z < endValue; ++z) {
                byte b = this.bytes[z];
                baos.write(b);
            }
            formElement.setFileBytes(baos.toByteArray());
        } else {
            Integer startValue = payload.indexOf("\r\n", endName + 1);
            Integer endValue = payload.indexOf(delimeter, startValue + 1);
            String value = payload.substring(startValue + 1, endValue);
            if (value.endsWith("\r\n--")) {
                int lastbit = value.indexOf("\r\n--");
                value = value.substring(0, lastbit).trim();
            }
            formElement.setValue(value);
        }
        return formElement;
    }
}

