/*
 * Decompiled with CFR 0.152.
 */
package eos.util;

import com.sun.net.httpserver.HttpExchange;
import eos.Eos;
import eos.util.MimeGetter;
import eos.util.Support;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.List;

public class ResourceResponse {
    final String GET = "get";
    final String WEBAPP = "webapp";
    final String CONTENTTYPE = "Content-Type";
    Eos.Cache cache;
    String requestUri;
    String httpVerb;
    HttpExchange httpExchange;
    Support support;

    public ResourceResponse(Builder builder) {
        this.cache = builder.cache;
        this.requestUri = builder.requestUri;
        this.httpVerb = builder.httpVerb;
        this.httpExchange = builder.httpExchange;
        this.support = new Support();
    }

    public static Boolean isResource(String requestUri, Eos.Cache cache) {
        if (cache.getResources() == null) {
            return false;
        }
        String[] bits = requestUri.split("/");
        if (bits.length > 1) {
            String resource = bits[1];
            if (cache.getResources().contains(resource)) {
                return true;
            }
        }
        return false;
    }

    public void serve() throws IOException {
        if (this.support.isJar()) {
            if (this.requestUri.startsWith("/")) {
                this.requestUri = this.requestUri.replaceFirst("/", "");
            }
            String resourcePath = "/webapp/" + this.requestUri;
            InputStream ris = this.getClass().getResourceAsStream(resourcePath);
            if (ris != null) {
                int unelength;
                ByteArrayOutputStream unebaos = new ByteArrayOutputStream();
                byte[] bytes = new byte[13312];
                while ((unelength = ris.read(bytes)) != -1) {
                    unebaos.write(bytes, 0, unelength);
                }
                MimeGetter mimeGetter = new MimeGetter(this.requestUri);
                String mimeType = mimeGetter.resolve();
                this.httpExchange.getResponseHeaders().set(this.CONTENTTYPE, mimeType);
                if (this.httpVerb.equals("get")) {
                    this.httpExchange.sendResponseHeaders(200, unebaos.size());
                    OutputStream os = this.httpExchange.getResponseBody();
                    os.write(unebaos.toByteArray());
                    os.close();
                    os.flush();
                } else {
                    this.httpExchange.sendResponseHeaders(200, -1L);
                }
                ris.close();
            }
        } else {
            FileInputStream fis;
            String webPath = Paths.get(this.WEBAPP, new String[0]).toString();
            String filePath = webPath.concat(this.requestUri);
            File file = new File(filePath);
            try {
                fis = new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                this.outputAlert(this.httpExchange, 404);
                return;
            }
            if (fis != null) {
                MimeGetter mimeGetter = new MimeGetter(filePath);
                String mimeType = mimeGetter.resolve();
                this.httpExchange.getResponseHeaders().set(this.CONTENTTYPE, mimeType);
                if (this.httpVerb.equals("get")) {
                    this.httpExchange.sendResponseHeaders(200, file.length());
                    OutputStream os = this.httpExchange.getResponseBody();
                    this.copyStream(fis, os);
                    os.close();
                    os.flush();
                } else {
                    this.httpExchange.sendResponseHeaders(200, -1L);
                }
                ((InputStream)fis).close();
            }
        }
    }

    private void outputAlert(HttpExchange httpExchange, int errorCode) throws IOException {
        String message = "A8i/ resource missing! " + errorCode;
        byte[] messageBytes = message.getBytes("utf-8");
        httpExchange.getResponseHeaders().set("Content-Type", "text/plain; charset=utf-8");
        httpExchange.sendResponseHeaders(errorCode, messageBytes.length);
        OutputStream os = httpExchange.getResponseBody();
        os.write(messageBytes);
        os.close();
    }

    private void copyStream(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] bytes = new byte[13312];
        while ((n = is.read(bytes)) >= 0) {
            os.write(bytes, 0, n);
        }
    }

    public static class Builder {
        Eos.Cache cache;
        String requestUri;
        String httpVerb;
        List<String> resources;
        HttpExchange httpExchange;

        public Builder withRequestUri(String requestUri) {
            this.requestUri = requestUri;
            return this;
        }

        public Builder withHttpVerb(String httpVerb) {
            this.httpVerb = httpVerb;
            return this;
        }

        public Builder withCache(Eos.Cache cache) {
            this.cache = cache;
            return this;
        }

        public Builder withResources(List<String> resources) {
            this.resources = resources;
            return this;
        }

        public Builder withHttpExchange(HttpExchange httpExchange) {
            this.httpExchange = httpExchange;
            return this;
        }

        public ResourceResponse make() {
            return new ResourceResponse(this);
        }
    }
}

