/*
 * Decompiled with CFR 0.152.
 */
package eos.startup;

import eos.Eos;
import eos.jdbc.Mediator;
import eos.jdbc.Repo;
import eos.model.Element;
import eos.model.web.EndpointMappings;
import eos.processor.AnnotationProcessor;
import eos.processor.ConfigurationProcessor;
import eos.processor.ElementProcessor;
import eos.processor.EndpointProcessor;
import eos.processor.InstanceProcessor;
import eos.processor.PropertiesProcessor;
import eos.util.Settings;
import eos.util.Support;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.sql.DataSource;

public class Startup {

    public static class Builder {
        Eos.Cache cache;
        Repo repo;
        Support support;
        Settings settings;

        public Builder with(Eos.Cache cache, Repo repo) {
            this.cache = cache;
            this.repo = repo;
            this.support = new Support();
            this.settings = new Settings();
            return this;
        }

        private void setAttributes() {
            Element element = new Element();
            element.setElement(this.cache);
            this.cache.getElementStorage().getElements().put("cache", element);
            Element repoElement = new Element();
            repoElement.setElement(this.repo);
            this.cache.getElementStorage().getElements().put("repo", repoElement);
            Element supportElement = new Element();
            supportElement.setElement(this.support);
            this.cache.getElementStorage().getElements().put("support", supportElement);
            if (this.cache.getResources() == null) {
                this.cache.setResources(new ArrayList<String>());
            }
            if (this.cache.getPropertiesFiles() == null) {
                this.cache.setPropertiesFiles(new ArrayList<String>());
            }
        }

        private void initDatabase() throws Exception {
            Mediator mediator = new Mediator(this.settings, this.support, this.cache);
            Element element = new Element();
            element.setElement(mediator);
            this.cache.getElementStorage().getElements().put("dbmediator", element);
            mediator.createDb();
        }

        private void validateDatasource() throws Exception {
            Element element = this.cache.getElementStorage().getElements().get("datasource");
            if (element != null) {
                DataSource dataSource = (DataSource)element.getElement();
                this.repo.setDataSource(dataSource);
            }
        }

        private void setDbAttributes() throws Exception {
            this.validateDatasource();
            this.initDatabase();
        }

        private void dispatchEvent() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            Method setupComplete;
            if (this.cache.getEvents() != null && (setupComplete = this.cache.getEvents().getClass().getDeclaredMethod("setupComplete", Eos.class)) != null) {
                setupComplete.setAccessible(true);
                setupComplete.invoke(this.cache.getEvents(), this.cache);
            }
        }

        private void runElementsProcessor() throws Exception {
            ElementProcessor elementsProcessor = new ElementProcessor(this.cache).run();
            this.cache.setElementProcessor(elementsProcessor);
        }

        private void runConfigProcessor() throws Exception {
            if (this.cache.getElementProcessor().getConfigs() != null && this.cache.getElementProcessor().getConfigs().size() > 0) {
                new ConfigurationProcessor(this.cache).run();
            }
        }

        private void runAnnotationProcessor() throws Exception {
            new AnnotationProcessor(this.cache).run();
        }

        private void runEndpointProcessor() throws Exception {
            EndpointProcessor endpointProcessor = new EndpointProcessor(this.cache).run();
            EndpointMappings endpointMappings = endpointProcessor.getMappings();
            this.cache.setEndpointMappings(endpointMappings);
        }

        private void runPropertiesProcessor() throws Exception {
            if (!this.cache.getPropertiesFiles().isEmpty()) {
                new PropertiesProcessor(this.cache).run();
            }
        }

        private void runInstanceProcessor() throws Exception {
            new InstanceProcessor(this.cache).run();
        }

        private void runProcessors() throws Exception {
            this.runPropertiesProcessor();
            this.runInstanceProcessor();
            this.runElementsProcessor();
            this.runConfigProcessor();
            this.runAnnotationProcessor();
            this.runEndpointProcessor();
        }

        private void sayReady() {
            String name = this.support.getProject();
            System.out.println("[READY!] " + name + "! : o . o . o . o . o . o . o . o . o . o . o . o  ");
        }

        public Startup build() throws Exception {
            this.setAttributes();
            this.runProcessors();
            this.setDbAttributes();
            this.sayReady();
            this.dispatchEvent();
            return new Startup();
        }
    }
}

