/*
 * Decompiled with CFR 0.152.
 */
package eos.startup;

import eos.Eos;
import eos.jdbc.Repo;
import eos.processor.UxProcessor;
import eos.startup.Startup;
import eos.util.Settings;
import eos.util.Support;
import eos.web.Interceptor;
import eos.web.Pointcut;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ExchangeStartup {
    Eos.Cache cache;
    UxProcessor uxProcessor;
    Map<String, Pointcut> pointcuts;
    Map<String, Interceptor> interceptors;

    public ExchangeStartup(Map<String, Pointcut> pointcuts, Map<String, Interceptor> interceptors, UxProcessor uxProcessor) {
        this.uxProcessor = uxProcessor;
        this.pointcuts = pointcuts;
        this.interceptors = interceptors;
    }

    /*
     * WARNING - void declaration
     */
    public void start() throws Exception {
        String propString;
        String resourceStr;
        Support support = new Support();
        InputStream is = this.getClass().getResourceAsStream("/src/main/resources/eros.props");
        if (is == null) {
            try {
                String uri = support.getResourceUri() + File.separator + "eros.props";
                is = new FileInputStream(uri);
            }
            catch (FileNotFoundException uri) {
                // empty catch block
            }
        }
        if (is == null) {
            throw new Exception("eros.props not found in src/main/resources/");
        }
        Properties props = new Properties();
        props.load(is);
        Object env = props.get("eros.env");
        Boolean noAction = true;
        Boolean createDb = false;
        Boolean dropDb = false;
        if (env != null) {
            String environment = env.toString().replaceAll("\\s+", "");
            List<String> properties = Arrays.asList(environment.split(","));
            for (String prop : properties) {
                if (prop.equals("create")) {
                    noAction = false;
                    createDb = true;
                }
                if (prop.equals("drop")) {
                    noAction = false;
                    dropDb = true;
                }
                if (!prop.equals("update") && !prop.equals("plain") && !prop.equals("basic") && !prop.equals("stub") && !prop.equals("")) continue;
                noAction = true;
            }
        }
        if (noAction.booleanValue() && (createDb.booleanValue() || dropDb.booleanValue())) {
            throw new Exception("You need to either set eros.env=basic for basic systems that do not need a database connection, or eros.env=create to create a db using src/main/resource/create-db.sql, or eros.env=create,drop to both create and drop a database.");
        }
        Object resourcesProp = props.get("eros.assets");
        Object propertiesProp = props.get("eros.properties");
        List<Object> resourcesPre = new ArrayList();
        if (resourcesProp != null && !(resourceStr = resourcesProp.toString()).equals("")) {
            resourcesPre = Arrays.asList(resourceStr.split(","));
        }
        List<Object> propertiesPre = new ArrayList();
        if (propertiesProp != null && !(propString = propertiesProp.toString()).equals("")) {
            propertiesPre = Arrays.asList(propString.split(","));
        }
        ArrayList<String> resources = new ArrayList<String>();
        if (!resourcesPre.isEmpty()) {
            for (Object resource : resourcesPre) {
                resource = ((String)resource).replaceAll("\\s+", "");
                resources.add((String)resource);
            }
        }
        ArrayList<String> propertiesFiles = new ArrayList<String>();
        if (!propertiesPre.isEmpty()) {
            for (String string : propertiesPre) {
                void var15_16;
                String string2 = string.replaceAll("\\s+", "");
                if (string2.equals("this")) {
                    String string3 = "eros.props";
                }
                propertiesFiles.add((String)var15_16);
            }
        }
        Settings settings = new Settings();
        settings.setCreateDb(createDb);
        settings.setDropDb(dropDb);
        settings.setNoAction(noAction);
        settings.setResources(resources);
        settings.setPropertiesFiles(propertiesFiles);
        Repo repo = new Repo();
        this.cache = new Eos.Cache.Builder().withSettings(settings).withPointCuts(this.pointcuts).withInterceptors(this.interceptors).withUxProcessor(this.uxProcessor).withRepo(repo).make();
        new Startup.Builder().with(this.cache, repo).build();
    }

    public Eos.Cache getCache() {
        return this.cache;
    }
}

