/*
 * Decompiled with CFR 0.152.
 */
package eos.processor;

import eos.Eos;
import eos.util.Support;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class PropertiesProcessor {
    Eos.Cache cache;
    Support support;

    public PropertiesProcessor(Eos.Cache cache) {
        this.cache = cache;
        this.support = new Support();
    }

    protected InputStream getPropertiesFile(String propertyFile) throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/src/main/resources/" + propertyFile);
        if (is == null) {
            PropertiesProcessor propertiesProcessor = this;
            String resourceUri = propertiesProcessor.support.getResourceUri();
            File file = new File(resourceUri + File.separator + propertyFile);
            if (!file.exists()) {
                throw new Exception(propertyFile + " properties file cannot be located...");
            }
            is = new FileInputStream(file);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        if (this.cache.getPropertiesFiles() != null) {
            for (String propertyFile : this.cache.getPropertiesFiles()) {
                Properties prop = null;
                try (InputStream is = null;){
                    is = this.getPropertiesFile(propertyFile);
                    prop = new Properties();
                    prop.load(is);
                    Enumeration<?> properties = prop.propertyNames();
                    while (properties.hasMoreElements()) {
                        String key = (String)properties.nextElement();
                        String value = prop.getProperty(key);
                        this.cache.getPropertyStorage().getProperties().put(key, value);
                    }
                }
            }
        }
    }
}

