/*
 * Decompiled with CFR 0.152.
 */
package eos.processor;

import eos.Eos;
import eos.annotate.Events;
import eos.model.ObjectDetails;
import eos.util.Support;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class InstanceProcessor {
    Eos.Cache cache;
    Support support;
    ClassLoader cl;
    List<String> jarDeps;
    Map<String, ObjectDetails> objects;

    public InstanceProcessor(Eos.Cache cache) {
        this.cache = cache;
        this.support = new Support();
        this.objects = new HashMap<String, ObjectDetails>();
        this.cl = Thread.currentThread().getContextClassLoader();
    }

    public InstanceProcessor run() {
        if (this.support.isJar()) {
            this.setJarDeps();
            this.getClassesJar();
        } else {
            String uri = null;
            try {
                uri = this.support.getClassesUri();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getClasses(uri);
        }
        return this;
    }

    private List<String> setJarDeps() {
        this.jarDeps = new ArrayList<String>();
        Enumeration entries = this.support.getJarEntries();
        do {
            JarEntry jarEntry;
            String path;
            if (!(path = this.getPath((jarEntry = (JarEntry)entries.nextElement()).toString())).contains("META-INF.maven.")) continue;
            String dep = path.substring(14);
            this.jarDeps.add(dep);
        } while (entries.hasMoreElements());
        return this.jarDeps;
    }

    protected boolean isDep(String jarEntry) {
        String jarPath = this.getPath(jarEntry);
        for (String dep : this.jarDeps) {
            if (!jarPath.contains(dep)) continue;
            return true;
        }
        return false;
    }

    private int getLastIndxOf(int nth, String ch, String string) {
        if (nth <= 0) {
            return string.length();
        }
        return this.getLastIndxOf(--nth, ch, string.substring(0, string.lastIndexOf(ch)));
    }

    protected Boolean isWithinRunningProgram(String jarEntry) {
        String main = this.support.getMain();
        String path = main.substring(0, this.getLastIndxOf(1, ".", main) + 1);
        String jarPath = this.getPath(jarEntry);
        return jarPath.contains(path);
    }

    protected Boolean isDirt(String jarEntry) {
        if (this.support.isJar() && !this.isWithinRunningProgram(jarEntry).booleanValue() && this.isDep(jarEntry)) {
            return true;
        }
        if (this.support.isJar() && !jarEntry.endsWith(".class")) {
            return true;
        }
        if (jarEntry.contains("org/h2")) {
            return true;
        }
        if (jarEntry.contains("javax/servlet/http")) {
            return true;
        }
        if (jarEntry.contains("package-info")) {
            return true;
        }
        if (jarEntry.startsWith("module-info")) {
            return true;
        }
        if (jarEntry.contains("META-INF/")) {
            return true;
        }
        if (jarEntry.contains("$")) {
            return true;
        }
        if (jarEntry.endsWith("Exception")) {
            return true;
        }
        return false;
    }

    protected void getClassesJar() {
        try {
            URL jarUriTres = this.cl.getResource("eos/");
            String jarPath = jarUriTres.getPath().substring(6, jarUriTres.getPath().indexOf("!"));
            JarFile file = new JarFile(jarPath);
            Enumeration<JarEntry> jarFile = file.entries();
            while (jarFile.hasMoreElements()) {
                String path;
                Class<?> cls;
                JarEntry jarEntry = jarFile.nextElement();
                if (jarEntry.isDirectory() || this.isDirt(jarEntry.toString()).booleanValue() || (cls = this.cl.loadClass(path = this.getPath(jarEntry.toString()))).isAnnotation() || cls.isInterface() || cls.getName() == this.getClass().getName()) continue;
                if (cls.isAnnotationPresent(Events.class)) {
                    this.cache.setEvents(this.getObject(cls));
                }
                ObjectDetails objectDetails = this.getObjectDetails(cls);
                this.cache.getObjects().put(objectDetails.getName(), objectDetails);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void getClasses(String uri) {
        File[] files;
        File pathFile = new File(uri);
        for (File file : files = pathFile.listFiles()) {
            if (file.isDirectory()) {
                this.getClasses(file.getPath());
                continue;
            }
            try {
                Class<?> cls;
                if (this.isDirt(file.getPath()).booleanValue() || !file.getPath().endsWith(".class") && !file.getPath().endsWith(".java")) continue;
                String path = this.getPath("java", "java", file.getPath());
                if (file.toString().endsWith(".class")) {
                    path = this.getPath("class", "classes", file.getPath());
                }
                if ((cls = this.cl.loadClass(path)).isAnnotation() || cls.isInterface() || cls.getName() == this.getClass().getName()) continue;
                if (cls.isAnnotationPresent(Events.class)) {
                    this.cache.setEvents(this.getObject(cls));
                }
                ObjectDetails objectDetails = this.getObjectDetails(cls);
                this.cache.getObjects().put(objectDetails.getName(), objectDetails);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected String getPath(String path) {
        if (path.startsWith("/")) {
            path = path.replaceFirst("/", "");
        }
        return path.replace("\\", ".").replace("/", ".").replace(".class", "");
    }

    protected String getPath(String name, String key, String path) {
        String separator = System.getProperty("file.separator");
        String regex = key + "\\" + separator;
        String[] pathParts = path.split(regex);
        return pathParts[1].replace("\\", ".").replace("/", ".").replace("." + name, "");
    }

    protected ObjectDetails getObjectDetails(Class cls) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        ObjectDetails objectDetails = new ObjectDetails();
        objectDetails.setClazz(cls);
        objectDetails.setName(this.support.getName(cls.getName()));
        Object object = this.getObject(cls);
        objectDetails.setObject(object);
        return objectDetails;
    }

    protected Object getObject(Class cls) {
        Object object = null;
        try {
            object = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return object;
    }
}

