/*
 * Decompiled with CFR 0.152.
 */
package eos.processor;

import eos.Eos;
import eos.annotate.Dependency;
import eos.annotate.Property;
import eos.model.Element;
import eos.model.ObjectDetails;
import eos.model.web.MethodFeature;
import eos.util.Support;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigurationProcessor {
    Eos.Cache cache;
    Support support;
    Map<String, MethodFeature> methods;
    List<MethodFeature> iterableMethods;
    Set<MethodFeature> processedMethods;
    Map<String, Integer> issues;

    public ConfigurationProcessor(Eos.Cache cache) throws Exception {
        this.cache = cache;
        this.support = new Support();
        this.methods = new HashMap<String, MethodFeature>();
        this.processedMethods = new HashSet<MethodFeature>();
        this.iterableMethods = new ArrayList<MethodFeature>();
        this.issues = new HashMap<String, Integer>();
    }

    public ConfigurationProcessor run() throws Exception {
        this.setMapDependencyMethods();
        this.setIterableMethods(this.methods);
        while (!this.allDependenciesProcessed().booleanValue()) {
            this.process(0);
        }
        return this;
    }

    protected void process(int idx) throws Exception {
        Integer classCount = this.cache.getObjects().size();
        if (idx > this.iterableMethods.size()) {
            idx = 0;
        }
        Integer z = idx;
        while (z < this.iterableMethods.size()) {
            block9: {
                MethodFeature methodFeature = this.iterableMethods.get(z);
                Method method = methodFeature.getMethod();
                String methodName = this.support.getName(method.getName());
                Object object = methodFeature.getObject();
                try {
                    Object dependency = method.invoke(object, new Object[0]);
                    String clsName = this.support.getName(dependency.getClass().getName());
                    if (this.cache.getObjects().get(clsName) != null) {
                        this.cache.getObjects().get(clsName).setObject(dependency);
                    } else {
                        ObjectDetails objectDetails = new ObjectDetails();
                        objectDetails.setClazz(dependency.getClass());
                        objectDetails.setName(clsName);
                        objectDetails.setObject(dependency);
                        this.cache.getObjects().put(clsName, objectDetails);
                    }
                    this.createAddElement(method, dependency);
                    this.processedMethods.add(methodFeature);
                }
                catch (Exception ex) {
                    this.process(z + 1);
                    if (this.issues.get(methodName) != null) {
                        int count = this.issues.get(methodName);
                        this.issues.replace(methodName, ++count);
                    } else {
                        this.issues.put(methodName, 1);
                    }
                    if (this.issues.get(methodName) == null || this.issues.get(methodName) < classCount) break block9;
                    StringBuilder builder = new StringBuilder();
                    for (Map.Entry<String, Integer> entry : this.issues.entrySet()) {
                        builder.append("       " + entry.getKey() + " :: " + entry.getValue() + " attempts \n");
                    }
                    throw new Exception("The following dependencies have not been resolved : \n\n\n" + builder.toString() + "\n\n" + ex.toString());
                }
            }
            Integer n = z;
            Integer n2 = z = Integer.valueOf(z + 1);
        }
    }

    private boolean setIterableMethods(Map<String, MethodFeature> methods) {
        for (Map.Entry<String, MethodFeature> entry : methods.entrySet()) {
            this.iterableMethods.add(entry.getValue());
        }
        return true;
    }

    protected Boolean allDependenciesProcessed() {
        return this.processedMethods.size() == this.iterableMethods.size();
    }

    protected void createAddElement(Method method, Object object) {
        Element element = new Element();
        element.setElement(object);
        String classKey = this.support.getName(method.getName());
        this.cache.getElementStorage().getElements().put(classKey, element);
    }

    protected void setMapDependencyMethods() throws Exception {
        for (Class config : this.cache.getElementProcessor().getConfigs()) {
            Constructor<?>[] constructors;
            Object object = null;
            for (Constructor<?> constructor : constructors = config.getConstructors()) {
                if (constructor.getParameterCount() != 0) continue;
                object = constructor.newInstance(new Object[0]);
            }
            List<Method> declaredMethods = Arrays.asList(config.getDeclaredMethods());
            for (Method method : declaredMethods) {
                if (!method.isAnnotationPresent(Dependency.class)) continue;
                String methodKey = method.getName().toLowerCase();
                if (this.methods.containsKey(methodKey)) {
                    throw new Exception("More than one dependency with the same name defined : " + method.getName());
                }
                if (this.cache.getElementStorage().getElements().containsKey(methodKey)) {
                    System.out.println("\n\n");
                    System.out.println("Warning: you elements being injected twice, once by configuration, the other via @Bind.");
                    System.out.println("Take a look at " + config.getName() + " and @Bind for " + method.getName());
                    System.out.println("\n\n");
                    Element existingElement = this.cache.getElementStorage().getElements().get(methodKey);
                    existingElement.setElement(object);
                    this.cache.getElementStorage().getElements().replace(methodKey, existingElement);
                }
                MethodFeature methodFeature = new MethodFeature();
                methodFeature.setName(method.getName());
                methodFeature.setMethod(method);
                methodFeature.setObject(object);
                this.methods.put(methodKey, methodFeature);
            }
            List<Field> declaredFields = Arrays.asList(config.getDeclaredFields());
            for (Field field : declaredFields) {
                if (!field.isAnnotationPresent(Property.class)) continue;
                Property property = field.getAnnotation(Property.class);
                String key = property.value();
                if (!this.cache.getPropertyStorage().getProperties().containsKey(key)) {
                    throw new Exception(key + " property is missing");
                }
                String value = this.cache.getPropertyStorage().getProperties().get(key);
                field.setAccessible(true);
                field.set(object, value);
            }
        }
    }
}

