/*
 * Decompiled with CFR 0.152.
 */
package eos.processor;

import eos.Eos;
import eos.annotate.Bind;
import eos.annotate.Property;
import eos.model.ObjectDetails;
import eos.util.Support;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationProcessor {
    Eos.Cache cache;
    Support support;
    Map<String, ObjectDetails> processed;
    List<ObjectDetails> annotations;

    public AnnotationProcessor(Eos.Cache cache) {
        this.cache = cache;
        this.support = new Support();
        this.processed = new HashMap<String, ObjectDetails>();
        this.annotations = new ArrayList<ObjectDetails>();
        this.map();
    }

    public void run() throws Exception {
        if (!this.allAnnotationsProcessed().booleanValue()) {
            this.processAnnotations(0);
        }
    }

    private void processAnnotations(int idx) throws Exception {
        if (idx > this.annotations.size()) {
            idx = 0;
        }
        Integer z = idx;
        while (z < this.annotations.size()) {
            Field[] fields;
            ObjectDetails objectDetails = this.annotations.get(z);
            Integer fieldsCount = this.getAnnotatedFieldsCount(objectDetails.getClazz());
            Integer processedFieldsCount = 0;
            Object object = objectDetails.getObject();
            for (Field field : fields = objectDetails.getClazz().getDeclaredFields()) {
                Integer n;
                if (field.isAnnotationPresent(Bind.class)) {
                    String fieldKey = field.getName().toLowerCase();
                    if (this.cache.getElementStorage().getElements().containsKey(fieldKey)) {
                        Object element = this.cache.getElementStorage().getElements().get(fieldKey).getElement();
                        field.setAccessible(true);
                        field.set(object, element);
                        Integer n2 = processedFieldsCount;
                        n = processedFieldsCount = Integer.valueOf(processedFieldsCount + 1);
                    } else {
                        this.processAnnotations(z + 1);
                    }
                }
                if (!field.isAnnotationPresent(Property.class)) continue;
                Property annotation = field.getAnnotation(Property.class);
                String key = annotation.value();
                if (this.cache.getPropertyStorage().getProperties().containsKey(key)) {
                    field.setAccessible(true);
                    String value = this.cache.getPropertyStorage().getProperties().get(key);
                    this.attachValue(field, object, value);
                    n = processedFieldsCount;
                    Integer n3 = processedFieldsCount = Integer.valueOf(processedFieldsCount + 1);
                    continue;
                }
                this.processAnnotations(z + 1);
                throw new Exception(field.getName() + " is missing on " + object.getClass().getName());
            }
            if (fieldsCount != processedFieldsCount) {
                this.processAnnotations(z + 1);
            } else {
                String key = this.support.getName(objectDetails.getName());
                this.processed.put(key, objectDetails);
            }
            Integer n = z;
            Integer n4 = z = Integer.valueOf(z + 1);
        }
    }

    protected void attachValue(Field field, Object object, String stringValue) throws Exception {
        Comparable<Boolean> value;
        Class<?> type = field.getType();
        if (type.getTypeName().equals("java.lang.String")) {
            field.set(object, stringValue);
        }
        if (type.getTypeName().equals("boolean") || type.getTypeName().equals("java.lang.Boolean")) {
            value = Boolean.valueOf(stringValue);
            field.set(object, value);
        }
        if (type.getTypeName().equals("int") || type.getTypeName().equals("java.lang.Integer")) {
            value = Integer.valueOf(stringValue);
            field.set(object, value);
        }
        if (type.getTypeName().equals("float") || type.getTypeName().equals("java.lang.Float")) {
            value = Float.valueOf(stringValue);
            field.set(object, value);
        }
        if (type.getTypeName().equals("double") || type.getTypeName().equals("java.lang.Double")) {
            value = Double.valueOf(stringValue);
            field.set(object, value);
        }
        if (type.getTypeName().equals("java.math.BigDecimal")) {
            value = new BigDecimal(stringValue);
            field.set(object, value);
        }
    }

    protected Integer getAnnotatedFieldsCount(Class clazz) throws Exception {
        Field[] fields;
        Integer count = 0;
        for (Field field : fields = clazz.getDeclaredFields()) {
            Integer n;
            Integer n2;
            if (field.isAnnotationPresent(Bind.class)) {
                n2 = count;
                n = count = Integer.valueOf(count + 1);
            }
            if (!field.isAnnotationPresent(Property.class)) continue;
            n2 = count;
            n = count = Integer.valueOf(count + 1);
        }
        return count;
    }

    private void map() {
        for (Map.Entry<String, ObjectDetails> entry : this.cache.getElementProcessor().getAnnotatedClasses().entrySet()) {
            ObjectDetails objectDetails = entry.getValue();
            if (this.annotations.contains(objectDetails)) continue;
            this.annotations.add(objectDetails);
        }
    }

    protected Boolean allAnnotationsProcessed() {
        return this.processed.size() == this.cache.getElementProcessor().getAnnotatedClasses().size();
    }
}

