/*
 * Decompiled with CFR 0.152.
 */
package eos.model.web;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import eos.model.web.FormElement;
import eos.model.web.HttpSession;
import eos.util.Support;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    HttpSession httpSession;
    HttpExchange httpExchange;
    Map<String, HttpSession> sessions;
    Map<String, FormElement> elements;
    String requestBody;
    Support support;

    public HttpRequest(Map<String, HttpSession> sessions, HttpExchange httpExchange) {
        this.sessions = sessions;
        this.support = new Support();
        this.elements = new HashMap<String, FormElement>();
        this.httpExchange = httpExchange;
        this.setSession();
    }

    public Map<String, FormElement> data() {
        return this.elements;
    }

    public Headers getHeaders() {
        return this.httpExchange.getRequestHeaders();
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public void setSession() {
        String id = this.support.getCookie("eros.sessions", this.httpExchange.getRequestHeaders());
        if (this.sessions.containsKey(id)) {
            this.setSession(this.sessions.get(id));
        }
    }

    public void setSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public HttpSession getSession(boolean newitup) {
        String id = this.support.getCookie("eros.sessions", this.httpExchange.getRequestHeaders());
        if (!newitup) {
            if (this.sessions.containsKey(id)) {
                this.setSession(this.sessions.get(id));
                return this.sessions.get(id);
            }
        } else if (newitup) {
            return this.getHttpSession();
        }
        return null;
    }

    private HttpSession getHttpSession() {
        HttpSession httpSession = new HttpSession(this.sessions, this.httpExchange);
        this.sessions.put(httpSession.getId(), httpSession);
        String compound = "eros.sessions=" + httpSession.getId();
        this.httpExchange.getResponseHeaders().set("Set-Cookie", compound);
        this.setSession(httpSession);
        return httpSession;
    }

    public void set(String key, FormElement formElement) {
        this.elements.put(key, formElement);
    }

    public String value(String key) {
        if (this.elements.containsKey(key)) {
            return this.elements.get(key).value();
        }
        return null;
    }

    public FormElement get(String key) {
        if (this.elements.containsKey(key)) {
            return this.elements.get(key);
        }
        return null;
    }

    public Object[] getMultiple(String key) {
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, FormElement> entry : this.elements.entrySet()) {
            if (!key.equals(entry.getKey()) || entry.getValue().value() == null) continue;
            values.add(entry.getValue().value());
        }
        return values.toArray();
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public byte[] getPayload(String key) {
        if (this.elements.containsKey(key) && this.elements.get(key).getFileBytes() != null) {
            return this.elements.get(key).getFileBytes();
        }
        return null;
    }

    public void setValues(String parameters) {
        String[] keyValues;
        for (String keyValue : keyValues = parameters.split("&")) {
            String[] parts = keyValue.split("=");
            if (parts.length <= 1) continue;
            String key = parts[0];
            String value = parts[1];
            FormElement formElement = new FormElement();
            formElement.setName(key);
            formElement.setValue(value);
            this.elements.put(key, formElement);
        }
    }
}

