/*
 * Decompiled with CFR 0.152.
 */
package eos.jdbc.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class Basic
implements DataSource {
    Boolean init = true;
    String dbDriver;
    String dbUrl;
    String dbName;
    String dbUsername;
    String dbPassword;
    Integer loginTimeout;
    Connection connection;
    private static String DB;

    public Basic(Builder builder) {
        this.dbDriver = builder.dbDriver;
        this.dbUrl = builder.dbUrl;
        this.dbName = builder.dbName;
        this.dbUsername = builder.dbUsername;
        this.dbPassword = builder.dbPassword;
        DB = this.dbName;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Class.forName(this.dbDriver);
            Connection connection = DriverManager.getConnection(this.dbUrl, this.dbUsername, this.dbPassword);
            connection.setAutoCommit(false);
            this.connection = connection;
            return connection;
        }
        catch (ClassNotFoundException | SQLException ex) {
            throw new RuntimeException("Problem connecting to the database", ex);
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            Class.forName(this.dbDriver);
            return DriverManager.getConnection(this.dbUrl, username, password);
        }
        catch (ClassNotFoundException | SQLException ex) {
            throw new RuntimeException("Problem connecting to the database", ex);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public static class Builder {
        String dbUrl;
        String dbName;
        String dbUsername;
        String dbPassword;
        String dbDriver;

        public Builder url(String dbUrl) {
            this.dbUrl = dbUrl;
            return this;
        }

        public Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public Builder username(String dbUsername) {
            this.dbUsername = dbUsername;
            return this;
        }

        public Builder password(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public Builder driver(String dbDriver) {
            this.dbDriver = dbDriver;
            return this;
        }

        public Basic build() {
            return new Basic(this);
        }
    }
}

