/*
 * Decompiled with CFR 0.152.
 */
package api.agent;

import api.quotation.bean.Candle;
import api.quotation.bean.DayCandle;
import api.quotation.bean.MarketCode;
import api.quotation.bean.MinuteCandle;
import api.quotation.bean.OrderBook;
import api.quotation.bean.Tick;
import api.quotation.bean.Ticker;
import api.quotation.module.CandlesApi;
import api.quotation.module.MarketApi;
import api.quotation.module.OrderBookApi;
import api.quotation.module.TickerApi;
import api.quotation.module.TradesApi;
import java.io.IOException;
import util.bean.UpbitResponse;

public class UpbitApi {
    private final MarketApi marketApi = new MarketApi();
    private final CandlesApi candlesApi = new CandlesApi();
    private final TradesApi tradesApi = new TradesApi();
    private final TickerApi tickerApi = new TickerApi();
    private final OrderBookApi orderBookApi = new OrderBookApi();

    public UpbitResponse<MarketCode[]> getMarketCodes(boolean isDetail) throws IOException {
        return this.marketApi.getMarketCodes(isDetail);
    }

    public UpbitResponse<MinuteCandle[]> getMinuteCandles(int unit, String market) throws IOException {
        return this.candlesApi.getMinuteCandles(unit, market);
    }

    public UpbitResponse<MinuteCandle[]> getMinuteCandles(int unit, String market, String to, int count) throws IOException {
        return this.candlesApi.getMinuteCandles(unit, market, to, count);
    }

    public UpbitResponse<DayCandle[]> getDayCandles(String market) throws IOException {
        return this.candlesApi.getDayCandles(market);
    }

    public UpbitResponse<DayCandle[]> getDayCandles(String market, String to, int count, String convertingPriceUnit) throws IOException {
        return this.candlesApi.getDayCandles(market, to, count, convertingPriceUnit);
    }

    public UpbitResponse<Candle[]> getWeekCandles(String market) throws IOException {
        return this.candlesApi.getWeekCandles(market);
    }

    public UpbitResponse<Candle[]> getWeekCandles(String market, String to, int count) throws IOException {
        return this.candlesApi.getWeekCandles(market, to, count);
    }

    public UpbitResponse<Candle[]> getMonthCandles(String market) throws IOException {
        return this.candlesApi.getMonthCandles(market);
    }

    public UpbitResponse<Candle[]> getMonthCandles(String market, String to, int count) throws IOException {
        return this.candlesApi.getMonthCandles(market, to, count);
    }

    public UpbitResponse<Tick[]> getTicks(String market) throws IOException {
        return this.tradesApi.getTicks(market);
    }

    public UpbitResponse<Tick[]> getTicks(String market, String to, int count, String cursor, int daysAgo) throws IOException {
        return this.tradesApi.getTicks(market, to, count, cursor, daysAgo);
    }

    public UpbitResponse<Ticker[]> getTickers(String[] markets) throws IOException {
        return this.tickerApi.getTickers(markets);
    }

    public UpbitResponse<OrderBook[]> getOrderBooks(String[] markets) throws IOException {
        return this.orderBookApi.getOrderBooks(markets);
    }
}

