/*
 * Decompiled with CFR 0.152.
 */
package api.agent;

import api.agent.UpbitApi;
import api.exchange.bean.Account;
import api.exchange.bean.Order;
import api.exchange.bean.OrderDetail;
import api.exchange.bean.OrderInfo;
import api.exchange.module.AccountsApi;
import api.exchange.module.OrdersApi;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import util.bean.UpbitResponse;

public class UpbitAuthApi
extends UpbitApi {
    private final String api;
    private final String secret;
    private final AccountsApi accountsApi;
    private final OrdersApi ordersApi;

    public UpbitAuthApi(String api, String secret) {
        this.api = api;
        this.secret = secret;
        this.accountsApi = new AccountsApi(this.api, this.secret);
        this.ordersApi = new OrdersApi(this.api, this.secret);
    }

    public String getApi() {
        return this.api;
    }

    public String getSecret() {
        return this.secret;
    }

    public UpbitResponse<Account[]> getAccounts() throws IOException {
        return this.accountsApi.getAccounts();
    }

    public UpbitResponse<OrderInfo> getOrderInfo(String market) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.getOrderInfo(market);
    }

    public UpbitResponse<OrderDetail> getOrder(String uuid) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.getOrder(uuid);
    }

    public UpbitResponse<OrderDetail> getOrder(String uuid, String identifier) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.getOrder(uuid, identifier);
    }

    public UpbitResponse<Order[]> getOrderLists() throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.getOrderLists();
    }

    public UpbitResponse<Order[]> getOrderLists(String market, String state) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.getOrderLists(market, state);
    }

    public UpbitResponse<Order[]> getOrderLists(String market, String[] uuids, String[] identifiers, String state, String[] states, int page, int limit, String order_by) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.getOrderLists(market, uuids, identifiers, state, states, page, limit, order_by);
    }

    public UpbitResponse<Order> deleteOrder(String uuid) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.deleteOrder(uuid);
    }

    public UpbitResponse<Order> deleteOrder(String uuid, String identifier) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.deleteOrder(uuid, identifier);
    }

    public UpbitResponse<Order> postSellOrder(String market, int volume) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.postSellOrder(market, volume);
    }

    public UpbitResponse<Order> postSellOrder(String market, int volume, String identifier) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.postSellOrder(market, volume, identifier);
    }

    public UpbitResponse<Order> postBuyOrder(String market, int price) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.postBuyOrder(market, price);
    }

    public UpbitResponse<Order> postBuyOrder(String market, int price, String identifier) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.postBuyOrder(market, price, identifier);
    }

    public UpbitResponse<Order> postLimitOrder(String market, String side, int volume, int price, String identifier) throws IOException, NoSuchAlgorithmException {
        return this.ordersApi.postLimitOrder(market, side, volume, price, identifier);
    }
}

