/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.extensions.utils.formatting;

import dev.inmo.tgbotapi.extensions.utils.formatting.StringFormattingKt;
import dev.inmo.tgbotapi.types.ParseMode.HTMLParseMode;
import dev.inmo.tgbotapi.types.ParseMode.MarkdownParseMode;
import dev.inmo.tgbotapi.types.ParseMode.MarkdownV2ParseMode;
import dev.inmo.tgbotapi.types.ParseMode.ParseMode;
import dev.inmo.tgbotapi.types.Username;
import dev.inmo.tgbotapi.types.chat.abstracts.PrivateChat;
import dev.inmo.tgbotapi.types.chat.abstracts.UsernameChat;
import dev.inmo.tgbotapi.types.chat.abstracts.extended.ExtendedChat;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0006\u001a\u00020\u00012\n\u0010\u0007\u001a\u00060\u0001j\u0002`\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\u00012\n\u0010\u0007\u001a\u00060\u0001j\u0002`\b\u001a\u0012\u0010\f\u001a\u00020\u00012\n\u0010\u0007\u001a\u00060\u0001j\u0002`\b\u001a\u0012\u0010\r\u001a\u00020\u00012\n\u0010\u0007\u001a\u00060\u0001j\u0002`\b\u001a\u001a\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013\u001a\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013\u001a\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00162\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013\u001a\u001a\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"internalLinkBeginning", "", "linkIdRedundantPartRegex", "Lkotlin/text/Regex;", "stickerSetAddingLinkPrefix", "usernameBeginSymbolRegex", "makeLinkToAddStickerSet", "stickerSetName", "Ldev/inmo/tgbotapi/types/StickerSetName;", "parseMode", "Ldev/inmo/tgbotapi/types/ParseMode/ParseMode;", "makeLinkToAddStickerSetInHtml", "makeLinkToAddStickerSetInMarkdown", "makeLinkToAddStickerSetInMarkdownV2", "makeLinkToMessage", "username", "Ldev/inmo/tgbotapi/types/Username;", "messageId", "", "Ldev/inmo/tgbotapi/types/MessageIdentifier;", "chat", "Ldev/inmo/tgbotapi/types/chat/abstracts/UsernameChat;", "Ldev/inmo/tgbotapi/types/chat/abstracts/extended/ExtendedChat;", "tgbotapi.extensions.utils"})
public final class LinksFormattingKt {
    private static final String internalLinkBeginning = "https://t.me";
    private static final Regex linkIdRedundantPartRegex = new Regex("^-100");
    private static final Regex usernameBeginSymbolRegex = new Regex("^@");
    private static final String stickerSetAddingLinkPrefix = "https://t.me/addstickers";

    @NotNull
    public static final String makeLinkToMessage(@NotNull String username, long messageId) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        return "https://t.me/" + username + '/' + messageId;
    }

    @NotNull
    public static final String makeLinkToMessage(@NotNull Username username, long messageId) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        return LinksFormattingKt.makeLinkToMessage(username.getUsername(), messageId);
    }

    @Nullable
    public static final String makeLinkToMessage(@NotNull UsernameChat chat, long messageId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Username username = chat.getUsername();
        if (username != null) {
            Username username2 = username;
            boolean bl = false;
            boolean bl2 = false;
            Username it = username2;
            boolean bl3 = false;
            string = LinksFormattingKt.makeLinkToMessage(it, messageId);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String makeLinkToMessage(@NotNull ExtendedChat chat, long messageId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        if (chat instanceof UsernameChat && ((UsernameChat)chat).getUsername() != null) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder().append("https://t.me/");
            Object object = ((UsernameChat)chat).getUsername();
            if (object != null && (object = object.getUsername()) != null) {
                CharSequence charSequence = (CharSequence)object;
                Regex regex = usernameBeginSymbolRegex;
                String string3 = "";
                boolean bl = false;
                string2 = regex.replace(charSequence, string3);
            } else {
                string2 = null;
            }
            string = stringBuilder.append(string2).append('/').append(messageId).toString();
        } else if (!(chat instanceof PrivateChat)) {
            CharSequence charSequence = String.valueOf(chat.getId().getChatId());
            Regex regex = linkIdRedundantPartRegex;
            String string4 = "";
            boolean bl = false;
            charSequence = regex.replace(charSequence, string4);
            boolean bl2 = false;
            boolean bl3 = false;
            CharSequence bareId = charSequence;
            boolean bl4 = false;
            string = "https://t.me/c/" + (String)bareId + '/' + messageId;
        } else {
            return null;
        }
        return string;
    }

    @NotNull
    public static final String makeLinkToAddStickerSet(@NotNull String stickerSetName, @NotNull ParseMode parseMode) {
        Intrinsics.checkNotNullParameter((Object)stickerSetName, (String)"stickerSetName");
        Intrinsics.checkNotNullParameter((Object)parseMode, (String)"parseMode");
        return StringFormattingKt.link((Pair<String, String>)TuplesKt.to((Object)stickerSetName, (Object)("https://t.me/addstickers/" + stickerSetName)), parseMode);
    }

    @NotNull
    public static final String makeLinkToAddStickerSetInMarkdownV2(@NotNull String stickerSetName) {
        Intrinsics.checkNotNullParameter((Object)stickerSetName, (String)"stickerSetName");
        return LinksFormattingKt.makeLinkToAddStickerSet(stickerSetName, (ParseMode)MarkdownV2ParseMode.INSTANCE);
    }

    @NotNull
    public static final String makeLinkToAddStickerSetInMarkdown(@NotNull String stickerSetName) {
        Intrinsics.checkNotNullParameter((Object)stickerSetName, (String)"stickerSetName");
        return LinksFormattingKt.makeLinkToAddStickerSet(stickerSetName, (ParseMode)MarkdownParseMode.INSTANCE);
    }

    @NotNull
    public static final String makeLinkToAddStickerSetInHtml(@NotNull String stickerSetName) {
        Intrinsics.checkNotNullParameter((Object)stickerSetName, (String)"stickerSetName");
        return LinksFormattingKt.makeLinkToAddStickerSet(stickerSetName, (ParseMode)HTMLParseMode.INSTANCE);
    }
}

