/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.chat;

import dev.inmo.tgbotapi.types.ChatId;
import dev.inmo.tgbotapi.types.ChatIdWithThreadId;
import dev.inmo.tgbotapi.types.ChatIdentifierKt;
import dev.inmo.tgbotapi.types.IdChatIdentifier;
import dev.inmo.tgbotapi.types.chat.ChatSerializersKt;
import dev.inmo.tgbotapi.types.chat.ChatType;
import dev.inmo.tgbotapi.types.chat.ExtendedBot;
import dev.inmo.tgbotapi.types.chat.ExtendedChannelChatImpl;
import dev.inmo.tgbotapi.types.chat.ExtendedChat;
import dev.inmo.tgbotapi.types.chat.ExtendedForumChatImpl;
import dev.inmo.tgbotapi.types.chat.ExtendedGroupChatImpl;
import dev.inmo.tgbotapi.types.chat.ExtendedPrivateChatImpl;
import dev.inmo.tgbotapi.types.chat.ExtendedSupergroupChat;
import dev.inmo.tgbotapi.types.chat.ExtendedSupergroupChatImpl;
import dev.inmo.tgbotapi.types.chat.UnknownExtendedChat;
import dev.inmo.tgbotapi.utils.RiskFeature;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@RiskFeature
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Ldev/inmo/tgbotapi/types/chat/ExtendedChatSerializer;", "Lkotlinx/serialization/KSerializer;", "Ldev/inmo/tgbotapi/types/chat/ExtendedChat;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor$annotations", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "BasedOnForumThread", "Companion", "Ldev/inmo/tgbotapi/types/chat/ExtendedChatSerializer$BasedOnForumThread;", "Ldev/inmo/tgbotapi/types/chat/ExtendedChatSerializer$Companion;", "tgbotapi.core"})
public abstract class ExtendedChatSerializer
implements KSerializer<ExtendedChat> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SerialDescriptor descriptor = SerialDescriptorsKt.buildSerialDescriptor$default((String)"ExtendedChatSerializer", (SerialKind)((SerialKind)PolymorphicKind.OPEN.INSTANCE), (SerialDescriptor[])new SerialDescriptor[0], null, (int)8, null);

    private ExtendedChatSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    public static /* synthetic */ void getDescriptor$annotations() {
    }

    @NotNull
    public ExtendedChat deserialize(@NotNull Decoder decoder) {
        ExtendedChat extendedChat;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonObject decodedJson = (JsonObject)JsonObject.Companion.serializer().deserialize(decoder);
        Object object = (JsonElement)decodedJson.get((Object)"type");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null || (object = ChatSerializersKt.getAsChatType((String)object)) == null) {
            throw new IllegalStateException(("Field type must be presented, but absent in " + decodedJson).toString());
        }
        Object type = object;
        JsonElement jsonElement = (JsonElement)decodedJson.get((Object)"is_forum");
        boolean isForum = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? Intrinsics.areEqual((Object)JsonElementKt.getBooleanOrNull((JsonPrimitive)jsonElement), (Object)true) : false;
        Object object2 = type;
        if (Intrinsics.areEqual((Object)object2, (Object)ChatType.PrivateChatType.INSTANCE)) {
            extendedChat = (ExtendedChat)ChatSerializersKt.access$getFormatter().decodeFromJsonElement((DeserializationStrategy)ExtendedPrivateChatImpl.Companion.serializer(), (JsonElement)decodedJson);
        } else if (Intrinsics.areEqual((Object)object2, (Object)ChatType.GroupChatType.INSTANCE)) {
            extendedChat = (ExtendedChat)ChatSerializersKt.access$getFormatter().decodeFromJsonElement((DeserializationStrategy)ExtendedGroupChatImpl.Companion.serializer(), (JsonElement)decodedJson);
        } else if (Intrinsics.areEqual((Object)object2, (Object)ChatType.SupergroupChatType.INSTANCE)) {
            extendedChat = isForum ? (ExtendedSupergroupChat)ChatSerializersKt.access$getFormatter().decodeFromJsonElement((DeserializationStrategy)ExtendedForumChatImpl.Companion.serializer(), (JsonElement)decodedJson) : (ExtendedSupergroupChat)ChatSerializersKt.access$getFormatter().decodeFromJsonElement((DeserializationStrategy)ExtendedSupergroupChatImpl.Companion.serializer(), (JsonElement)decodedJson);
        } else if (Intrinsics.areEqual((Object)object2, (Object)ChatType.ChannelChatType.INSTANCE)) {
            extendedChat = (ExtendedChat)ChatSerializersKt.access$getFormatter().decodeFromJsonElement((DeserializationStrategy)ExtendedChannelChatImpl.Companion.serializer(), (JsonElement)decodedJson);
        } else if (object2 instanceof ChatType.UnknownChatType) {
            Json json2 = ChatSerializersKt.access$getFormatter();
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)BuiltinSerializersKt.serializer((LongCompanionObject)LongCompanionObject.INSTANCE);
            JsonElement jsonElement2 = (JsonElement)decodedJson.get((Object)"chat_id");
            if (jsonElement2 == null) {
                jsonElement2 = (JsonElement)JsonElementKt.JsonPrimitive((Number)-1);
            }
            extendedChat = new UnknownExtendedChat(ChatId.box-impl(ChatIdentifierKt.toChatId(((Number)json2.decodeFromJsonElement(deserializationStrategy, jsonElement2)).longValue())), decodedJson.toString(), decodedJson);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return extendedChat;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull ExtendedChat value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ExtendedChat extendedChat = value;
        if (extendedChat instanceof ExtendedPrivateChatImpl) {
            ExtendedPrivateChatImpl.Companion.serializer().serialize(encoder, (Object)value);
        } else if (extendedChat instanceof ExtendedGroupChatImpl) {
            ExtendedGroupChatImpl.Companion.serializer().serialize(encoder, (Object)value);
        } else if (extendedChat instanceof ExtendedSupergroupChatImpl) {
            ExtendedSupergroupChatImpl.Companion.serializer().serialize(encoder, (Object)value);
        } else if (extendedChat instanceof ExtendedForumChatImpl) {
            ExtendedForumChatImpl.Companion.serializer().serialize(encoder, (Object)value);
        } else if (extendedChat instanceof ExtendedChannelChatImpl) {
            ExtendedChannelChatImpl.Companion.serializer().serialize(encoder, (Object)value);
        } else if (extendedChat instanceof ExtendedBot) {
            ExtendedBot.Companion.serializer().serialize(encoder, (Object)value);
        } else if (extendedChat instanceof UnknownExtendedChat) {
            JsonObject.Companion.serializer().serialize(encoder, (Object)((UnknownExtendedChat)value).getRawJson());
        }
    }

    public /* synthetic */ ExtendedChatSerializer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/inmo/tgbotapi/types/chat/ExtendedChatSerializer$BasedOnForumThread;", "Ldev/inmo/tgbotapi/types/chat/ExtendedChatSerializer;", "threadId", "", "Ldev/inmo/tgbotapi/types/MessageThreadId;", "(J)V", "deserialize", "Ldev/inmo/tgbotapi/types/chat/ExtendedChat;", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "tgbotapi.core"})
    public static final class BasedOnForumThread
    extends ExtendedChatSerializer {
        private final long threadId;

        public BasedOnForumThread(long threadId) {
            super(null);
            this.threadId = threadId;
        }

        @Override
        @NotNull
        public ExtendedChat deserialize(@NotNull Decoder decoder) {
            ExtendedChat extendedChat;
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            ExtendedChat it = super.deserialize(decoder);
            boolean bl = false;
            if (it instanceof ExtendedForumChatImpl) {
                ExtendedForumChatImpl extendedForumChatImpl = (ExtendedForumChatImpl)it;
                IdChatIdentifier idChatIdentifier = it.getId();
                Pair<? extends Long, ? extends Long> pair = idChatIdentifier instanceof ChatIdWithThreadId ? ((ChatIdWithThreadId)idChatIdentifier).unbox-impl() : null;
                if (pair == null) {
                    pair = ChatIdWithThreadId.constructor-impl(it.getId().getChatId(), this.threadId);
                }
                extendedChat = ExtendedForumChatImpl.copy$default(extendedForumChatImpl, ChatIdWithThreadId.box-impl((Pair)pair), null, null, null, null, null, null, null, null, null, null, false, null, null, false, false, false, false, 262142, null);
            } else {
                extendedChat = it;
            }
            return extendedChat;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ldev/inmo/tgbotapi/types/chat/ExtendedChatSerializer$Companion;", "Ldev/inmo/tgbotapi/types/chat/ExtendedChatSerializer;", "()V", "tgbotapi.core"})
    public static final class Companion
    extends ExtendedChatSerializer {
        private Companion() {
            super(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

