/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.message;

import dev.inmo.tgbotapi.types.chat.User;
import dev.inmo.tgbotapi.types.message.RawMessageEntity;
import dev.inmo.tgbotapi.types.message.textsources.BoldTextSource;
import dev.inmo.tgbotapi.types.message.textsources.BotCommandTextSource;
import dev.inmo.tgbotapi.types.message.textsources.CashTagTextSource;
import dev.inmo.tgbotapi.types.message.textsources.CodeTextSource;
import dev.inmo.tgbotapi.types.message.textsources.CustomEmojiTextSource;
import dev.inmo.tgbotapi.types.message.textsources.EMailTextSource;
import dev.inmo.tgbotapi.types.message.textsources.HashTagTextSource;
import dev.inmo.tgbotapi.types.message.textsources.ItalicTextSource;
import dev.inmo.tgbotapi.types.message.textsources.MentionTextSource;
import dev.inmo.tgbotapi.types.message.textsources.MultilevelTextSource;
import dev.inmo.tgbotapi.types.message.textsources.PhoneNumberTextSource;
import dev.inmo.tgbotapi.types.message.textsources.PreTextSource;
import dev.inmo.tgbotapi.types.message.textsources.RegularTextSource;
import dev.inmo.tgbotapi.types.message.textsources.SpoilerTextSource;
import dev.inmo.tgbotapi.types.message.textsources.StrikethroughTextSource;
import dev.inmo.tgbotapi.types.message.textsources.TextLinkTextSource;
import dev.inmo.tgbotapi.types.message.textsources.TextMentionTextSource;
import dev.inmo.tgbotapi.types.message.textsources.TextSource;
import dev.inmo.tgbotapi.types.message.textsources.URLTextSource;
import dev.inmo.tgbotapi.types.message.textsources.UnderlineTextSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\b\u001a4\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\b0\u0001j\u0002`\tH\u0002\u001a.\u0010\n\u001a\u00020\u0004*\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001H\u0000\u001a(\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u00040\u0001j\u0002`\u000e*\f\u0012\u0004\u0012\u00020\b0\u0001j\u0002`\t2\u0006\u0010\u000f\u001a\u00020\u0006H\u0000\u001a1\u0010\u0010\u001a\u00020\u0011\"\u000e\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u0013*\b\u0012\u0004\u0012\u0002H\u00120\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014H\u0082\n\u001a0\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00040\u0001j\u0002`\u000e*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0006H\u0000\u001a\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0001*\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0001*\f\u0012\u0004\u0012\u00020\u00040\u0001j\u0002`\u000eH\u0000\u001a&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0001*\f\u0012\u0004\u0012\u00020\u00040\u0001j\u0002`\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\u0003H\u0000*\u0018\b\u0000\u0010\u001a\"\b\u0012\u0004\u0012\u00020\b0\u00012\b\u0012\u0004\u0012\u00020\b0\u0001\u00a8\u0006\u001b\u00b2\u0006\u0014\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u00040\u0001j\u0002`\u000eX\u008a\u0084\u0002"}, d2={"createTextSources", "", "Lkotlin/Pair;", "", "Ldev/inmo/tgbotapi/types/message/textsources/TextSource;", "originalFullString", "", "entities", "Ldev/inmo/tgbotapi/types/message/RawMessageEntity;", "Ldev/inmo/tgbotapi/types/message/RawMessageEntities;", "asTextSource", "source", "subParts", "asTextSources", "Ldev/inmo/tgbotapi/types/message/textsources/TextSourcesList;", "sourceString", "contains", "", "T", "", "Lkotlin/ranges/ClosedRange;", "other", "fillWithRegulars", "toRawMessageEntities", "offset", "preOffset", "RawMessageEntities", "tgbotapi.core", "subPartsWithRegulars"})
@SourceDebugExtension(value={"SMAP\nRawMessageEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawMessageEntity.kt\ndev/inmo/tgbotapi/types/message/RawMessageEntityKt\n+ 2 RegularTextSource.kt\ndev/inmo/tgbotapi/types/message/textsources/RegularTextSourceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n85#1:224\n20#2:218\n20#2:219\n1002#3,2:220\n1002#3,2:222\n1549#3:225\n1620#3,3:226\n1360#3:229\n1446#3,2:230\n1963#3,14:232\n1448#3,3:246\n*S KotlinDebug\n*F\n+ 1 RawMessageEntity.kt\ndev/inmo/tgbotapi/types/message/RawMessageEntityKt\n*L\n126#1:224\n94#1:218\n102#1:219\n113#1:220,2\n114#1:222,2\n145#1:225\n145#1:226,3\n204#1:229\n204#1:230,2\n206#1:232,14\n204#1:246,3\n*E\n"})
public final class RawMessageEntityKt {
    @NotNull
    public static final TextSource asTextSource(@NotNull RawMessageEntity $this$asTextSource, @NotNull String source, @NotNull List<? extends Pair<Integer, ? extends TextSource>> subParts) {
        Intrinsics.checkNotNullParameter((Object)$this$asTextSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(subParts, (String)"subParts");
        String sourceSubstring = StringsKt.substring((String)source, (IntRange)$this$asTextSource.getRange$tgbotapi_core());
        Lazy subPartsWithRegulars$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends TextSource>>(subParts, sourceSubstring, $this$asTextSource){
            final /* synthetic */ List<Pair<Integer, TextSource>> $subParts;
            final /* synthetic */ String $sourceSubstring;
            final /* synthetic */ RawMessageEntity $this_asTextSource;
            {
                this.$subParts = $subParts;
                this.$sourceSubstring = $sourceSubstring;
                this.$this_asTextSource = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<TextSource> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$subParts;
                RawMessageEntity rawMessageEntity = this.$this_asTextSource;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)(((Number)it.getFirst()).intValue() - rawMessageEntity.getOffset()), (Object)it.getSecond()));
                }
                return RawMessageEntityKt.fillWithRegulars((List)destination$iv$iv, this.$sourceSubstring);
            }
        }));
        return switch ($this$asTextSource.getType()) {
            case "mention" -> new MentionTextSource(sourceSubstring, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            case "hashtag" -> new HashTagTextSource(sourceSubstring, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            case "cashtag" -> new CashTagTextSource(sourceSubstring, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            case "bot_command" -> new BotCommandTextSource(sourceSubstring);
            case "url" -> new URLTextSource(sourceSubstring);
            case "email" -> new EMailTextSource(sourceSubstring, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            case "phone_number" -> new PhoneNumberTextSource(sourceSubstring, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            case "bold" -> new BoldTextSource(sourceSubstring, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            case "italic" -> new ItalicTextSource(sourceSubstring, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            case "code" -> new CodeTextSource(sourceSubstring);
            case "pre" -> new PreTextSource(sourceSubstring, $this$asTextSource.getLanguage());
            case "text_link" -> {
                String v1 = $this$asTextSource.getUrl();
                if (v1 == null) {
                    throw new IllegalStateException("URL must not be null for text link");
                }
                yield new TextLinkTextSource(sourceSubstring, v1);
            }
            case "text_mention" -> {
                User v2 = $this$asTextSource.getUser();
                if (v2 == null) {
                    throw new IllegalStateException("User must not be null for text mention");
                }
                yield new TextMentionTextSource(sourceSubstring, v2, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            }
            case "underline" -> new UnderlineTextSource(sourceSubstring, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            case "strikethrough" -> new StrikethroughTextSource(sourceSubstring, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            case "spoiler" -> new SpoilerTextSource(sourceSubstring, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate));
            case "custom_emoji" -> {
                String v3 = $this$asTextSource.getCustom_emoji_id-GbmMWyQ();
                if (v3 == null) {
                    throw new IllegalStateException("For custom emoji custom_emoji_id should exists".toString());
                }
                yield new CustomEmojiTextSource(sourceSubstring, v3, RawMessageEntityKt.asTextSource$lambda$0((Lazy<? extends List<? extends TextSource>>)subPartsWithRegulars$delegate), null);
            }
            default -> new RegularTextSource(sourceSubstring);
        };
    }

    private static final <T extends Comparable<? super T>> boolean contains(ClosedRange<T> $this$contains, ClosedRange<T> other) {
        Intrinsics.checkNotNullParameter($this$contains, (String)"<this>");
        boolean $i$f$contains = false;
        return $this$contains.getStart().compareTo(other.getStart()) <= 0 && $this$contains.getEndInclusive().compareTo(other.getEndInclusive()) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TextSource> fillWithRegulars(@NotNull List<? extends Pair<Integer, ? extends TextSource>> $this$fillWithRegulars, @NotNull String source) {
        Intrinsics.checkNotNullParameter($this$fillWithRegulars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int index = 0;
        List result2 = new ArrayList();
        int n = $this$fillWithRegulars.size();
        for (int i = 0; i < n; ++i) {
            Pair<Integer, ? extends TextSource> pair = $this$fillWithRegulars.get(i);
            int offset = ((Number)pair.component1()).intValue();
            TextSource textSource = (TextSource)pair.component2();
            if (offset - index > 0) {
                void text$iv;
                Intrinsics.checkNotNullExpressionValue((Object)source.substring(index, offset), (String)"substring(...)");
                boolean $i$f$regular = false;
                result2.add(new RegularTextSource((String)text$iv));
                index = offset;
            }
            result2.add(textSource);
            index += textSource.getSource().length();
        }
        if (index != source.length()) {
            void text$iv;
            String string = source.substring(index, source.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String i = string;
            boolean $i$f$regular = false;
            result2.add(new RegularTextSource((String)text$iv));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<Integer, TextSource>> createTextSources(String originalFullString, List<RawMessageEntity> entities) {
        List list;
        List $this$createTextSources_u24lambda_u243 = list = CollectionsKt.toMutableList((Collection)entities);
        boolean bl = false;
        List $this$sortBy$iv = $this$createTextSources_u24lambda_u243;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    RawMessageEntity it = (RawMessageEntity)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (RawMessageEntity)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                }
            });
        }
        $this$sortBy$iv = $this$createTextSources_u24lambda_u243;
        $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    RawMessageEntity it = (RawMessageEntity)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getOffset());
                    it = (RawMessageEntity)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOffset()));
                }
            });
        }
        List mutableEntities = list;
        List resultList = new ArrayList();
        while (!((Collection)mutableEntities).isEmpty()) {
            List<Pair<Integer, TextSource>> list2;
            Object other$iv;
            RawMessageEntity parent = (RawMessageEntity)CollectionsKt.removeFirst((List)mutableEntities);
            List subentities = new ArrayList();
            List toAddCutted = new ArrayList();
            while (!((Collection)mutableEntities).isEmpty()) {
                void $this$contains$iv;
                RawMessageEntity potentialParent = (RawMessageEntity)CollectionsKt.first((List)mutableEntities);
                if (potentialParent.getRange$tgbotapi_core().getFirst() > parent.getRange$tgbotapi_core().getLast()) break;
                ClosedRange closedRange = (ClosedRange)parent.getRange$tgbotapi_core();
                other$iv = (ClosedRange)potentialParent.getRange$tgbotapi_core();
                boolean $i$f$contains = false;
                if ($this$contains$iv.getStart().compareTo(other$iv.getStart()) <= 0 && $this$contains$iv.getEndInclusive().compareTo(other$iv.getEndInclusive()) >= 0) {
                    subentities.add(potentialParent);
                } else if (potentialParent.getOffset() == parent.getOffset() && potentialParent.getLength() > parent.getLength()) {
                    subentities.add(parent);
                    parent = potentialParent;
                } else {
                    toAddCutted.add(potentialParent);
                }
                mutableEntities.remove(potentialParent);
            }
            if (!((Collection)subentities).isEmpty()) {
                mutableEntities.removeAll(subentities);
                if (!((Collection)toAddCutted).isEmpty()) {
                    Collection<RawMessageEntity> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    int borderIndex = parent.getRange$tgbotapi_core().getLast() + 1;
                    other$iv = toAddCutted;
                    int n = 0;
                    List list3 = mutableEntities;
                    boolean $i$f$map = false;
                    void var11_15 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        RawMessageEntity rawMessageEntity = (RawMessageEntity)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        int firstLength = borderIndex - it.getOffset();
                        subentities.add(RawMessageEntity.copy-SbQeJ6M$default((RawMessageEntity)it, null, 0, firstLength, null, null, null, null, 123, null));
                        collection.add(RawMessageEntity.copy-SbQeJ6M$default((RawMessageEntity)it, null, borderIndex, it.getLength() - firstLength, null, null, null, null, 121, null));
                    }
                    collection = (List)destination$iv$iv;
                    list3.addAll(n, (Collection)collection);
                }
                list2 = RawMessageEntityKt.createTextSources(originalFullString, subentities);
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List<Pair<Integer, TextSource>> subtextSources = list2;
            resultList.add(TuplesKt.to((Object)parent.getOffset(), (Object)RawMessageEntityKt.asTextSource(parent, originalFullString, (List<? extends Pair<Integer, ? extends TextSource>>)subtextSources)));
        }
        return resultList;
    }

    @NotNull
    public static final List<RawMessageEntity> toRawMessageEntities(@NotNull TextSource $this$toRawMessageEntities, int offset) {
        RawMessageEntity rawMessageEntity;
        Intrinsics.checkNotNullParameter((Object)$this$toRawMessageEntities, (String)"<this>");
        String source = $this$toRawMessageEntities.getSource();
        int length = source.length();
        TextSource textSource = $this$toRawMessageEntities;
        if (textSource instanceof MentionTextSource) {
            rawMessageEntity = new RawMessageEntity("mention", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof HashTagTextSource) {
            rawMessageEntity = new RawMessageEntity("hashtag", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof CashTagTextSource) {
            rawMessageEntity = new RawMessageEntity("cashtag", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof BotCommandTextSource) {
            rawMessageEntity = new RawMessageEntity("bot_command", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof URLTextSource) {
            rawMessageEntity = new RawMessageEntity("url", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof EMailTextSource) {
            rawMessageEntity = new RawMessageEntity("email", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof PhoneNumberTextSource) {
            rawMessageEntity = new RawMessageEntity("phone_number", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof BoldTextSource) {
            rawMessageEntity = new RawMessageEntity("bold", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof ItalicTextSource) {
            rawMessageEntity = new RawMessageEntity("italic", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof CodeTextSource) {
            rawMessageEntity = new RawMessageEntity("code", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof PreTextSource) {
            rawMessageEntity = new RawMessageEntity("pre", offset, length, null, null, ((PreTextSource)$this$toRawMessageEntities).getLanguage(), null, 88, null);
        } else if (textSource instanceof TextLinkTextSource) {
            rawMessageEntity = new RawMessageEntity("text_link", offset, length, ((TextLinkTextSource)$this$toRawMessageEntities).getUrl(), null, null, null, 112, null);
        } else if (textSource instanceof TextMentionTextSource) {
            rawMessageEntity = new RawMessageEntity("text_mention", offset, length, null, ((TextMentionTextSource)$this$toRawMessageEntities).getUser(), null, null, 104, null);
        } else if (textSource instanceof UnderlineTextSource) {
            rawMessageEntity = new RawMessageEntity("underline", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof StrikethroughTextSource) {
            rawMessageEntity = new RawMessageEntity("strikethrough", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof SpoilerTextSource) {
            rawMessageEntity = new RawMessageEntity("spoiler", offset, length, null, null, null, null, 120, null);
        } else if (textSource instanceof CustomEmojiTextSource) {
            rawMessageEntity = new RawMessageEntity("custom_emoji", offset, length, null, null, null, ((CustomEmojiTextSource)$this$toRawMessageEntities).getCustomEmojiId-dDnjveI(), 56, null);
        } else if (textSource instanceof RegularTextSource) {
            rawMessageEntity = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)rawMessageEntity), (Iterable)($this$toRawMessageEntities instanceof MultilevelTextSource ? RawMessageEntityKt.toRawMessageEntities(((MultilevelTextSource)$this$toRawMessageEntities).getSubsources(), offset) : CollectionsKt.emptyList()));
    }

    public static /* synthetic */ List toRawMessageEntities$default(TextSource textSource, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return RawMessageEntityKt.toRawMessageEntities(textSource, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RawMessageEntity> toRawMessageEntities(@NotNull List<? extends TextSource> $this$toRawMessageEntities, int preOffset) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toRawMessageEntities, (String)"<this>");
        int i = 0;
        i = preOffset;
        Iterable $this$flatMap$iv = $this$toRawMessageEntities;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object v0;
            void $this$maxByOrNull$iv;
            List<RawMessageEntity> list;
            TextSource textSource = (TextSource)element$iv$iv;
            boolean bl = false;
            List<RawMessageEntity> it = list = RawMessageEntityKt.toRawMessageEntities(textSource, i);
            boolean bl2 = false;
            Iterable iterable2 = it;
            int n = i;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    RawMessageEntity it2 = (RawMessageEntity)maxElem$iv;
                    boolean bl3 = false;
                    int maxValue$iv = it2.getLength();
                    do {
                        Object e$iv = iterator$iv.next();
                        RawMessageEntity it3 = (RawMessageEntity)e$iv;
                        $i$a$-maxByOrNull-RawMessageEntityKt$toRawMessageEntities$1$1$1 = false;
                        int v$iv = it3.getLength();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Object var24_27 = v0;
            RawMessageEntity rawMessageEntity = var24_27;
            i = n + (rawMessageEntity != null ? rawMessageEntity.getLength() : textSource.getSource().length());
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List toRawMessageEntities$default(List list, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return RawMessageEntityKt.toRawMessageEntities(list, n);
    }

    @NotNull
    public static final List<RawMessageEntity> toRawMessageEntities(@NotNull List<? extends TextSource> $this$toRawMessageEntities) {
        Intrinsics.checkNotNullParameter($this$toRawMessageEntities, (String)"<this>");
        return RawMessageEntityKt.toRawMessageEntities($this$toRawMessageEntities, 0);
    }

    @NotNull
    public static final List<TextSource> asTextSources(@NotNull List<RawMessageEntity> $this$asTextSources, @NotNull String sourceString) {
        Intrinsics.checkNotNullParameter($this$asTextSources, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sourceString, (String)"sourceString");
        return RawMessageEntityKt.fillWithRegulars(RawMessageEntityKt.createTextSources(sourceString, $this$asTextSources), sourceString);
    }

    private static final List<TextSource> asTextSource$lambda$0(Lazy<? extends List<? extends TextSource>> $subPartsWithRegulars$delegate) {
        Lazy<? extends List<? extends TextSource>> lazy = $subPartsWithRegulars$delegate;
        return (List)lazy.getValue();
    }
}

