/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.utils;

import io.ktor.http.CodecsKt;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import korlibs.crypto.HMAC;
import korlibs.crypto.Hash;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Ldev/inmo/tgbotapi/utils/TelegramAPIUrlsKeeper;", "", "token", "", "testServer", "", "hostUrl", "(Ljava/lang/String;ZLjava/lang/String;)V", "urlsSuffixes", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "commonAPIUrl", "getCommonAPIUrl", "()Ljava/lang/String;", "fileBaseUrl", "getFileBaseUrl", "webAppDataSecretKey", "getWebAppDataSecretKey", "webAppDataSecretKeyHash", "Lkorlibs/crypto/Hash;", "getWebAppDataSecretKeyHash", "()Lkorlibs/crypto/Hash;", "webAppDataSecretKeyHash$delegate", "Lkotlin/Lazy;", "checkWebAppData", "rawData", "hash", "createFileLinkUrl", "filePath", "tgbotapi.core"})
@SourceDebugExtension(value={"SMAP\nTelegramAPIUrlsKeeper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelegramAPIUrlsKeeper.kt\ndev/inmo/tgbotapi/utils/TelegramAPIUrlsKeeper\n+ 2 TelegramAPIUrlsKeeper.kt\ndev/inmo/tgbotapi/utils/TelegramAPIUrlsKeeperKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Strings.kt\nio/ktor/utils/io/core/StringsKt\n*L\n1#1,64:1\n11#2,7:65\n1#3:72\n819#4:73\n847#4,2:74\n7#5,4:76\n*S KotlinDebug\n*F\n+ 1 TelegramAPIUrlsKeeper.kt\ndev/inmo/tgbotapi/utils/TelegramAPIUrlsKeeper\n*L\n42#1:65,7\n57#1:73\n57#1:74,2\n61#1:76,4\n*E\n"})
public final class TelegramAPIUrlsKeeper {
    @NotNull
    private final Lazy webAppDataSecretKeyHash$delegate;
    @NotNull
    private final String commonAPIUrl;
    @NotNull
    private final String fileBaseUrl;

    public TelegramAPIUrlsKeeper(@NotNull String token, @NotNull String hostUrl, @NotNull String urlsSuffixes) {
        String withoutSuffix$iv;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)hostUrl, (String)"hostUrl");
        Intrinsics.checkNotNullParameter((Object)urlsSuffixes, (String)"urlsSuffixes");
        this.webAppDataSecretKeyHash$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Hash>(token){
            final /* synthetic */ String $token;
            {
                this.$token = $token;
                super(0);
            }

            @NotNull
            public final Hash invoke() {
                byte[] byArray;
                byte[] byArray2;
                String $this$toByteArray_u24default$iv = "WebAppData";
                Charset charset$iv = Charsets.UTF_8;
                boolean $i$f$toByteArray = false;
                if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
                    byArray2 = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv);
                } else {
                    CharsetEncoder charsetEncoder = charset$iv.newEncoder();
                    Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
                    byArray2 = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray_u24default$iv, (int)0, (int)$this$toByteArray_u24default$iv.length());
                }
                $this$toByteArray_u24default$iv = this.$token;
                charset$iv = Charsets.UTF_8;
                $i$f$toByteArray = false;
                if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
                    byArray = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv);
                } else {
                    CharsetEncoder charsetEncoder = charset$iv.newEncoder();
                    Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
                    byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray_u24default$iv, (int)0, (int)$this$toByteArray_u24default$iv.length());
                }
                return HMAC.Companion.hmacSHA256(byArray2, byArray);
            }
        }));
        String $this$withoutLastSlash$iv = hostUrl;
        boolean $i$f$getWithoutLastSlash = false;
        String correctedUrl$iv = $this$withoutLastSlash$iv;
        while (!Intrinsics.areEqual((Object)(withoutSuffix$iv = StringsKt.removeSuffix((String)correctedUrl$iv, (CharSequence)"/")), (Object)correctedUrl$iv)) {
            correctedUrl$iv = withoutSuffix$iv;
        }
        String correctedHost = correctedUrl$iv;
        this.commonAPIUrl = correctedHost + "/bot" + token + urlsSuffixes;
        this.fileBaseUrl = correctedHost + "/file/bot" + token + urlsSuffixes;
    }

    public /* synthetic */ TelegramAPIUrlsKeeper(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "https://api.telegram.org";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final Hash getWebAppDataSecretKeyHash() {
        Lazy lazy = this.webAppDataSecretKeyHash$delegate;
        return (Hash)lazy.getValue();
    }

    @NotNull
    public final String getWebAppDataSecretKey() {
        return this.getWebAppDataSecretKeyHash().getHexLower();
    }

    @NotNull
    public final String getCommonAPIUrl() {
        return this.commonAPIUrl;
    }

    @NotNull
    public final String getFileBaseUrl() {
        return this.fileBaseUrl;
    }

    public TelegramAPIUrlsKeeper(@NotNull String token, boolean testServer, @NotNull String hostUrl) {
        String string;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)hostUrl, (String)"hostUrl");
        String string2 = string = "/test";
        String string3 = hostUrl;
        String string4 = token;
        TelegramAPIUrlsKeeper telegramAPIUrlsKeeper = this;
        boolean bl = false;
        boolean bl2 = testServer;
        String string5 = bl2 ? string : null;
        if (string5 == null) {
            string5 = "";
        }
        telegramAPIUrlsKeeper(string4, string3, string5);
    }

    public /* synthetic */ TelegramAPIUrlsKeeper(String string, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "https://api.telegram.org";
        }
        this(string, bl, string2);
    }

    @NotNull
    public final String createFileLinkUrl(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.fileBaseUrl + '/' + filePath;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkWebAppData(@NotNull String rawData, @NotNull String hash) {
        byte[] byArray;
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Object object = new String[]{"&"};
        object = StringsKt.split$default((CharSequence)CodecsKt.decodeURLQueryComponent$default((String)rawData, (int)0, (int)0, (boolean)false, null, (int)15, null), (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filterNot = false;
        void var6_6 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it, (String)"hash=", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String preparedData = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        byte[] byArray2 = this.getWebAppDataSecretKeyHash().getBytes();
        String $this$toByteArray_u24default$iv = preparedData;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$toByteArray = false;
        if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
            byArray = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv);
        } else {
            CharsetEncoder charsetEncoder = charset$iv.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray_u24default$iv, (int)0, (int)$this$toByteArray_u24default$iv.length());
        }
        String string = HMAC.Companion.hmacSHA256(byArray2, byArray).getHexLower();
        String string2 = hash.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return Intrinsics.areEqual((Object)string, (Object)string2);
    }
}

