/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.polls;

import com.soywiz.klock.DateTime;
import com.soywiz.klock.TimeSpan;
import dev.inmo.tgbotapi.types.message.RawMessageEntityKt;
import dev.inmo.tgbotapi.types.message.textsources.TextSource;
import dev.inmo.tgbotapi.types.polls.ApproximateScheduledCloseInfo;
import dev.inmo.tgbotapi.types.polls.ExactScheduledCloseInfo;
import dev.inmo.tgbotapi.types.polls.Poll;
import dev.inmo.tgbotapi.types.polls.PollOption;
import dev.inmo.tgbotapi.types.polls.QuizPoll;
import dev.inmo.tgbotapi.types.polls.RawPoll;
import dev.inmo.tgbotapi.types.polls.RegularPoll;
import dev.inmo.tgbotapi.types.polls.ScheduledCloseInfo;
import dev.inmo.tgbotapi.types.polls.UnknownPollType;
import dev.inmo.tgbotapi.utils.JSONKt;
import dev.inmo.tgbotapi.utils.RiskFeature;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@RiskFeature
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ldev/inmo/tgbotapi/types/polls/PollSerializer;", "Lkotlinx/serialization/KSerializer;", "Ldev/inmo/tgbotapi/types/polls/Poll;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "tgbotapi.core"})
@SourceDebugExtension(value={"SMAP\nPoll.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Poll.kt\ndev/inmo/tgbotapi/types/polls/PollSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
public final class PollSerializer
implements KSerializer<Poll> {
    @NotNull
    public static final PollSerializer INSTANCE = new PollSerializer();

    private PollSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return RawPoll.Companion.serializer().getDescriptor();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Poll deserialize(@NotNull Decoder decoder) {
        Poll poll;
        block5: {
            String string;
            RawPoll rawPoll;
            JsonObject asJson;
            block2: {
                Object object;
                String string2;
                Integer n;
                int n2;
                List<PollOption> list;
                String string3;
                String string4;
                block4: {
                    block3: {
                        void it;
                        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
                        asJson = (JsonObject)JsonObject.Companion.serializer().deserialize(decoder);
                        rawPoll = (RawPoll)JSONKt.getNonstrictJsonFormat().decodeFromJsonElement((DeserializationStrategy)RawPoll.Companion.serializer(), (JsonElement)asJson);
                        string = rawPoll.getType();
                        if (!Intrinsics.areEqual((Object)string, (Object)"quiz")) break block2;
                        string4 = rawPoll.getId();
                        string3 = rawPoll.getQuestion();
                        list = rawPoll.getOptions();
                        n2 = rawPoll.getVotesCount();
                        n = rawPoll.getCorrectOptionId();
                        string2 = rawPoll.getExplanation();
                        object = rawPoll.getExplanation();
                        if (object == null) break block3;
                        String string5 = object;
                        String string6 = string2;
                        Integer n3 = n;
                        int n4 = n2;
                        List<PollOption> list2 = list;
                        String string7 = string3;
                        String string8 = string4;
                        boolean bl = false;
                        List<TextSource> list3 = RawMessageEntityKt.asTextSources(rawPoll.getExplanationEntities(), (String)it);
                        string4 = string8;
                        string3 = string7;
                        list = list2;
                        n2 = n4;
                        n = n3;
                        string2 = string6;
                        List<TextSource> list4 = list3;
                        object = list4;
                        if (list4 != null) break block4;
                    }
                    object = CollectionsKt.emptyList();
                }
                ScheduledCloseInfo scheduledCloseInfo = rawPoll.getScheduledCloseInfo();
                boolean bl = rawPoll.isAnonymous();
                boolean bl2 = rawPoll.isClosed();
                List<TextSource> list5 = object;
                String string9 = string2;
                Integer n5 = n;
                int n6 = n2;
                List<PollOption> list6 = list;
                String string10 = string3;
                String string11 = string4;
                poll = new QuizPoll(string11, string10, list6, n6, n5, string9, list5, bl2, bl, scheduledCloseInfo);
                break block5;
            }
            poll = Intrinsics.areEqual((Object)string, (Object)"regular") ? (Poll)new RegularPoll(rawPoll.getId(), rawPoll.getQuestion(), rawPoll.getOptions(), rawPoll.getVotesCount(), rawPoll.isClosed(), rawPoll.isAnonymous(), rawPoll.getAllowMultipleAnswers(), rawPoll.getScheduledCloseInfo()) : (Poll)new UnknownPollType(rawPoll.getId(), rawPoll.getQuestion(), rawPoll.getOptions(), rawPoll.getVotesCount(), rawPoll.isClosed(), rawPoll.isAnonymous(), asJson);
        }
        return poll;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Poll value) {
        RawPoll rawPoll;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ScheduledCloseInfo closeInfo = value.getScheduledCloseInfo();
        Poll poll = value;
        if (poll instanceof RegularPoll) {
            ApproximateScheduledCloseInfo approximateScheduledCloseInfo = closeInfo instanceof ApproximateScheduledCloseInfo ? (ApproximateScheduledCloseInfo)closeInfo : null;
            ExactScheduledCloseInfo exactScheduledCloseInfo = closeInfo instanceof ExactScheduledCloseInfo ? (ExactScheduledCloseInfo)closeInfo : null;
            rawPoll = new RawPoll(value.getId(), value.getQuestion(), value.getOptions(), value.getVotesCount(), value.isClosed(), value.isAnonymous(), "regular", ((RegularPoll)value).getAllowMultipleAnswers(), null, null, null, approximateScheduledCloseInfo != null ? Long.valueOf((long)TimeSpan.getSeconds-impl((double)approximateScheduledCloseInfo.getOpenDuration-v1w6yZw())) : null, exactScheduledCloseInfo != null ? Long.valueOf(DateTime.getUnixMillisLong-impl((double)exactScheduledCloseInfo.getCloseDateTime-TZYpA4o()) / 1000L) : null, 1792, null);
        } else if (poll instanceof QuizPoll) {
            ApproximateScheduledCloseInfo approximateScheduledCloseInfo = closeInfo instanceof ApproximateScheduledCloseInfo ? (ApproximateScheduledCloseInfo)closeInfo : null;
            ExactScheduledCloseInfo exactScheduledCloseInfo = closeInfo instanceof ExactScheduledCloseInfo ? (ExactScheduledCloseInfo)closeInfo : null;
            rawPoll = new RawPoll(value.getId(), value.getQuestion(), value.getOptions(), value.getVotesCount(), value.isClosed(), value.isAnonymous(), "regular", false, ((QuizPoll)value).getCorrectOptionId(), ((QuizPoll)value).getText(), RawMessageEntityKt.toRawMessageEntities(((QuizPoll)value).getTextSources()), approximateScheduledCloseInfo != null ? Long.valueOf((long)TimeSpan.getSeconds-impl((double)approximateScheduledCloseInfo.getOpenDuration-v1w6yZw())) : null, exactScheduledCloseInfo != null ? Long.valueOf(DateTime.getUnixMillisLong-impl((double)exactScheduledCloseInfo.getCloseDateTime-TZYpA4o()) / 1000L) : null, 128, null);
        } else {
            if (poll instanceof UnknownPollType) {
                JsonObject.Companion.serializer().serialize(encoder, (Object)((UnknownPollType)value).getRaw());
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        RawPoll rawPoll2 = rawPoll;
        RawPoll.Companion.serializer().serialize(encoder, (Object)rawPoll2);
    }
}

