/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.buttons;

import dev.inmo.tgbotapi.types.buttons.KeyboardButton;
import dev.inmo.tgbotapi.types.buttons.KeyboardButtonPollType;
import dev.inmo.tgbotapi.types.buttons.KeyboardButtonPollTypeSerializer;
import dev.inmo.tgbotapi.types.buttons.RequestContactKeyboardButton;
import dev.inmo.tgbotapi.types.buttons.RequestLocationKeyboardButton;
import dev.inmo.tgbotapi.types.buttons.RequestPollKeyboardButton;
import dev.inmo.tgbotapi.types.buttons.SimpleKeyboardButton;
import dev.inmo.tgbotapi.types.buttons.UnknownKeyboardButton;
import dev.inmo.tgbotapi.types.buttons.WebAppKeyboardButton;
import dev.inmo.tgbotapi.types.webapps.WebAppInfo;
import dev.inmo.tgbotapi.utils.JSONKt;
import dev.inmo.tgbotapi.utils.RiskFeature;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@RiskFeature
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/inmo/tgbotapi/types/buttons/KeyboardButtonSerializer;", "Lkotlinx/serialization/KSerializer;", "Ldev/inmo/tgbotapi/types/buttons/KeyboardButton;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "internalSerializer", "Lkotlinx/serialization/json/JsonElement;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "tgbotapi.core"})
public final class KeyboardButtonSerializer
implements KSerializer<KeyboardButton> {
    @NotNull
    public static final KeyboardButtonSerializer INSTANCE = new KeyboardButtonSerializer();
    @NotNull
    private static final KSerializer<JsonElement> internalSerializer = JsonElement.Companion.serializer();
    @NotNull
    private static final SerialDescriptor descriptor = internalSerializer.getDescriptor();

    private KeyboardButtonSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public KeyboardButton deserialize(@NotNull Decoder decoder) {
        KeyboardButton keyboardButton;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonElement asJson = (JsonElement)internalSerializer.deserialize(decoder);
        if (asJson instanceof JsonPrimitive) {
            keyboardButton = new SimpleKeyboardButton(((JsonPrimitive)asJson).getContent());
        } else if (asJson instanceof JsonObject && ((JsonObject)asJson).get((Object)"request_contact") != null) {
            Object object = ((JsonObject)asJson).get((Object)"text");
            Intrinsics.checkNotNull((Object)object);
            keyboardButton = new RequestContactKeyboardButton(JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object)).getContent());
        } else if (asJson instanceof JsonObject && ((JsonObject)asJson).get((Object)"request_location") != null) {
            Object object = ((JsonObject)asJson).get((Object)"text");
            Intrinsics.checkNotNull((Object)object);
            keyboardButton = new RequestLocationKeyboardButton(JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object)).getContent());
        } else if (asJson instanceof JsonObject && ((JsonObject)asJson).get((Object)"web_app") != null) {
            Object object = ((JsonObject)asJson).get((Object)"text");
            Intrinsics.checkNotNull((Object)object);
            String string = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object)).getContent();
            Json json2 = JSONKt.getNonstrictJsonFormat();
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)WebAppInfo.Companion.serializer();
            Object object2 = ((JsonObject)asJson).get((Object)"web_app");
            Intrinsics.checkNotNull((Object)object2);
            keyboardButton = new WebAppKeyboardButton(string, (WebAppInfo)json2.decodeFromJsonElement(deserializationStrategy, (JsonElement)object2));
        } else if (asJson instanceof JsonObject && ((JsonObject)asJson).get((Object)"request_poll") != null) {
            Object object = ((JsonObject)asJson).get((Object)"text");
            Intrinsics.checkNotNull((Object)object);
            String string = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object)).getContent();
            Json json3 = JSONKt.getNonstrictJsonFormat();
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)KeyboardButtonPollTypeSerializer.INSTANCE;
            JsonElement jsonElement = (JsonElement)((JsonObject)asJson).get((Object)"request_poll");
            if (jsonElement == null || (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) == null) {
                JsonObjectBuilder builder$iv;
                boolean $i$f$buildJsonObject = false;
                JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
                DeserializationStrategy deserializationStrategy2 = deserializationStrategy;
                Json json4 = json3;
                String string2 = string;
                boolean bl = false;
                Unit unit = Unit.INSTANCE;
                string = string2;
                json3 = json4;
                deserializationStrategy = deserializationStrategy2;
                jsonElement = builder$iv.build();
            }
            KeyboardButtonPollType keyboardButtonPollType = (KeyboardButtonPollType)json3.decodeFromJsonElement(deserializationStrategy, jsonElement);
            String string3 = string;
            keyboardButton = new RequestPollKeyboardButton(string3, keyboardButtonPollType);
        } else {
            String string;
            JsonElement jsonElement = asJson;
            if (jsonElement instanceof JsonObject) {
                Object object = ((JsonObject)asJson).get((Object)"text");
                Intrinsics.checkNotNull((Object)object);
                string = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object)).getContent();
            } else if (jsonElement instanceof JsonArray) {
                string = "";
            } else if (jsonElement instanceof JsonPrimitive) {
                string = ((JsonPrimitive)asJson).getContent();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            keyboardButton = new UnknownKeyboardButton(string, asJson.toString());
        }
        return keyboardButton;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull KeyboardButton value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        KeyboardButton keyboardButton = value;
        if (keyboardButton instanceof RequestContactKeyboardButton) {
            RequestContactKeyboardButton.Companion.serializer().serialize(encoder, (Object)value);
        } else if (keyboardButton instanceof RequestLocationKeyboardButton) {
            RequestLocationKeyboardButton.Companion.serializer().serialize(encoder, (Object)value);
        } else if (keyboardButton instanceof WebAppKeyboardButton) {
            WebAppKeyboardButton.Companion.serializer().serialize(encoder, (Object)value);
        } else if (keyboardButton instanceof RequestPollKeyboardButton) {
            RequestPollKeyboardButton.Companion.serializer().serialize(encoder, (Object)value);
        } else if (keyboardButton instanceof SimpleKeyboardButton) {
            encoder.encodeString(value.getText());
        } else if (keyboardButton instanceof UnknownKeyboardButton) {
            JsonElement.Companion.serializer().serialize(encoder, (Object)JSONKt.getNonstrictJsonFormat().parseToJsonElement(((UnknownKeyboardButton)value).getRaw()));
        }
    }
}

