/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.files;

import dev.inmo.tgbotapi.types.StickerType;
import dev.inmo.tgbotapi.types.files.CustomEmojiAnimatedSticker;
import dev.inmo.tgbotapi.types.files.CustomEmojiSimpleSticker;
import dev.inmo.tgbotapi.types.files.CustomEmojiSticker;
import dev.inmo.tgbotapi.types.files.CustomEmojiVideoSticker;
import dev.inmo.tgbotapi.types.files.MaskAnimatedSticker;
import dev.inmo.tgbotapi.types.files.MaskSimpleSticker;
import dev.inmo.tgbotapi.types.files.MaskSticker;
import dev.inmo.tgbotapi.types.files.MaskVideoSticker;
import dev.inmo.tgbotapi.types.files.RegularAnimatedSticker;
import dev.inmo.tgbotapi.types.files.RegularSimpleSticker;
import dev.inmo.tgbotapi.types.files.RegularSticker;
import dev.inmo.tgbotapi.types.files.RegularVideoSticker;
import dev.inmo.tgbotapi.types.files.Sticker;
import dev.inmo.tgbotapi.types.files.StickerSurrogate;
import dev.inmo.tgbotapi.types.files.UnknownSticker;
import dev.inmo.tgbotapi.types.stickers.MaskPosition;
import dev.inmo.tgbotapi.utils.JSONKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ldev/inmo/tgbotapi/types/files/StickerSerializer;", "Lkotlinx/serialization/KSerializer;", "Ldev/inmo/tgbotapi/types/files/Sticker;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "tgbotapi.core"})
public final class StickerSerializer
implements KSerializer<Sticker> {
    @NotNull
    public static final StickerSerializer INSTANCE = new StickerSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = StickerSurrogate.Companion.serializer().getDescriptor();

    private StickerSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Sticker deserialize(@NotNull Decoder decoder) {
        Sticker sticker;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonElement json2 = (JsonElement)JsonElement.Companion.serializer().deserialize(decoder);
        StickerSurrogate surrogate = (StickerSurrogate)JSONKt.getNonstrictJsonFormat().decodeFromJsonElement((DeserializationStrategy)StickerSurrogate.Companion.serializer(), json2);
        StickerType stickerType = surrogate.getType();
        if (Intrinsics.areEqual((Object)stickerType, (Object)StickerType.Regular.INSTANCE)) {
            sticker = Intrinsics.areEqual((Object)surrogate.is_animated(), (Object)true) ? (RegularSticker)new RegularAnimatedSticker(surrogate.getFile_id(), surrogate.getFile_unique_id(), surrogate.getWidth(), surrogate.getHeight(), surrogate.getThumb(), surrogate.getEmoji(), surrogate.getSet_name(), surrogate.getPremium_animation(), surrogate.getFile_size()) : (Intrinsics.areEqual((Object)surrogate.is_video(), (Object)true) ? (RegularSticker)new RegularVideoSticker(surrogate.getFile_id(), surrogate.getFile_unique_id(), surrogate.getWidth(), surrogate.getHeight(), surrogate.getThumb(), surrogate.getEmoji(), surrogate.getSet_name(), surrogate.getPremium_animation(), surrogate.getFile_size()) : (RegularSticker)new RegularSimpleSticker(surrogate.getFile_id(), surrogate.getFile_unique_id(), surrogate.getWidth(), surrogate.getHeight(), surrogate.getThumb(), surrogate.getEmoji(), surrogate.getSet_name(), surrogate.getPremium_animation(), surrogate.getFile_size()));
        } else if (Intrinsics.areEqual((Object)stickerType, (Object)StickerType.Mask.INSTANCE)) {
            MaskSticker maskSticker;
            if (Intrinsics.areEqual((Object)surrogate.is_animated(), (Object)true)) {
                MaskPosition maskPosition = surrogate.getMask_position();
                if (maskPosition == null) {
                    throw new IllegalStateException("For mask stickers field mask_position should be presented".toString());
                }
                maskSticker = new MaskAnimatedSticker(surrogate.getFile_id(), surrogate.getFile_unique_id(), surrogate.getWidth(), surrogate.getHeight(), maskPosition, surrogate.getThumb(), surrogate.getEmoji(), surrogate.getSet_name(), surrogate.getFile_size());
            } else if (Intrinsics.areEqual((Object)surrogate.is_video(), (Object)true)) {
                MaskPosition maskPosition = surrogate.getMask_position();
                if (maskPosition == null) {
                    throw new IllegalStateException("For mask stickers field mask_position should be presented".toString());
                }
                maskSticker = new MaskVideoSticker(surrogate.getFile_id(), surrogate.getFile_unique_id(), surrogate.getWidth(), surrogate.getHeight(), maskPosition, surrogate.getThumb(), surrogate.getEmoji(), surrogate.getSet_name(), surrogate.getFile_size());
            } else {
                MaskPosition maskPosition = surrogate.getMask_position();
                if (maskPosition == null) {
                    throw new IllegalStateException("For mask stickers field mask_position should be presented".toString());
                }
                maskSticker = new MaskSimpleSticker(surrogate.getFile_id(), surrogate.getFile_unique_id(), surrogate.getWidth(), surrogate.getHeight(), maskPosition, surrogate.getThumb(), surrogate.getEmoji(), surrogate.getSet_name(), surrogate.getFile_size());
            }
            sticker = maskSticker;
        } else if (Intrinsics.areEqual((Object)stickerType, (Object)StickerType.CustomEmoji.INSTANCE)) {
            CustomEmojiSticker customEmojiSticker;
            if (Intrinsics.areEqual((Object)surrogate.is_animated(), (Object)true)) {
                String string = surrogate.getCustom_emoji_id-GbmMWyQ();
                if (string == null) {
                    throw new IllegalStateException("For mask stickers field mask_position should be presented".toString());
                }
                customEmojiSticker = new CustomEmojiAnimatedSticker(surrogate.getFile_id(), surrogate.getFile_unique_id(), surrogate.getWidth(), surrogate.getHeight(), string, surrogate.getThumb(), surrogate.getEmoji(), surrogate.getSet_name(), surrogate.getFile_size(), null);
            } else if (Intrinsics.areEqual((Object)surrogate.is_video(), (Object)true)) {
                String string = surrogate.getCustom_emoji_id-GbmMWyQ();
                if (string == null) {
                    throw new IllegalStateException("For mask stickers field mask_position should be presented".toString());
                }
                customEmojiSticker = new CustomEmojiVideoSticker(surrogate.getFile_id(), surrogate.getFile_unique_id(), surrogate.getWidth(), surrogate.getHeight(), string, surrogate.getThumb(), surrogate.getEmoji(), surrogate.getSet_name(), surrogate.getFile_size(), null);
            } else {
                String string = surrogate.getCustom_emoji_id-GbmMWyQ();
                if (string == null) {
                    throw new IllegalStateException("For mask stickers field mask_position should be presented".toString());
                }
                customEmojiSticker = new CustomEmojiSimpleSticker(surrogate.getFile_id(), surrogate.getFile_unique_id(), surrogate.getWidth(), surrogate.getHeight(), string, surrogate.getThumb(), surrogate.getEmoji(), surrogate.getSet_name(), surrogate.getFile_size(), null);
            }
            sticker = customEmojiSticker;
        } else if (stickerType instanceof StickerType.Unknown) {
            sticker = new UnknownSticker(surrogate.getFile_id(), surrogate.getFile_unique_id(), surrogate.getWidth(), surrogate.getHeight(), surrogate.getThumb(), surrogate.getEmoji(), surrogate.getSet_name(), surrogate.getFile_size(), json2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sticker;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Sticker value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }
}

