/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.chat.member;

import dev.inmo.tgbotapi.types.chat.member.AdministratorChatMemberImpl;
import dev.inmo.tgbotapi.types.chat.member.ChatMember;
import dev.inmo.tgbotapi.types.chat.member.KickedChatMember;
import dev.inmo.tgbotapi.types.chat.member.LeftChatMember;
import dev.inmo.tgbotapi.types.chat.member.LeftChatMemberImpl;
import dev.inmo.tgbotapi.types.chat.member.MemberChatMember;
import dev.inmo.tgbotapi.types.chat.member.MemberChatMemberImpl;
import dev.inmo.tgbotapi.types.chat.member.OwnerChatMember;
import dev.inmo.tgbotapi.types.chat.member.RestrictedChatMember;
import dev.inmo.tgbotapi.utils.JSONKt;
import dev.inmo.tgbotapi.utils.RiskFeature;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@RiskFeature
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ldev/inmo/tgbotapi/types/chat/member/ChatMemberSerializer;", "Lkotlinx/serialization/KSerializer;", "Ldev/inmo/tgbotapi/types/chat/member/ChatMember;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "tgbotapi.core"})
public final class ChatMemberSerializer
implements KSerializer<ChatMember> {
    @NotNull
    public static final ChatMemberSerializer INSTANCE = new ChatMemberSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = JsonObject.Companion.serializer().getDescriptor();

    private ChatMemberSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public ChatMember deserialize(@NotNull Decoder decoder) {
        ChatMember chatMember;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonObject json2 = (JsonObject)JsonObject.Companion.serializer().deserialize(decoder);
        Object object = (JsonElement)json2.get((Object)"status");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
            throw new IllegalStateException(("Status field of chat member must be specified, but incoming json contains next: " + json2).toString());
        }
        switch (object) {
            case "creator": {
                chatMember = (ChatMember)JSONKt.getNonstrictJsonFormat().decodeFromJsonElement((DeserializationStrategy)OwnerChatMember.Companion.serializer(), (JsonElement)json2);
                break;
            }
            case "administrator": {
                chatMember = (ChatMember)JSONKt.getNonstrictJsonFormat().decodeFromJsonElement((DeserializationStrategy)AdministratorChatMemberImpl.Companion.serializer(), (JsonElement)json2);
                break;
            }
            case "member": {
                chatMember = (ChatMember)JSONKt.getNonstrictJsonFormat().decodeFromJsonElement((DeserializationStrategy)MemberChatMemberImpl.Companion.serializer(), (JsonElement)json2);
                break;
            }
            case "restricted": {
                chatMember = (ChatMember)JSONKt.getNonstrictJsonFormat().decodeFromJsonElement((DeserializationStrategy)RestrictedChatMember.Companion.serializer(), (JsonElement)json2);
                break;
            }
            case "left": {
                chatMember = (ChatMember)JSONKt.getNonstrictJsonFormat().decodeFromJsonElement((DeserializationStrategy)LeftChatMemberImpl.Companion.serializer(), (JsonElement)json2);
                break;
            }
            case "kicked": {
                chatMember = (ChatMember)JSONKt.getNonstrictJsonFormat().decodeFromJsonElement((DeserializationStrategy)KickedChatMember.Companion.serializer(), (JsonElement)json2);
                break;
            }
            default: {
                throw new IllegalStateException(("Unknown type of chat member in json: " + json2).toString());
            }
        }
        return chatMember;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull ChatMember value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ChatMember chatMember = value;
        if (chatMember instanceof OwnerChatMember) {
            OwnerChatMember.Companion.serializer();
        } else if (chatMember instanceof AdministratorChatMemberImpl) {
            AdministratorChatMemberImpl.Companion.serializer();
        } else if (chatMember instanceof MemberChatMember) {
            MemberChatMemberImpl.Companion.serializer();
        } else if (chatMember instanceof RestrictedChatMember) {
            RestrictedChatMember.Companion.serializer();
        } else if (chatMember instanceof LeftChatMember) {
            LeftChatMemberImpl.Companion.serializer();
        } else if (chatMember instanceof KickedChatMember) {
            KickedChatMember.Companion.serializer();
        }
    }
}

