/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.chat;

import dev.inmo.tgbotapi.types.ChatIdentifierKt;
import dev.inmo.tgbotapi.types.chat.ChannelChatImpl;
import dev.inmo.tgbotapi.types.chat.Chat;
import dev.inmo.tgbotapi.types.chat.ChatSerializersKt;
import dev.inmo.tgbotapi.types.chat.ChatType;
import dev.inmo.tgbotapi.types.chat.CommonBot;
import dev.inmo.tgbotapi.types.chat.CommonUser;
import dev.inmo.tgbotapi.types.chat.ExtendedBot;
import dev.inmo.tgbotapi.types.chat.ExtendedChat;
import dev.inmo.tgbotapi.types.chat.ExtendedChatSerializer;
import dev.inmo.tgbotapi.types.chat.GroupChatImpl;
import dev.inmo.tgbotapi.types.chat.PrivateChatImpl;
import dev.inmo.tgbotapi.types.chat.SupergroupChatImpl;
import dev.inmo.tgbotapi.types.chat.UnknownChatType;
import dev.inmo.tgbotapi.utils.RiskFeature;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@RiskFeature
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Ldev/inmo/tgbotapi/types/chat/PreviewChatSerializer;", "Lkotlinx/serialization/KSerializer;", "Ldev/inmo/tgbotapi/types/chat/Chat;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor$annotations", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "tgbotapi.core"})
public final class PreviewChatSerializer
implements KSerializer<Chat> {
    @NotNull
    public static final PreviewChatSerializer INSTANCE = new PreviewChatSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.buildSerialDescriptor$default((String)"PreviewChatSerializer", (SerialKind)((SerialKind)PolymorphicKind.OPEN.INSTANCE), (SerialDescriptor[])new SerialDescriptor[0], null, (int)8, null);

    private PreviewChatSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    public static /* synthetic */ void getDescriptor$annotations() {
    }

    @NotNull
    public Chat deserialize(@NotNull Decoder decoder) {
        Chat chat;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonObject decodedJson = (JsonObject)JsonObject.Companion.serializer().deserialize(decoder);
        Object object = (JsonElement)decodedJson.get((Object)"type");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null || (object = ChatSerializersKt.getAsChatType((String)object)) == null) {
            throw new IllegalStateException(("Field type must be presented, but absent in " + decodedJson).toString());
        }
        Object type = object;
        Object object2 = type;
        if (Intrinsics.areEqual((Object)object2, (Object)ChatType.PrivateChatType.INSTANCE)) {
            chat = (Chat)ChatSerializersKt.access$getFormatter().decodeFromJsonElement((DeserializationStrategy)PrivateChatImpl.Companion.serializer(), (JsonElement)decodedJson);
        } else if (Intrinsics.areEqual((Object)object2, (Object)ChatType.GroupChatType.INSTANCE)) {
            chat = (Chat)ChatSerializersKt.access$getFormatter().decodeFromJsonElement((DeserializationStrategy)GroupChatImpl.Companion.serializer(), (JsonElement)decodedJson);
        } else if (Intrinsics.areEqual((Object)object2, (Object)ChatType.SupergroupChatType.INSTANCE)) {
            chat = (Chat)ChatSerializersKt.access$getFormatter().decodeFromJsonElement((DeserializationStrategy)SupergroupChatImpl.Companion.serializer(), (JsonElement)decodedJson);
        } else if (Intrinsics.areEqual((Object)object2, (Object)ChatType.ChannelChatType.INSTANCE)) {
            chat = (Chat)ChatSerializersKt.access$getFormatter().decodeFromJsonElement((DeserializationStrategy)ChannelChatImpl.Companion.serializer(), (JsonElement)decodedJson);
        } else if (object2 instanceof ChatType.UnknownChatType) {
            Json json2 = ChatSerializersKt.access$getFormatter();
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)BuiltinSerializersKt.serializer((LongCompanionObject)LongCompanionObject.INSTANCE);
            JsonElement jsonElement = (JsonElement)decodedJson.get((Object)"chat_id");
            if (jsonElement == null) {
                jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Number)-1);
            }
            chat = new UnknownChatType(ChatIdentifierKt.toChatId(((Number)json2.decodeFromJsonElement(deserializationStrategy, jsonElement)).longValue()), decodedJson.toString(), decodedJson);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return chat;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Chat value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Chat chat = value;
        if (chat instanceof ExtendedChat) {
            ExtendedChatSerializer.INSTANCE.serialize(encoder, (ExtendedChat)value);
        } else if (chat instanceof PrivateChatImpl) {
            PrivateChatImpl.Companion.serializer().serialize(encoder, (Object)value);
        } else if (chat instanceof GroupChatImpl) {
            GroupChatImpl.Companion.serializer().serialize(encoder, (Object)value);
        } else if (chat instanceof SupergroupChatImpl) {
            SupergroupChatImpl.Companion.serializer().serialize(encoder, (Object)value);
        } else if (chat instanceof ChannelChatImpl) {
            ChannelChatImpl.Companion.serializer().serialize(encoder, (Object)value);
        } else if (chat instanceof CommonBot) {
            CommonBot.Companion.serializer().serialize(encoder, (Object)value);
        } else if (chat instanceof ExtendedBot) {
            ExtendedBot.Companion.serializer().serialize(encoder, (Object)value);
        } else if (chat instanceof CommonUser) {
            CommonUser.Companion.serializer().serialize(encoder, (Object)value);
        } else if (chat instanceof UnknownChatType) {
            JsonObject.Companion.serializer().serialize(encoder, (Object)((UnknownChatType)value).getRawJson());
        }
    }
}

