/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.utils.internal;

import dev.inmo.tgbotapi.types.ChatId;
import dev.inmo.tgbotapi.types.ChatIdentifierKt;
import dev.inmo.tgbotapi.types.ParseMode.HTMLParseMode;
import dev.inmo.tgbotapi.types.ParseMode.MarkdownParseMode;
import dev.inmo.tgbotapi.types.ParseMode.MarkdownV2ParseMode;
import dev.inmo.tgbotapi.types.ParseMode.ParseMode;
import dev.inmo.tgbotapi.utils.extensions.StringKt;
import dev.inmo.tgbotapi.utils.internal.StringFormattingKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\f\u0010\u0013\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0015\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0080\u0004\u001a\f\u0010\u0018\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u001a\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a%\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u001d\u00a2\u0006\u0002\b\u001eH\u0000\u001a\f\u0010\u001f\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010 \u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010!\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\"\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a&\u0010#\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u001d\u00a2\u0006\u0002\b\u001eH\u0082\b\u001a\f\u0010$\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u001e\u0010%\u001a\u00020\u0001*\u00020\u00012\u0006\u0010&\u001a\u00020\u00012\b\b\u0002\u0010'\u001a\u00020\u0001H\u0002\u001a\f\u0010(\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a!\u0010)\u001a\u00020\u0001*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010\u0016\u001a\u00020\u0017H\u0080\u0004\u001a\u0014\u0010+\u001a\u00020\u0001*\u00020\u00012\u0006\u0010)\u001a\u00020\u0001H\u0000\u001a\u0014\u0010,\u001a\u00020\u0001*\u00020\u00012\u0006\u0010)\u001a\u00020\u0001H\u0000\u001a\u0014\u0010-\u001a\u00020\u0001*\u00020\u00012\u0006\u0010)\u001a\u00020\u0001H\u0000\u001a\u001e\u0010.\u001a\u00020\u0001*\u00020\u00012\u0006\u0010&\u001a\u00020\u00012\b\b\u0002\u0010'\u001a\u00020\u0001H\u0002\u001a9\u0010/\u001a\u00020\u0001*\u00020\u00012\u0006\u0010&\u001a\u00020\u00012\b\b\u0002\u0010'\u001a\u00020\u00012\u0019\b\u0002\u00100\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u001d\u00a2\u0006\u0002\b\u001eH\u0002\u001a&\u00101\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u001d\u00a2\u0006\u0002\b\u001eH\u0082\b\u001a\f\u00102\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u00103\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0018\u00104\u001a\u00020\u0001*\u00020\u00012\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0018\u00106\u001a\u00020\u0001*\u00020\u00012\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0018\u00107\u001a\u00020\u0001*\u00020\u00012\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\f\u00108\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u00109\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010:\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010;\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010<\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0018\u0010=\u001a\u00020\u0001*\u00020\u00012\n\u0010>\u001a\u00060?j\u0002`@H\u0000\u001a\u0015\u0010A\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0080\u0004\u001a\f\u0010B\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010C\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010D\u001a\u00020\u0001*\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"htmlBoldControl", "", "htmlCodeControl", "htmlItalicControl", "htmlPreControl", "htmlSpoilerClosingControl", "htmlSpoilerControl", "htmlStrikethroughControl", "htmlUnderlineControl", "markdownBoldControl", "markdownCodeControl", "markdownItalicControl", "markdownPreControl", "markdownSpoilerControl", "markdownV2ItalicEndControl", "markdownV2ItalicUnderlineDelimiter", "markdownV2StrikethroughControl", "markdownV2UnderlineControl", "markdownV2UnderlineEndControl", "boldMarkdown", "cashTagMarkdown", "code", "parseMode", "Ldev/inmo/tgbotapi/types/ParseMode/ParseMode;", "codeHTML", "codeMarkdown", "codeMarkdownV2", "command", "adapt", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "commandHTML", "commandMarkdown", "commandMarkdownV2", "emailMarkdown", "hashTag", "hashTagMarkdown", "htmlDefault", "openControlSymbol", "closeControlSymbol", "italicMarkdown", "link", "Lkotlin/Pair;", "linkHTML", "linkMarkdown", "linkMarkdownV2", "markdownDefault", "markdownV2Default", "escapeFun", "mention", "mentionMarkdown", "phoneMarkdown", "preHTML", "language", "preMarkdown", "preMarkdownV2", "regularHtml", "regularMarkdown", "regularMarkdownV2", "spoilerMarkdown", "strikethroughMarkdown", "textMentionMarkdown", "userId", "Ldev/inmo/tgbotapi/types/ChatId;", "Ldev/inmo/tgbotapi/types/UserId;", "underline", "underlineHTML", "underlineMarkdown", "underlineMarkdownV2", "tgbotapi.core"})
public final class StringFormattingKt {
    @NotNull
    public static final String markdownBoldControl = "*";
    @NotNull
    public static final String markdownItalicControl = "_";
    @NotNull
    public static final String markdownSpoilerControl = "||";
    @NotNull
    public static final String markdownCodeControl = "`";
    @NotNull
    public static final String markdownPreControl = "```";
    @NotNull
    public static final String markdownV2ItalicUnderlineDelimiter = "\u0013";
    @NotNull
    public static final String markdownV2StrikethroughControl = "~";
    @NotNull
    public static final String markdownV2UnderlineControl = "__";
    @NotNull
    public static final String markdownV2UnderlineEndControl = "__\u0013";
    @NotNull
    public static final String markdownV2ItalicEndControl = "_\u0013";
    @NotNull
    public static final String htmlBoldControl = "b";
    @NotNull
    public static final String htmlItalicControl = "i";
    @NotNull
    public static final String htmlSpoilerControl = "span class=\"tg-spoiler\"";
    @NotNull
    public static final String htmlSpoilerClosingControl = "span";
    @NotNull
    public static final String htmlCodeControl = "code";
    @NotNull
    public static final String htmlPreControl = "pre";
    @NotNull
    public static final String htmlUnderlineControl = "u";
    @NotNull
    public static final String htmlStrikethroughControl = "s";

    private static final String markdownDefault(String $this$markdownDefault, String openControlSymbol, String closeControlSymbol) {
        return openControlSymbol + StringKt.toMarkdown($this$markdownDefault) + closeControlSymbol;
    }

    static /* synthetic */ String markdownDefault$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = string2;
        }
        return StringFormattingKt.markdownDefault(string, string2, string3);
    }

    private static final String markdownV2Default(String $this$markdownV2Default, String openControlSymbol, String closeControlSymbol, Function1<? super String, String> escapeFun) {
        return openControlSymbol + (String)escapeFun.invoke((Object)$this$markdownV2Default) + closeControlSymbol;
    }

    static /* synthetic */ String markdownV2Default$default(String string, String string2, String string3, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = string2;
        }
        if ((n & 4) != 0) {
            function1 = markdownV2Default.1.INSTANCE;
        }
        return StringFormattingKt.markdownV2Default(string, string2, string3, (Function1<? super String, String>)function1);
    }

    private static final String htmlDefault(String $this$htmlDefault, String openControlSymbol, String closeControlSymbol) {
        return '<' + openControlSymbol + '>' + StringKt.toHtml($this$htmlDefault) + "</" + closeControlSymbol + '>';
    }

    static /* synthetic */ String htmlDefault$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = string2;
        }
        return StringFormattingKt.htmlDefault(string, string2, string3);
    }

    @NotNull
    public static final String linkMarkdown(@NotNull String $this$linkMarkdown, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)$this$linkMarkdown, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return '[' + StringKt.toMarkdown($this$linkMarkdown) + "](" + StringKt.toMarkdown(link) + ')';
    }

    @NotNull
    public static final String linkMarkdownV2(@NotNull String $this$linkMarkdownV2, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)$this$linkMarkdownV2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return '[' + StringKt.escapeMarkdownV2Common($this$linkMarkdownV2) + "](" + StringKt.escapeMarkdownV2Link(link) + ')';
    }

    @NotNull
    public static final String linkHTML(@NotNull String $this$linkHTML, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)$this$linkHTML, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return "<a href=\"" + link + "\">" + StringKt.toHtml($this$linkHTML) + "</a>";
    }

    @NotNull
    public static final String boldMarkdown(@NotNull String $this$boldMarkdown) {
        Intrinsics.checkNotNullParameter((Object)$this$boldMarkdown, (String)"<this>");
        return StringFormattingKt.markdownDefault$default($this$boldMarkdown, markdownBoldControl, null, 2, null);
    }

    @NotNull
    public static final String italicMarkdown(@NotNull String $this$italicMarkdown) {
        Intrinsics.checkNotNullParameter((Object)$this$italicMarkdown, (String)"<this>");
        return StringFormattingKt.markdownDefault$default($this$italicMarkdown, markdownItalicControl, null, 2, null);
    }

    @NotNull
    public static final String spoilerMarkdown(@NotNull String $this$spoilerMarkdown) {
        Intrinsics.checkNotNullParameter((Object)$this$spoilerMarkdown, (String)"<this>");
        return StringFormattingKt.regularMarkdown($this$spoilerMarkdown);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String strikethroughMarkdown(@NotNull String $this$strikethroughMarkdown) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$strikethroughMarkdown, (String)"<this>");
        CharSequence $this$map$iv = $this$strikethroughMarkdown;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        for (int i = 0; i < var6_6.length(); ++i) {
            void it;
            char item$iv$iv = var6_6.charAt(i);
            char c = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = it;
            String string = "\u0336";
            collection.add((char)var11_11 + string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String underlineMarkdown(@NotNull String $this$underlineMarkdown) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$underlineMarkdown, (String)"<this>");
        CharSequence $this$map$iv = $this$underlineMarkdown;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        for (int i = 0; i < var6_6.length(); ++i) {
            void it;
            char item$iv$iv = var6_6.charAt(i);
            char c = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = it;
            String string = "\u0347";
            collection.add((char)var11_11 + string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String underlineMarkdownV2(@NotNull String $this$underlineMarkdownV2) {
        Intrinsics.checkNotNullParameter((Object)$this$underlineMarkdownV2, (String)"<this>");
        return StringFormattingKt.markdownV2Default$default($this$underlineMarkdownV2, markdownV2UnderlineControl, markdownV2UnderlineEndControl, null, 4, null);
    }

    @NotNull
    public static final String underlineHTML(@NotNull String $this$underlineHTML) {
        Intrinsics.checkNotNullParameter((Object)$this$underlineHTML, (String)"<this>");
        return StringFormattingKt.htmlDefault$default($this$underlineHTML, htmlUnderlineControl, null, 2, null);
    }

    @NotNull
    public static final String codeMarkdown(@NotNull String $this$codeMarkdown) {
        Intrinsics.checkNotNullParameter((Object)$this$codeMarkdown, (String)"<this>");
        return StringFormattingKt.markdownDefault$default($this$codeMarkdown, markdownCodeControl, null, 2, null);
    }

    @NotNull
    public static final String codeMarkdownV2(@NotNull String $this$codeMarkdownV2) {
        Intrinsics.checkNotNullParameter((Object)$this$codeMarkdownV2, (String)"<this>");
        return StringFormattingKt.markdownV2Default$default($this$codeMarkdownV2, markdownCodeControl, null, codeMarkdownV2.1.INSTANCE, 2, null);
    }

    @NotNull
    public static final String codeHTML(@NotNull String $this$codeHTML) {
        Intrinsics.checkNotNullParameter((Object)$this$codeHTML, (String)"<this>");
        return StringFormattingKt.htmlDefault$default($this$codeHTML, htmlCodeControl, null, 2, null);
    }

    @NotNull
    public static final String preMarkdown(@NotNull String $this$preMarkdown, @Nullable String language) {
        Intrinsics.checkNotNullParameter((Object)$this$preMarkdown, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder().append(markdownPreControl);
        String string = language;
        if (string == null) {
            string = "";
        }
        return StringFormattingKt.markdownDefault($this$preMarkdown, stringBuilder.append(string).append('\n').toString(), "\n```");
    }

    public static /* synthetic */ String preMarkdown$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return StringFormattingKt.preMarkdown(string, string2);
    }

    @NotNull
    public static final String preMarkdownV2(@NotNull String $this$preMarkdownV2, @Nullable String language) {
        Intrinsics.checkNotNullParameter((Object)$this$preMarkdownV2, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder().append(markdownPreControl);
        String string = language;
        if (string == null) {
            string = "";
        }
        return StringFormattingKt.markdownV2Default($this$preMarkdownV2, stringBuilder.append(string).append('\n').toString(), "\n```", (Function1<? super String, String>)((Function1)preMarkdownV2.1.INSTANCE));
    }

    public static /* synthetic */ String preMarkdownV2$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return StringFormattingKt.preMarkdownV2(string, string2);
    }

    @NotNull
    public static final String preHTML(@NotNull String $this$preHTML, @Nullable String language) {
        String string;
        String string2;
        String string3;
        String string4;
        Intrinsics.checkNotNullParameter((Object)$this$preHTML, (String)"<this>");
        String string5 = $this$preHTML;
        String string6 = language;
        if (string6 == null) {
            string4 = htmlPreControl;
        } else {
            String string7 = string6;
            string3 = string5;
            boolean bl = false;
            string5 = string3;
            string2 = "pre><code class=\"language-" + language + '\"';
            string4 = string2 == null ? htmlPreControl : string2;
        }
        string6 = language;
        if (string6 == null) {
            string = htmlPreControl;
        } else {
            String it = string6;
            String string8 = string4;
            string3 = string5;
            boolean bl = false;
            String string9 = "code></pre";
            string5 = string3;
            string4 = string8;
            string = string2 = string9;
        }
        return StringFormattingKt.htmlDefault(string5, string4, string);
    }

    public static /* synthetic */ String preHTML$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return StringFormattingKt.preHTML(string, string2);
    }

    @NotNull
    public static final String emailMarkdown(@NotNull String $this$emailMarkdown) {
        Intrinsics.checkNotNullParameter((Object)$this$emailMarkdown, (String)"<this>");
        return StringFormattingKt.linkMarkdown($this$emailMarkdown, Intrinsics.stringPlus((String)"mailto://$", (Object)StringKt.toMarkdown($this$emailMarkdown)));
    }

    private static final String mention(String $this$mention, Function1<? super String, String> adapt) {
        boolean $i$f$mention = false;
        return StringsKt.startsWith$default((String)$this$mention, (String)"@", (boolean)false, (int)2, null) ? (String)adapt.invoke((Object)$this$mention) : Intrinsics.stringPlus((String)"@", (Object)adapt.invoke((Object)$this$mention));
    }

    private static final String hashTag(String $this$hashTag, Function1<? super String, String> adapt) {
        boolean $i$f$hashTag = false;
        return StringsKt.startsWith$default((String)$this$hashTag, (String)"#", (boolean)false, (int)2, null) ? (String)adapt.invoke((Object)$this$hashTag) : Intrinsics.stringPlus((String)"#", (Object)adapt.invoke((Object)$this$hashTag));
    }

    @NotNull
    public static final String textMentionMarkdown(@NotNull String $this$textMentionMarkdown, @NotNull ChatId userId) {
        Intrinsics.checkNotNullParameter((Object)$this$textMentionMarkdown, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return StringFormattingKt.linkMarkdown($this$textMentionMarkdown, ChatIdentifierKt.getLink(userId));
    }

    @NotNull
    public static final String mentionMarkdown(@NotNull String $this$mentionMarkdown) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$mentionMarkdown, (String)"<this>");
        String $this$mention$iv = $this$mentionMarkdown;
        boolean $i$f$mention = false;
        if (StringsKt.startsWith$default((String)$this$mention$iv, (String)"@", (boolean)false, (int)2, null)) {
            String p0 = $this$mention$iv;
            boolean bl = false;
            string = StringKt.toMarkdown(p0);
        } else {
            String p0 = $this$mention$iv;
            String string2 = "@";
            boolean bl = false;
            string = Intrinsics.stringPlus((String)string2, (Object)StringKt.toMarkdown(p0));
        }
        return string;
    }

    @NotNull
    public static final String hashTagMarkdown(@NotNull String $this$hashTagMarkdown) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$hashTagMarkdown, (String)"<this>");
        String $this$hashTag$iv = $this$hashTagMarkdown;
        boolean $i$f$hashTag = false;
        if (StringsKt.startsWith$default((String)$this$hashTag$iv, (String)"#", (boolean)false, (int)2, null)) {
            String p0 = $this$hashTag$iv;
            boolean bl = false;
            string = StringKt.toMarkdown(p0);
        } else {
            String p0 = $this$hashTag$iv;
            String string2 = "#";
            boolean bl = false;
            string = Intrinsics.stringPlus((String)string2, (Object)StringKt.toMarkdown(p0));
        }
        return string;
    }

    @NotNull
    public static final String phoneMarkdown(@NotNull String $this$phoneMarkdown) {
        Intrinsics.checkNotNullParameter((Object)$this$phoneMarkdown, (String)"<this>");
        return StringKt.toMarkdown($this$phoneMarkdown);
    }

    @NotNull
    public static final String command(@NotNull String $this$command, @NotNull Function1<? super String, String> adapt) {
        Intrinsics.checkNotNullParameter((Object)$this$command, (String)"<this>");
        Intrinsics.checkNotNullParameter(adapt, (String)"adapt");
        return StringsKt.startsWith$default((String)$this$command, (String)"/", (boolean)false, (int)2, null) ? (String)adapt.invoke((Object)$this$command) : Intrinsics.stringPlus((String)"/", (Object)adapt.invoke((Object)$this$command));
    }

    @NotNull
    public static final String commandMarkdown(@NotNull String $this$commandMarkdown) {
        Intrinsics.checkNotNullParameter((Object)$this$commandMarkdown, (String)"<this>");
        return StringFormattingKt.command($this$commandMarkdown, (Function1<? super String, String>)((Function1)commandMarkdown.1.INSTANCE));
    }

    @NotNull
    public static final String commandMarkdownV2(@NotNull String $this$commandMarkdownV2) {
        Intrinsics.checkNotNullParameter((Object)$this$commandMarkdownV2, (String)"<this>");
        return StringFormattingKt.command($this$commandMarkdownV2, (Function1<? super String, String>)((Function1)commandMarkdownV2.1.INSTANCE));
    }

    @NotNull
    public static final String commandHTML(@NotNull String $this$commandHTML) {
        Intrinsics.checkNotNullParameter((Object)$this$commandHTML, (String)"<this>");
        return StringFormattingKt.command($this$commandHTML, (Function1<? super String, String>)((Function1)commandHTML.1.INSTANCE));
    }

    @NotNull
    public static final String regularMarkdown(@NotNull String $this$regularMarkdown) {
        Intrinsics.checkNotNullParameter((Object)$this$regularMarkdown, (String)"<this>");
        return StringKt.toMarkdown($this$regularMarkdown);
    }

    @NotNull
    public static final String regularMarkdownV2(@NotNull String $this$regularMarkdownV2) {
        Intrinsics.checkNotNullParameter((Object)$this$regularMarkdownV2, (String)"<this>");
        return StringKt.escapeMarkdownV2Common($this$regularMarkdownV2);
    }

    @NotNull
    public static final String regularHtml(@NotNull String $this$regularHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$regularHtml, (String)"<this>");
        return StringKt.toHtml($this$regularHtml);
    }

    @NotNull
    public static final String cashTagMarkdown(@NotNull String $this$cashTagMarkdown) {
        Intrinsics.checkNotNullParameter((Object)$this$cashTagMarkdown, (String)"<this>");
        return StringKt.toMarkdown($this$cashTagMarkdown);
    }

    @NotNull
    public static final String code(@NotNull String $this$code, @NotNull ParseMode parseMode) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$code, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parseMode, (String)"parseMode");
        ParseMode parseMode2 = parseMode;
        if (parseMode2 instanceof HTMLParseMode) {
            string = StringFormattingKt.codeHTML($this$code);
        } else if (parseMode2 instanceof MarkdownParseMode) {
            string = StringFormattingKt.codeMarkdown($this$code);
        } else if (parseMode2 instanceof MarkdownV2ParseMode) {
            string = StringFormattingKt.codeMarkdownV2($this$code);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final String link(@NotNull Pair<String, String> $this$link, @NotNull ParseMode parseMode) {
        String string;
        Intrinsics.checkNotNullParameter($this$link, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parseMode, (String)"parseMode");
        ParseMode parseMode2 = parseMode;
        if (parseMode2 instanceof HTMLParseMode) {
            string = StringFormattingKt.linkHTML((String)$this$link.getFirst(), (String)$this$link.getSecond());
        } else if (parseMode2 instanceof MarkdownParseMode) {
            string = StringFormattingKt.linkMarkdown((String)$this$link.getFirst(), (String)$this$link.getSecond());
        } else if (parseMode2 instanceof MarkdownV2ParseMode) {
            string = StringFormattingKt.linkMarkdownV2((String)$this$link.getFirst(), (String)$this$link.getSecond());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final String underline(@NotNull String $this$underline, @NotNull ParseMode parseMode) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$underline, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parseMode, (String)"parseMode");
        ParseMode parseMode2 = parseMode;
        if (parseMode2 instanceof HTMLParseMode) {
            string = StringFormattingKt.underlineHTML($this$underline);
        } else if (parseMode2 instanceof MarkdownParseMode) {
            string = StringFormattingKt.underlineMarkdown($this$underline);
        } else if (parseMode2 instanceof MarkdownV2ParseMode) {
            string = StringFormattingKt.underlineMarkdownV2($this$underline);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

