/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.bot.exceptions;

import com.soywiz.klock.DateTime;
import dev.inmo.tgbotapi.bot.exceptions.CommonRequestException;
import dev.inmo.tgbotapi.bot.exceptions.GetUpdatesConflict;
import dev.inmo.tgbotapi.bot.exceptions.InvalidPhotoDimensionsException;
import dev.inmo.tgbotapi.bot.exceptions.MessageIsNotModifiedException;
import dev.inmo.tgbotapi.bot.exceptions.MessageToEditNotFoundException;
import dev.inmo.tgbotapi.bot.exceptions.ReplyMessageNotFoundException;
import dev.inmo.tgbotapi.bot.exceptions.RequestException;
import dev.inmo.tgbotapi.bot.exceptions.TooMuchRequestsException;
import dev.inmo.tgbotapi.bot.exceptions.UnauthorizedException;
import dev.inmo.tgbotapi.bot.exceptions.WrongFileIdentifierException;
import dev.inmo.tgbotapi.types.RequestError;
import dev.inmo.tgbotapi.types.Response;
import dev.inmo.tgbotapi.types.ResponseParametersRaw;
import dev.inmo.tgbotapi.types.RetryAfterError;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"newRequestException", "Ldev/inmo/tgbotapi/bot/exceptions/RequestException;", "response", "Ldev/inmo/tgbotapi/types/Response;", "plainAnswer", "", "message", "cause", "", "tgbotapi.core"})
public final class RequestExceptionKt {
    @NotNull
    public static final RequestException newRequestException(@NotNull Response response, @NotNull String plainAnswer, @Nullable String message, @Nullable Throwable cause) {
        RequestException requestException;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)plainAnswer, (String)"plainAnswer");
        String string = response.getDescription();
        if (string == null) {
            requestException = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String description = string2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)description, (Object)"Bad Request: reply message not found") || Intrinsics.areEqual((Object)description, (Object)"Bad Request: replied message not found")) {
                requestException = new ReplyMessageNotFoundException(response, plainAnswer, message, cause);
            } else if (Intrinsics.areEqual((Object)description, (Object)"Bad Request: message to edit not found")) {
                requestException = new MessageToEditNotFoundException(response, plainAnswer, message, cause);
            } else if (StringsKt.contains$default((CharSequence)description, (CharSequence)"Bad Request: message is not modified", (boolean)false, (int)2, null)) {
                requestException = new MessageIsNotModifiedException(response, plainAnswer, message, cause);
            } else if (Intrinsics.areEqual((Object)description, (Object)"Unauthorized")) {
                requestException = new UnauthorizedException(response, plainAnswer, message, cause);
            } else if (StringsKt.contains$default((CharSequence)description, (CharSequence)"PHOTO_INVALID_DIMENSIONS", (boolean)false, (int)2, null)) {
                requestException = new InvalidPhotoDimensionsException(response, plainAnswer, message, cause);
            } else if (StringsKt.contains$default((CharSequence)description, (CharSequence)"wrong file identifier", (boolean)false, (int)2, null)) {
                requestException = new WrongFileIdentifierException(response, plainAnswer, message, cause);
            } else if (StringsKt.contains$default((CharSequence)description, (CharSequence)"Too Many Requests", (boolean)false, (int)2, null)) {
                ResponseParametersRaw responseParametersRaw = response.getParameters();
                RequestError requestError = responseParametersRaw == null ? null : responseParametersRaw.getError();
                RetryAfterError retryAfterError = requestError instanceof RetryAfterError ? (RetryAfterError)requestError : null;
                requestException = new TooMuchRequestsException(retryAfterError == null ? new RetryAfterError(60, DateTime.getUnixMillisLong-impl((double)DateTime.Companion.now-TZYpA4o())) : retryAfterError, response, plainAnswer, message, cause);
            } else {
                requestException = StringsKt.contains$default((CharSequence)description, (CharSequence)"Conflict: terminated by other getUpdates request", (boolean)false, (int)2, null) ? (RequestException)new GetUpdatesConflict(response, plainAnswer, message, cause) : null;
            }
        }
        RequestException requestException2 = requestException;
        return requestException2 == null ? (RequestException)new CommonRequestException(response, plainAnswer, message, cause) : requestException2;
    }

    public static /* synthetic */ RequestException newRequestException$default(Response response, String string, String string2, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            throwable = null;
        }
        return RequestExceptionKt.newRequestException(response, string, string2, throwable);
    }
}

