/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.message.content.media;

import dev.inmo.tgbotapi.CommonAbstracts.CaptionedInput;
import dev.inmo.tgbotapi.CommonAbstracts.TextPart;
import dev.inmo.tgbotapi.CommonAbstracts.TextSource;
import dev.inmo.tgbotapi.CommonAbstracts.TextedInput;
import dev.inmo.tgbotapi.requests.abstracts.Request;
import dev.inmo.tgbotapi.requests.send.media.SendAnimationKt;
import dev.inmo.tgbotapi.types.ChatIdentifier;
import dev.inmo.tgbotapi.types.InputMedia.InputMediaAnimation;
import dev.inmo.tgbotapi.types.InputMedia.InputMediaAnimationKt;
import dev.inmo.tgbotapi.types.buttons.KeyboardMarkup;
import dev.inmo.tgbotapi.types.files.AnimationFile;
import dev.inmo.tgbotapi.types.files.DocumentFile;
import dev.inmo.tgbotapi.types.files.PhotoSize;
import dev.inmo.tgbotapi.types.message.abstracts.ContentMessage;
import dev.inmo.tgbotapi.types.message.content.abstracts.MediaContent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0012\b\u0002\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u0013\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u00c6\u0003J?\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0012\b\u0002\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u00c6\u0001JM\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0018\u00010&j\u0004\u0018\u0001`'2\b\u0010(\u001a\u0004\u0018\u00010$2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0002\u0010+J\u0013\u0010,\u001a\u00020$2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Ldev/inmo/tgbotapi/types/message/content/media/AnimationContent;", "Ldev/inmo/tgbotapi/types/message/content/abstracts/MediaContent;", "Ldev/inmo/tgbotapi/CommonAbstracts/CaptionedInput;", "Ldev/inmo/tgbotapi/CommonAbstracts/TextedInput;", "media", "Ldev/inmo/tgbotapi/types/files/AnimationFile;", "includedDocument", "Ldev/inmo/tgbotapi/types/files/DocumentFile;", "text", "", "textSources", "", "Ldev/inmo/tgbotapi/CommonAbstracts/TextSource;", "Ldev/inmo/tgbotapi/CommonAbstracts/TextSourcesList;", "(Ldev/inmo/tgbotapi/types/files/AnimationFile;Ldev/inmo/tgbotapi/types/files/DocumentFile;Ljava/lang/String;Ljava/util/List;)V", "getIncludedDocument", "()Ldev/inmo/tgbotapi/types/files/DocumentFile;", "getMedia", "()Ldev/inmo/tgbotapi/types/files/AnimationFile;", "getText", "()Ljava/lang/String;", "getTextSources", "()Ljava/util/List;", "asInputMedia", "Ldev/inmo/tgbotapi/types/InputMedia/InputMediaAnimation;", "component1", "component2", "component3", "component4", "copy", "createResend", "Ldev/inmo/tgbotapi/requests/abstracts/Request;", "Ldev/inmo/tgbotapi/types/message/abstracts/ContentMessage;", "chatId", "Ldev/inmo/tgbotapi/types/ChatIdentifier;", "disableNotification", "", "replyToMessageId", "", "Ldev/inmo/tgbotapi/types/MessageIdentifier;", "allowSendingWithoutReply", "replyMarkup", "Ldev/inmo/tgbotapi/types/buttons/KeyboardMarkup;", "(Ldev/inmo/tgbotapi/types/ChatIdentifier;ZLjava/lang/Long;Ljava/lang/Boolean;Ldev/inmo/tgbotapi/types/buttons/KeyboardMarkup;)Ldev/inmo/tgbotapi/requests/abstracts/Request;", "equals", "other", "", "hashCode", "", "toString", "tgbotapi.core"})
public final class AnimationContent
implements MediaContent,
CaptionedInput,
TextedInput {
    @NotNull
    private final AnimationFile media;
    @Nullable
    private final DocumentFile includedDocument;
    @Nullable
    private final String text;
    @NotNull
    private final List<TextSource> textSources;

    public AnimationContent(@NotNull AnimationFile media, @Nullable DocumentFile includedDocument, @Nullable String text, @NotNull List<? extends TextSource> textSources2) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        Intrinsics.checkNotNullParameter(textSources2, (String)"textSources");
        this.media = media;
        this.includedDocument = includedDocument;
        this.text = text;
        this.textSources = textSources2;
    }

    public /* synthetic */ AnimationContent(AnimationFile animationFile, DocumentFile documentFile, String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(animationFile, documentFile, string, list);
    }

    @Override
    @NotNull
    public AnimationFile getMedia() {
        return this.media;
    }

    @Nullable
    public final DocumentFile getIncludedDocument() {
        return this.includedDocument;
    }

    @Override
    @Nullable
    public String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public List<TextSource> getTextSources() {
        return this.textSources;
    }

    @NotNull
    public Request<ContentMessage<AnimationContent>> createResend(@NotNull ChatIdentifier chatId, boolean disableNotification, @Nullable Long replyToMessageId, @Nullable Boolean allowSendingWithoutReply, @Nullable KeyboardMarkup replyMarkup) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        PhotoSize photoSize = this.getMedia().getThumb();
        return SendAnimationKt.SendAnimation(chatId, this.getMedia().getFileId(), photoSize == null ? null : photoSize.getFileId(), this.getTextSources(), this.getMedia().getDuration(), this.getMedia().getWidth(), this.getMedia().getHeight(), disableNotification, replyToMessageId, allowSendingWithoutReply, replyMarkup);
    }

    @Override
    @NotNull
    public InputMediaAnimation asInputMedia() {
        PhotoSize photoSize;
        return InputMediaAnimationKt.InputMediaAnimation(this.getMedia().getFileId(), this.getTextSources(), this.getMedia().getWidth(), this.getMedia().getHeight(), this.getMedia().getDuration(), (photoSize = this.getMedia().getThumb()) == null ? null : photoSize.getFileId());
    }

    @Override
    @Nullable
    public String getCaption() {
        return CaptionedInput.DefaultImpls.getCaption(this);
    }

    @Override
    @NotNull
    public List<TextPart> getCaptionEntities() {
        return CaptionedInput.DefaultImpls.getCaptionEntities(this);
    }

    @Override
    @NotNull
    public List<TextPart> getTextEntities() {
        return CaptionedInput.DefaultImpls.getTextEntities(this);
    }

    @NotNull
    public final AnimationFile component1() {
        return this.getMedia();
    }

    @Nullable
    public final DocumentFile component2() {
        return this.includedDocument;
    }

    @Nullable
    public final String component3() {
        return this.getText();
    }

    @NotNull
    public final List<TextSource> component4() {
        return this.getTextSources();
    }

    @NotNull
    public final AnimationContent copy(@NotNull AnimationFile media, @Nullable DocumentFile includedDocument, @Nullable String text, @NotNull List<? extends TextSource> textSources2) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        Intrinsics.checkNotNullParameter(textSources2, (String)"textSources");
        return new AnimationContent(media, includedDocument, text, textSources2);
    }

    public static /* synthetic */ AnimationContent copy$default(AnimationContent animationContent, AnimationFile animationFile, DocumentFile documentFile, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            animationFile = animationContent.getMedia();
        }
        if ((n & 2) != 0) {
            documentFile = animationContent.includedDocument;
        }
        if ((n & 4) != 0) {
            string = animationContent.getText();
        }
        if ((n & 8) != 0) {
            list = animationContent.getTextSources();
        }
        return animationContent.copy(animationFile, documentFile, string, list);
    }

    @NotNull
    public String toString() {
        return "AnimationContent(media=" + this.getMedia() + ", includedDocument=" + this.includedDocument + ", text=" + this.getText() + ", textSources=" + this.getTextSources() + ')';
    }

    public int hashCode() {
        int result2 = this.getMedia().hashCode();
        result2 = result2 * 31 + (this.includedDocument == null ? 0 : this.includedDocument.hashCode());
        result2 = result2 * 31 + (this.getText() == null ? 0 : this.getText().hashCode());
        result2 = result2 * 31 + ((Object)this.getTextSources()).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnimationContent)) {
            return false;
        }
        AnimationContent animationContent = (AnimationContent)other;
        if (!Intrinsics.areEqual((Object)this.getMedia(), (Object)animationContent.getMedia())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.includedDocument, (Object)animationContent.includedDocument)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getText(), (Object)animationContent.getText())) {
            return false;
        }
        return Intrinsics.areEqual(this.getTextSources(), animationContent.getTextSources());
    }
}

