/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.MessageEntity.textsources;

import dev.inmo.tgbotapi.CommonAbstracts.MultilevelTextSource;
import dev.inmo.tgbotapi.CommonAbstracts.TextSource;
import dev.inmo.tgbotapi.types.User;
import dev.inmo.tgbotapi.utils.RiskFeature;
import dev.inmo.tgbotapi.utils.internal.MultilevelTextSourceFormattingKt;
import dev.inmo.tgbotapi.utils.internal.StringFormattingKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u001b\u0010\n\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u001b\u0010\u0012\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0013\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Ldev/inmo/tgbotapi/types/MessageEntity/textsources/TextMentionTextSource;", "Ldev/inmo/tgbotapi/CommonAbstracts/MultilevelTextSource;", "source", "", "user", "Ldev/inmo/tgbotapi/types/User;", "subsources", "", "Ldev/inmo/tgbotapi/CommonAbstracts/TextSource;", "(Ljava/lang/String;Ldev/inmo/tgbotapi/types/User;Ljava/util/List;)V", "html", "getHtml", "()Ljava/lang/String;", "html$delegate", "Lkotlin/Lazy;", "markdown", "getMarkdown", "markdown$delegate", "markdownV2", "getMarkdownV2", "markdownV2$delegate", "getSource", "getSubsources", "()Ljava/util/List;", "getUser", "()Ldev/inmo/tgbotapi/types/User;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "tgbotapi.core"})
public final class TextMentionTextSource
implements MultilevelTextSource {
    @NotNull
    private final String source;
    @NotNull
    private final User user;
    @NotNull
    private final List<TextSource> subsources;
    @NotNull
    private final Lazy markdown$delegate;
    @NotNull
    private final Lazy markdownV2$delegate;
    @NotNull
    private final Lazy html$delegate;

    @RiskFeature(message="It is strongly not recommended to use constructors directly instead of factory methods")
    public TextMentionTextSource(@NotNull String source, @NotNull User user, @NotNull List<? extends TextSource> subsources) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(subsources, (String)"subsources");
        this.source = source;
        this.user = user;
        this.subsources = subsources;
        this.markdown$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TextMentionTextSource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return StringFormattingKt.textMentionMarkdown(this.this$0.getSource(), this.this$0.getUser().getId());
            }
        }));
        this.markdownV2$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TextMentionTextSource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return MultilevelTextSourceFormattingKt.textMentionMarkdownV2(this.this$0, this.this$0.getUser().getId());
            }
        }));
        this.html$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ TextMentionTextSource this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return MultilevelTextSourceFormattingKt.textMentionHTML(this.this$0, this.this$0.getUser().getId());
            }
        }));
    }

    @Override
    @NotNull
    public String getSource() {
        return this.source;
    }

    @NotNull
    public final User getUser() {
        return this.user;
    }

    @Override
    @NotNull
    public List<TextSource> getSubsources() {
        return this.subsources;
    }

    @Override
    @NotNull
    public String getMarkdown() {
        Lazy lazy = this.markdown$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getMarkdownV2() {
        Lazy lazy = this.markdownV2$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getHtml() {
        Lazy lazy = this.html$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getAsText() {
        return MultilevelTextSource.DefaultImpls.getAsText(this);
    }

    @NotNull
    public final String component1() {
        return this.getSource();
    }

    @NotNull
    public final User component2() {
        return this.user;
    }

    @NotNull
    public final List<TextSource> component3() {
        return this.getSubsources();
    }

    @NotNull
    public final TextMentionTextSource copy(@NotNull String source, @NotNull User user, @NotNull List<? extends TextSource> subsources) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(subsources, (String)"subsources");
        return new TextMentionTextSource(source, user, subsources);
    }

    public static /* synthetic */ TextMentionTextSource copy$default(TextMentionTextSource textMentionTextSource, String string, User user, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = textMentionTextSource.getSource();
        }
        if ((n & 2) != 0) {
            user = textMentionTextSource.user;
        }
        if ((n & 4) != 0) {
            list = textMentionTextSource.getSubsources();
        }
        return textMentionTextSource.copy(string, user, list);
    }

    @NotNull
    public String toString() {
        return "TextMentionTextSource(source=" + this.getSource() + ", user=" + this.user + ", subsources=" + this.getSubsources() + ')';
    }

    public int hashCode() {
        int result2 = this.getSource().hashCode();
        result2 = result2 * 31 + this.user.hashCode();
        result2 = result2 * 31 + ((Object)this.getSubsources()).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextMentionTextSource)) {
            return false;
        }
        TextMentionTextSource textMentionTextSource = (TextMentionTextSource)other;
        if (!Intrinsics.areEqual((Object)this.getSource(), (Object)textMentionTextSource.getSource())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.user, (Object)textMentionTextSource.user)) {
            return false;
        }
        return Intrinsics.areEqual(this.getSubsources(), textMentionTextSource.getSubsources());
    }
}

