/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.message.content.media;

import dev.inmo.tgbotapi.CommonAbstracts.CaptionedInput;
import dev.inmo.tgbotapi.CommonAbstracts.CaptionedKt;
import dev.inmo.tgbotapi.CommonAbstracts.TextPart;
import dev.inmo.tgbotapi.requests.abstracts.Request;
import dev.inmo.tgbotapi.requests.send.media.SendAnimationKt;
import dev.inmo.tgbotapi.types.ChatIdentifier;
import dev.inmo.tgbotapi.types.InputMedia.InputMediaAnimation;
import dev.inmo.tgbotapi.types.InputMedia.InputMediaAnimationKt;
import dev.inmo.tgbotapi.types.buttons.KeyboardMarkup;
import dev.inmo.tgbotapi.types.files.AnimationFile;
import dev.inmo.tgbotapi.types.files.DocumentFile;
import dev.inmo.tgbotapi.types.files.PhotoSize;
import dev.inmo.tgbotapi.types.message.abstracts.ContentMessage;
import dev.inmo.tgbotapi.types.message.abstracts.Message;
import dev.inmo.tgbotapi.types.message.content.abstracts.MediaContent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001JM\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u000e\u0010#\u001a\n\u0018\u00010$j\u0004\u0018\u0001`%2\b\u0010&\u001a\u0004\u0018\u00010\"2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010)J\u0013\u0010*\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\bH\u00d6\u0001R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Ldev/inmo/tgbotapi/types/message/content/media/AnimationContent;", "Ldev/inmo/tgbotapi/types/message/content/abstracts/MediaContent;", "Ldev/inmo/tgbotapi/CommonAbstracts/CaptionedInput;", "media", "Ldev/inmo/tgbotapi/types/files/AnimationFile;", "includedDocument", "Ldev/inmo/tgbotapi/types/files/DocumentFile;", "caption", "", "captionEntities", "", "Ldev/inmo/tgbotapi/CommonAbstracts/TextPart;", "(Ldev/inmo/tgbotapi/types/files/AnimationFile;Ldev/inmo/tgbotapi/types/files/DocumentFile;Ljava/lang/String;Ljava/util/List;)V", "getCaption", "()Ljava/lang/String;", "getCaptionEntities", "()Ljava/util/List;", "getIncludedDocument", "()Ldev/inmo/tgbotapi/types/files/DocumentFile;", "getMedia", "()Ldev/inmo/tgbotapi/types/files/AnimationFile;", "asInputMedia", "Ldev/inmo/tgbotapi/types/InputMedia/InputMediaAnimation;", "component1", "component2", "component3", "component4", "copy", "createResend", "Ldev/inmo/tgbotapi/requests/abstracts/Request;", "Ldev/inmo/tgbotapi/types/message/abstracts/ContentMessage;", "chatId", "Ldev/inmo/tgbotapi/types/ChatIdentifier;", "disableNotification", "", "replyToMessageId", "", "Ldev/inmo/tgbotapi/types/MessageIdentifier;", "allowSendingWithoutReply", "replyMarkup", "Ldev/inmo/tgbotapi/types/buttons/KeyboardMarkup;", "(Ldev/inmo/tgbotapi/types/ChatIdentifier;ZLjava/lang/Long;Ljava/lang/Boolean;Ldev/inmo/tgbotapi/types/buttons/KeyboardMarkup;)Ldev/inmo/tgbotapi/requests/abstracts/Request;", "equals", "other", "", "hashCode", "", "toString", "tgbotapi.core"})
public final class AnimationContent
implements MediaContent,
CaptionedInput {
    @NotNull
    private final AnimationFile media;
    @Nullable
    private final DocumentFile includedDocument;
    @Nullable
    private final String caption;
    @NotNull
    private final List<TextPart> captionEntities;

    public AnimationContent(@NotNull AnimationFile media, @Nullable DocumentFile includedDocument, @Nullable String caption, @NotNull List<TextPart> captionEntities) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        Intrinsics.checkNotNullParameter(captionEntities, (String)"captionEntities");
        this.media = media;
        this.includedDocument = includedDocument;
        this.caption = caption;
        this.captionEntities = captionEntities;
    }

    @Override
    @NotNull
    public AnimationFile getMedia() {
        return this.media;
    }

    @Nullable
    public final DocumentFile getIncludedDocument() {
        return this.includedDocument;
    }

    @Override
    @Nullable
    public String getCaption() {
        return this.caption;
    }

    @Override
    @NotNull
    public List<TextPart> getCaptionEntities() {
        return this.captionEntities;
    }

    @NotNull
    public Request<ContentMessage<AnimationContent>> createResend(@NotNull ChatIdentifier chatId, boolean disableNotification, @Nullable Long replyToMessageId, @Nullable Boolean allowSendingWithoutReply, @Nullable KeyboardMarkup replyMarkup) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        PhotoSize photoSize = this.getMedia().getThumb();
        return SendAnimationKt.SendAnimation(chatId, this.getMedia().getFileId(), photoSize == null ? null : photoSize.getFileId(), CaptionedKt.getTextSources(this), this.getMedia().getDuration(), this.getMedia().getWidth(), this.getMedia().getHeight(), disableNotification, replyToMessageId, allowSendingWithoutReply, replyMarkup);
    }

    @Override
    @NotNull
    public InputMediaAnimation asInputMedia() {
        PhotoSize photoSize;
        return InputMediaAnimationKt.InputMediaAnimation(this.getMedia().getFileId(), CaptionedKt.getTextSources(this), this.getMedia().getWidth(), this.getMedia().getHeight(), this.getMedia().getDuration(), (photoSize = this.getMedia().getThumb()) == null ? null : photoSize.getFileId());
    }

    @Override
    @NotNull
    public List<Request<? extends Message>> createResends(@NotNull ChatIdentifier chatId, boolean disableNotification, @Nullable Long replyToMessageId, @Nullable Boolean allowSendingWithoutReply, @Nullable KeyboardMarkup replyMarkup) {
        return MediaContent.DefaultImpls.createResends(this, chatId, disableNotification, replyToMessageId, allowSendingWithoutReply, replyMarkup);
    }

    @NotNull
    public final AnimationFile component1() {
        return this.getMedia();
    }

    @Nullable
    public final DocumentFile component2() {
        return this.includedDocument;
    }

    @Nullable
    public final String component3() {
        return this.getCaption();
    }

    @NotNull
    public final List<TextPart> component4() {
        return this.getCaptionEntities();
    }

    @NotNull
    public final AnimationContent copy(@NotNull AnimationFile media, @Nullable DocumentFile includedDocument, @Nullable String caption, @NotNull List<TextPart> captionEntities) {
        Intrinsics.checkNotNullParameter((Object)media, (String)"media");
        Intrinsics.checkNotNullParameter(captionEntities, (String)"captionEntities");
        return new AnimationContent(media, includedDocument, caption, captionEntities);
    }

    public static /* synthetic */ AnimationContent copy$default(AnimationContent animationContent, AnimationFile animationFile, DocumentFile documentFile, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            animationFile = animationContent.getMedia();
        }
        if ((n & 2) != 0) {
            documentFile = animationContent.includedDocument;
        }
        if ((n & 4) != 0) {
            string = animationContent.getCaption();
        }
        if ((n & 8) != 0) {
            list = animationContent.getCaptionEntities();
        }
        return animationContent.copy(animationFile, documentFile, string, list);
    }

    @NotNull
    public String toString() {
        return "AnimationContent(media=" + this.getMedia() + ", includedDocument=" + this.includedDocument + ", caption=" + this.getCaption() + ", captionEntities=" + this.getCaptionEntities() + ')';
    }

    public int hashCode() {
        int result2 = this.getMedia().hashCode();
        result2 = result2 * 31 + (this.includedDocument == null ? 0 : this.includedDocument.hashCode());
        result2 = result2 * 31 + (this.getCaption() == null ? 0 : this.getCaption().hashCode());
        result2 = result2 * 31 + ((Object)this.getCaptionEntities()).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnimationContent)) {
            return false;
        }
        AnimationContent animationContent = (AnimationContent)other;
        if (!Intrinsics.areEqual((Object)this.getMedia(), (Object)animationContent.getMedia())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.includedDocument, (Object)animationContent.includedDocument)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getCaption(), (Object)animationContent.getCaption())) {
            return false;
        }
        return Intrinsics.areEqual(this.getCaptionEntities(), animationContent.getCaptionEntities());
    }
}

