/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.tgbotapi.types.message.content.media;

import dev.inmo.tgbotapi.CommonAbstracts.CaptionedKt;
import dev.inmo.tgbotapi.CommonAbstracts.TextPart;
import dev.inmo.tgbotapi.requests.abstracts.Request;
import dev.inmo.tgbotapi.requests.send.media.SendPhotoKt;
import dev.inmo.tgbotapi.types.ChatIdentifier;
import dev.inmo.tgbotapi.types.InputMedia.InputMediaPhoto;
import dev.inmo.tgbotapi.types.InputMedia.InputMediaPhotoKt;
import dev.inmo.tgbotapi.types.buttons.KeyboardMarkup;
import dev.inmo.tgbotapi.types.files.PhotoSize;
import dev.inmo.tgbotapi.types.files.PhotoSizeKt;
import dev.inmo.tgbotapi.types.message.abstracts.ContentMessage;
import dev.inmo.tgbotapi.types.message.abstracts.Message;
import dev.inmo.tgbotapi.types.message.content.abstracts.MediaCollectionContent;
import dev.inmo.tgbotapi.types.message.content.abstracts.VisualMediaGroupContent;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B3\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00020\u0005j\u0002`\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00020\u0005j\u0002`\u0006H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0003J9\u0010\u0019\u001a\u00020\u00002\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00020\u0005j\u0002`\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0001JM\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010!\u001a\n\u0018\u00010\"j\u0004\u0018\u0001`#2\b\u0010$\u001a\u0004\u0018\u00010 2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J\u0013\u0010(\u001a\u00020 2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\b\u0010-\u001a\u00020\u0015H\u0016J\t\u0010.\u001a\u00020\bH\u00d6\u0001R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00020\u0005j\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006/"}, d2={"Ldev/inmo/tgbotapi/types/message/content/media/PhotoContent;", "Ldev/inmo/tgbotapi/types/message/content/abstracts/MediaCollectionContent;", "Ldev/inmo/tgbotapi/types/files/PhotoSize;", "Ldev/inmo/tgbotapi/types/message/content/abstracts/VisualMediaGroupContent;", "mediaCollection", "", "Ldev/inmo/tgbotapi/types/files/Photo;", "caption", "", "captionEntities", "Ldev/inmo/tgbotapi/CommonAbstracts/TextPart;", "(Ljava/util/List;Ljava/lang/String;Ljava/util/List;)V", "getCaption", "()Ljava/lang/String;", "getCaptionEntities", "()Ljava/util/List;", "media", "getMedia", "()Ldev/inmo/tgbotapi/types/files/PhotoSize;", "getMediaCollection", "asInputMedia", "Ldev/inmo/tgbotapi/types/InputMedia/InputMediaPhoto;", "component1", "component2", "component3", "copy", "createResend", "Ldev/inmo/tgbotapi/requests/abstracts/Request;", "Ldev/inmo/tgbotapi/types/message/abstracts/ContentMessage;", "chatId", "Ldev/inmo/tgbotapi/types/ChatIdentifier;", "disableNotification", "", "replyToMessageId", "", "Ldev/inmo/tgbotapi/types/MessageIdentifier;", "allowSendingWithoutReply", "replyMarkup", "Ldev/inmo/tgbotapi/types/buttons/KeyboardMarkup;", "(Ldev/inmo/tgbotapi/types/ChatIdentifier;ZLjava/lang/Long;Ljava/lang/Boolean;Ldev/inmo/tgbotapi/types/buttons/KeyboardMarkup;)Ldev/inmo/tgbotapi/requests/abstracts/Request;", "equals", "other", "", "hashCode", "", "toMediaGroupMemberInputMedia", "toString", "tgbotapi.core"})
public final class PhotoContent
implements MediaCollectionContent<PhotoSize>,
VisualMediaGroupContent {
    @NotNull
    private final List<PhotoSize> mediaCollection;
    @Nullable
    private final String caption;
    @NotNull
    private final List<TextPart> captionEntities;
    @NotNull
    private final PhotoSize media;

    public PhotoContent(@NotNull List<PhotoSize> mediaCollection, @Nullable String caption, @NotNull List<TextPart> captionEntities) {
        Intrinsics.checkNotNullParameter(mediaCollection, (String)"mediaCollection");
        Intrinsics.checkNotNullParameter(captionEntities, (String)"captionEntities");
        this.mediaCollection = mediaCollection;
        this.caption = caption;
        this.captionEntities = captionEntities;
        PhotoSize photoSize = PhotoSizeKt.biggest(this.getMediaCollection());
        if (photoSize == null) {
            throw new IllegalStateException("Can't locate any photo size for this content");
        }
        this.media = photoSize;
    }

    public /* synthetic */ PhotoContent(List list, String string, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(list, string, list2);
    }

    @Override
    @NotNull
    public List<PhotoSize> getMediaCollection() {
        return this.mediaCollection;
    }

    @Override
    @Nullable
    public String getCaption() {
        return this.caption;
    }

    @Override
    @NotNull
    public List<TextPart> getCaptionEntities() {
        return this.captionEntities;
    }

    @Override
    @NotNull
    public PhotoSize getMedia() {
        return this.media;
    }

    @NotNull
    public Request<ContentMessage<PhotoContent>> createResend(@NotNull ChatIdentifier chatId, boolean disableNotification, @Nullable Long replyToMessageId, @Nullable Boolean allowSendingWithoutReply, @Nullable KeyboardMarkup replyMarkup) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        return SendPhotoKt.SendPhoto(chatId, this.getMedia().getFileId(), CaptionedKt.getTextSources(this), disableNotification, replyToMessageId, allowSendingWithoutReply, replyMarkup);
    }

    @Override
    @NotNull
    public InputMediaPhoto toMediaGroupMemberInputMedia() {
        return this.asInputMedia();
    }

    @Override
    @NotNull
    public InputMediaPhoto asInputMedia() {
        return InputMediaPhotoKt.toInputMediaPhoto(this.getMedia(), CaptionedKt.getTextSources(this));
    }

    @Override
    @NotNull
    public List<Request<? extends Message>> createResends(@NotNull ChatIdentifier chatId, boolean disableNotification, @Nullable Long replyToMessageId, @Nullable Boolean allowSendingWithoutReply, @Nullable KeyboardMarkup replyMarkup) {
        return MediaCollectionContent.DefaultImpls.createResends(this, chatId, disableNotification, replyToMessageId, allowSendingWithoutReply, replyMarkup);
    }

    @NotNull
    public final List<PhotoSize> component1() {
        return this.getMediaCollection();
    }

    @Nullable
    public final String component2() {
        return this.getCaption();
    }

    @NotNull
    public final List<TextPart> component3() {
        return this.getCaptionEntities();
    }

    @NotNull
    public final PhotoContent copy(@NotNull List<PhotoSize> mediaCollection, @Nullable String caption, @NotNull List<TextPart> captionEntities) {
        Intrinsics.checkNotNullParameter(mediaCollection, (String)"mediaCollection");
        Intrinsics.checkNotNullParameter(captionEntities, (String)"captionEntities");
        return new PhotoContent(mediaCollection, caption, captionEntities);
    }

    public static /* synthetic */ PhotoContent copy$default(PhotoContent photoContent, List list, String string, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = photoContent.getMediaCollection();
        }
        if ((n & 2) != 0) {
            string = photoContent.getCaption();
        }
        if ((n & 4) != 0) {
            list2 = photoContent.getCaptionEntities();
        }
        return photoContent.copy(list, string, list2);
    }

    @NotNull
    public String toString() {
        return "PhotoContent(mediaCollection=" + this.getMediaCollection() + ", caption=" + this.getCaption() + ", captionEntities=" + this.getCaptionEntities() + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.getMediaCollection()).hashCode();
        result2 = result2 * 31 + (this.getCaption() == null ? 0 : this.getCaption().hashCode());
        result2 = result2 * 31 + ((Object)this.getCaptionEntities()).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhotoContent)) {
            return false;
        }
        PhotoContent photoContent = (PhotoContent)other;
        if (!Intrinsics.areEqual(this.getMediaCollection(), photoContent.getMediaCollection())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getCaption(), (Object)photoContent.getCaption())) {
            return false;
        }
        return Intrinsics.areEqual(this.getCaptionEntities(), photoContent.getCaptionEntities());
    }
}

