package dev.inmo.plagubot.plugins.captcha

import dev.inmo.plagubot.plugins.captcha.provider.cancelData
import dev.inmo.tgbotapi.extensions.utils.SlotMachineReelImage
import dev.inmo.tgbotapi.extensions.utils.types.buttons.dataButton
import dev.inmo.tgbotapi.extensions.utils.types.buttons.inlineKeyboard
import dev.inmo.tgbotapi.types.buttons.InlineKeyboardButtons.CallbackDataInlineKeyboardButton
import dev.inmo.tgbotapi.types.buttons.InlineKeyboardButtons.InlineKeyboardButton
import dev.inmo.tgbotapi.types.buttons.InlineKeyboardMarkup
import dev.inmo.tgbotapi.utils.row

infix fun String.startingOf(target: String) = target.startsWith(this)

private val buttonsPreset: List<List<InlineKeyboardButton>> = SlotMachineReelImage.values().toList().chunked(2).map {
    it.map {
        CallbackDataInlineKeyboardButton(it.text, it.text)
    }
}

fun slotMachineReplyMarkup(
    adminCancelButton: Boolean = false
): InlineKeyboardMarkup {
    return inlineKeyboard {
        buttonsPreset.forEach(::add)
        if (adminCancelButton) {
            row {
                dataButton("Cancel (Admins only)", cancelData)
            }
        }
    }
}
