package dev.inmo.micro_utils.strings

import dev.inmo.micro_utils.language_codes.toIetfLanguageCode
import java.util.Locale

fun StringResource.translation(locale: Locale = Locale.getDefault()): String {
    return translation(locale.toIetfLanguageCode())
}

fun Locale.translation(resource: StringResource): String = resource.translation(this)