/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.micro_utils.pagination.utils;

import dev.inmo.micro_utils.pagination.Pagination;
import dev.inmo.micro_utils.pagination.PaginationKt;
import dev.inmo.micro_utils.pagination.PaginationResult;
import dev.inmo.micro_utils.pagination.PaginationResultKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010 \n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0006\b\u0000\u0010\u0002\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0005\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\b\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004\u001a$\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f\u001a$\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a$\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"optionallyReverse", "", "T", "reverse", "", "([Ljava/lang/Object;Z)[Ljava/lang/Object;", "", "", "", "paginate", "Ldev/inmo/micro_utils/pagination/PaginationResult;", "with", "Ldev/inmo/micro_utils/pagination/Pagination;", "micro_utils.pagination.common"})
public final class IterableExtensionsKt {
    @NotNull
    public static final <T> PaginationResult<T> paginate(@NotNull Iterable<? extends T> $this$paginate, @NotNull Pagination with) {
        Intrinsics.checkNotNullParameter($this$paginate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)with, (String)"with");
        int i = 0;
        List result = new ArrayList();
        int lowerIndex = PaginationKt.getFirstIndex(with);
        int greatestIndex = PaginationKt.getLastIndex(with);
        for (T item : $this$paginate) {
            int n;
            if (i < lowerIndex || i > greatestIndex) {
                n = i;
                i = n + 1;
                continue;
            }
            result.add(item);
            n = i;
            i = n + 1;
        }
        return PaginationResultKt.createPaginationResult(result, with, (long)i);
    }

    @NotNull
    public static final <T> PaginationResult<T> paginate(@NotNull List<? extends T> $this$paginate, @NotNull Pagination with) {
        Intrinsics.checkNotNullParameter($this$paginate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)with, (String)"with");
        int firstIndex = Math.max(PaginationKt.getFirstIndex(with), 0);
        int lastIndex = Math.min(PaginationKt.getLastIndexExclusive(with), $this$paginate.size());
        if (firstIndex > lastIndex) {
            return PaginationResultKt.emptyPaginationResult();
        }
        return PaginationResultKt.createPaginationResult($this$paginate.subList(firstIndex, lastIndex), with, (long)$this$paginate.size());
    }

    @NotNull
    public static final <T> PaginationResult<T> paginate(@NotNull Set<? extends T> $this$paginate, @NotNull Pagination with) {
        Intrinsics.checkNotNullParameter($this$paginate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)with, (String)"with");
        return PaginationResultKt.createPaginationResult(CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)$this$paginate, (int)PaginationKt.getFirstIndex(with)), (int)with.getSize()), with, (long)$this$paginate.size());
    }

    @NotNull
    public static final <T> Iterable<T> optionallyReverse(@NotNull Iterable<? extends T> $this$optionallyReverse, boolean reverse) {
        Intrinsics.checkNotNullParameter($this$optionallyReverse, (String)"<this>");
        Iterable iterable = $this$optionallyReverse;
        return iterable instanceof List ? (Iterable)IterableExtensionsKt.optionallyReverse((List)$this$optionallyReverse, reverse) : (iterable instanceof Set ? (Iterable)IterableExtensionsKt.optionallyReverse((Set)$this$optionallyReverse, reverse) : (reverse ? (Iterable)CollectionsKt.reversed($this$optionallyReverse) : $this$optionallyReverse));
    }

    @NotNull
    public static final <T> List<T> optionallyReverse(@NotNull List<? extends T> $this$optionallyReverse, boolean reverse) {
        Intrinsics.checkNotNullParameter($this$optionallyReverse, (String)"<this>");
        return reverse ? CollectionsKt.reversed((Iterable)$this$optionallyReverse) : $this$optionallyReverse;
    }

    @NotNull
    public static final <T> Set<T> optionallyReverse(@NotNull Set<? extends T> $this$optionallyReverse, boolean reverse) {
        Intrinsics.checkNotNullParameter($this$optionallyReverse, (String)"<this>");
        return reverse ? CollectionsKt.toSet((Iterable)CollectionsKt.reversed((Iterable)$this$optionallyReverse)) : $this$optionallyReverse;
    }

    public static final /* synthetic */ <T> T[] optionallyReverse(T[] $this$optionallyReverse, boolean reverse) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter($this$optionallyReverse, (String)"<this>");
        boolean $i$f$optionallyReverse = false;
        if (reverse) {
            int n = 0;
            int n2 = $this$optionallyReverse.length;
            Intrinsics.reifiedOperationMarker((int)0, (String)"T");
            Object[] objectArray2 = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                objectArray2[n3] = $this$optionallyReverse[ArraysKt.getLastIndex((Object[])$this$optionallyReverse) - n3];
            }
            objectArray = objectArray2;
        } else {
            objectArray = $this$optionallyReverse;
        }
        return objectArray;
    }
}

