/*
 * Decompiled with CFR 0.152.
 */
package dev.inmo.micro_utils.pagination;

import dev.inmo.micro_utils.common.RangeIntersectionKt;
import dev.inmo.micro_utils.pagination.Pagination;
import dev.inmo.micro_utils.pagination.SimplePagination;
import dev.inmo.micro_utils.pagination.SimplePaginationKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007\u001a\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007\u001a\u0016\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007\"\u0016\u0010\u0003\u001a\u00020\u0004*\u00020\u00018\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u0007*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0015\u0010\f\u001a\u00020\u0007*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0014"}, d2={"intersect", "Ldev/inmo/micro_utils/pagination/Pagination;", "other", "isFirstPage", "", "(Ldev/inmo/micro_utils/pagination/Pagination;)Z", "firstIndex", "", "getFirstIndex", "(Ldev/inmo/micro_utils/pagination/Pagination;)I", "lastIndexExclusive", "getLastIndexExclusive", "lastIndex", "getLastIndex", "calculatePagesNumber", "datasetSize", "", "pageSize", "calculatePage", "resultsSize", "micro_utils.pagination.common"})
public final class PaginationKt {
    @Nullable
    public static final Pagination intersect(@NotNull Pagination $this$intersect, @NotNull Pagination other) {
        SimplePagination simplePagination;
        Intrinsics.checkNotNullParameter((Object)$this$intersect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Pair pair = RangeIntersectionKt.intersect((ClosedRange)$this$intersect, (ClosedRange)other);
        if (pair != null) {
            Pair it = pair;
            boolean bl = false;
            simplePagination = SimplePaginationKt.PaginationByIndexes(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
        } else {
            simplePagination = null;
        }
        return simplePagination;
    }

    public static final boolean isFirstPage(@NotNull Pagination $this$isFirstPage) {
        Intrinsics.checkNotNullParameter((Object)$this$isFirstPage, (String)"<this>");
        boolean $i$f$isFirstPage = false;
        return $this$isFirstPage.getPage() == 0;
    }

    public static final int getFirstIndex(@NotNull Pagination $this$firstIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$firstIndex, (String)"<this>");
        return $this$firstIndex.getStart();
    }

    public static final int getLastIndexExclusive(@NotNull Pagination $this$lastIndexExclusive) {
        Intrinsics.checkNotNullParameter((Object)$this$lastIndexExclusive, (String)"<this>");
        return $this$lastIndexExclusive.getEndInclusive() + 1;
    }

    public static final int getLastIndex(@NotNull Pagination $this$lastIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$lastIndex, (String)"<this>");
        return $this$lastIndex.getEndInclusive();
    }

    public static final int calculatePagesNumber(long datasetSize, int pageSize) {
        return (int)Math.ceil((double)datasetSize / (double)pageSize);
    }

    public static final int calculatePagesNumber(int pageSize, long datasetSize) {
        return PaginationKt.calculatePagesNumber(datasetSize, pageSize);
    }

    public static final int calculatePagesNumber(int datasetSize, int pageSize) {
        return PaginationKt.calculatePagesNumber((long)datasetSize, pageSize);
    }

    public static final int calculatePage(int firstIndex, int resultsSize) {
        return resultsSize > 0 ? (int)Math.floor((float)firstIndex / (float)resultsSize) : 0;
    }
}

