(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlinx-serialization-kotlinx-serialization-core-jsLegacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlinx-serialization-kotlinx-serialization-core-jsLegacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'micro_utils-micro_utils.pagination.common-jsLegacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'micro_utils-micro_utils.pagination.common-jsLegacy'.");
    }if (typeof this['kotlinx-serialization-kotlinx-serialization-core-jsLegacy'] === 'undefined') {
      throw new Error("Error loading module 'micro_utils-micro_utils.pagination.common-jsLegacy'. Its dependency 'kotlinx-serialization-kotlinx-serialization-core-jsLegacy' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-core-jsLegacy' is loaded prior to 'micro_utils-micro_utils.pagination.common-jsLegacy'.");
    }root['micro_utils-micro_utils.pagination.common-jsLegacy'] = factory(typeof this['micro_utils-micro_utils.pagination.common-jsLegacy'] === 'undefined' ? {} : this['micro_utils-micro_utils.pagination.common-jsLegacy'], kotlin, this['kotlinx-serialization-kotlinx-serialization-core-jsLegacy']);
  }
}(this, function (_, Kotlin, $module$kotlinx_serialization_kotlinx_serialization_core_jsLegacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var numberToInt = Kotlin.numberToInt;
  var Math_0 = Math;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var SerializerFactory = $module$kotlinx_serialization_kotlinx_serialization_core_jsLegacy.kotlinx.serialization.internal.SerializerFactory;
  var PluginGeneratedSerialDescriptor = $module$kotlinx_serialization_kotlinx_serialization_core_jsLegacy.kotlinx.serialization.internal.PluginGeneratedSerialDescriptor;
  var ArrayListSerializer = $module$kotlinx_serialization_kotlinx_serialization_core_jsLegacy.kotlinx.serialization.internal.ArrayListSerializer;
  var UnknownFieldException = $module$kotlinx_serialization_kotlinx_serialization_core_jsLegacy.kotlinx.serialization.UnknownFieldException;
  var internal = $module$kotlinx_serialization_kotlinx_serialization_core_jsLegacy.kotlinx.serialization.internal;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var GeneratedSerializer = $module$kotlinx_serialization_kotlinx_serialization_core_jsLegacy.kotlinx.serialization.internal.GeneratedSerializer;
  var MissingFieldException_init = $module$kotlinx_serialization_kotlinx_serialization_core_jsLegacy.kotlinx.serialization.MissingFieldException_init_61zpoe$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var wrapFunction = Kotlin.wrapFunction;
  var drop = Kotlin.kotlin.collections.drop_ba2ldo$;
  var take = Kotlin.kotlin.collections.take_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var removeFirst = Kotlin.kotlin.collections.removeFirst_vvxzk3$;
  var Iterator = Kotlin.kotlin.collections.Iterator;
  var Iterable = Kotlin.kotlin.collections.Iterable;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  function Pagination() {
  }
  Pagination.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Pagination',
    interfaces: []
  };
  var get_isFirstPage = defineInlineFunction('micro_utils-micro_utils.pagination.common-jsLegacy.dev.inmo.micro_utils.pagination.get_isFirstPage_qog94p$', function ($receiver) {
    return $receiver.page === 0;
  });
  function get_firstIndex($receiver) {
    return Kotlin.imul($receiver.page, $receiver.size);
  }
  function get_lastIndexExclusive($receiver) {
    return get_firstIndex($receiver) + $receiver.size | 0;
  }
  function get_lastIndex($receiver) {
    return get_lastIndexExclusive($receiver) - 1 | 0;
  }
  function calculatePagesNumber(datasetSize, pageSize) {
    var x = datasetSize.toNumber() / pageSize;
    return numberToInt(Math_0.ceil(x));
  }
  function calculatePagesNumber_0(pageSize, datasetSize) {
    return calculatePagesNumber(datasetSize, pageSize);
  }
  function calculatePagesNumber_1(datasetSize, pageSize) {
    return calculatePagesNumber(Kotlin.Long.fromInt(datasetSize), pageSize);
  }
  function calculatePage(firstIndex, resultsSize) {
    if (resultsSize > 0) {
      var x = firstIndex / resultsSize;
      return numberToInt(Math_0.floor(x));
    } else {
      return 0;
    }
  }
  function PaginationResult(page, pagesNumber, results, size) {
    PaginationResult$Companion_getInstance();
    this.page_uicji$_0 = page;
    this.pagesNumber = pagesNumber;
    this.results = results;
    this.size_spgs0$_0 = size;
  }
  Object.defineProperty(PaginationResult.prototype, 'page', {
    get: function () {
      return this.page_uicji$_0;
    }
  });
  Object.defineProperty(PaginationResult.prototype, 'size', {
    get: function () {
      return this.size_spgs0$_0;
    }
  });
  function PaginationResult$Companion() {
    PaginationResult$Companion_instance = this;
  }
  PaginationResult$Companion.prototype.serializer_swdriu$ = function (typeSerial0) {
    return PaginationResult$PaginationResult$$serializer_init(typeSerial0);
  };
  PaginationResult$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [SerializerFactory]
  };
  var PaginationResult$Companion_instance = null;
  function PaginationResult$Companion_getInstance() {
    if (PaginationResult$Companion_instance === null) {
      new PaginationResult$Companion();
    }return PaginationResult$Companion_instance;
  }
  function PaginationResult$$serializer() {
    this.descriptor_kjefq$_0 = new PluginGeneratedSerialDescriptor('dev.inmo.micro_utils.pagination.PaginationResult', this, 4);
    this.descriptor.addElement_ivxn3r$('page', false);
    this.descriptor.addElement_ivxn3r$('pagesNumber', false);
    this.descriptor.addElement_ivxn3r$('results', false);
    this.descriptor.addElement_ivxn3r$('size', false);
  }
  Object.defineProperty(PaginationResult$$serializer.prototype, 'descriptor', {
    configurable: true,
    get: function () {
      return this.descriptor_kjefq$_0;
    }
  });
  PaginationResult$$serializer.prototype.serialize_55azsf$ = function (encoder, value) {
    var output = encoder.beginStructure_24f42q$(this.descriptor);
    output.encodeIntElement_ptg7oe$(this.descriptor, 0, value.page);
    output.encodeIntElement_ptg7oe$(this.descriptor, 1, value.pagesNumber);
    output.encodeSerializableElement_r4qlx7$(this.descriptor, 2, new ArrayListSerializer(this.typeSerial0), value.results);
    output.encodeIntElement_ptg7oe$(this.descriptor, 3, value.size);
    output.endStructure_24f42q$(this.descriptor);
  };
  PaginationResult$$serializer.prototype.deserialize_bq71mq$ = function (decoder) {
    var index;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_24f42q$(this.descriptor);
    loopLabel: while (true) {
      index = input.decodeElementIndex_24f42q$(this.descriptor);
      switch (index) {
        case 0:
          local0 = input.decodeIntElement_szpzho$(this.descriptor, 0);
          bitMask0 |= 1;
          break;
        case 1:
          local1 = input.decodeIntElement_szpzho$(this.descriptor, 1);
          bitMask0 |= 2;
          break;
        case 2:
          local2 = input.decodeSerializableElement_12e8id$(this.descriptor, 2, new ArrayListSerializer(this.typeSerial0), local2);
          bitMask0 |= 4;
          break;
        case 3:
          local3 = input.decodeIntElement_szpzho$(this.descriptor, 3);
          bitMask0 |= 8;
          break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_24f42q$(this.descriptor);
    return PaginationResult_init(bitMask0, local0, local1, local2, local3, null);
  };
  PaginationResult$$serializer.prototype.childSerializers = function () {
    return [internal.IntSerializer, internal.IntSerializer, new ArrayListSerializer(this.typeSerial0), internal.IntSerializer];
  };
  PaginationResult$$serializer.prototype.typeParametersSerializers = function () {
    return [this.typeSerial0];
  };
  function PaginationResult$PaginationResult$$serializer_init(typeSerial0) {
    var $this = new PaginationResult$$serializer();
    $this.typeSerial0 = typeSerial0;
    return $this;
  }
  PaginationResult$$serializer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  function PaginationResult_init(seen1, page, pagesNumber, results, size, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(PaginationResult.prototype);
    if ((seen1 & 1) === 0)
      throw MissingFieldException_init('page');
    else
      $this.page_uicji$_0 = page;
    if ((seen1 & 2) === 0)
      throw MissingFieldException_init('pagesNumber');
    else
      $this.pagesNumber = pagesNumber;
    if ((seen1 & 4) === 0)
      throw MissingFieldException_init('results');
    else
      $this.results = results;
    if ((seen1 & 8) === 0)
      throw MissingFieldException_init('size');
    else
      $this.size_spgs0$_0 = size;
    return $this;
  }
  PaginationResult.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PaginationResult',
    interfaces: [Pagination]
  };
  PaginationResult.prototype.component1 = function () {
    return this.page;
  };
  PaginationResult.prototype.component2 = function () {
    return this.pagesNumber;
  };
  PaginationResult.prototype.component3 = function () {
    return this.results;
  };
  PaginationResult.prototype.component4 = function () {
    return this.size;
  };
  PaginationResult.prototype.copy_26gsx0$ = function (page, pagesNumber, results, size) {
    return new PaginationResult(page === void 0 ? this.page : page, pagesNumber === void 0 ? this.pagesNumber : pagesNumber, results === void 0 ? this.results : results, size === void 0 ? this.size : size);
  };
  PaginationResult.prototype.toString = function () {
    return 'PaginationResult(page=' + Kotlin.toString(this.page) + (', pagesNumber=' + Kotlin.toString(this.pagesNumber)) + (', results=' + Kotlin.toString(this.results)) + (', size=' + Kotlin.toString(this.size)) + ')';
  };
  PaginationResult.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.page) | 0;
    result = result * 31 + Kotlin.hashCode(this.pagesNumber) | 0;
    result = result * 31 + Kotlin.hashCode(this.results) | 0;
    result = result * 31 + Kotlin.hashCode(this.size) | 0;
    return result;
  };
  PaginationResult.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.page, other.page) && Kotlin.equals(this.pagesNumber, other.pagesNumber) && Kotlin.equals(this.results, other.results) && Kotlin.equals(this.size, other.size)))));
  };
  function emptyPaginationResult() {
    return new PaginationResult(0, 0, emptyList(), 0);
  }
  function createPaginationResult($receiver, pagination, commonObjectsNumber) {
    return new PaginationResult(pagination.page, calculatePagesNumber(commonObjectsNumber, pagination.size), $receiver, pagination.size);
  }
  function createPaginationResult_0($receiver, firstIndex, commonObjectsNumber) {
    return new PaginationResult(calculatePage(firstIndex, $receiver.size), calculatePagesNumber(commonObjectsNumber, $receiver.size), $receiver, $receiver.size);
  }
  function createPaginationResult_1($receiver, pagination) {
    return createPaginationResult($receiver.second, pagination, $receiver.first);
  }
  var defaultSmallPageSize;
  var defaultMediumPageSize;
  var defaultLargePageSize;
  var defaultExtraLargePageSize;
  var defaultPaginationPageSize;
  var FirstPagePagination = defineInlineFunction('micro_utils-micro_utils.pagination.common-jsLegacy.dev.inmo.micro_utils.pagination.FirstPagePagination_za3lpa$', wrapFunction(function () {
    var pagination = _.dev.inmo.micro_utils.pagination;
    var SimplePagination_init = _.dev.inmo.micro_utils.pagination.SimplePagination;
    return function (size) {
      if (size === void 0)
        size = pagination.defaultPaginationPageSize;
      return new SimplePagination_init(0, size);
    };
  }));
  var emptyPagination;
  var firstPageWithOneElementPagination;
  var nextPage = defineInlineFunction('micro_utils-micro_utils.pagination.common-jsLegacy.dev.inmo.micro_utils.pagination.nextPage_qog94p$', wrapFunction(function () {
    var SimplePagination_init = _.dev.inmo.micro_utils.pagination.SimplePagination;
    return function ($receiver) {
      return new SimplePagination_init($receiver.page + 1 | 0, $receiver.size);
    };
  }));
  function SimplePagination(page, size) {
    SimplePagination$Companion_getInstance();
    this.page_y6ey1$_0 = page;
    this.size_wdj6j$_0 = size;
  }
  Object.defineProperty(SimplePagination.prototype, 'page', {
    get: function () {
      return this.page_y6ey1$_0;
    }
  });
  Object.defineProperty(SimplePagination.prototype, 'size', {
    get: function () {
      return this.size_wdj6j$_0;
    }
  });
  function SimplePagination$Companion() {
    SimplePagination$Companion_instance = this;
  }
  SimplePagination$Companion.prototype.serializer = function () {
    return SimplePagination$$serializer_getInstance();
  };
  SimplePagination$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SimplePagination$Companion_instance = null;
  function SimplePagination$Companion_getInstance() {
    if (SimplePagination$Companion_instance === null) {
      new SimplePagination$Companion();
    }return SimplePagination$Companion_instance;
  }
  function SimplePagination$$serializer() {
    this.descriptor_fyu3lr$_0 = new PluginGeneratedSerialDescriptor('dev.inmo.micro_utils.pagination.SimplePagination', this, 2);
    this.descriptor.addElement_ivxn3r$('page', false);
    this.descriptor.addElement_ivxn3r$('size', false);
    SimplePagination$$serializer_instance = this;
  }
  Object.defineProperty(SimplePagination$$serializer.prototype, 'descriptor', {
    configurable: true,
    get: function () {
      return this.descriptor_fyu3lr$_0;
    }
  });
  SimplePagination$$serializer.prototype.serialize_55azsf$ = function (encoder, value) {
    var output = encoder.beginStructure_24f42q$(this.descriptor);
    output.encodeIntElement_ptg7oe$(this.descriptor, 0, value.page);
    output.encodeIntElement_ptg7oe$(this.descriptor, 1, value.size);
    output.endStructure_24f42q$(this.descriptor);
  };
  SimplePagination$$serializer.prototype.deserialize_bq71mq$ = function (decoder) {
    var index;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_24f42q$(this.descriptor);
    loopLabel: while (true) {
      index = input.decodeElementIndex_24f42q$(this.descriptor);
      switch (index) {
        case 0:
          local0 = input.decodeIntElement_szpzho$(this.descriptor, 0);
          bitMask0 |= 1;
          break;
        case 1:
          local1 = input.decodeIntElement_szpzho$(this.descriptor, 1);
          bitMask0 |= 2;
          break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_24f42q$(this.descriptor);
    return SimplePagination_init(bitMask0, local0, local1, null);
  };
  SimplePagination$$serializer.prototype.childSerializers = function () {
    return [internal.IntSerializer, internal.IntSerializer];
  };
  SimplePagination$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SimplePagination$$serializer_instance = null;
  function SimplePagination$$serializer_getInstance() {
    if (SimplePagination$$serializer_instance === null) {
      new SimplePagination$$serializer();
    }return SimplePagination$$serializer_instance;
  }
  function SimplePagination_init(seen1, page, size, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SimplePagination.prototype);
    if ((seen1 & 1) === 0)
      throw MissingFieldException_init('page');
    else
      $this.page_y6ey1$_0 = page;
    if ((seen1 & 2) === 0)
      throw MissingFieldException_init('size');
    else
      $this.size_wdj6j$_0 = size;
    return $this;
  }
  SimplePagination.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SimplePagination',
    interfaces: [Pagination]
  };
  SimplePagination.prototype.component1 = function () {
    return this.page;
  };
  SimplePagination.prototype.component2 = function () {
    return this.size;
  };
  SimplePagination.prototype.copy_vux9f0$ = function (page, size) {
    return new SimplePagination(page === void 0 ? this.page : page, size === void 0 ? this.size : size);
  };
  SimplePagination.prototype.toString = function () {
    return 'SimplePagination(page=' + Kotlin.toString(this.page) + (', size=' + Kotlin.toString(this.size)) + ')';
  };
  SimplePagination.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.page) | 0;
    result = result * 31 + Kotlin.hashCode(this.size) | 0;
    return result;
  };
  SimplePagination.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.page, other.page) && Kotlin.equals(this.size, other.size)))));
  };
  function Pagination_0(page, size) {
    return new SimplePagination(page, size);
  }
  function PaginationByIndexes(firstIndex, lastIndex) {
    var b = lastIndex - firstIndex + 1 | 0;
    var size = Math_0.max(0, b);
    return Pagination_0(calculatePage(firstIndex, size), size);
  }
  var doWithPagination = defineInlineFunction('micro_utils-micro_utils.pagination.common-jsLegacy.dev.inmo.micro_utils.pagination.doWithPagination_uzjclt$', wrapFunction(function () {
    var pagination = _.dev.inmo.micro_utils.pagination;
    var SimplePagination_init = _.dev.inmo.micro_utils.pagination.SimplePagination;
    return function (startPagination, requestMaker) {
      if (startPagination === void 0) {
        startPagination = new SimplePagination_init(0, pagination.defaultPaginationPageSize);
      }var pagination_0 = requestMaker(startPagination);
      while (pagination_0 != null) {
        pagination_0 = requestMaker(pagination_0);
      }
    };
  }));
  var nextPageIfNotEmpty = defineInlineFunction('micro_utils-micro_utils.pagination.common-jsLegacy.dev.inmo.micro_utils.pagination.nextPageIfNotEmpty_ku6zwc$', wrapFunction(function () {
    var SimplePagination_init = _.dev.inmo.micro_utils.pagination.SimplePagination;
    return function ($receiver) {
      if (!$receiver.results.isEmpty()) {
        return new SimplePagination_init($receiver.page + 1 | 0, $receiver.size);
      } else {
        return null;
      }
    };
  }));
  var thisPageIfNotEmpty = defineInlineFunction('micro_utils-micro_utils.pagination.common-jsLegacy.dev.inmo.micro_utils.pagination.thisPageIfNotEmpty_ku6zwc$', function ($receiver) {
    if (!$receiver.results.isEmpty()) {
      return $receiver;
    } else {
      return null;
    }
  });
  function paginate($receiver, with_0) {
    var tmp$;
    var i = 0;
    var result = ArrayList_init();
    var lowerIndex = get_firstIndex(with_0);
    var greatestIndex = get_lastIndex(with_0);
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      if (i < lowerIndex || i > greatestIndex) {
        i = i + 1 | 0;
      } else {
        result.add_11rb$(item);
        i = i + 1 | 0;
      }
    }
    return createPaginationResult(result, with_0, Kotlin.Long.fromInt(i));
  }
  function paginate_0($receiver, with_0) {
    var a = get_firstIndex(with_0);
    var firstIndex = Math_0.max(a, 0);
    var a_0 = get_lastIndexExclusive(with_0);
    var b = $receiver.size;
    var lastIndex = Math_0.min(a_0, b);
    if (firstIndex > lastIndex) {
      return emptyPaginationResult();
    }return createPaginationResult($receiver.subList_vux9f0$(firstIndex, lastIndex), with_0, Kotlin.Long.fromInt($receiver.size));
  }
  function paginate_1($receiver, with_0) {
    return createPaginationResult(take(drop($receiver, get_firstIndex(with_0)), with_0.size), with_0, Kotlin.Long.fromInt($receiver.size));
  }
  function PaginatedIterator(pageSize, countGetter, paginationResultGetter) {
    this.countGetter_0 = countGetter;
    this.paginationResultGetter_0 = paginationResultGetter;
    this.pagination_0 = new SimplePagination(0, pageSize);
    this.currentStack_0 = ArrayList_init();
  }
  PaginatedIterator.prototype.hasNext = function () {
    return !this.currentStack_0.isEmpty() || this.countGetter_0().toNumber() < get_lastIndexExclusive(this.pagination_0);
  };
  PaginatedIterator.prototype.next = function () {
    if (this.currentStack_0.isEmpty()) {
      var resultPagination = this.paginationResultGetter_0(this.pagination_0);
      this.currentStack_0.addAll_brywnq$(resultPagination.results);
      if (!!this.currentStack_0.isEmpty()) {
        var message = 'There is no elements left';
        throw IllegalArgumentException_init(message.toString());
      }this.pagination_0 = new SimplePagination(resultPagination.page + 1 | 0, resultPagination.size);
    }return removeFirst(this.currentStack_0);
  };
  PaginatedIterator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PaginatedIterator',
    interfaces: [Iterator]
  };
  function PaginatedIterable(pageSize, countGetter, paginationResultGetter) {
    this.pageSize_0 = pageSize;
    this.countGetter_0 = countGetter;
    this.paginationResultGetter_0 = paginationResultGetter;
  }
  PaginatedIterable.prototype.iterator = function () {
    return new PaginatedIterator(this.pageSize_0, this.countGetter_0, this.paginationResultGetter_0);
  };
  PaginatedIterable.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PaginatedIterable',
    interfaces: [Iterable]
  };
  var makeIterable = defineInlineFunction('micro_utils-micro_utils.pagination.common-jsLegacy.dev.inmo.micro_utils.pagination.utils.makeIterable_genep6$', wrapFunction(function () {
    var pagination = _.dev.inmo.micro_utils.pagination;
    var PaginatedIterable_init = _.dev.inmo.micro_utils.pagination.utils.PaginatedIterable;
    return function (countGetter, pageSize, paginationResultGetter) {
      if (pageSize === void 0)
        pageSize = pagination.defaultPaginationPageSize;
      return new PaginatedIterable_init(pageSize, countGetter, paginationResultGetter);
    };
  }));
  function reverse($receiver, datasetSize) {
    var tmp$;
    var pagesNumber = calculatePagesNumber_0($receiver.size, datasetSize);
    var newPage = pagesNumber - $receiver.page - 1 | 0;
    if ($receiver.page < 0 || $receiver.page >= pagesNumber)
      tmp$ = emptyPagination;
    else
      tmp$ = Pagination_0(newPage, $receiver.size);
    return tmp$;
  }
  function reverse_0($receiver, objectsCount) {
    return reverse($receiver, Kotlin.Long.fromInt(objectsCount));
  }
  var package$dev = _.dev || (_.dev = {});
  var package$inmo = package$dev.inmo || (package$dev.inmo = {});
  var package$micro_utils = package$inmo.micro_utils || (package$inmo.micro_utils = {});
  var package$pagination = package$micro_utils.pagination || (package$micro_utils.pagination = {});
  package$pagination.Pagination = Pagination;
  package$pagination.get_isFirstPage_qog94p$ = get_isFirstPage;
  package$pagination.get_firstIndex_qog94p$ = get_firstIndex;
  package$pagination.get_lastIndexExclusive_qog94p$ = get_lastIndexExclusive;
  package$pagination.get_lastIndex_qog94p$ = get_lastIndex;
  package$pagination.calculatePagesNumber_yhmem3$ = calculatePagesNumber;
  package$pagination.calculatePagesNumber_6svq3l$ = calculatePagesNumber_0;
  package$pagination.calculatePagesNumber_vux9f0$ = calculatePagesNumber_1;
  package$pagination.calculatePage_vux9f0$ = calculatePage;
  Object.defineProperty(PaginationResult, 'Companion', {
    get: PaginationResult$Companion_getInstance
  });
  PaginationResult.$serializer_init_swdriu$ = PaginationResult$PaginationResult$$serializer_init;
  PaginationResult.$serializer = PaginationResult$$serializer;
  package$pagination.PaginationResult_init_5a9qbf$ = PaginationResult_init;
  package$pagination.PaginationResult = PaginationResult;
  package$pagination.emptyPaginationResult_287e2$ = emptyPaginationResult;
  package$pagination.createPaginationResult_ewdglv$ = createPaginationResult;
  package$pagination.createPaginationResult_3a6pir$ = createPaginationResult_0;
  package$pagination.createPaginationResult_siswnw$ = createPaginationResult_1;
  Object.defineProperty(package$pagination, 'defaultSmallPageSize', {
    get: function () {
      return defaultSmallPageSize;
    }
  });
  Object.defineProperty(package$pagination, 'defaultMediumPageSize', {
    get: function () {
      return defaultMediumPageSize;
    }
  });
  Object.defineProperty(package$pagination, 'defaultLargePageSize', {
    get: function () {
      return defaultLargePageSize;
    }
  });
  Object.defineProperty(package$pagination, 'defaultExtraLargePageSize', {
    get: function () {
      return defaultExtraLargePageSize;
    }
  });
  Object.defineProperty(package$pagination, 'defaultPaginationPageSize', {
    get: function () {
      return defaultPaginationPageSize;
    },
    set: function (value) {
      defaultPaginationPageSize = value;
    }
  });
  package$pagination.FirstPagePagination_za3lpa$ = FirstPagePagination;
  Object.defineProperty(package$pagination, 'emptyPagination', {
    get: function () {
      return emptyPagination;
    }
  });
  $$importsForInline$$['micro_utils-micro_utils.pagination.common-jsLegacy'] = _;
  Object.defineProperty(package$pagination, 'firstPageWithOneElementPagination', {
    get: function () {
      return firstPageWithOneElementPagination;
    }
  });
  package$pagination.nextPage_qog94p$ = nextPage;
  Object.defineProperty(SimplePagination, 'Companion', {
    get: SimplePagination$Companion_getInstance
  });
  Object.defineProperty(SimplePagination, '$serializer', {
    get: SimplePagination$$serializer_getInstance
  });
  package$pagination.SimplePagination_init_tup0k7$ = SimplePagination_init;
  package$pagination.SimplePagination = SimplePagination;
  package$pagination.Pagination_vux9f0$ = Pagination_0;
  package$pagination.PaginationByIndexes_vux9f0$ = PaginationByIndexes;
  package$pagination.doWithPagination_uzjclt$ = doWithPagination;
  package$pagination.nextPageIfNotEmpty_ku6zwc$ = nextPageIfNotEmpty;
  package$pagination.thisPageIfNotEmpty_ku6zwc$ = thisPageIfNotEmpty;
  var package$utils = package$pagination.utils || (package$pagination.utils = {});
  package$utils.paginate_mdzfi6$ = paginate;
  package$utils.paginate_9kgo46$ = paginate_0;
  package$utils.paginate_amfzxe$ = paginate_1;
  package$utils.PaginatedIterator = PaginatedIterator;
  package$utils.PaginatedIterable = PaginatedIterable;
  package$utils.makeIterable_genep6$ = makeIterable;
  package$utils.reverse_c018w2$ = reverse;
  package$utils.reverse_yr8wo9$ = reverse_0;
  SimplePagination$$serializer.prototype.typeParametersSerializers = GeneratedSerializer.prototype.typeParametersSerializers;
  defaultSmallPageSize = 2;
  defaultMediumPageSize = 5;
  defaultLargePageSize = 10;
  defaultExtraLargePageSize = 15;
  defaultPaginationPageSize = 5;
  emptyPagination = Pagination_0(0, 0);
  firstPageWithOneElementPagination = new SimplePagination(0, 1);
  Kotlin.defineModule('micro_utils-micro_utils.pagination.common-jsLegacy', _);
  return _;
}));

//# sourceMappingURL=micro_utils-micro_utils.pagination.common-jsLegacy.js.map
