package dev.inmo.micro_utils.language_codes

val knownLanguageCodesMap: Map<String, IetfLang> by lazy {
    mapOf(
        IetfLang.Afar.code to IetfLang.Afar,
        IetfLang.Abkhazian.code to IetfLang.Abkhazian,
        IetfLang.Achinese.code to IetfLang.Achinese,
        IetfLang.Acoli.code to IetfLang.Acoli,
        IetfLang.Adangme.code to IetfLang.Adangme,
        IetfLang.AdygheAdygei.code to IetfLang.AdygheAdygei,
        IetfLang.AfroAsiaticLanguages.code to IetfLang.AfroAsiaticLanguages,
        IetfLang.Afrihili.code to IetfLang.Afrihili,
        IetfLang.Afrikaans.code to IetfLang.Afrikaans,
            IetfLang.Afrikaans.NA.code to IetfLang.Afrikaans.NA,
            IetfLang.Afrikaans.ZA.code to IetfLang.Afrikaans.ZA,
        IetfLang.Ainu.code to IetfLang.Ainu,
        IetfLang.Akan.code to IetfLang.Akan,
            IetfLang.Akan.GH.code to IetfLang.Akan.GH,
        IetfLang.Akkadian.code to IetfLang.Akkadian,
        IetfLang.Albanian.code to IetfLang.Albanian,
            IetfLang.Albanian.AL.code to IetfLang.Albanian.AL,
            IetfLang.Albanian.MK.code to IetfLang.Albanian.MK,
            IetfLang.Albanian.XK.code to IetfLang.Albanian.XK,
        IetfLang.Aleut.code to IetfLang.Aleut,
        IetfLang.AlgonquianLanguages.code to IetfLang.AlgonquianLanguages,
        IetfLang.SouthernAltai.code to IetfLang.SouthernAltai,
        IetfLang.Amharic.code to IetfLang.Amharic,
            IetfLang.Amharic.ET.code to IetfLang.Amharic.ET,
        IetfLang.EnglishOldCa_4501100.code to IetfLang.EnglishOldCa_4501100,
        IetfLang.Angika.code to IetfLang.Angika,
        IetfLang.ApacheLanguages.code to IetfLang.ApacheLanguages,
        IetfLang.Arabic.code to IetfLang.Arabic,
            IetfLang.Arabic.L001.code to IetfLang.Arabic.L001,
            IetfLang.Arabic.AE.code to IetfLang.Arabic.AE,
            IetfLang.Arabic.BH.code to IetfLang.Arabic.BH,
            IetfLang.Arabic.DJ.code to IetfLang.Arabic.DJ,
            IetfLang.Arabic.DZ.code to IetfLang.Arabic.DZ,
            IetfLang.Arabic.EG.code to IetfLang.Arabic.EG,
            IetfLang.Arabic.EH.code to IetfLang.Arabic.EH,
            IetfLang.Arabic.ER.code to IetfLang.Arabic.ER,
            IetfLang.Arabic.IL.code to IetfLang.Arabic.IL,
            IetfLang.Arabic.IQ.code to IetfLang.Arabic.IQ,
            IetfLang.Arabic.JO.code to IetfLang.Arabic.JO,
            IetfLang.Arabic.KM.code to IetfLang.Arabic.KM,
            IetfLang.Arabic.KW.code to IetfLang.Arabic.KW,
            IetfLang.Arabic.LB.code to IetfLang.Arabic.LB,
            IetfLang.Arabic.LY.code to IetfLang.Arabic.LY,
            IetfLang.Arabic.MA.code to IetfLang.Arabic.MA,
            IetfLang.Arabic.MR.code to IetfLang.Arabic.MR,
            IetfLang.Arabic.OM.code to IetfLang.Arabic.OM,
            IetfLang.Arabic.PS.code to IetfLang.Arabic.PS,
            IetfLang.Arabic.QA.code to IetfLang.Arabic.QA,
            IetfLang.Arabic.SA.code to IetfLang.Arabic.SA,
            IetfLang.Arabic.SD.code to IetfLang.Arabic.SD,
            IetfLang.Arabic.SO.code to IetfLang.Arabic.SO,
            IetfLang.Arabic.SS.code to IetfLang.Arabic.SS,
            IetfLang.Arabic.SY.code to IetfLang.Arabic.SY,
            IetfLang.Arabic.TD.code to IetfLang.Arabic.TD,
            IetfLang.Arabic.TN.code to IetfLang.Arabic.TN,
            IetfLang.Arabic.YE.code to IetfLang.Arabic.YE,
        IetfLang.OfficialAramaic700300BCEImperialAramaic700300BCE.code to IetfLang.OfficialAramaic700300BCEImperialAramaic700300BCE,
        IetfLang.Aragonese.code to IetfLang.Aragonese,
        IetfLang.Armenian.code to IetfLang.Armenian,
            IetfLang.Armenian.AM.code to IetfLang.Armenian.AM,
        IetfLang.MapudungunMapuche.code to IetfLang.MapudungunMapuche,
        IetfLang.Arapaho.code to IetfLang.Arapaho,
        IetfLang.ArtificialLanguages.code to IetfLang.ArtificialLanguages,
        IetfLang.Arawak.code to IetfLang.Arawak,
        IetfLang.Assamese.code to IetfLang.Assamese,
            IetfLang.Assamese.IN.code to IetfLang.Assamese.IN,
        IetfLang.AsturianBableLeoneseAsturleonese.code to IetfLang.AsturianBableLeoneseAsturleonese,
            IetfLang.AsturianBableLeoneseAsturleonese.ES.code to IetfLang.AsturianBableLeoneseAsturleonese.ES,
        IetfLang.AthapascanLanguages.code to IetfLang.AthapascanLanguages,
        IetfLang.AustralianLanguages.code to IetfLang.AustralianLanguages,
        IetfLang.Avaric.code to IetfLang.Avaric,
        IetfLang.Avestan.code to IetfLang.Avestan,
        IetfLang.Awadhi.code to IetfLang.Awadhi,
        IetfLang.Aymara.code to IetfLang.Aymara,
        IetfLang.Azerbaijani.code to IetfLang.Azerbaijani,
            IetfLang.Azerbaijani.Cyrl.code to IetfLang.Azerbaijani.Cyrl,
                IetfLang.Azerbaijani.Cyrl.AZ.code to IetfLang.Azerbaijani.Cyrl.AZ,
            IetfLang.Azerbaijani.Latn.code to IetfLang.Azerbaijani.Latn,
                IetfLang.Azerbaijani.Latn.AZ.code to IetfLang.Azerbaijani.Latn.AZ,
        IetfLang.BandaLanguages.code to IetfLang.BandaLanguages,
        IetfLang.BamilekeLanguages.code to IetfLang.BamilekeLanguages,
        IetfLang.Bashkir.code to IetfLang.Bashkir,
        IetfLang.Baluchi.code to IetfLang.Baluchi,
        IetfLang.Bambara.code to IetfLang.Bambara,
            IetfLang.Bambara.ML.code to IetfLang.Bambara.ML,
        IetfLang.Balinese.code to IetfLang.Balinese,
        IetfLang.Basque.code to IetfLang.Basque,
            IetfLang.Basque.ES.code to IetfLang.Basque.ES,
        IetfLang.Basa.code to IetfLang.Basa,
            IetfLang.Basa.CM.code to IetfLang.Basa.CM,
        IetfLang.BalticLanguages.code to IetfLang.BalticLanguages,
        IetfLang.BejaBedawiyet.code to IetfLang.BejaBedawiyet,
        IetfLang.Belarusian.code to IetfLang.Belarusian,
            IetfLang.Belarusian.BY.code to IetfLang.Belarusian.BY,
        IetfLang.Bemba.code to IetfLang.Bemba,
            IetfLang.Bemba.ZM.code to IetfLang.Bemba.ZM,
        IetfLang.Bengali.code to IetfLang.Bengali,
            IetfLang.Bengali.BD.code to IetfLang.Bengali.BD,
            IetfLang.Bengali.IN.code to IetfLang.Bengali.IN,
        IetfLang.BerberLanguages.code to IetfLang.BerberLanguages,
        IetfLang.Bhojpuri.code to IetfLang.Bhojpuri,
        IetfLang.BihariLanguages.code to IetfLang.BihariLanguages,
        IetfLang.Bikol.code to IetfLang.Bikol,
        IetfLang.BiniEdo.code to IetfLang.BiniEdo,
        IetfLang.Bislama.code to IetfLang.Bislama,
        IetfLang.Siksika.code to IetfLang.Siksika,
        IetfLang.BantuOther.code to IetfLang.BantuOther,
        IetfLang.Bosnian.code to IetfLang.Bosnian,
            IetfLang.Bosnian.Cyrl.code to IetfLang.Bosnian.Cyrl,
                IetfLang.Bosnian.Cyrl.BA.code to IetfLang.Bosnian.Cyrl.BA,
            IetfLang.Bosnian.Latn.code to IetfLang.Bosnian.Latn,
                IetfLang.Bosnian.Latn.BA.code to IetfLang.Bosnian.Latn.BA,
        IetfLang.Braj.code to IetfLang.Braj,
        IetfLang.Breton.code to IetfLang.Breton,
            IetfLang.Breton.FR.code to IetfLang.Breton.FR,
        IetfLang.BatakLanguages.code to IetfLang.BatakLanguages,
        IetfLang.Buriat.code to IetfLang.Buriat,
        IetfLang.Buginese.code to IetfLang.Buginese,
        IetfLang.Bulgarian.code to IetfLang.Bulgarian,
            IetfLang.Bulgarian.BG.code to IetfLang.Bulgarian.BG,
        IetfLang.Burmese.code to IetfLang.Burmese,
            IetfLang.Burmese.MM.code to IetfLang.Burmese.MM,
        IetfLang.BlinBilin.code to IetfLang.BlinBilin,
        IetfLang.Caddo.code to IetfLang.Caddo,
        IetfLang.CentralAmericanIndianLanguages.code to IetfLang.CentralAmericanIndianLanguages,
        IetfLang.GalibiCarib.code to IetfLang.GalibiCarib,
        IetfLang.CatalanValencian.code to IetfLang.CatalanValencian,
            IetfLang.CatalanValencian.AD.code to IetfLang.CatalanValencian.AD,
            IetfLang.CatalanValencian.ES.code to IetfLang.CatalanValencian.ES,
                IetfLang.CatalanValencian.ES.VALENCIA.code to IetfLang.CatalanValencian.ES.VALENCIA,
            IetfLang.CatalanValencian.FR.code to IetfLang.CatalanValencian.FR,
            IetfLang.CatalanValencian.IT.code to IetfLang.CatalanValencian.IT,
        IetfLang.CaucasianLanguages.code to IetfLang.CaucasianLanguages,
        IetfLang.Cebuano.code to IetfLang.Cebuano,
        IetfLang.CelticLanguages.code to IetfLang.CelticLanguages,
        IetfLang.Chamorro.code to IetfLang.Chamorro,
        IetfLang.Chibcha.code to IetfLang.Chibcha,
        IetfLang.Chechen.code to IetfLang.Chechen,
            IetfLang.Chechen.RU.code to IetfLang.Chechen.RU,
        IetfLang.Chagatai.code to IetfLang.Chagatai,
        IetfLang.Chinese.code to IetfLang.Chinese,
            IetfLang.Chinese.Hans.code to IetfLang.Chinese.Hans,
                IetfLang.Chinese.Hans.CN.code to IetfLang.Chinese.Hans.CN,
                IetfLang.Chinese.Hans.HK.code to IetfLang.Chinese.Hans.HK,
                IetfLang.Chinese.Hans.MO.code to IetfLang.Chinese.Hans.MO,
                IetfLang.Chinese.Hans.SG.code to IetfLang.Chinese.Hans.SG,
            IetfLang.Chinese.Hant.code to IetfLang.Chinese.Hant,
                IetfLang.Chinese.Hant.HK.code to IetfLang.Chinese.Hant.HK,
                IetfLang.Chinese.Hant.MO.code to IetfLang.Chinese.Hant.MO,
                IetfLang.Chinese.Hant.TW.code to IetfLang.Chinese.Hant.TW,
        IetfLang.Chuukese.code to IetfLang.Chuukese,
        IetfLang.Mari.code to IetfLang.Mari,
        IetfLang.ChinookJargon.code to IetfLang.ChinookJargon,
        IetfLang.Choctaw.code to IetfLang.Choctaw,
        IetfLang.ChipewyanDeneSuline.code to IetfLang.ChipewyanDeneSuline,
        IetfLang.Cherokee.code to IetfLang.Cherokee,
            IetfLang.Cherokee.US.code to IetfLang.Cherokee.US,
        IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.code to IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic,
            IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.RU.code to IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.RU,
        IetfLang.Chuvash.code to IetfLang.Chuvash,
        IetfLang.Cheyenne.code to IetfLang.Cheyenne,
        IetfLang.ChamicLanguages.code to IetfLang.ChamicLanguages,
        IetfLang.Coptic.code to IetfLang.Coptic,
        IetfLang.Cornish.code to IetfLang.Cornish,
            IetfLang.Cornish.GB.code to IetfLang.Cornish.GB,
        IetfLang.Corsican.code to IetfLang.Corsican,
        IetfLang.CreolesAndPidginsEnglishBased.code to IetfLang.CreolesAndPidginsEnglishBased,
        IetfLang.CreolesAndPidginsFrenchbased.code to IetfLang.CreolesAndPidginsFrenchbased,
        IetfLang.CreolesAndPidginsPortuguesebased.code to IetfLang.CreolesAndPidginsPortuguesebased,
        IetfLang.Cree.code to IetfLang.Cree,
        IetfLang.CrimeanTatarCrimeanTurkish.code to IetfLang.CrimeanTatarCrimeanTurkish,
        IetfLang.CreolesAndPidgins.code to IetfLang.CreolesAndPidgins,
        IetfLang.Kashubian.code to IetfLang.Kashubian,
        IetfLang.CushiticLanguages.code to IetfLang.CushiticLanguages,
        IetfLang.Czech.code to IetfLang.Czech,
            IetfLang.Czech.CZ.code to IetfLang.Czech.CZ,
        IetfLang.Dakota.code to IetfLang.Dakota,
        IetfLang.Danish.code to IetfLang.Danish,
            IetfLang.Danish.DK.code to IetfLang.Danish.DK,
            IetfLang.Danish.GL.code to IetfLang.Danish.GL,
        IetfLang.Dargwa.code to IetfLang.Dargwa,
        IetfLang.LandDayakLanguages.code to IetfLang.LandDayakLanguages,
        IetfLang.Delaware.code to IetfLang.Delaware,
        IetfLang.SlaveAthapascan.code to IetfLang.SlaveAthapascan,
        IetfLang.Dogrib.code to IetfLang.Dogrib,
        IetfLang.Dinka.code to IetfLang.Dinka,
        IetfLang.DivehiDhivehiMaldivian.code to IetfLang.DivehiDhivehiMaldivian,
        IetfLang.Dogri.code to IetfLang.Dogri,
        IetfLang.DravidianLanguages.code to IetfLang.DravidianLanguages,
        IetfLang.LowerSorbian.code to IetfLang.LowerSorbian,
            IetfLang.LowerSorbian.DE.code to IetfLang.LowerSorbian.DE,
        IetfLang.Duala.code to IetfLang.Duala,
            IetfLang.Duala.CM.code to IetfLang.Duala.CM,
        IetfLang.DutchMiddleCa_10501350.code to IetfLang.DutchMiddleCa_10501350,
        IetfLang.DutchFlemish.code to IetfLang.DutchFlemish,
            IetfLang.DutchFlemish.AW.code to IetfLang.DutchFlemish.AW,
            IetfLang.DutchFlemish.BE.code to IetfLang.DutchFlemish.BE,
            IetfLang.DutchFlemish.BQ.code to IetfLang.DutchFlemish.BQ,
            IetfLang.DutchFlemish.CW.code to IetfLang.DutchFlemish.CW,
            IetfLang.DutchFlemish.NL.code to IetfLang.DutchFlemish.NL,
            IetfLang.DutchFlemish.SR.code to IetfLang.DutchFlemish.SR,
            IetfLang.DutchFlemish.SX.code to IetfLang.DutchFlemish.SX,
        IetfLang.Dyula.code to IetfLang.Dyula,
        IetfLang.Dzongkha.code to IetfLang.Dzongkha,
            IetfLang.Dzongkha.BT.code to IetfLang.Dzongkha.BT,
        IetfLang.Efik.code to IetfLang.Efik,
        IetfLang.EgyptianAncient.code to IetfLang.EgyptianAncient,
        IetfLang.Ekajuk.code to IetfLang.Ekajuk,
        IetfLang.Elamite.code to IetfLang.Elamite,
        IetfLang.English.code to IetfLang.English,
            IetfLang.English.L001.code to IetfLang.English.L001,
            IetfLang.English.L150.code to IetfLang.English.L150,
            IetfLang.English.AG.code to IetfLang.English.AG,
            IetfLang.English.AI.code to IetfLang.English.AI,
            IetfLang.English.AS.code to IetfLang.English.AS,
            IetfLang.English.AT.code to IetfLang.English.AT,
            IetfLang.English.AU.code to IetfLang.English.AU,
            IetfLang.English.BB.code to IetfLang.English.BB,
            IetfLang.English.BE.code to IetfLang.English.BE,
            IetfLang.English.BI.code to IetfLang.English.BI,
            IetfLang.English.BM.code to IetfLang.English.BM,
            IetfLang.English.BS.code to IetfLang.English.BS,
            IetfLang.English.BW.code to IetfLang.English.BW,
            IetfLang.English.BZ.code to IetfLang.English.BZ,
            IetfLang.English.CA.code to IetfLang.English.CA,
            IetfLang.English.CC.code to IetfLang.English.CC,
            IetfLang.English.CH.code to IetfLang.English.CH,
            IetfLang.English.CK.code to IetfLang.English.CK,
            IetfLang.English.CM.code to IetfLang.English.CM,
            IetfLang.English.CX.code to IetfLang.English.CX,
            IetfLang.English.CY.code to IetfLang.English.CY,
            IetfLang.English.DE.code to IetfLang.English.DE,
            IetfLang.English.DG.code to IetfLang.English.DG,
            IetfLang.English.DK.code to IetfLang.English.DK,
            IetfLang.English.DM.code to IetfLang.English.DM,
            IetfLang.English.ER.code to IetfLang.English.ER,
            IetfLang.English.FI.code to IetfLang.English.FI,
            IetfLang.English.FJ.code to IetfLang.English.FJ,
            IetfLang.English.FK.code to IetfLang.English.FK,
            IetfLang.English.FM.code to IetfLang.English.FM,
            IetfLang.English.GB.code to IetfLang.English.GB,
            IetfLang.English.GD.code to IetfLang.English.GD,
            IetfLang.English.GG.code to IetfLang.English.GG,
            IetfLang.English.GH.code to IetfLang.English.GH,
            IetfLang.English.GI.code to IetfLang.English.GI,
            IetfLang.English.GM.code to IetfLang.English.GM,
            IetfLang.English.GU.code to IetfLang.English.GU,
            IetfLang.English.GY.code to IetfLang.English.GY,
            IetfLang.English.HK.code to IetfLang.English.HK,
            IetfLang.English.IE.code to IetfLang.English.IE,
            IetfLang.English.IL.code to IetfLang.English.IL,
            IetfLang.English.IM.code to IetfLang.English.IM,
            IetfLang.English.IN.code to IetfLang.English.IN,
            IetfLang.English.IO.code to IetfLang.English.IO,
            IetfLang.English.JE.code to IetfLang.English.JE,
            IetfLang.English.JM.code to IetfLang.English.JM,
            IetfLang.English.KE.code to IetfLang.English.KE,
            IetfLang.English.KI.code to IetfLang.English.KI,
            IetfLang.English.KN.code to IetfLang.English.KN,
            IetfLang.English.KY.code to IetfLang.English.KY,
            IetfLang.English.LC.code to IetfLang.English.LC,
            IetfLang.English.LR.code to IetfLang.English.LR,
            IetfLang.English.LS.code to IetfLang.English.LS,
            IetfLang.English.MG.code to IetfLang.English.MG,
            IetfLang.English.MH.code to IetfLang.English.MH,
            IetfLang.English.MO.code to IetfLang.English.MO,
            IetfLang.English.MP.code to IetfLang.English.MP,
            IetfLang.English.MS.code to IetfLang.English.MS,
            IetfLang.English.MT.code to IetfLang.English.MT,
            IetfLang.English.MU.code to IetfLang.English.MU,
            IetfLang.English.MW.code to IetfLang.English.MW,
            IetfLang.English.MY.code to IetfLang.English.MY,
            IetfLang.English.NA.code to IetfLang.English.NA,
            IetfLang.English.NF.code to IetfLang.English.NF,
            IetfLang.English.NG.code to IetfLang.English.NG,
            IetfLang.English.NL.code to IetfLang.English.NL,
            IetfLang.English.NR.code to IetfLang.English.NR,
            IetfLang.English.NU.code to IetfLang.English.NU,
            IetfLang.English.NZ.code to IetfLang.English.NZ,
            IetfLang.English.PG.code to IetfLang.English.PG,
            IetfLang.English.PH.code to IetfLang.English.PH,
            IetfLang.English.PK.code to IetfLang.English.PK,
            IetfLang.English.PN.code to IetfLang.English.PN,
            IetfLang.English.PR.code to IetfLang.English.PR,
            IetfLang.English.PW.code to IetfLang.English.PW,
            IetfLang.English.RW.code to IetfLang.English.RW,
            IetfLang.English.SB.code to IetfLang.English.SB,
            IetfLang.English.SC.code to IetfLang.English.SC,
            IetfLang.English.SD.code to IetfLang.English.SD,
            IetfLang.English.SE.code to IetfLang.English.SE,
            IetfLang.English.SG.code to IetfLang.English.SG,
            IetfLang.English.SH.code to IetfLang.English.SH,
            IetfLang.English.SI.code to IetfLang.English.SI,
            IetfLang.English.SL.code to IetfLang.English.SL,
            IetfLang.English.SS.code to IetfLang.English.SS,
            IetfLang.English.SX.code to IetfLang.English.SX,
            IetfLang.English.SZ.code to IetfLang.English.SZ,
            IetfLang.English.TC.code to IetfLang.English.TC,
            IetfLang.English.TK.code to IetfLang.English.TK,
            IetfLang.English.TO.code to IetfLang.English.TO,
            IetfLang.English.TT.code to IetfLang.English.TT,
            IetfLang.English.TV.code to IetfLang.English.TV,
            IetfLang.English.TZ.code to IetfLang.English.TZ,
            IetfLang.English.UG.code to IetfLang.English.UG,
            IetfLang.English.UM.code to IetfLang.English.UM,
            IetfLang.English.US.code to IetfLang.English.US,
                IetfLang.English.US.POSIX.code to IetfLang.English.US.POSIX,
            IetfLang.English.VC.code to IetfLang.English.VC,
            IetfLang.English.VG.code to IetfLang.English.VG,
            IetfLang.English.VI.code to IetfLang.English.VI,
            IetfLang.English.VU.code to IetfLang.English.VU,
            IetfLang.English.WS.code to IetfLang.English.WS,
            IetfLang.English.ZA.code to IetfLang.English.ZA,
            IetfLang.English.ZM.code to IetfLang.English.ZM,
            IetfLang.English.ZW.code to IetfLang.English.ZW,
        IetfLang.EnglishMiddle11001500.code to IetfLang.EnglishMiddle11001500,
        IetfLang.Esperanto.code to IetfLang.Esperanto,
            IetfLang.Esperanto.L001.code to IetfLang.Esperanto.L001,
        IetfLang.Estonian.code to IetfLang.Estonian,
            IetfLang.Estonian.EE.code to IetfLang.Estonian.EE,
        IetfLang.Ewe.code to IetfLang.Ewe,
            IetfLang.Ewe.GH.code to IetfLang.Ewe.GH,
            IetfLang.Ewe.TG.code to IetfLang.Ewe.TG,
        IetfLang.Ewondo.code to IetfLang.Ewondo,
            IetfLang.Ewondo.CM.code to IetfLang.Ewondo.CM,
        IetfLang.Fang.code to IetfLang.Fang,
        IetfLang.Faroese.code to IetfLang.Faroese,
            IetfLang.Faroese.DK.code to IetfLang.Faroese.DK,
            IetfLang.Faroese.FO.code to IetfLang.Faroese.FO,
        IetfLang.Fanti.code to IetfLang.Fanti,
        IetfLang.Fijian.code to IetfLang.Fijian,
        IetfLang.FilipinoPilipino.code to IetfLang.FilipinoPilipino,
            IetfLang.FilipinoPilipino.PH.code to IetfLang.FilipinoPilipino.PH,
        IetfLang.Finnish.code to IetfLang.Finnish,
            IetfLang.Finnish.FI.code to IetfLang.Finnish.FI,
        IetfLang.FinnoUgrianLanguages.code to IetfLang.FinnoUgrianLanguages,
        IetfLang.Fon.code to IetfLang.Fon,
        IetfLang.French.code to IetfLang.French,
            IetfLang.French.BE.code to IetfLang.French.BE,
            IetfLang.French.BF.code to IetfLang.French.BF,
            IetfLang.French.BI.code to IetfLang.French.BI,
            IetfLang.French.BJ.code to IetfLang.French.BJ,
            IetfLang.French.BL.code to IetfLang.French.BL,
            IetfLang.French.CA.code to IetfLang.French.CA,
            IetfLang.French.CD.code to IetfLang.French.CD,
            IetfLang.French.CF.code to IetfLang.French.CF,
            IetfLang.French.CG.code to IetfLang.French.CG,
            IetfLang.French.CH.code to IetfLang.French.CH,
            IetfLang.French.CI.code to IetfLang.French.CI,
            IetfLang.French.CM.code to IetfLang.French.CM,
            IetfLang.French.DJ.code to IetfLang.French.DJ,
            IetfLang.French.DZ.code to IetfLang.French.DZ,
            IetfLang.French.FR.code to IetfLang.French.FR,
            IetfLang.French.GA.code to IetfLang.French.GA,
            IetfLang.French.GF.code to IetfLang.French.GF,
            IetfLang.French.GN.code to IetfLang.French.GN,
            IetfLang.French.GP.code to IetfLang.French.GP,
            IetfLang.French.GQ.code to IetfLang.French.GQ,
            IetfLang.French.HT.code to IetfLang.French.HT,
            IetfLang.French.KM.code to IetfLang.French.KM,
            IetfLang.French.LU.code to IetfLang.French.LU,
            IetfLang.French.MA.code to IetfLang.French.MA,
            IetfLang.French.MC.code to IetfLang.French.MC,
            IetfLang.French.MF.code to IetfLang.French.MF,
            IetfLang.French.MG.code to IetfLang.French.MG,
            IetfLang.French.ML.code to IetfLang.French.ML,
            IetfLang.French.MQ.code to IetfLang.French.MQ,
            IetfLang.French.MR.code to IetfLang.French.MR,
            IetfLang.French.MU.code to IetfLang.French.MU,
            IetfLang.French.NC.code to IetfLang.French.NC,
            IetfLang.French.NE.code to IetfLang.French.NE,
            IetfLang.French.PF.code to IetfLang.French.PF,
            IetfLang.French.PM.code to IetfLang.French.PM,
            IetfLang.French.RE.code to IetfLang.French.RE,
            IetfLang.French.RW.code to IetfLang.French.RW,
            IetfLang.French.SC.code to IetfLang.French.SC,
            IetfLang.French.SN.code to IetfLang.French.SN,
            IetfLang.French.SY.code to IetfLang.French.SY,
            IetfLang.French.TD.code to IetfLang.French.TD,
            IetfLang.French.TG.code to IetfLang.French.TG,
            IetfLang.French.TN.code to IetfLang.French.TN,
            IetfLang.French.VU.code to IetfLang.French.VU,
            IetfLang.French.WF.code to IetfLang.French.WF,
            IetfLang.French.YT.code to IetfLang.French.YT,
        IetfLang.FrenchMiddleCa_14001600.code to IetfLang.FrenchMiddleCa_14001600,
        IetfLang.FrenchOld842ca_1400.code to IetfLang.FrenchOld842ca_1400,
        IetfLang.NorthernFrisian.code to IetfLang.NorthernFrisian,
        IetfLang.EasternFrisian.code to IetfLang.EasternFrisian,
        IetfLang.WesternFrisian.code to IetfLang.WesternFrisian,
            IetfLang.WesternFrisian.NL.code to IetfLang.WesternFrisian.NL,
        IetfLang.Fulah.code to IetfLang.Fulah,
            IetfLang.Fulah.CM.code to IetfLang.Fulah.CM,
            IetfLang.Fulah.GN.code to IetfLang.Fulah.GN,
            IetfLang.Fulah.MR.code to IetfLang.Fulah.MR,
            IetfLang.Fulah.SN.code to IetfLang.Fulah.SN,
        IetfLang.Friulian.code to IetfLang.Friulian,
            IetfLang.Friulian.IT.code to IetfLang.Friulian.IT,
        IetfLang.Ga.code to IetfLang.Ga,
        IetfLang.Gayo.code to IetfLang.Gayo,
        IetfLang.Gbaya.code to IetfLang.Gbaya,
        IetfLang.GermanicLanguages.code to IetfLang.GermanicLanguages,
        IetfLang.Georgian.code to IetfLang.Georgian,
            IetfLang.Georgian.GE.code to IetfLang.Georgian.GE,
        IetfLang.German.code to IetfLang.German,
            IetfLang.German.AT.code to IetfLang.German.AT,
            IetfLang.German.BE.code to IetfLang.German.BE,
            IetfLang.German.CH.code to IetfLang.German.CH,
            IetfLang.German.DE.code to IetfLang.German.DE,
            IetfLang.German.IT.code to IetfLang.German.IT,
            IetfLang.German.LI.code to IetfLang.German.LI,
            IetfLang.German.LU.code to IetfLang.German.LU,
        IetfLang.Geez.code to IetfLang.Geez,
        IetfLang.Gilbertese.code to IetfLang.Gilbertese,
        IetfLang.GaelicScottishGaelic.code to IetfLang.GaelicScottishGaelic,
            IetfLang.GaelicScottishGaelic.GB.code to IetfLang.GaelicScottishGaelic.GB,
        IetfLang.Irish.code to IetfLang.Irish,
            IetfLang.Irish.IE.code to IetfLang.Irish.IE,
        IetfLang.Galician.code to IetfLang.Galician,
            IetfLang.Galician.ES.code to IetfLang.Galician.ES,
        IetfLang.Manx.code to IetfLang.Manx,
            IetfLang.Manx.IM.code to IetfLang.Manx.IM,
        IetfLang.GermanMiddleHighCa_10501500.code to IetfLang.GermanMiddleHighCa_10501500,
        IetfLang.GermanOldHighCa_7501050.code to IetfLang.GermanOldHighCa_7501050,
        IetfLang.Gondi.code to IetfLang.Gondi,
        IetfLang.Gorontalo.code to IetfLang.Gorontalo,
        IetfLang.Gothic.code to IetfLang.Gothic,
        IetfLang.Grebo.code to IetfLang.Grebo,
        IetfLang.GreekAncientTo1453.code to IetfLang.GreekAncientTo1453,
        IetfLang.GreekModern1453.code to IetfLang.GreekModern1453,
            IetfLang.GreekModern1453.CY.code to IetfLang.GreekModern1453.CY,
            IetfLang.GreekModern1453.GR.code to IetfLang.GreekModern1453.GR,
        IetfLang.Guarani.code to IetfLang.Guarani,
        IetfLang.SwissGermanAlemannicAlsatian.code to IetfLang.SwissGermanAlemannicAlsatian,
            IetfLang.SwissGermanAlemannicAlsatian.CH.code to IetfLang.SwissGermanAlemannicAlsatian.CH,
            IetfLang.SwissGermanAlemannicAlsatian.FR.code to IetfLang.SwissGermanAlemannicAlsatian.FR,
            IetfLang.SwissGermanAlemannicAlsatian.LI.code to IetfLang.SwissGermanAlemannicAlsatian.LI,
        IetfLang.Gujarati.code to IetfLang.Gujarati,
            IetfLang.Gujarati.IN.code to IetfLang.Gujarati.IN,
        IetfLang.Gwich_in.code to IetfLang.Gwich_in,
        IetfLang.Haida.code to IetfLang.Haida,
        IetfLang.HaitianHaitianCreole.code to IetfLang.HaitianHaitianCreole,
        IetfLang.Hausa.code to IetfLang.Hausa,
            IetfLang.Hausa.GH.code to IetfLang.Hausa.GH,
            IetfLang.Hausa.NE.code to IetfLang.Hausa.NE,
            IetfLang.Hausa.NG.code to IetfLang.Hausa.NG,
        IetfLang.Hawaiian.code to IetfLang.Hawaiian,
            IetfLang.Hawaiian.US.code to IetfLang.Hawaiian.US,
        IetfLang.Hebrew.code to IetfLang.Hebrew,
            IetfLang.Hebrew.IL.code to IetfLang.Hebrew.IL,
        IetfLang.Herero.code to IetfLang.Herero,
        IetfLang.Hiligaynon.code to IetfLang.Hiligaynon,
        IetfLang.HimachaliLanguagesWesternPahariLanguages.code to IetfLang.HimachaliLanguagesWesternPahariLanguages,
        IetfLang.Hindi.code to IetfLang.Hindi,
            IetfLang.Hindi.IN.code to IetfLang.Hindi.IN,
        IetfLang.Hittite.code to IetfLang.Hittite,
        IetfLang.HmongMong.code to IetfLang.HmongMong,
        IetfLang.HiriMotu.code to IetfLang.HiriMotu,
        IetfLang.Croatian.code to IetfLang.Croatian,
            IetfLang.Croatian.BA.code to IetfLang.Croatian.BA,
            IetfLang.Croatian.HR.code to IetfLang.Croatian.HR,
        IetfLang.UpperSorbian.code to IetfLang.UpperSorbian,
            IetfLang.UpperSorbian.DE.code to IetfLang.UpperSorbian.DE,
        IetfLang.Hungarian.code to IetfLang.Hungarian,
            IetfLang.Hungarian.HU.code to IetfLang.Hungarian.HU,
        IetfLang.Hupa.code to IetfLang.Hupa,
        IetfLang.Iban.code to IetfLang.Iban,
        IetfLang.Igbo.code to IetfLang.Igbo,
            IetfLang.Igbo.NG.code to IetfLang.Igbo.NG,
        IetfLang.Icelandic.code to IetfLang.Icelandic,
            IetfLang.Icelandic.IS.code to IetfLang.Icelandic.IS,
        IetfLang.Ido.code to IetfLang.Ido,
        IetfLang.SichuanYiNuosu.code to IetfLang.SichuanYiNuosu,
            IetfLang.SichuanYiNuosu.CN.code to IetfLang.SichuanYiNuosu.CN,
        IetfLang.IjoLanguages.code to IetfLang.IjoLanguages,
        IetfLang.Inuktitut.code to IetfLang.Inuktitut,
        IetfLang.InterlingueOccidental.code to IetfLang.InterlingueOccidental,
        IetfLang.Iloko.code to IetfLang.Iloko,
        IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation.code to IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation,
        IetfLang.IndicLanguages.code to IetfLang.IndicLanguages,
        IetfLang.Indonesian.code to IetfLang.Indonesian,
            IetfLang.Indonesian.ID.code to IetfLang.Indonesian.ID,
        IetfLang.IndoEuropeanLanguages.code to IetfLang.IndoEuropeanLanguages,
        IetfLang.Ingush.code to IetfLang.Ingush,
        IetfLang.Inupiaq.code to IetfLang.Inupiaq,
        IetfLang.IranianLanguages.code to IetfLang.IranianLanguages,
        IetfLang.IroquoianLanguages.code to IetfLang.IroquoianLanguages,
        IetfLang.Italian.code to IetfLang.Italian,
            IetfLang.Italian.CH.code to IetfLang.Italian.CH,
            IetfLang.Italian.IT.code to IetfLang.Italian.IT,
            IetfLang.Italian.SM.code to IetfLang.Italian.SM,
            IetfLang.Italian.VA.code to IetfLang.Italian.VA,
        IetfLang.Javanese.code to IetfLang.Javanese,
        IetfLang.Lojban.code to IetfLang.Lojban,
        IetfLang.Japanese.code to IetfLang.Japanese,
            IetfLang.Japanese.JP.code to IetfLang.Japanese.JP,
        IetfLang.JudeoPersian.code to IetfLang.JudeoPersian,
        IetfLang.JudeoArabic.code to IetfLang.JudeoArabic,
        IetfLang.KaraKalpak.code to IetfLang.KaraKalpak,
        IetfLang.Kabyle.code to IetfLang.Kabyle,
            IetfLang.Kabyle.DZ.code to IetfLang.Kabyle.DZ,
        IetfLang.KachinJingpho.code to IetfLang.KachinJingpho,
        IetfLang.KalaallisutGreenlandic.code to IetfLang.KalaallisutGreenlandic,
            IetfLang.KalaallisutGreenlandic.GL.code to IetfLang.KalaallisutGreenlandic.GL,
        IetfLang.Kamba.code to IetfLang.Kamba,
            IetfLang.Kamba.KE.code to IetfLang.Kamba.KE,
        IetfLang.Kannada.code to IetfLang.Kannada,
            IetfLang.Kannada.IN.code to IetfLang.Kannada.IN,
        IetfLang.KarenLanguages.code to IetfLang.KarenLanguages,
        IetfLang.Kashmiri.code to IetfLang.Kashmiri,
            IetfLang.Kashmiri.IN.code to IetfLang.Kashmiri.IN,
        IetfLang.Kanuri.code to IetfLang.Kanuri,
        IetfLang.Kawi.code to IetfLang.Kawi,
        IetfLang.Kazakh.code to IetfLang.Kazakh,
            IetfLang.Kazakh.KZ.code to IetfLang.Kazakh.KZ,
        IetfLang.Kabardian.code to IetfLang.Kabardian,
        IetfLang.Khasi.code to IetfLang.Khasi,
        IetfLang.KhoisanLanguages.code to IetfLang.KhoisanLanguages,
        IetfLang.CentralKhmer.code to IetfLang.CentralKhmer,
            IetfLang.CentralKhmer.KH.code to IetfLang.CentralKhmer.KH,
        IetfLang.KhotaneseSakan.code to IetfLang.KhotaneseSakan,
        IetfLang.KikuyuGikuyu.code to IetfLang.KikuyuGikuyu,
            IetfLang.KikuyuGikuyu.KE.code to IetfLang.KikuyuGikuyu.KE,
        IetfLang.Kinyarwanda.code to IetfLang.Kinyarwanda,
            IetfLang.Kinyarwanda.RW.code to IetfLang.Kinyarwanda.RW,
        IetfLang.KirghizKyrgyz.code to IetfLang.KirghizKyrgyz,
            IetfLang.KirghizKyrgyz.KG.code to IetfLang.KirghizKyrgyz.KG,
        IetfLang.Kimbundu.code to IetfLang.Kimbundu,
        IetfLang.Konkani.code to IetfLang.Konkani,
            IetfLang.Konkani.IN.code to IetfLang.Konkani.IN,
        IetfLang.Komi.code to IetfLang.Komi,
        IetfLang.Kongo.code to IetfLang.Kongo,
        IetfLang.Korean.code to IetfLang.Korean,
            IetfLang.Korean.KP.code to IetfLang.Korean.KP,
            IetfLang.Korean.KR.code to IetfLang.Korean.KR,
        IetfLang.Kosraean.code to IetfLang.Kosraean,
        IetfLang.Kpelle.code to IetfLang.Kpelle,
        IetfLang.KarachayBalkar.code to IetfLang.KarachayBalkar,
        IetfLang.Karelian.code to IetfLang.Karelian,
        IetfLang.KruLanguages.code to IetfLang.KruLanguages,
        IetfLang.Kurukh.code to IetfLang.Kurukh,
        IetfLang.KuanyamaKwanyama.code to IetfLang.KuanyamaKwanyama,
        IetfLang.Kumyk.code to IetfLang.Kumyk,
        IetfLang.Kurdish.code to IetfLang.Kurdish,
        IetfLang.Kutenai.code to IetfLang.Kutenai,
        IetfLang.Ladino.code to IetfLang.Ladino,
        IetfLang.Lahnda.code to IetfLang.Lahnda,
        IetfLang.Lamba.code to IetfLang.Lamba,
        IetfLang.Lao.code to IetfLang.Lao,
            IetfLang.Lao.LA.code to IetfLang.Lao.LA,
        IetfLang.Latin.code to IetfLang.Latin,
        IetfLang.Latvian.code to IetfLang.Latvian,
            IetfLang.Latvian.LV.code to IetfLang.Latvian.LV,
        IetfLang.Lezghian.code to IetfLang.Lezghian,
        IetfLang.LimburganLimburgerLimburgish.code to IetfLang.LimburganLimburgerLimburgish,
        IetfLang.Lingala.code to IetfLang.Lingala,
            IetfLang.Lingala.AO.code to IetfLang.Lingala.AO,
            IetfLang.Lingala.CD.code to IetfLang.Lingala.CD,
            IetfLang.Lingala.CF.code to IetfLang.Lingala.CF,
            IetfLang.Lingala.CG.code to IetfLang.Lingala.CG,
        IetfLang.Lithuanian.code to IetfLang.Lithuanian,
            IetfLang.Lithuanian.LT.code to IetfLang.Lithuanian.LT,
        IetfLang.Mongo.code to IetfLang.Mongo,
        IetfLang.Lozi.code to IetfLang.Lozi,
        IetfLang.LuxembourgishLetzeburgesch.code to IetfLang.LuxembourgishLetzeburgesch,
            IetfLang.LuxembourgishLetzeburgesch.LU.code to IetfLang.LuxembourgishLetzeburgesch.LU,
        IetfLang.LubaLulua.code to IetfLang.LubaLulua,
        IetfLang.LubaKatanga.code to IetfLang.LubaKatanga,
            IetfLang.LubaKatanga.CD.code to IetfLang.LubaKatanga.CD,
        IetfLang.Ganda.code to IetfLang.Ganda,
            IetfLang.Ganda.UG.code to IetfLang.Ganda.UG,
        IetfLang.Luiseno.code to IetfLang.Luiseno,
        IetfLang.Lunda.code to IetfLang.Lunda,
        IetfLang.LuoKenyaAndTanzania.code to IetfLang.LuoKenyaAndTanzania,
            IetfLang.LuoKenyaAndTanzania.KE.code to IetfLang.LuoKenyaAndTanzania.KE,
        IetfLang.Lushai.code to IetfLang.Lushai,
        IetfLang.Macedonian.code to IetfLang.Macedonian,
            IetfLang.Macedonian.MK.code to IetfLang.Macedonian.MK,
        IetfLang.Madurese.code to IetfLang.Madurese,
        IetfLang.Magahi.code to IetfLang.Magahi,
        IetfLang.Marshallese.code to IetfLang.Marshallese,
        IetfLang.Maithili.code to IetfLang.Maithili,
        IetfLang.Makasar.code to IetfLang.Makasar,
        IetfLang.Malayalam.code to IetfLang.Malayalam,
            IetfLang.Malayalam.IN.code to IetfLang.Malayalam.IN,
        IetfLang.Mandingo.code to IetfLang.Mandingo,
        IetfLang.Maori.code to IetfLang.Maori,
        IetfLang.AustronesianLanguages.code to IetfLang.AustronesianLanguages,
        IetfLang.Marathi.code to IetfLang.Marathi,
            IetfLang.Marathi.IN.code to IetfLang.Marathi.IN,
        IetfLang.Masai.code to IetfLang.Masai,
            IetfLang.Masai.KE.code to IetfLang.Masai.KE,
            IetfLang.Masai.TZ.code to IetfLang.Masai.TZ,
        IetfLang.Malay.code to IetfLang.Malay,
            IetfLang.Malay.BN.code to IetfLang.Malay.BN,
            IetfLang.Malay.MY.code to IetfLang.Malay.MY,
            IetfLang.Malay.SG.code to IetfLang.Malay.SG,
        IetfLang.Moksha.code to IetfLang.Moksha,
        IetfLang.Mandar.code to IetfLang.Mandar,
        IetfLang.Mende.code to IetfLang.Mende,
        IetfLang.IrishMiddle9001200.code to IetfLang.IrishMiddle9001200,
        IetfLang.Mi_kmaqMicmac.code to IetfLang.Mi_kmaqMicmac,
        IetfLang.Minangkabau.code to IetfLang.Minangkabau,
        IetfLang.UncodedLanguages.code to IetfLang.UncodedLanguages,
        IetfLang.MonKhmerLanguages.code to IetfLang.MonKhmerLanguages,
        IetfLang.Malagasy.code to IetfLang.Malagasy,
            IetfLang.Malagasy.MG.code to IetfLang.Malagasy.MG,
        IetfLang.Maltese.code to IetfLang.Maltese,
            IetfLang.Maltese.MT.code to IetfLang.Maltese.MT,
        IetfLang.Manchu.code to IetfLang.Manchu,
        IetfLang.Manipuri.code to IetfLang.Manipuri,
        IetfLang.ManoboLanguages.code to IetfLang.ManoboLanguages,
        IetfLang.Mohawk.code to IetfLang.Mohawk,
        IetfLang.Mongolian.code to IetfLang.Mongolian,
            IetfLang.Mongolian.MN.code to IetfLang.Mongolian.MN,
        IetfLang.Mossi.code to IetfLang.Mossi,
        IetfLang.MultipleLanguages.code to IetfLang.MultipleLanguages,
        IetfLang.MundaLanguages.code to IetfLang.MundaLanguages,
        IetfLang.Creek.code to IetfLang.Creek,
        IetfLang.Mirandese.code to IetfLang.Mirandese,
        IetfLang.Marwari.code to IetfLang.Marwari,
        IetfLang.MayanLanguages.code to IetfLang.MayanLanguages,
        IetfLang.Erzya.code to IetfLang.Erzya,
        IetfLang.NahuatlLanguages.code to IetfLang.NahuatlLanguages,
        IetfLang.NorthAmericanIndianLanguages.code to IetfLang.NorthAmericanIndianLanguages,
        IetfLang.Neapolitan.code to IetfLang.Neapolitan,
        IetfLang.Nauru.code to IetfLang.Nauru,
        IetfLang.NavajoNavaho.code to IetfLang.NavajoNavaho,
        IetfLang.NdebeleSouthSouthNdebele.code to IetfLang.NdebeleSouthSouthNdebele,
        IetfLang.NdebeleNorthNorthNdebele.code to IetfLang.NdebeleNorthNorthNdebele,
            IetfLang.NdebeleNorthNorthNdebele.ZW.code to IetfLang.NdebeleNorthNorthNdebele.ZW,
        IetfLang.Ndonga.code to IetfLang.Ndonga,
        IetfLang.LowGermanLowSaxonGermanLowSaxonLow.code to IetfLang.LowGermanLowSaxonGermanLowSaxonLow,
            IetfLang.LowGermanLowSaxonGermanLowSaxonLow.DE.code to IetfLang.LowGermanLowSaxonGermanLowSaxonLow.DE,
            IetfLang.LowGermanLowSaxonGermanLowSaxonLow.NL.code to IetfLang.LowGermanLowSaxonGermanLowSaxonLow.NL,
        IetfLang.Nepali.code to IetfLang.Nepali,
            IetfLang.Nepali.IN.code to IetfLang.Nepali.IN,
            IetfLang.Nepali.NP.code to IetfLang.Nepali.NP,
        IetfLang.NepalBhasaNewari.code to IetfLang.NepalBhasaNewari,
        IetfLang.Nias.code to IetfLang.Nias,
        IetfLang.NigerKordofanianLanguages.code to IetfLang.NigerKordofanianLanguages,
        IetfLang.Niuean.code to IetfLang.Niuean,
        IetfLang.NorwegianNynorskNynorskNorwegian.code to IetfLang.NorwegianNynorskNynorskNorwegian,
            IetfLang.NorwegianNynorskNynorskNorwegian.NO.code to IetfLang.NorwegianNynorskNynorskNorwegian.NO,
        IetfLang.BokmalNorwegianNorwegianBokmal.code to IetfLang.BokmalNorwegianNorwegianBokmal,
            IetfLang.BokmalNorwegianNorwegianBokmal.NO.code to IetfLang.BokmalNorwegianNorwegianBokmal.NO,
            IetfLang.BokmalNorwegianNorwegianBokmal.SJ.code to IetfLang.BokmalNorwegianNorwegianBokmal.SJ,
        IetfLang.Nogai.code to IetfLang.Nogai,
        IetfLang.NorseOld.code to IetfLang.NorseOld,
        IetfLang.Norwegian.code to IetfLang.Norwegian,
        IetfLang.N_Ko.code to IetfLang.N_Ko,
        IetfLang.PediSepediNorthernSotho.code to IetfLang.PediSepediNorthernSotho,
        IetfLang.NubianLanguages.code to IetfLang.NubianLanguages,
        IetfLang.ClassicalNewariOldNewariClassicalNepalBhasa.code to IetfLang.ClassicalNewariOldNewariClassicalNepalBhasa,
        IetfLang.ChichewaChewaNyanja.code to IetfLang.ChichewaChewaNyanja,
        IetfLang.Nyamwezi.code to IetfLang.Nyamwezi,
        IetfLang.Nyankole.code to IetfLang.Nyankole,
            IetfLang.Nyankole.UG.code to IetfLang.Nyankole.UG,
        IetfLang.Nyoro.code to IetfLang.Nyoro,
        IetfLang.Nzima.code to IetfLang.Nzima,
        IetfLang.OccitanPost1500Provencal.code to IetfLang.OccitanPost1500Provencal,
        IetfLang.Ojibwa.code to IetfLang.Ojibwa,
        IetfLang.Oriya.code to IetfLang.Oriya,
            IetfLang.Oriya.IN.code to IetfLang.Oriya.IN,
        IetfLang.Oromo.code to IetfLang.Oromo,
            IetfLang.Oromo.ET.code to IetfLang.Oromo.ET,
            IetfLang.Oromo.KE.code to IetfLang.Oromo.KE,
        IetfLang.Osage.code to IetfLang.Osage,
        IetfLang.OssetianOssetic.code to IetfLang.OssetianOssetic,
            IetfLang.OssetianOssetic.GE.code to IetfLang.OssetianOssetic.GE,
            IetfLang.OssetianOssetic.RU.code to IetfLang.OssetianOssetic.RU,
        IetfLang.TurkishOttoman15001928.code to IetfLang.TurkishOttoman15001928,
        IetfLang.OtomianLanguages.code to IetfLang.OtomianLanguages,
        IetfLang.PapuanLanguages.code to IetfLang.PapuanLanguages,
        IetfLang.Pangasinan.code to IetfLang.Pangasinan,
        IetfLang.Pahlavi.code to IetfLang.Pahlavi,
        IetfLang.PampangaKapampangan.code to IetfLang.PampangaKapampangan,
        IetfLang.PanjabiPunjabi.code to IetfLang.PanjabiPunjabi,
            IetfLang.PanjabiPunjabi.Arab.code to IetfLang.PanjabiPunjabi.Arab,
                IetfLang.PanjabiPunjabi.Arab.PK.code to IetfLang.PanjabiPunjabi.Arab.PK,
            IetfLang.PanjabiPunjabi.Guru.code to IetfLang.PanjabiPunjabi.Guru,
                IetfLang.PanjabiPunjabi.Guru.IN.code to IetfLang.PanjabiPunjabi.Guru.IN,
        IetfLang.Papiamento.code to IetfLang.Papiamento,
        IetfLang.Palauan.code to IetfLang.Palauan,
        IetfLang.PersianOldCa_600400B_C_.code to IetfLang.PersianOldCa_600400B_C_,
        IetfLang.Persian.code to IetfLang.Persian,
            IetfLang.Persian.AF.code to IetfLang.Persian.AF,
            IetfLang.Persian.IR.code to IetfLang.Persian.IR,
        IetfLang.PhilippineLanguages.code to IetfLang.PhilippineLanguages,
        IetfLang.Phoenician.code to IetfLang.Phoenician,
        IetfLang.Pali.code to IetfLang.Pali,
        IetfLang.Polish.code to IetfLang.Polish,
            IetfLang.Polish.PL.code to IetfLang.Polish.PL,
        IetfLang.Pohnpeian.code to IetfLang.Pohnpeian,
        IetfLang.Portuguese.code to IetfLang.Portuguese,
            IetfLang.Portuguese.AO.code to IetfLang.Portuguese.AO,
            IetfLang.Portuguese.BR.code to IetfLang.Portuguese.BR,
            IetfLang.Portuguese.CH.code to IetfLang.Portuguese.CH,
            IetfLang.Portuguese.CV.code to IetfLang.Portuguese.CV,
            IetfLang.Portuguese.GQ.code to IetfLang.Portuguese.GQ,
            IetfLang.Portuguese.GW.code to IetfLang.Portuguese.GW,
            IetfLang.Portuguese.LU.code to IetfLang.Portuguese.LU,
            IetfLang.Portuguese.MO.code to IetfLang.Portuguese.MO,
            IetfLang.Portuguese.MZ.code to IetfLang.Portuguese.MZ,
            IetfLang.Portuguese.PT.code to IetfLang.Portuguese.PT,
            IetfLang.Portuguese.ST.code to IetfLang.Portuguese.ST,
            IetfLang.Portuguese.TL.code to IetfLang.Portuguese.TL,
        IetfLang.PrakritLanguages.code to IetfLang.PrakritLanguages,
        IetfLang.ProvencalOldTo1500.code to IetfLang.ProvencalOldTo1500,
        IetfLang.PushtoPashto.code to IetfLang.PushtoPashto,
            IetfLang.PushtoPashto.AF.code to IetfLang.PushtoPashto.AF,
        IetfLang.ReservedForLocalUse.code to IetfLang.ReservedForLocalUse,
        IetfLang.Quechua.code to IetfLang.Quechua,
            IetfLang.Quechua.BO.code to IetfLang.Quechua.BO,
            IetfLang.Quechua.EC.code to IetfLang.Quechua.EC,
            IetfLang.Quechua.PE.code to IetfLang.Quechua.PE,
        IetfLang.Rajasthani.code to IetfLang.Rajasthani,
        IetfLang.Rapanui.code to IetfLang.Rapanui,
        IetfLang.RarotonganCookIslandsMaori.code to IetfLang.RarotonganCookIslandsMaori,
        IetfLang.RomanceLanguages.code to IetfLang.RomanceLanguages,
        IetfLang.Romansh.code to IetfLang.Romansh,
            IetfLang.Romansh.CH.code to IetfLang.Romansh.CH,
        IetfLang.Romany.code to IetfLang.Romany,
        IetfLang.RomanianMoldavianMoldovan.code to IetfLang.RomanianMoldavianMoldovan,
            IetfLang.RomanianMoldavianMoldovan.MD.code to IetfLang.RomanianMoldavianMoldovan.MD,
            IetfLang.RomanianMoldavianMoldovan.RO.code to IetfLang.RomanianMoldavianMoldovan.RO,
        IetfLang.Rundi.code to IetfLang.Rundi,
            IetfLang.Rundi.BI.code to IetfLang.Rundi.BI,
        IetfLang.AromanianArumanianMacedoRomanian.code to IetfLang.AromanianArumanianMacedoRomanian,
        IetfLang.Russian.code to IetfLang.Russian,
            IetfLang.Russian.BY.code to IetfLang.Russian.BY,
            IetfLang.Russian.KG.code to IetfLang.Russian.KG,
            IetfLang.Russian.KZ.code to IetfLang.Russian.KZ,
            IetfLang.Russian.MD.code to IetfLang.Russian.MD,
            IetfLang.Russian.RU.code to IetfLang.Russian.RU,
            IetfLang.Russian.UA.code to IetfLang.Russian.UA,
        IetfLang.Sandawe.code to IetfLang.Sandawe,
        IetfLang.Sango.code to IetfLang.Sango,
            IetfLang.Sango.CF.code to IetfLang.Sango.CF,
        IetfLang.Yakut.code to IetfLang.Yakut,
            IetfLang.Yakut.RU.code to IetfLang.Yakut.RU,
        IetfLang.SouthAmericanIndianOther.code to IetfLang.SouthAmericanIndianOther,
        IetfLang.SalishanLanguages.code to IetfLang.SalishanLanguages,
        IetfLang.SamaritanAramaic.code to IetfLang.SamaritanAramaic,
        IetfLang.Sanskrit.code to IetfLang.Sanskrit,
        IetfLang.Sasak.code to IetfLang.Sasak,
        IetfLang.Santali.code to IetfLang.Santali,
        IetfLang.Sicilian.code to IetfLang.Sicilian,
        IetfLang.Scots.code to IetfLang.Scots,
        IetfLang.Selkup.code to IetfLang.Selkup,
        IetfLang.SemiticLanguages.code to IetfLang.SemiticLanguages,
        IetfLang.IrishOldTo900.code to IetfLang.IrishOldTo900,
        IetfLang.SignLanguages.code to IetfLang.SignLanguages,
        IetfLang.Shan.code to IetfLang.Shan,
        IetfLang.Sidamo.code to IetfLang.Sidamo,
        IetfLang.SinhalaSinhalese.code to IetfLang.SinhalaSinhalese,
            IetfLang.SinhalaSinhalese.LK.code to IetfLang.SinhalaSinhalese.LK,
        IetfLang.SiouanLanguages.code to IetfLang.SiouanLanguages,
        IetfLang.SinoTibetanLanguages.code to IetfLang.SinoTibetanLanguages,
        IetfLang.SlavicLanguages.code to IetfLang.SlavicLanguages,
        IetfLang.Slovak.code to IetfLang.Slovak,
            IetfLang.Slovak.SK.code to IetfLang.Slovak.SK,
        IetfLang.Slovenian.code to IetfLang.Slovenian,
            IetfLang.Slovenian.SI.code to IetfLang.Slovenian.SI,
        IetfLang.SouthernSami.code to IetfLang.SouthernSami,
        IetfLang.NorthernSami.code to IetfLang.NorthernSami,
            IetfLang.NorthernSami.FI.code to IetfLang.NorthernSami.FI,
            IetfLang.NorthernSami.NO.code to IetfLang.NorthernSami.NO,
            IetfLang.NorthernSami.SE.code to IetfLang.NorthernSami.SE,
        IetfLang.SamiLanguages.code to IetfLang.SamiLanguages,
        IetfLang.LuleSami.code to IetfLang.LuleSami,
        IetfLang.InariSami.code to IetfLang.InariSami,
            IetfLang.InariSami.FI.code to IetfLang.InariSami.FI,
        IetfLang.Samoan.code to IetfLang.Samoan,
        IetfLang.SkoltSami.code to IetfLang.SkoltSami,
        IetfLang.Shona.code to IetfLang.Shona,
            IetfLang.Shona.ZW.code to IetfLang.Shona.ZW,
        IetfLang.Sindhi.code to IetfLang.Sindhi,
        IetfLang.Soninke.code to IetfLang.Soninke,
        IetfLang.Sogdian.code to IetfLang.Sogdian,
        IetfLang.Somali.code to IetfLang.Somali,
            IetfLang.Somali.DJ.code to IetfLang.Somali.DJ,
            IetfLang.Somali.ET.code to IetfLang.Somali.ET,
            IetfLang.Somali.KE.code to IetfLang.Somali.KE,
            IetfLang.Somali.SO.code to IetfLang.Somali.SO,
        IetfLang.SonghaiLanguages.code to IetfLang.SonghaiLanguages,
        IetfLang.SothoSouthern.code to IetfLang.SothoSouthern,
        IetfLang.SpanishCastilian.code to IetfLang.SpanishCastilian,
            IetfLang.SpanishCastilian.L419.code to IetfLang.SpanishCastilian.L419,
            IetfLang.SpanishCastilian.AR.code to IetfLang.SpanishCastilian.AR,
            IetfLang.SpanishCastilian.BO.code to IetfLang.SpanishCastilian.BO,
            IetfLang.SpanishCastilian.BR.code to IetfLang.SpanishCastilian.BR,
            IetfLang.SpanishCastilian.BZ.code to IetfLang.SpanishCastilian.BZ,
            IetfLang.SpanishCastilian.CL.code to IetfLang.SpanishCastilian.CL,
            IetfLang.SpanishCastilian.CO.code to IetfLang.SpanishCastilian.CO,
            IetfLang.SpanishCastilian.CR.code to IetfLang.SpanishCastilian.CR,
            IetfLang.SpanishCastilian.CU.code to IetfLang.SpanishCastilian.CU,
            IetfLang.SpanishCastilian.DO.code to IetfLang.SpanishCastilian.DO,
            IetfLang.SpanishCastilian.EA.code to IetfLang.SpanishCastilian.EA,
            IetfLang.SpanishCastilian.EC.code to IetfLang.SpanishCastilian.EC,
            IetfLang.SpanishCastilian.ES.code to IetfLang.SpanishCastilian.ES,
            IetfLang.SpanishCastilian.GQ.code to IetfLang.SpanishCastilian.GQ,
            IetfLang.SpanishCastilian.GT.code to IetfLang.SpanishCastilian.GT,
            IetfLang.SpanishCastilian.HN.code to IetfLang.SpanishCastilian.HN,
            IetfLang.SpanishCastilian.IC.code to IetfLang.SpanishCastilian.IC,
            IetfLang.SpanishCastilian.MX.code to IetfLang.SpanishCastilian.MX,
            IetfLang.SpanishCastilian.NI.code to IetfLang.SpanishCastilian.NI,
            IetfLang.SpanishCastilian.PA.code to IetfLang.SpanishCastilian.PA,
            IetfLang.SpanishCastilian.PE.code to IetfLang.SpanishCastilian.PE,
            IetfLang.SpanishCastilian.PH.code to IetfLang.SpanishCastilian.PH,
            IetfLang.SpanishCastilian.PR.code to IetfLang.SpanishCastilian.PR,
            IetfLang.SpanishCastilian.PY.code to IetfLang.SpanishCastilian.PY,
            IetfLang.SpanishCastilian.SV.code to IetfLang.SpanishCastilian.SV,
            IetfLang.SpanishCastilian.US.code to IetfLang.SpanishCastilian.US,
            IetfLang.SpanishCastilian.UY.code to IetfLang.SpanishCastilian.UY,
            IetfLang.SpanishCastilian.VE.code to IetfLang.SpanishCastilian.VE,
        IetfLang.Sardinian.code to IetfLang.Sardinian,
        IetfLang.SrananTongo.code to IetfLang.SrananTongo,
        IetfLang.Serbian.code to IetfLang.Serbian,
            IetfLang.Serbian.Cyrl.code to IetfLang.Serbian.Cyrl,
                IetfLang.Serbian.Cyrl.BA.code to IetfLang.Serbian.Cyrl.BA,
                IetfLang.Serbian.Cyrl.ME.code to IetfLang.Serbian.Cyrl.ME,
                IetfLang.Serbian.Cyrl.RS.code to IetfLang.Serbian.Cyrl.RS,
                IetfLang.Serbian.Cyrl.XK.code to IetfLang.Serbian.Cyrl.XK,
            IetfLang.Serbian.Latn.code to IetfLang.Serbian.Latn,
                IetfLang.Serbian.Latn.BA.code to IetfLang.Serbian.Latn.BA,
                IetfLang.Serbian.Latn.ME.code to IetfLang.Serbian.Latn.ME,
                IetfLang.Serbian.Latn.RS.code to IetfLang.Serbian.Latn.RS,
                IetfLang.Serbian.Latn.XK.code to IetfLang.Serbian.Latn.XK,
        IetfLang.Serer.code to IetfLang.Serer,
        IetfLang.NiloSaharanLanguages.code to IetfLang.NiloSaharanLanguages,
        IetfLang.Swati.code to IetfLang.Swati,
        IetfLang.Sukuma.code to IetfLang.Sukuma,
        IetfLang.Sundanese.code to IetfLang.Sundanese,
        IetfLang.Susu.code to IetfLang.Susu,
        IetfLang.Sumerian.code to IetfLang.Sumerian,
        IetfLang.Swahili.code to IetfLang.Swahili,
            IetfLang.Swahili.CD.code to IetfLang.Swahili.CD,
            IetfLang.Swahili.KE.code to IetfLang.Swahili.KE,
            IetfLang.Swahili.TZ.code to IetfLang.Swahili.TZ,
            IetfLang.Swahili.UG.code to IetfLang.Swahili.UG,
        IetfLang.Swedish.code to IetfLang.Swedish,
            IetfLang.Swedish.AX.code to IetfLang.Swedish.AX,
            IetfLang.Swedish.FI.code to IetfLang.Swedish.FI,
            IetfLang.Swedish.SE.code to IetfLang.Swedish.SE,
        IetfLang.ClassicalSyriac.code to IetfLang.ClassicalSyriac,
        IetfLang.Syriac.code to IetfLang.Syriac,
        IetfLang.Tahitian.code to IetfLang.Tahitian,
        IetfLang.TaiLanguages.code to IetfLang.TaiLanguages,
        IetfLang.Tamil.code to IetfLang.Tamil,
            IetfLang.Tamil.IN.code to IetfLang.Tamil.IN,
            IetfLang.Tamil.LK.code to IetfLang.Tamil.LK,
            IetfLang.Tamil.MY.code to IetfLang.Tamil.MY,
            IetfLang.Tamil.SG.code to IetfLang.Tamil.SG,
        IetfLang.Tatar.code to IetfLang.Tatar,
        IetfLang.Telugu.code to IetfLang.Telugu,
            IetfLang.Telugu.IN.code to IetfLang.Telugu.IN,
        IetfLang.Timne.code to IetfLang.Timne,
        IetfLang.Tereno.code to IetfLang.Tereno,
        IetfLang.Tetum.code to IetfLang.Tetum,
        IetfLang.Tajik.code to IetfLang.Tajik,
        IetfLang.Tagalog.code to IetfLang.Tagalog,
        IetfLang.Thai.code to IetfLang.Thai,
            IetfLang.Thai.TH.code to IetfLang.Thai.TH,
        IetfLang.Tibetan.code to IetfLang.Tibetan,
            IetfLang.Tibetan.CN.code to IetfLang.Tibetan.CN,
            IetfLang.Tibetan.IN.code to IetfLang.Tibetan.IN,
        IetfLang.Tigre.code to IetfLang.Tigre,
        IetfLang.Tigrinya.code to IetfLang.Tigrinya,
            IetfLang.Tigrinya.ER.code to IetfLang.Tigrinya.ER,
            IetfLang.Tigrinya.ET.code to IetfLang.Tigrinya.ET,
        IetfLang.Tiv.code to IetfLang.Tiv,
        IetfLang.Tokelau.code to IetfLang.Tokelau,
        IetfLang.KlingonTlhInganHol.code to IetfLang.KlingonTlhInganHol,
        IetfLang.Tlingit.code to IetfLang.Tlingit,
        IetfLang.Tamashek.code to IetfLang.Tamashek,
        IetfLang.TongaNyasa.code to IetfLang.TongaNyasa,
        IetfLang.TongaTongaIslands.code to IetfLang.TongaTongaIslands,
            IetfLang.TongaTongaIslands.TO.code to IetfLang.TongaTongaIslands.TO,
        IetfLang.TokPisin.code to IetfLang.TokPisin,
        IetfLang.Tsimshian.code to IetfLang.Tsimshian,
        IetfLang.Tswana.code to IetfLang.Tswana,
        IetfLang.Tsonga.code to IetfLang.Tsonga,
        IetfLang.Turkmen.code to IetfLang.Turkmen,
            IetfLang.Turkmen.TM.code to IetfLang.Turkmen.TM,
        IetfLang.Tumbuka.code to IetfLang.Tumbuka,
        IetfLang.TupiLanguages.code to IetfLang.TupiLanguages,
        IetfLang.Turkish.code to IetfLang.Turkish,
            IetfLang.Turkish.CY.code to IetfLang.Turkish.CY,
            IetfLang.Turkish.TR.code to IetfLang.Turkish.TR,
        IetfLang.AltaicLanguages.code to IetfLang.AltaicLanguages,
        IetfLang.Tuvalu.code to IetfLang.Tuvalu,
        IetfLang.Twi.code to IetfLang.Twi,
        IetfLang.Tuvinian.code to IetfLang.Tuvinian,
        IetfLang.Udmurt.code to IetfLang.Udmurt,
        IetfLang.Ugaritic.code to IetfLang.Ugaritic,
        IetfLang.UighurUyghur.code to IetfLang.UighurUyghur,
            IetfLang.UighurUyghur.CN.code to IetfLang.UighurUyghur.CN,
        IetfLang.Ukrainian.code to IetfLang.Ukrainian,
            IetfLang.Ukrainian.UA.code to IetfLang.Ukrainian.UA,
        IetfLang.Umbundu.code to IetfLang.Umbundu,
        IetfLang.Undetermined.code to IetfLang.Undetermined,
        IetfLang.Urdu.code to IetfLang.Urdu,
            IetfLang.Urdu.IN.code to IetfLang.Urdu.IN,
            IetfLang.Urdu.PK.code to IetfLang.Urdu.PK,
        IetfLang.Uzbek.code to IetfLang.Uzbek,
            IetfLang.Uzbek.Arab.code to IetfLang.Uzbek.Arab,
                IetfLang.Uzbek.Arab.AF.code to IetfLang.Uzbek.Arab.AF,
            IetfLang.Uzbek.Cyrl.code to IetfLang.Uzbek.Cyrl,
                IetfLang.Uzbek.Cyrl.UZ.code to IetfLang.Uzbek.Cyrl.UZ,
            IetfLang.Uzbek.Latn.code to IetfLang.Uzbek.Latn,
                IetfLang.Uzbek.Latn.UZ.code to IetfLang.Uzbek.Latn.UZ,
        IetfLang.Vai.code to IetfLang.Vai,
            IetfLang.Vai.Latn.code to IetfLang.Vai.Latn,
                IetfLang.Vai.Latn.LR.code to IetfLang.Vai.Latn.LR,
            IetfLang.Vai.Vaii.code to IetfLang.Vai.Vaii,
                IetfLang.Vai.Vaii.LR.code to IetfLang.Vai.Vaii.LR,
        IetfLang.Venda.code to IetfLang.Venda,
        IetfLang.Vietnamese.code to IetfLang.Vietnamese,
            IetfLang.Vietnamese.VN.code to IetfLang.Vietnamese.VN,
        IetfLang.Volapuk.code to IetfLang.Volapuk,
            IetfLang.Volapuk.L001.code to IetfLang.Volapuk.L001,
        IetfLang.Votic.code to IetfLang.Votic,
        IetfLang.WakashanLanguages.code to IetfLang.WakashanLanguages,
        IetfLang.Walamo.code to IetfLang.Walamo,
        IetfLang.Waray.code to IetfLang.Waray,
        IetfLang.Washo.code to IetfLang.Washo,
        IetfLang.Welsh.code to IetfLang.Welsh,
            IetfLang.Welsh.GB.code to IetfLang.Welsh.GB,
        IetfLang.SorbianLanguages.code to IetfLang.SorbianLanguages,
        IetfLang.Walloon.code to IetfLang.Walloon,
        IetfLang.Wolof.code to IetfLang.Wolof,
        IetfLang.KalmykOirat.code to IetfLang.KalmykOirat,
        IetfLang.Xhosa.code to IetfLang.Xhosa,
        IetfLang.Yao.code to IetfLang.Yao,
        IetfLang.Yapese.code to IetfLang.Yapese,
        IetfLang.Yiddish.code to IetfLang.Yiddish,
            IetfLang.Yiddish.L001.code to IetfLang.Yiddish.L001,
        IetfLang.Yoruba.code to IetfLang.Yoruba,
            IetfLang.Yoruba.BJ.code to IetfLang.Yoruba.BJ,
            IetfLang.Yoruba.NG.code to IetfLang.Yoruba.NG,
        IetfLang.YupikLanguages.code to IetfLang.YupikLanguages,
        IetfLang.Zapotec.code to IetfLang.Zapotec,
        IetfLang.BlissymbolsBlissymbolicsBliss.code to IetfLang.BlissymbolsBlissymbolicsBliss,
        IetfLang.Zenaga.code to IetfLang.Zenaga,
        IetfLang.StandardMoroccanTamazight.code to IetfLang.StandardMoroccanTamazight,
            IetfLang.StandardMoroccanTamazight.MA.code to IetfLang.StandardMoroccanTamazight.MA,
        IetfLang.ZhuangChuang.code to IetfLang.ZhuangChuang,
        IetfLang.ZandeLanguages.code to IetfLang.ZandeLanguages,
        IetfLang.Zulu.code to IetfLang.Zulu,
            IetfLang.Zulu.ZA.code to IetfLang.Zulu.ZA,
        IetfLang.Zuni.code to IetfLang.Zuni,
        IetfLang.NoLinguisticContentNotApplicable.code to IetfLang.NoLinguisticContentNotApplicable,
        IetfLang.ZazaDimiliDimliKirdkiKirmanjkiZazaki.code to IetfLang.ZazaDimiliDimliKirdkiKirmanjkiZazaki
    )
}
val knownLanguageCodesMapByLowerCasedKeys: Map<String, IetfLang> by lazy {
    mapOf(
        IetfLang.Afar.code.lowercase() to IetfLang.Afar,
        IetfLang.Abkhazian.code.lowercase() to IetfLang.Abkhazian,
        IetfLang.Achinese.code.lowercase() to IetfLang.Achinese,
        IetfLang.Acoli.code.lowercase() to IetfLang.Acoli,
        IetfLang.Adangme.code.lowercase() to IetfLang.Adangme,
        IetfLang.AdygheAdygei.code.lowercase() to IetfLang.AdygheAdygei,
        IetfLang.AfroAsiaticLanguages.code.lowercase() to IetfLang.AfroAsiaticLanguages,
        IetfLang.Afrihili.code.lowercase() to IetfLang.Afrihili,
        IetfLang.Afrikaans.code.lowercase() to IetfLang.Afrikaans,
            IetfLang.Afrikaans.NA.code.lowercase() to IetfLang.Afrikaans.NA,
            IetfLang.Afrikaans.ZA.code.lowercase() to IetfLang.Afrikaans.ZA,
        IetfLang.Ainu.code.lowercase() to IetfLang.Ainu,
        IetfLang.Akan.code.lowercase() to IetfLang.Akan,
            IetfLang.Akan.GH.code.lowercase() to IetfLang.Akan.GH,
        IetfLang.Akkadian.code.lowercase() to IetfLang.Akkadian,
        IetfLang.Albanian.code.lowercase() to IetfLang.Albanian,
            IetfLang.Albanian.AL.code.lowercase() to IetfLang.Albanian.AL,
            IetfLang.Albanian.MK.code.lowercase() to IetfLang.Albanian.MK,
            IetfLang.Albanian.XK.code.lowercase() to IetfLang.Albanian.XK,
        IetfLang.Aleut.code.lowercase() to IetfLang.Aleut,
        IetfLang.AlgonquianLanguages.code.lowercase() to IetfLang.AlgonquianLanguages,
        IetfLang.SouthernAltai.code.lowercase() to IetfLang.SouthernAltai,
        IetfLang.Amharic.code.lowercase() to IetfLang.Amharic,
            IetfLang.Amharic.ET.code.lowercase() to IetfLang.Amharic.ET,
        IetfLang.EnglishOldCa_4501100.code.lowercase() to IetfLang.EnglishOldCa_4501100,
        IetfLang.Angika.code.lowercase() to IetfLang.Angika,
        IetfLang.ApacheLanguages.code.lowercase() to IetfLang.ApacheLanguages,
        IetfLang.Arabic.code.lowercase() to IetfLang.Arabic,
            IetfLang.Arabic.L001.code.lowercase() to IetfLang.Arabic.L001,
            IetfLang.Arabic.AE.code.lowercase() to IetfLang.Arabic.AE,
            IetfLang.Arabic.BH.code.lowercase() to IetfLang.Arabic.BH,
            IetfLang.Arabic.DJ.code.lowercase() to IetfLang.Arabic.DJ,
            IetfLang.Arabic.DZ.code.lowercase() to IetfLang.Arabic.DZ,
            IetfLang.Arabic.EG.code.lowercase() to IetfLang.Arabic.EG,
            IetfLang.Arabic.EH.code.lowercase() to IetfLang.Arabic.EH,
            IetfLang.Arabic.ER.code.lowercase() to IetfLang.Arabic.ER,
            IetfLang.Arabic.IL.code.lowercase() to IetfLang.Arabic.IL,
            IetfLang.Arabic.IQ.code.lowercase() to IetfLang.Arabic.IQ,
            IetfLang.Arabic.JO.code.lowercase() to IetfLang.Arabic.JO,
            IetfLang.Arabic.KM.code.lowercase() to IetfLang.Arabic.KM,
            IetfLang.Arabic.KW.code.lowercase() to IetfLang.Arabic.KW,
            IetfLang.Arabic.LB.code.lowercase() to IetfLang.Arabic.LB,
            IetfLang.Arabic.LY.code.lowercase() to IetfLang.Arabic.LY,
            IetfLang.Arabic.MA.code.lowercase() to IetfLang.Arabic.MA,
            IetfLang.Arabic.MR.code.lowercase() to IetfLang.Arabic.MR,
            IetfLang.Arabic.OM.code.lowercase() to IetfLang.Arabic.OM,
            IetfLang.Arabic.PS.code.lowercase() to IetfLang.Arabic.PS,
            IetfLang.Arabic.QA.code.lowercase() to IetfLang.Arabic.QA,
            IetfLang.Arabic.SA.code.lowercase() to IetfLang.Arabic.SA,
            IetfLang.Arabic.SD.code.lowercase() to IetfLang.Arabic.SD,
            IetfLang.Arabic.SO.code.lowercase() to IetfLang.Arabic.SO,
            IetfLang.Arabic.SS.code.lowercase() to IetfLang.Arabic.SS,
            IetfLang.Arabic.SY.code.lowercase() to IetfLang.Arabic.SY,
            IetfLang.Arabic.TD.code.lowercase() to IetfLang.Arabic.TD,
            IetfLang.Arabic.TN.code.lowercase() to IetfLang.Arabic.TN,
            IetfLang.Arabic.YE.code.lowercase() to IetfLang.Arabic.YE,
        IetfLang.OfficialAramaic700300BCEImperialAramaic700300BCE.code.lowercase() to IetfLang.OfficialAramaic700300BCEImperialAramaic700300BCE,
        IetfLang.Aragonese.code.lowercase() to IetfLang.Aragonese,
        IetfLang.Armenian.code.lowercase() to IetfLang.Armenian,
            IetfLang.Armenian.AM.code.lowercase() to IetfLang.Armenian.AM,
        IetfLang.MapudungunMapuche.code.lowercase() to IetfLang.MapudungunMapuche,
        IetfLang.Arapaho.code.lowercase() to IetfLang.Arapaho,
        IetfLang.ArtificialLanguages.code.lowercase() to IetfLang.ArtificialLanguages,
        IetfLang.Arawak.code.lowercase() to IetfLang.Arawak,
        IetfLang.Assamese.code.lowercase() to IetfLang.Assamese,
            IetfLang.Assamese.IN.code.lowercase() to IetfLang.Assamese.IN,
        IetfLang.AsturianBableLeoneseAsturleonese.code.lowercase() to IetfLang.AsturianBableLeoneseAsturleonese,
            IetfLang.AsturianBableLeoneseAsturleonese.ES.code.lowercase() to IetfLang.AsturianBableLeoneseAsturleonese.ES,
        IetfLang.AthapascanLanguages.code.lowercase() to IetfLang.AthapascanLanguages,
        IetfLang.AustralianLanguages.code.lowercase() to IetfLang.AustralianLanguages,
        IetfLang.Avaric.code.lowercase() to IetfLang.Avaric,
        IetfLang.Avestan.code.lowercase() to IetfLang.Avestan,
        IetfLang.Awadhi.code.lowercase() to IetfLang.Awadhi,
        IetfLang.Aymara.code.lowercase() to IetfLang.Aymara,
        IetfLang.Azerbaijani.code.lowercase() to IetfLang.Azerbaijani,
            IetfLang.Azerbaijani.Cyrl.code.lowercase() to IetfLang.Azerbaijani.Cyrl,
                IetfLang.Azerbaijani.Cyrl.AZ.code.lowercase() to IetfLang.Azerbaijani.Cyrl.AZ,
            IetfLang.Azerbaijani.Latn.code.lowercase() to IetfLang.Azerbaijani.Latn,
                IetfLang.Azerbaijani.Latn.AZ.code.lowercase() to IetfLang.Azerbaijani.Latn.AZ,
        IetfLang.BandaLanguages.code.lowercase() to IetfLang.BandaLanguages,
        IetfLang.BamilekeLanguages.code.lowercase() to IetfLang.BamilekeLanguages,
        IetfLang.Bashkir.code.lowercase() to IetfLang.Bashkir,
        IetfLang.Baluchi.code.lowercase() to IetfLang.Baluchi,
        IetfLang.Bambara.code.lowercase() to IetfLang.Bambara,
            IetfLang.Bambara.ML.code.lowercase() to IetfLang.Bambara.ML,
        IetfLang.Balinese.code.lowercase() to IetfLang.Balinese,
        IetfLang.Basque.code.lowercase() to IetfLang.Basque,
            IetfLang.Basque.ES.code.lowercase() to IetfLang.Basque.ES,
        IetfLang.Basa.code.lowercase() to IetfLang.Basa,
            IetfLang.Basa.CM.code.lowercase() to IetfLang.Basa.CM,
        IetfLang.BalticLanguages.code.lowercase() to IetfLang.BalticLanguages,
        IetfLang.BejaBedawiyet.code.lowercase() to IetfLang.BejaBedawiyet,
        IetfLang.Belarusian.code.lowercase() to IetfLang.Belarusian,
            IetfLang.Belarusian.BY.code.lowercase() to IetfLang.Belarusian.BY,
        IetfLang.Bemba.code.lowercase() to IetfLang.Bemba,
            IetfLang.Bemba.ZM.code.lowercase() to IetfLang.Bemba.ZM,
        IetfLang.Bengali.code.lowercase() to IetfLang.Bengali,
            IetfLang.Bengali.BD.code.lowercase() to IetfLang.Bengali.BD,
            IetfLang.Bengali.IN.code.lowercase() to IetfLang.Bengali.IN,
        IetfLang.BerberLanguages.code.lowercase() to IetfLang.BerberLanguages,
        IetfLang.Bhojpuri.code.lowercase() to IetfLang.Bhojpuri,
        IetfLang.BihariLanguages.code.lowercase() to IetfLang.BihariLanguages,
        IetfLang.Bikol.code.lowercase() to IetfLang.Bikol,
        IetfLang.BiniEdo.code.lowercase() to IetfLang.BiniEdo,
        IetfLang.Bislama.code.lowercase() to IetfLang.Bislama,
        IetfLang.Siksika.code.lowercase() to IetfLang.Siksika,
        IetfLang.BantuOther.code.lowercase() to IetfLang.BantuOther,
        IetfLang.Bosnian.code.lowercase() to IetfLang.Bosnian,
            IetfLang.Bosnian.Cyrl.code.lowercase() to IetfLang.Bosnian.Cyrl,
                IetfLang.Bosnian.Cyrl.BA.code.lowercase() to IetfLang.Bosnian.Cyrl.BA,
            IetfLang.Bosnian.Latn.code.lowercase() to IetfLang.Bosnian.Latn,
                IetfLang.Bosnian.Latn.BA.code.lowercase() to IetfLang.Bosnian.Latn.BA,
        IetfLang.Braj.code.lowercase() to IetfLang.Braj,
        IetfLang.Breton.code.lowercase() to IetfLang.Breton,
            IetfLang.Breton.FR.code.lowercase() to IetfLang.Breton.FR,
        IetfLang.BatakLanguages.code.lowercase() to IetfLang.BatakLanguages,
        IetfLang.Buriat.code.lowercase() to IetfLang.Buriat,
        IetfLang.Buginese.code.lowercase() to IetfLang.Buginese,
        IetfLang.Bulgarian.code.lowercase() to IetfLang.Bulgarian,
            IetfLang.Bulgarian.BG.code.lowercase() to IetfLang.Bulgarian.BG,
        IetfLang.Burmese.code.lowercase() to IetfLang.Burmese,
            IetfLang.Burmese.MM.code.lowercase() to IetfLang.Burmese.MM,
        IetfLang.BlinBilin.code.lowercase() to IetfLang.BlinBilin,
        IetfLang.Caddo.code.lowercase() to IetfLang.Caddo,
        IetfLang.CentralAmericanIndianLanguages.code.lowercase() to IetfLang.CentralAmericanIndianLanguages,
        IetfLang.GalibiCarib.code.lowercase() to IetfLang.GalibiCarib,
        IetfLang.CatalanValencian.code.lowercase() to IetfLang.CatalanValencian,
            IetfLang.CatalanValencian.AD.code.lowercase() to IetfLang.CatalanValencian.AD,
            IetfLang.CatalanValencian.ES.code.lowercase() to IetfLang.CatalanValencian.ES,
                IetfLang.CatalanValencian.ES.VALENCIA.code.lowercase() to IetfLang.CatalanValencian.ES.VALENCIA,
            IetfLang.CatalanValencian.FR.code.lowercase() to IetfLang.CatalanValencian.FR,
            IetfLang.CatalanValencian.IT.code.lowercase() to IetfLang.CatalanValencian.IT,
        IetfLang.CaucasianLanguages.code.lowercase() to IetfLang.CaucasianLanguages,
        IetfLang.Cebuano.code.lowercase() to IetfLang.Cebuano,
        IetfLang.CelticLanguages.code.lowercase() to IetfLang.CelticLanguages,
        IetfLang.Chamorro.code.lowercase() to IetfLang.Chamorro,
        IetfLang.Chibcha.code.lowercase() to IetfLang.Chibcha,
        IetfLang.Chechen.code.lowercase() to IetfLang.Chechen,
            IetfLang.Chechen.RU.code.lowercase() to IetfLang.Chechen.RU,
        IetfLang.Chagatai.code.lowercase() to IetfLang.Chagatai,
        IetfLang.Chinese.code.lowercase() to IetfLang.Chinese,
            IetfLang.Chinese.Hans.code.lowercase() to IetfLang.Chinese.Hans,
                IetfLang.Chinese.Hans.CN.code.lowercase() to IetfLang.Chinese.Hans.CN,
                IetfLang.Chinese.Hans.HK.code.lowercase() to IetfLang.Chinese.Hans.HK,
                IetfLang.Chinese.Hans.MO.code.lowercase() to IetfLang.Chinese.Hans.MO,
                IetfLang.Chinese.Hans.SG.code.lowercase() to IetfLang.Chinese.Hans.SG,
            IetfLang.Chinese.Hant.code.lowercase() to IetfLang.Chinese.Hant,
                IetfLang.Chinese.Hant.HK.code.lowercase() to IetfLang.Chinese.Hant.HK,
                IetfLang.Chinese.Hant.MO.code.lowercase() to IetfLang.Chinese.Hant.MO,
                IetfLang.Chinese.Hant.TW.code.lowercase() to IetfLang.Chinese.Hant.TW,
        IetfLang.Chuukese.code.lowercase() to IetfLang.Chuukese,
        IetfLang.Mari.code.lowercase() to IetfLang.Mari,
        IetfLang.ChinookJargon.code.lowercase() to IetfLang.ChinookJargon,
        IetfLang.Choctaw.code.lowercase() to IetfLang.Choctaw,
        IetfLang.ChipewyanDeneSuline.code.lowercase() to IetfLang.ChipewyanDeneSuline,
        IetfLang.Cherokee.code.lowercase() to IetfLang.Cherokee,
            IetfLang.Cherokee.US.code.lowercase() to IetfLang.Cherokee.US,
        IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.code.lowercase() to IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic,
            IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.RU.code.lowercase() to IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.RU,
        IetfLang.Chuvash.code.lowercase() to IetfLang.Chuvash,
        IetfLang.Cheyenne.code.lowercase() to IetfLang.Cheyenne,
        IetfLang.ChamicLanguages.code.lowercase() to IetfLang.ChamicLanguages,
        IetfLang.Coptic.code.lowercase() to IetfLang.Coptic,
        IetfLang.Cornish.code.lowercase() to IetfLang.Cornish,
            IetfLang.Cornish.GB.code.lowercase() to IetfLang.Cornish.GB,
        IetfLang.Corsican.code.lowercase() to IetfLang.Corsican,
        IetfLang.CreolesAndPidginsEnglishBased.code.lowercase() to IetfLang.CreolesAndPidginsEnglishBased,
        IetfLang.CreolesAndPidginsFrenchbased.code.lowercase() to IetfLang.CreolesAndPidginsFrenchbased,
        IetfLang.CreolesAndPidginsPortuguesebased.code.lowercase() to IetfLang.CreolesAndPidginsPortuguesebased,
        IetfLang.Cree.code.lowercase() to IetfLang.Cree,
        IetfLang.CrimeanTatarCrimeanTurkish.code.lowercase() to IetfLang.CrimeanTatarCrimeanTurkish,
        IetfLang.CreolesAndPidgins.code.lowercase() to IetfLang.CreolesAndPidgins,
        IetfLang.Kashubian.code.lowercase() to IetfLang.Kashubian,
        IetfLang.CushiticLanguages.code.lowercase() to IetfLang.CushiticLanguages,
        IetfLang.Czech.code.lowercase() to IetfLang.Czech,
            IetfLang.Czech.CZ.code.lowercase() to IetfLang.Czech.CZ,
        IetfLang.Dakota.code.lowercase() to IetfLang.Dakota,
        IetfLang.Danish.code.lowercase() to IetfLang.Danish,
            IetfLang.Danish.DK.code.lowercase() to IetfLang.Danish.DK,
            IetfLang.Danish.GL.code.lowercase() to IetfLang.Danish.GL,
        IetfLang.Dargwa.code.lowercase() to IetfLang.Dargwa,
        IetfLang.LandDayakLanguages.code.lowercase() to IetfLang.LandDayakLanguages,
        IetfLang.Delaware.code.lowercase() to IetfLang.Delaware,
        IetfLang.SlaveAthapascan.code.lowercase() to IetfLang.SlaveAthapascan,
        IetfLang.Dogrib.code.lowercase() to IetfLang.Dogrib,
        IetfLang.Dinka.code.lowercase() to IetfLang.Dinka,
        IetfLang.DivehiDhivehiMaldivian.code.lowercase() to IetfLang.DivehiDhivehiMaldivian,
        IetfLang.Dogri.code.lowercase() to IetfLang.Dogri,
        IetfLang.DravidianLanguages.code.lowercase() to IetfLang.DravidianLanguages,
        IetfLang.LowerSorbian.code.lowercase() to IetfLang.LowerSorbian,
            IetfLang.LowerSorbian.DE.code.lowercase() to IetfLang.LowerSorbian.DE,
        IetfLang.Duala.code.lowercase() to IetfLang.Duala,
            IetfLang.Duala.CM.code.lowercase() to IetfLang.Duala.CM,
        IetfLang.DutchMiddleCa_10501350.code.lowercase() to IetfLang.DutchMiddleCa_10501350,
        IetfLang.DutchFlemish.code.lowercase() to IetfLang.DutchFlemish,
            IetfLang.DutchFlemish.AW.code.lowercase() to IetfLang.DutchFlemish.AW,
            IetfLang.DutchFlemish.BE.code.lowercase() to IetfLang.DutchFlemish.BE,
            IetfLang.DutchFlemish.BQ.code.lowercase() to IetfLang.DutchFlemish.BQ,
            IetfLang.DutchFlemish.CW.code.lowercase() to IetfLang.DutchFlemish.CW,
            IetfLang.DutchFlemish.NL.code.lowercase() to IetfLang.DutchFlemish.NL,
            IetfLang.DutchFlemish.SR.code.lowercase() to IetfLang.DutchFlemish.SR,
            IetfLang.DutchFlemish.SX.code.lowercase() to IetfLang.DutchFlemish.SX,
        IetfLang.Dyula.code.lowercase() to IetfLang.Dyula,
        IetfLang.Dzongkha.code.lowercase() to IetfLang.Dzongkha,
            IetfLang.Dzongkha.BT.code.lowercase() to IetfLang.Dzongkha.BT,
        IetfLang.Efik.code.lowercase() to IetfLang.Efik,
        IetfLang.EgyptianAncient.code.lowercase() to IetfLang.EgyptianAncient,
        IetfLang.Ekajuk.code.lowercase() to IetfLang.Ekajuk,
        IetfLang.Elamite.code.lowercase() to IetfLang.Elamite,
        IetfLang.English.code.lowercase() to IetfLang.English,
            IetfLang.English.L001.code.lowercase() to IetfLang.English.L001,
            IetfLang.English.L150.code.lowercase() to IetfLang.English.L150,
            IetfLang.English.AG.code.lowercase() to IetfLang.English.AG,
            IetfLang.English.AI.code.lowercase() to IetfLang.English.AI,
            IetfLang.English.AS.code.lowercase() to IetfLang.English.AS,
            IetfLang.English.AT.code.lowercase() to IetfLang.English.AT,
            IetfLang.English.AU.code.lowercase() to IetfLang.English.AU,
            IetfLang.English.BB.code.lowercase() to IetfLang.English.BB,
            IetfLang.English.BE.code.lowercase() to IetfLang.English.BE,
            IetfLang.English.BI.code.lowercase() to IetfLang.English.BI,
            IetfLang.English.BM.code.lowercase() to IetfLang.English.BM,
            IetfLang.English.BS.code.lowercase() to IetfLang.English.BS,
            IetfLang.English.BW.code.lowercase() to IetfLang.English.BW,
            IetfLang.English.BZ.code.lowercase() to IetfLang.English.BZ,
            IetfLang.English.CA.code.lowercase() to IetfLang.English.CA,
            IetfLang.English.CC.code.lowercase() to IetfLang.English.CC,
            IetfLang.English.CH.code.lowercase() to IetfLang.English.CH,
            IetfLang.English.CK.code.lowercase() to IetfLang.English.CK,
            IetfLang.English.CM.code.lowercase() to IetfLang.English.CM,
            IetfLang.English.CX.code.lowercase() to IetfLang.English.CX,
            IetfLang.English.CY.code.lowercase() to IetfLang.English.CY,
            IetfLang.English.DE.code.lowercase() to IetfLang.English.DE,
            IetfLang.English.DG.code.lowercase() to IetfLang.English.DG,
            IetfLang.English.DK.code.lowercase() to IetfLang.English.DK,
            IetfLang.English.DM.code.lowercase() to IetfLang.English.DM,
            IetfLang.English.ER.code.lowercase() to IetfLang.English.ER,
            IetfLang.English.FI.code.lowercase() to IetfLang.English.FI,
            IetfLang.English.FJ.code.lowercase() to IetfLang.English.FJ,
            IetfLang.English.FK.code.lowercase() to IetfLang.English.FK,
            IetfLang.English.FM.code.lowercase() to IetfLang.English.FM,
            IetfLang.English.GB.code.lowercase() to IetfLang.English.GB,
            IetfLang.English.GD.code.lowercase() to IetfLang.English.GD,
            IetfLang.English.GG.code.lowercase() to IetfLang.English.GG,
            IetfLang.English.GH.code.lowercase() to IetfLang.English.GH,
            IetfLang.English.GI.code.lowercase() to IetfLang.English.GI,
            IetfLang.English.GM.code.lowercase() to IetfLang.English.GM,
            IetfLang.English.GU.code.lowercase() to IetfLang.English.GU,
            IetfLang.English.GY.code.lowercase() to IetfLang.English.GY,
            IetfLang.English.HK.code.lowercase() to IetfLang.English.HK,
            IetfLang.English.IE.code.lowercase() to IetfLang.English.IE,
            IetfLang.English.IL.code.lowercase() to IetfLang.English.IL,
            IetfLang.English.IM.code.lowercase() to IetfLang.English.IM,
            IetfLang.English.IN.code.lowercase() to IetfLang.English.IN,
            IetfLang.English.IO.code.lowercase() to IetfLang.English.IO,
            IetfLang.English.JE.code.lowercase() to IetfLang.English.JE,
            IetfLang.English.JM.code.lowercase() to IetfLang.English.JM,
            IetfLang.English.KE.code.lowercase() to IetfLang.English.KE,
            IetfLang.English.KI.code.lowercase() to IetfLang.English.KI,
            IetfLang.English.KN.code.lowercase() to IetfLang.English.KN,
            IetfLang.English.KY.code.lowercase() to IetfLang.English.KY,
            IetfLang.English.LC.code.lowercase() to IetfLang.English.LC,
            IetfLang.English.LR.code.lowercase() to IetfLang.English.LR,
            IetfLang.English.LS.code.lowercase() to IetfLang.English.LS,
            IetfLang.English.MG.code.lowercase() to IetfLang.English.MG,
            IetfLang.English.MH.code.lowercase() to IetfLang.English.MH,
            IetfLang.English.MO.code.lowercase() to IetfLang.English.MO,
            IetfLang.English.MP.code.lowercase() to IetfLang.English.MP,
            IetfLang.English.MS.code.lowercase() to IetfLang.English.MS,
            IetfLang.English.MT.code.lowercase() to IetfLang.English.MT,
            IetfLang.English.MU.code.lowercase() to IetfLang.English.MU,
            IetfLang.English.MW.code.lowercase() to IetfLang.English.MW,
            IetfLang.English.MY.code.lowercase() to IetfLang.English.MY,
            IetfLang.English.NA.code.lowercase() to IetfLang.English.NA,
            IetfLang.English.NF.code.lowercase() to IetfLang.English.NF,
            IetfLang.English.NG.code.lowercase() to IetfLang.English.NG,
            IetfLang.English.NL.code.lowercase() to IetfLang.English.NL,
            IetfLang.English.NR.code.lowercase() to IetfLang.English.NR,
            IetfLang.English.NU.code.lowercase() to IetfLang.English.NU,
            IetfLang.English.NZ.code.lowercase() to IetfLang.English.NZ,
            IetfLang.English.PG.code.lowercase() to IetfLang.English.PG,
            IetfLang.English.PH.code.lowercase() to IetfLang.English.PH,
            IetfLang.English.PK.code.lowercase() to IetfLang.English.PK,
            IetfLang.English.PN.code.lowercase() to IetfLang.English.PN,
            IetfLang.English.PR.code.lowercase() to IetfLang.English.PR,
            IetfLang.English.PW.code.lowercase() to IetfLang.English.PW,
            IetfLang.English.RW.code.lowercase() to IetfLang.English.RW,
            IetfLang.English.SB.code.lowercase() to IetfLang.English.SB,
            IetfLang.English.SC.code.lowercase() to IetfLang.English.SC,
            IetfLang.English.SD.code.lowercase() to IetfLang.English.SD,
            IetfLang.English.SE.code.lowercase() to IetfLang.English.SE,
            IetfLang.English.SG.code.lowercase() to IetfLang.English.SG,
            IetfLang.English.SH.code.lowercase() to IetfLang.English.SH,
            IetfLang.English.SI.code.lowercase() to IetfLang.English.SI,
            IetfLang.English.SL.code.lowercase() to IetfLang.English.SL,
            IetfLang.English.SS.code.lowercase() to IetfLang.English.SS,
            IetfLang.English.SX.code.lowercase() to IetfLang.English.SX,
            IetfLang.English.SZ.code.lowercase() to IetfLang.English.SZ,
            IetfLang.English.TC.code.lowercase() to IetfLang.English.TC,
            IetfLang.English.TK.code.lowercase() to IetfLang.English.TK,
            IetfLang.English.TO.code.lowercase() to IetfLang.English.TO,
            IetfLang.English.TT.code.lowercase() to IetfLang.English.TT,
            IetfLang.English.TV.code.lowercase() to IetfLang.English.TV,
            IetfLang.English.TZ.code.lowercase() to IetfLang.English.TZ,
            IetfLang.English.UG.code.lowercase() to IetfLang.English.UG,
            IetfLang.English.UM.code.lowercase() to IetfLang.English.UM,
            IetfLang.English.US.code.lowercase() to IetfLang.English.US,
                IetfLang.English.US.POSIX.code.lowercase() to IetfLang.English.US.POSIX,
            IetfLang.English.VC.code.lowercase() to IetfLang.English.VC,
            IetfLang.English.VG.code.lowercase() to IetfLang.English.VG,
            IetfLang.English.VI.code.lowercase() to IetfLang.English.VI,
            IetfLang.English.VU.code.lowercase() to IetfLang.English.VU,
            IetfLang.English.WS.code.lowercase() to IetfLang.English.WS,
            IetfLang.English.ZA.code.lowercase() to IetfLang.English.ZA,
            IetfLang.English.ZM.code.lowercase() to IetfLang.English.ZM,
            IetfLang.English.ZW.code.lowercase() to IetfLang.English.ZW,
        IetfLang.EnglishMiddle11001500.code.lowercase() to IetfLang.EnglishMiddle11001500,
        IetfLang.Esperanto.code.lowercase() to IetfLang.Esperanto,
            IetfLang.Esperanto.L001.code.lowercase() to IetfLang.Esperanto.L001,
        IetfLang.Estonian.code.lowercase() to IetfLang.Estonian,
            IetfLang.Estonian.EE.code.lowercase() to IetfLang.Estonian.EE,
        IetfLang.Ewe.code.lowercase() to IetfLang.Ewe,
            IetfLang.Ewe.GH.code.lowercase() to IetfLang.Ewe.GH,
            IetfLang.Ewe.TG.code.lowercase() to IetfLang.Ewe.TG,
        IetfLang.Ewondo.code.lowercase() to IetfLang.Ewondo,
            IetfLang.Ewondo.CM.code.lowercase() to IetfLang.Ewondo.CM,
        IetfLang.Fang.code.lowercase() to IetfLang.Fang,
        IetfLang.Faroese.code.lowercase() to IetfLang.Faroese,
            IetfLang.Faroese.DK.code.lowercase() to IetfLang.Faroese.DK,
            IetfLang.Faroese.FO.code.lowercase() to IetfLang.Faroese.FO,
        IetfLang.Fanti.code.lowercase() to IetfLang.Fanti,
        IetfLang.Fijian.code.lowercase() to IetfLang.Fijian,
        IetfLang.FilipinoPilipino.code.lowercase() to IetfLang.FilipinoPilipino,
            IetfLang.FilipinoPilipino.PH.code.lowercase() to IetfLang.FilipinoPilipino.PH,
        IetfLang.Finnish.code.lowercase() to IetfLang.Finnish,
            IetfLang.Finnish.FI.code.lowercase() to IetfLang.Finnish.FI,
        IetfLang.FinnoUgrianLanguages.code.lowercase() to IetfLang.FinnoUgrianLanguages,
        IetfLang.Fon.code.lowercase() to IetfLang.Fon,
        IetfLang.French.code.lowercase() to IetfLang.French,
            IetfLang.French.BE.code.lowercase() to IetfLang.French.BE,
            IetfLang.French.BF.code.lowercase() to IetfLang.French.BF,
            IetfLang.French.BI.code.lowercase() to IetfLang.French.BI,
            IetfLang.French.BJ.code.lowercase() to IetfLang.French.BJ,
            IetfLang.French.BL.code.lowercase() to IetfLang.French.BL,
            IetfLang.French.CA.code.lowercase() to IetfLang.French.CA,
            IetfLang.French.CD.code.lowercase() to IetfLang.French.CD,
            IetfLang.French.CF.code.lowercase() to IetfLang.French.CF,
            IetfLang.French.CG.code.lowercase() to IetfLang.French.CG,
            IetfLang.French.CH.code.lowercase() to IetfLang.French.CH,
            IetfLang.French.CI.code.lowercase() to IetfLang.French.CI,
            IetfLang.French.CM.code.lowercase() to IetfLang.French.CM,
            IetfLang.French.DJ.code.lowercase() to IetfLang.French.DJ,
            IetfLang.French.DZ.code.lowercase() to IetfLang.French.DZ,
            IetfLang.French.FR.code.lowercase() to IetfLang.French.FR,
            IetfLang.French.GA.code.lowercase() to IetfLang.French.GA,
            IetfLang.French.GF.code.lowercase() to IetfLang.French.GF,
            IetfLang.French.GN.code.lowercase() to IetfLang.French.GN,
            IetfLang.French.GP.code.lowercase() to IetfLang.French.GP,
            IetfLang.French.GQ.code.lowercase() to IetfLang.French.GQ,
            IetfLang.French.HT.code.lowercase() to IetfLang.French.HT,
            IetfLang.French.KM.code.lowercase() to IetfLang.French.KM,
            IetfLang.French.LU.code.lowercase() to IetfLang.French.LU,
            IetfLang.French.MA.code.lowercase() to IetfLang.French.MA,
            IetfLang.French.MC.code.lowercase() to IetfLang.French.MC,
            IetfLang.French.MF.code.lowercase() to IetfLang.French.MF,
            IetfLang.French.MG.code.lowercase() to IetfLang.French.MG,
            IetfLang.French.ML.code.lowercase() to IetfLang.French.ML,
            IetfLang.French.MQ.code.lowercase() to IetfLang.French.MQ,
            IetfLang.French.MR.code.lowercase() to IetfLang.French.MR,
            IetfLang.French.MU.code.lowercase() to IetfLang.French.MU,
            IetfLang.French.NC.code.lowercase() to IetfLang.French.NC,
            IetfLang.French.NE.code.lowercase() to IetfLang.French.NE,
            IetfLang.French.PF.code.lowercase() to IetfLang.French.PF,
            IetfLang.French.PM.code.lowercase() to IetfLang.French.PM,
            IetfLang.French.RE.code.lowercase() to IetfLang.French.RE,
            IetfLang.French.RW.code.lowercase() to IetfLang.French.RW,
            IetfLang.French.SC.code.lowercase() to IetfLang.French.SC,
            IetfLang.French.SN.code.lowercase() to IetfLang.French.SN,
            IetfLang.French.SY.code.lowercase() to IetfLang.French.SY,
            IetfLang.French.TD.code.lowercase() to IetfLang.French.TD,
            IetfLang.French.TG.code.lowercase() to IetfLang.French.TG,
            IetfLang.French.TN.code.lowercase() to IetfLang.French.TN,
            IetfLang.French.VU.code.lowercase() to IetfLang.French.VU,
            IetfLang.French.WF.code.lowercase() to IetfLang.French.WF,
            IetfLang.French.YT.code.lowercase() to IetfLang.French.YT,
        IetfLang.FrenchMiddleCa_14001600.code.lowercase() to IetfLang.FrenchMiddleCa_14001600,
        IetfLang.FrenchOld842ca_1400.code.lowercase() to IetfLang.FrenchOld842ca_1400,
        IetfLang.NorthernFrisian.code.lowercase() to IetfLang.NorthernFrisian,
        IetfLang.EasternFrisian.code.lowercase() to IetfLang.EasternFrisian,
        IetfLang.WesternFrisian.code.lowercase() to IetfLang.WesternFrisian,
            IetfLang.WesternFrisian.NL.code.lowercase() to IetfLang.WesternFrisian.NL,
        IetfLang.Fulah.code.lowercase() to IetfLang.Fulah,
            IetfLang.Fulah.CM.code.lowercase() to IetfLang.Fulah.CM,
            IetfLang.Fulah.GN.code.lowercase() to IetfLang.Fulah.GN,
            IetfLang.Fulah.MR.code.lowercase() to IetfLang.Fulah.MR,
            IetfLang.Fulah.SN.code.lowercase() to IetfLang.Fulah.SN,
        IetfLang.Friulian.code.lowercase() to IetfLang.Friulian,
            IetfLang.Friulian.IT.code.lowercase() to IetfLang.Friulian.IT,
        IetfLang.Ga.code.lowercase() to IetfLang.Ga,
        IetfLang.Gayo.code.lowercase() to IetfLang.Gayo,
        IetfLang.Gbaya.code.lowercase() to IetfLang.Gbaya,
        IetfLang.GermanicLanguages.code.lowercase() to IetfLang.GermanicLanguages,
        IetfLang.Georgian.code.lowercase() to IetfLang.Georgian,
            IetfLang.Georgian.GE.code.lowercase() to IetfLang.Georgian.GE,
        IetfLang.German.code.lowercase() to IetfLang.German,
            IetfLang.German.AT.code.lowercase() to IetfLang.German.AT,
            IetfLang.German.BE.code.lowercase() to IetfLang.German.BE,
            IetfLang.German.CH.code.lowercase() to IetfLang.German.CH,
            IetfLang.German.DE.code.lowercase() to IetfLang.German.DE,
            IetfLang.German.IT.code.lowercase() to IetfLang.German.IT,
            IetfLang.German.LI.code.lowercase() to IetfLang.German.LI,
            IetfLang.German.LU.code.lowercase() to IetfLang.German.LU,
        IetfLang.Geez.code.lowercase() to IetfLang.Geez,
        IetfLang.Gilbertese.code.lowercase() to IetfLang.Gilbertese,
        IetfLang.GaelicScottishGaelic.code.lowercase() to IetfLang.GaelicScottishGaelic,
            IetfLang.GaelicScottishGaelic.GB.code.lowercase() to IetfLang.GaelicScottishGaelic.GB,
        IetfLang.Irish.code.lowercase() to IetfLang.Irish,
            IetfLang.Irish.IE.code.lowercase() to IetfLang.Irish.IE,
        IetfLang.Galician.code.lowercase() to IetfLang.Galician,
            IetfLang.Galician.ES.code.lowercase() to IetfLang.Galician.ES,
        IetfLang.Manx.code.lowercase() to IetfLang.Manx,
            IetfLang.Manx.IM.code.lowercase() to IetfLang.Manx.IM,
        IetfLang.GermanMiddleHighCa_10501500.code.lowercase() to IetfLang.GermanMiddleHighCa_10501500,
        IetfLang.GermanOldHighCa_7501050.code.lowercase() to IetfLang.GermanOldHighCa_7501050,
        IetfLang.Gondi.code.lowercase() to IetfLang.Gondi,
        IetfLang.Gorontalo.code.lowercase() to IetfLang.Gorontalo,
        IetfLang.Gothic.code.lowercase() to IetfLang.Gothic,
        IetfLang.Grebo.code.lowercase() to IetfLang.Grebo,
        IetfLang.GreekAncientTo1453.code.lowercase() to IetfLang.GreekAncientTo1453,
        IetfLang.GreekModern1453.code.lowercase() to IetfLang.GreekModern1453,
            IetfLang.GreekModern1453.CY.code.lowercase() to IetfLang.GreekModern1453.CY,
            IetfLang.GreekModern1453.GR.code.lowercase() to IetfLang.GreekModern1453.GR,
        IetfLang.Guarani.code.lowercase() to IetfLang.Guarani,
        IetfLang.SwissGermanAlemannicAlsatian.code.lowercase() to IetfLang.SwissGermanAlemannicAlsatian,
            IetfLang.SwissGermanAlemannicAlsatian.CH.code.lowercase() to IetfLang.SwissGermanAlemannicAlsatian.CH,
            IetfLang.SwissGermanAlemannicAlsatian.FR.code.lowercase() to IetfLang.SwissGermanAlemannicAlsatian.FR,
            IetfLang.SwissGermanAlemannicAlsatian.LI.code.lowercase() to IetfLang.SwissGermanAlemannicAlsatian.LI,
        IetfLang.Gujarati.code.lowercase() to IetfLang.Gujarati,
            IetfLang.Gujarati.IN.code.lowercase() to IetfLang.Gujarati.IN,
        IetfLang.Gwich_in.code.lowercase() to IetfLang.Gwich_in,
        IetfLang.Haida.code.lowercase() to IetfLang.Haida,
        IetfLang.HaitianHaitianCreole.code.lowercase() to IetfLang.HaitianHaitianCreole,
        IetfLang.Hausa.code.lowercase() to IetfLang.Hausa,
            IetfLang.Hausa.GH.code.lowercase() to IetfLang.Hausa.GH,
            IetfLang.Hausa.NE.code.lowercase() to IetfLang.Hausa.NE,
            IetfLang.Hausa.NG.code.lowercase() to IetfLang.Hausa.NG,
        IetfLang.Hawaiian.code.lowercase() to IetfLang.Hawaiian,
            IetfLang.Hawaiian.US.code.lowercase() to IetfLang.Hawaiian.US,
        IetfLang.Hebrew.code.lowercase() to IetfLang.Hebrew,
            IetfLang.Hebrew.IL.code.lowercase() to IetfLang.Hebrew.IL,
        IetfLang.Herero.code.lowercase() to IetfLang.Herero,
        IetfLang.Hiligaynon.code.lowercase() to IetfLang.Hiligaynon,
        IetfLang.HimachaliLanguagesWesternPahariLanguages.code.lowercase() to IetfLang.HimachaliLanguagesWesternPahariLanguages,
        IetfLang.Hindi.code.lowercase() to IetfLang.Hindi,
            IetfLang.Hindi.IN.code.lowercase() to IetfLang.Hindi.IN,
        IetfLang.Hittite.code.lowercase() to IetfLang.Hittite,
        IetfLang.HmongMong.code.lowercase() to IetfLang.HmongMong,
        IetfLang.HiriMotu.code.lowercase() to IetfLang.HiriMotu,
        IetfLang.Croatian.code.lowercase() to IetfLang.Croatian,
            IetfLang.Croatian.BA.code.lowercase() to IetfLang.Croatian.BA,
            IetfLang.Croatian.HR.code.lowercase() to IetfLang.Croatian.HR,
        IetfLang.UpperSorbian.code.lowercase() to IetfLang.UpperSorbian,
            IetfLang.UpperSorbian.DE.code.lowercase() to IetfLang.UpperSorbian.DE,
        IetfLang.Hungarian.code.lowercase() to IetfLang.Hungarian,
            IetfLang.Hungarian.HU.code.lowercase() to IetfLang.Hungarian.HU,
        IetfLang.Hupa.code.lowercase() to IetfLang.Hupa,
        IetfLang.Iban.code.lowercase() to IetfLang.Iban,
        IetfLang.Igbo.code.lowercase() to IetfLang.Igbo,
            IetfLang.Igbo.NG.code.lowercase() to IetfLang.Igbo.NG,
        IetfLang.Icelandic.code.lowercase() to IetfLang.Icelandic,
            IetfLang.Icelandic.IS.code.lowercase() to IetfLang.Icelandic.IS,
        IetfLang.Ido.code.lowercase() to IetfLang.Ido,
        IetfLang.SichuanYiNuosu.code.lowercase() to IetfLang.SichuanYiNuosu,
            IetfLang.SichuanYiNuosu.CN.code.lowercase() to IetfLang.SichuanYiNuosu.CN,
        IetfLang.IjoLanguages.code.lowercase() to IetfLang.IjoLanguages,
        IetfLang.Inuktitut.code.lowercase() to IetfLang.Inuktitut,
        IetfLang.InterlingueOccidental.code.lowercase() to IetfLang.InterlingueOccidental,
        IetfLang.Iloko.code.lowercase() to IetfLang.Iloko,
        IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation.code.lowercase() to IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation,
        IetfLang.IndicLanguages.code.lowercase() to IetfLang.IndicLanguages,
        IetfLang.Indonesian.code.lowercase() to IetfLang.Indonesian,
            IetfLang.Indonesian.ID.code.lowercase() to IetfLang.Indonesian.ID,
        IetfLang.IndoEuropeanLanguages.code.lowercase() to IetfLang.IndoEuropeanLanguages,
        IetfLang.Ingush.code.lowercase() to IetfLang.Ingush,
        IetfLang.Inupiaq.code.lowercase() to IetfLang.Inupiaq,
        IetfLang.IranianLanguages.code.lowercase() to IetfLang.IranianLanguages,
        IetfLang.IroquoianLanguages.code.lowercase() to IetfLang.IroquoianLanguages,
        IetfLang.Italian.code.lowercase() to IetfLang.Italian,
            IetfLang.Italian.CH.code.lowercase() to IetfLang.Italian.CH,
            IetfLang.Italian.IT.code.lowercase() to IetfLang.Italian.IT,
            IetfLang.Italian.SM.code.lowercase() to IetfLang.Italian.SM,
            IetfLang.Italian.VA.code.lowercase() to IetfLang.Italian.VA,
        IetfLang.Javanese.code.lowercase() to IetfLang.Javanese,
        IetfLang.Lojban.code.lowercase() to IetfLang.Lojban,
        IetfLang.Japanese.code.lowercase() to IetfLang.Japanese,
            IetfLang.Japanese.JP.code.lowercase() to IetfLang.Japanese.JP,
        IetfLang.JudeoPersian.code.lowercase() to IetfLang.JudeoPersian,
        IetfLang.JudeoArabic.code.lowercase() to IetfLang.JudeoArabic,
        IetfLang.KaraKalpak.code.lowercase() to IetfLang.KaraKalpak,
        IetfLang.Kabyle.code.lowercase() to IetfLang.Kabyle,
            IetfLang.Kabyle.DZ.code.lowercase() to IetfLang.Kabyle.DZ,
        IetfLang.KachinJingpho.code.lowercase() to IetfLang.KachinJingpho,
        IetfLang.KalaallisutGreenlandic.code.lowercase() to IetfLang.KalaallisutGreenlandic,
            IetfLang.KalaallisutGreenlandic.GL.code.lowercase() to IetfLang.KalaallisutGreenlandic.GL,
        IetfLang.Kamba.code.lowercase() to IetfLang.Kamba,
            IetfLang.Kamba.KE.code.lowercase() to IetfLang.Kamba.KE,
        IetfLang.Kannada.code.lowercase() to IetfLang.Kannada,
            IetfLang.Kannada.IN.code.lowercase() to IetfLang.Kannada.IN,
        IetfLang.KarenLanguages.code.lowercase() to IetfLang.KarenLanguages,
        IetfLang.Kashmiri.code.lowercase() to IetfLang.Kashmiri,
            IetfLang.Kashmiri.IN.code.lowercase() to IetfLang.Kashmiri.IN,
        IetfLang.Kanuri.code.lowercase() to IetfLang.Kanuri,
        IetfLang.Kawi.code.lowercase() to IetfLang.Kawi,
        IetfLang.Kazakh.code.lowercase() to IetfLang.Kazakh,
            IetfLang.Kazakh.KZ.code.lowercase() to IetfLang.Kazakh.KZ,
        IetfLang.Kabardian.code.lowercase() to IetfLang.Kabardian,
        IetfLang.Khasi.code.lowercase() to IetfLang.Khasi,
        IetfLang.KhoisanLanguages.code.lowercase() to IetfLang.KhoisanLanguages,
        IetfLang.CentralKhmer.code.lowercase() to IetfLang.CentralKhmer,
            IetfLang.CentralKhmer.KH.code.lowercase() to IetfLang.CentralKhmer.KH,
        IetfLang.KhotaneseSakan.code.lowercase() to IetfLang.KhotaneseSakan,
        IetfLang.KikuyuGikuyu.code.lowercase() to IetfLang.KikuyuGikuyu,
            IetfLang.KikuyuGikuyu.KE.code.lowercase() to IetfLang.KikuyuGikuyu.KE,
        IetfLang.Kinyarwanda.code.lowercase() to IetfLang.Kinyarwanda,
            IetfLang.Kinyarwanda.RW.code.lowercase() to IetfLang.Kinyarwanda.RW,
        IetfLang.KirghizKyrgyz.code.lowercase() to IetfLang.KirghizKyrgyz,
            IetfLang.KirghizKyrgyz.KG.code.lowercase() to IetfLang.KirghizKyrgyz.KG,
        IetfLang.Kimbundu.code.lowercase() to IetfLang.Kimbundu,
        IetfLang.Konkani.code.lowercase() to IetfLang.Konkani,
            IetfLang.Konkani.IN.code.lowercase() to IetfLang.Konkani.IN,
        IetfLang.Komi.code.lowercase() to IetfLang.Komi,
        IetfLang.Kongo.code.lowercase() to IetfLang.Kongo,
        IetfLang.Korean.code.lowercase() to IetfLang.Korean,
            IetfLang.Korean.KP.code.lowercase() to IetfLang.Korean.KP,
            IetfLang.Korean.KR.code.lowercase() to IetfLang.Korean.KR,
        IetfLang.Kosraean.code.lowercase() to IetfLang.Kosraean,
        IetfLang.Kpelle.code.lowercase() to IetfLang.Kpelle,
        IetfLang.KarachayBalkar.code.lowercase() to IetfLang.KarachayBalkar,
        IetfLang.Karelian.code.lowercase() to IetfLang.Karelian,
        IetfLang.KruLanguages.code.lowercase() to IetfLang.KruLanguages,
        IetfLang.Kurukh.code.lowercase() to IetfLang.Kurukh,
        IetfLang.KuanyamaKwanyama.code.lowercase() to IetfLang.KuanyamaKwanyama,
        IetfLang.Kumyk.code.lowercase() to IetfLang.Kumyk,
        IetfLang.Kurdish.code.lowercase() to IetfLang.Kurdish,
        IetfLang.Kutenai.code.lowercase() to IetfLang.Kutenai,
        IetfLang.Ladino.code.lowercase() to IetfLang.Ladino,
        IetfLang.Lahnda.code.lowercase() to IetfLang.Lahnda,
        IetfLang.Lamba.code.lowercase() to IetfLang.Lamba,
        IetfLang.Lao.code.lowercase() to IetfLang.Lao,
            IetfLang.Lao.LA.code.lowercase() to IetfLang.Lao.LA,
        IetfLang.Latin.code.lowercase() to IetfLang.Latin,
        IetfLang.Latvian.code.lowercase() to IetfLang.Latvian,
            IetfLang.Latvian.LV.code.lowercase() to IetfLang.Latvian.LV,
        IetfLang.Lezghian.code.lowercase() to IetfLang.Lezghian,
        IetfLang.LimburganLimburgerLimburgish.code.lowercase() to IetfLang.LimburganLimburgerLimburgish,
        IetfLang.Lingala.code.lowercase() to IetfLang.Lingala,
            IetfLang.Lingala.AO.code.lowercase() to IetfLang.Lingala.AO,
            IetfLang.Lingala.CD.code.lowercase() to IetfLang.Lingala.CD,
            IetfLang.Lingala.CF.code.lowercase() to IetfLang.Lingala.CF,
            IetfLang.Lingala.CG.code.lowercase() to IetfLang.Lingala.CG,
        IetfLang.Lithuanian.code.lowercase() to IetfLang.Lithuanian,
            IetfLang.Lithuanian.LT.code.lowercase() to IetfLang.Lithuanian.LT,
        IetfLang.Mongo.code.lowercase() to IetfLang.Mongo,
        IetfLang.Lozi.code.lowercase() to IetfLang.Lozi,
        IetfLang.LuxembourgishLetzeburgesch.code.lowercase() to IetfLang.LuxembourgishLetzeburgesch,
            IetfLang.LuxembourgishLetzeburgesch.LU.code.lowercase() to IetfLang.LuxembourgishLetzeburgesch.LU,
        IetfLang.LubaLulua.code.lowercase() to IetfLang.LubaLulua,
        IetfLang.LubaKatanga.code.lowercase() to IetfLang.LubaKatanga,
            IetfLang.LubaKatanga.CD.code.lowercase() to IetfLang.LubaKatanga.CD,
        IetfLang.Ganda.code.lowercase() to IetfLang.Ganda,
            IetfLang.Ganda.UG.code.lowercase() to IetfLang.Ganda.UG,
        IetfLang.Luiseno.code.lowercase() to IetfLang.Luiseno,
        IetfLang.Lunda.code.lowercase() to IetfLang.Lunda,
        IetfLang.LuoKenyaAndTanzania.code.lowercase() to IetfLang.LuoKenyaAndTanzania,
            IetfLang.LuoKenyaAndTanzania.KE.code.lowercase() to IetfLang.LuoKenyaAndTanzania.KE,
        IetfLang.Lushai.code.lowercase() to IetfLang.Lushai,
        IetfLang.Macedonian.code.lowercase() to IetfLang.Macedonian,
            IetfLang.Macedonian.MK.code.lowercase() to IetfLang.Macedonian.MK,
        IetfLang.Madurese.code.lowercase() to IetfLang.Madurese,
        IetfLang.Magahi.code.lowercase() to IetfLang.Magahi,
        IetfLang.Marshallese.code.lowercase() to IetfLang.Marshallese,
        IetfLang.Maithili.code.lowercase() to IetfLang.Maithili,
        IetfLang.Makasar.code.lowercase() to IetfLang.Makasar,
        IetfLang.Malayalam.code.lowercase() to IetfLang.Malayalam,
            IetfLang.Malayalam.IN.code.lowercase() to IetfLang.Malayalam.IN,
        IetfLang.Mandingo.code.lowercase() to IetfLang.Mandingo,
        IetfLang.Maori.code.lowercase() to IetfLang.Maori,
        IetfLang.AustronesianLanguages.code.lowercase() to IetfLang.AustronesianLanguages,
        IetfLang.Marathi.code.lowercase() to IetfLang.Marathi,
            IetfLang.Marathi.IN.code.lowercase() to IetfLang.Marathi.IN,
        IetfLang.Masai.code.lowercase() to IetfLang.Masai,
            IetfLang.Masai.KE.code.lowercase() to IetfLang.Masai.KE,
            IetfLang.Masai.TZ.code.lowercase() to IetfLang.Masai.TZ,
        IetfLang.Malay.code.lowercase() to IetfLang.Malay,
            IetfLang.Malay.BN.code.lowercase() to IetfLang.Malay.BN,
            IetfLang.Malay.MY.code.lowercase() to IetfLang.Malay.MY,
            IetfLang.Malay.SG.code.lowercase() to IetfLang.Malay.SG,
        IetfLang.Moksha.code.lowercase() to IetfLang.Moksha,
        IetfLang.Mandar.code.lowercase() to IetfLang.Mandar,
        IetfLang.Mende.code.lowercase() to IetfLang.Mende,
        IetfLang.IrishMiddle9001200.code.lowercase() to IetfLang.IrishMiddle9001200,
        IetfLang.Mi_kmaqMicmac.code.lowercase() to IetfLang.Mi_kmaqMicmac,
        IetfLang.Minangkabau.code.lowercase() to IetfLang.Minangkabau,
        IetfLang.UncodedLanguages.code.lowercase() to IetfLang.UncodedLanguages,
        IetfLang.MonKhmerLanguages.code.lowercase() to IetfLang.MonKhmerLanguages,
        IetfLang.Malagasy.code.lowercase() to IetfLang.Malagasy,
            IetfLang.Malagasy.MG.code.lowercase() to IetfLang.Malagasy.MG,
        IetfLang.Maltese.code.lowercase() to IetfLang.Maltese,
            IetfLang.Maltese.MT.code.lowercase() to IetfLang.Maltese.MT,
        IetfLang.Manchu.code.lowercase() to IetfLang.Manchu,
        IetfLang.Manipuri.code.lowercase() to IetfLang.Manipuri,
        IetfLang.ManoboLanguages.code.lowercase() to IetfLang.ManoboLanguages,
        IetfLang.Mohawk.code.lowercase() to IetfLang.Mohawk,
        IetfLang.Mongolian.code.lowercase() to IetfLang.Mongolian,
            IetfLang.Mongolian.MN.code.lowercase() to IetfLang.Mongolian.MN,
        IetfLang.Mossi.code.lowercase() to IetfLang.Mossi,
        IetfLang.MultipleLanguages.code.lowercase() to IetfLang.MultipleLanguages,
        IetfLang.MundaLanguages.code.lowercase() to IetfLang.MundaLanguages,
        IetfLang.Creek.code.lowercase() to IetfLang.Creek,
        IetfLang.Mirandese.code.lowercase() to IetfLang.Mirandese,
        IetfLang.Marwari.code.lowercase() to IetfLang.Marwari,
        IetfLang.MayanLanguages.code.lowercase() to IetfLang.MayanLanguages,
        IetfLang.Erzya.code.lowercase() to IetfLang.Erzya,
        IetfLang.NahuatlLanguages.code.lowercase() to IetfLang.NahuatlLanguages,
        IetfLang.NorthAmericanIndianLanguages.code.lowercase() to IetfLang.NorthAmericanIndianLanguages,
        IetfLang.Neapolitan.code.lowercase() to IetfLang.Neapolitan,
        IetfLang.Nauru.code.lowercase() to IetfLang.Nauru,
        IetfLang.NavajoNavaho.code.lowercase() to IetfLang.NavajoNavaho,
        IetfLang.NdebeleSouthSouthNdebele.code.lowercase() to IetfLang.NdebeleSouthSouthNdebele,
        IetfLang.NdebeleNorthNorthNdebele.code.lowercase() to IetfLang.NdebeleNorthNorthNdebele,
            IetfLang.NdebeleNorthNorthNdebele.ZW.code.lowercase() to IetfLang.NdebeleNorthNorthNdebele.ZW,
        IetfLang.Ndonga.code.lowercase() to IetfLang.Ndonga,
        IetfLang.LowGermanLowSaxonGermanLowSaxonLow.code.lowercase() to IetfLang.LowGermanLowSaxonGermanLowSaxonLow,
            IetfLang.LowGermanLowSaxonGermanLowSaxonLow.DE.code.lowercase() to IetfLang.LowGermanLowSaxonGermanLowSaxonLow.DE,
            IetfLang.LowGermanLowSaxonGermanLowSaxonLow.NL.code.lowercase() to IetfLang.LowGermanLowSaxonGermanLowSaxonLow.NL,
        IetfLang.Nepali.code.lowercase() to IetfLang.Nepali,
            IetfLang.Nepali.IN.code.lowercase() to IetfLang.Nepali.IN,
            IetfLang.Nepali.NP.code.lowercase() to IetfLang.Nepali.NP,
        IetfLang.NepalBhasaNewari.code.lowercase() to IetfLang.NepalBhasaNewari,
        IetfLang.Nias.code.lowercase() to IetfLang.Nias,
        IetfLang.NigerKordofanianLanguages.code.lowercase() to IetfLang.NigerKordofanianLanguages,
        IetfLang.Niuean.code.lowercase() to IetfLang.Niuean,
        IetfLang.NorwegianNynorskNynorskNorwegian.code.lowercase() to IetfLang.NorwegianNynorskNynorskNorwegian,
            IetfLang.NorwegianNynorskNynorskNorwegian.NO.code.lowercase() to IetfLang.NorwegianNynorskNynorskNorwegian.NO,
        IetfLang.BokmalNorwegianNorwegianBokmal.code.lowercase() to IetfLang.BokmalNorwegianNorwegianBokmal,
            IetfLang.BokmalNorwegianNorwegianBokmal.NO.code.lowercase() to IetfLang.BokmalNorwegianNorwegianBokmal.NO,
            IetfLang.BokmalNorwegianNorwegianBokmal.SJ.code.lowercase() to IetfLang.BokmalNorwegianNorwegianBokmal.SJ,
        IetfLang.Nogai.code.lowercase() to IetfLang.Nogai,
        IetfLang.NorseOld.code.lowercase() to IetfLang.NorseOld,
        IetfLang.Norwegian.code.lowercase() to IetfLang.Norwegian,
        IetfLang.N_Ko.code.lowercase() to IetfLang.N_Ko,
        IetfLang.PediSepediNorthernSotho.code.lowercase() to IetfLang.PediSepediNorthernSotho,
        IetfLang.NubianLanguages.code.lowercase() to IetfLang.NubianLanguages,
        IetfLang.ClassicalNewariOldNewariClassicalNepalBhasa.code.lowercase() to IetfLang.ClassicalNewariOldNewariClassicalNepalBhasa,
        IetfLang.ChichewaChewaNyanja.code.lowercase() to IetfLang.ChichewaChewaNyanja,
        IetfLang.Nyamwezi.code.lowercase() to IetfLang.Nyamwezi,
        IetfLang.Nyankole.code.lowercase() to IetfLang.Nyankole,
            IetfLang.Nyankole.UG.code.lowercase() to IetfLang.Nyankole.UG,
        IetfLang.Nyoro.code.lowercase() to IetfLang.Nyoro,
        IetfLang.Nzima.code.lowercase() to IetfLang.Nzima,
        IetfLang.OccitanPost1500Provencal.code.lowercase() to IetfLang.OccitanPost1500Provencal,
        IetfLang.Ojibwa.code.lowercase() to IetfLang.Ojibwa,
        IetfLang.Oriya.code.lowercase() to IetfLang.Oriya,
            IetfLang.Oriya.IN.code.lowercase() to IetfLang.Oriya.IN,
        IetfLang.Oromo.code.lowercase() to IetfLang.Oromo,
            IetfLang.Oromo.ET.code.lowercase() to IetfLang.Oromo.ET,
            IetfLang.Oromo.KE.code.lowercase() to IetfLang.Oromo.KE,
        IetfLang.Osage.code.lowercase() to IetfLang.Osage,
        IetfLang.OssetianOssetic.code.lowercase() to IetfLang.OssetianOssetic,
            IetfLang.OssetianOssetic.GE.code.lowercase() to IetfLang.OssetianOssetic.GE,
            IetfLang.OssetianOssetic.RU.code.lowercase() to IetfLang.OssetianOssetic.RU,
        IetfLang.TurkishOttoman15001928.code.lowercase() to IetfLang.TurkishOttoman15001928,
        IetfLang.OtomianLanguages.code.lowercase() to IetfLang.OtomianLanguages,
        IetfLang.PapuanLanguages.code.lowercase() to IetfLang.PapuanLanguages,
        IetfLang.Pangasinan.code.lowercase() to IetfLang.Pangasinan,
        IetfLang.Pahlavi.code.lowercase() to IetfLang.Pahlavi,
        IetfLang.PampangaKapampangan.code.lowercase() to IetfLang.PampangaKapampangan,
        IetfLang.PanjabiPunjabi.code.lowercase() to IetfLang.PanjabiPunjabi,
            IetfLang.PanjabiPunjabi.Arab.code.lowercase() to IetfLang.PanjabiPunjabi.Arab,
                IetfLang.PanjabiPunjabi.Arab.PK.code.lowercase() to IetfLang.PanjabiPunjabi.Arab.PK,
            IetfLang.PanjabiPunjabi.Guru.code.lowercase() to IetfLang.PanjabiPunjabi.Guru,
                IetfLang.PanjabiPunjabi.Guru.IN.code.lowercase() to IetfLang.PanjabiPunjabi.Guru.IN,
        IetfLang.Papiamento.code.lowercase() to IetfLang.Papiamento,
        IetfLang.Palauan.code.lowercase() to IetfLang.Palauan,
        IetfLang.PersianOldCa_600400B_C_.code.lowercase() to IetfLang.PersianOldCa_600400B_C_,
        IetfLang.Persian.code.lowercase() to IetfLang.Persian,
            IetfLang.Persian.AF.code.lowercase() to IetfLang.Persian.AF,
            IetfLang.Persian.IR.code.lowercase() to IetfLang.Persian.IR,
        IetfLang.PhilippineLanguages.code.lowercase() to IetfLang.PhilippineLanguages,
        IetfLang.Phoenician.code.lowercase() to IetfLang.Phoenician,
        IetfLang.Pali.code.lowercase() to IetfLang.Pali,
        IetfLang.Polish.code.lowercase() to IetfLang.Polish,
            IetfLang.Polish.PL.code.lowercase() to IetfLang.Polish.PL,
        IetfLang.Pohnpeian.code.lowercase() to IetfLang.Pohnpeian,
        IetfLang.Portuguese.code.lowercase() to IetfLang.Portuguese,
            IetfLang.Portuguese.AO.code.lowercase() to IetfLang.Portuguese.AO,
            IetfLang.Portuguese.BR.code.lowercase() to IetfLang.Portuguese.BR,
            IetfLang.Portuguese.CH.code.lowercase() to IetfLang.Portuguese.CH,
            IetfLang.Portuguese.CV.code.lowercase() to IetfLang.Portuguese.CV,
            IetfLang.Portuguese.GQ.code.lowercase() to IetfLang.Portuguese.GQ,
            IetfLang.Portuguese.GW.code.lowercase() to IetfLang.Portuguese.GW,
            IetfLang.Portuguese.LU.code.lowercase() to IetfLang.Portuguese.LU,
            IetfLang.Portuguese.MO.code.lowercase() to IetfLang.Portuguese.MO,
            IetfLang.Portuguese.MZ.code.lowercase() to IetfLang.Portuguese.MZ,
            IetfLang.Portuguese.PT.code.lowercase() to IetfLang.Portuguese.PT,
            IetfLang.Portuguese.ST.code.lowercase() to IetfLang.Portuguese.ST,
            IetfLang.Portuguese.TL.code.lowercase() to IetfLang.Portuguese.TL,
        IetfLang.PrakritLanguages.code.lowercase() to IetfLang.PrakritLanguages,
        IetfLang.ProvencalOldTo1500.code.lowercase() to IetfLang.ProvencalOldTo1500,
        IetfLang.PushtoPashto.code.lowercase() to IetfLang.PushtoPashto,
            IetfLang.PushtoPashto.AF.code.lowercase() to IetfLang.PushtoPashto.AF,
        IetfLang.ReservedForLocalUse.code.lowercase() to IetfLang.ReservedForLocalUse,
        IetfLang.Quechua.code.lowercase() to IetfLang.Quechua,
            IetfLang.Quechua.BO.code.lowercase() to IetfLang.Quechua.BO,
            IetfLang.Quechua.EC.code.lowercase() to IetfLang.Quechua.EC,
            IetfLang.Quechua.PE.code.lowercase() to IetfLang.Quechua.PE,
        IetfLang.Rajasthani.code.lowercase() to IetfLang.Rajasthani,
        IetfLang.Rapanui.code.lowercase() to IetfLang.Rapanui,
        IetfLang.RarotonganCookIslandsMaori.code.lowercase() to IetfLang.RarotonganCookIslandsMaori,
        IetfLang.RomanceLanguages.code.lowercase() to IetfLang.RomanceLanguages,
        IetfLang.Romansh.code.lowercase() to IetfLang.Romansh,
            IetfLang.Romansh.CH.code.lowercase() to IetfLang.Romansh.CH,
        IetfLang.Romany.code.lowercase() to IetfLang.Romany,
        IetfLang.RomanianMoldavianMoldovan.code.lowercase() to IetfLang.RomanianMoldavianMoldovan,
            IetfLang.RomanianMoldavianMoldovan.MD.code.lowercase() to IetfLang.RomanianMoldavianMoldovan.MD,
            IetfLang.RomanianMoldavianMoldovan.RO.code.lowercase() to IetfLang.RomanianMoldavianMoldovan.RO,
        IetfLang.Rundi.code.lowercase() to IetfLang.Rundi,
            IetfLang.Rundi.BI.code.lowercase() to IetfLang.Rundi.BI,
        IetfLang.AromanianArumanianMacedoRomanian.code.lowercase() to IetfLang.AromanianArumanianMacedoRomanian,
        IetfLang.Russian.code.lowercase() to IetfLang.Russian,
            IetfLang.Russian.BY.code.lowercase() to IetfLang.Russian.BY,
            IetfLang.Russian.KG.code.lowercase() to IetfLang.Russian.KG,
            IetfLang.Russian.KZ.code.lowercase() to IetfLang.Russian.KZ,
            IetfLang.Russian.MD.code.lowercase() to IetfLang.Russian.MD,
            IetfLang.Russian.RU.code.lowercase() to IetfLang.Russian.RU,
            IetfLang.Russian.UA.code.lowercase() to IetfLang.Russian.UA,
        IetfLang.Sandawe.code.lowercase() to IetfLang.Sandawe,
        IetfLang.Sango.code.lowercase() to IetfLang.Sango,
            IetfLang.Sango.CF.code.lowercase() to IetfLang.Sango.CF,
        IetfLang.Yakut.code.lowercase() to IetfLang.Yakut,
            IetfLang.Yakut.RU.code.lowercase() to IetfLang.Yakut.RU,
        IetfLang.SouthAmericanIndianOther.code.lowercase() to IetfLang.SouthAmericanIndianOther,
        IetfLang.SalishanLanguages.code.lowercase() to IetfLang.SalishanLanguages,
        IetfLang.SamaritanAramaic.code.lowercase() to IetfLang.SamaritanAramaic,
        IetfLang.Sanskrit.code.lowercase() to IetfLang.Sanskrit,
        IetfLang.Sasak.code.lowercase() to IetfLang.Sasak,
        IetfLang.Santali.code.lowercase() to IetfLang.Santali,
        IetfLang.Sicilian.code.lowercase() to IetfLang.Sicilian,
        IetfLang.Scots.code.lowercase() to IetfLang.Scots,
        IetfLang.Selkup.code.lowercase() to IetfLang.Selkup,
        IetfLang.SemiticLanguages.code.lowercase() to IetfLang.SemiticLanguages,
        IetfLang.IrishOldTo900.code.lowercase() to IetfLang.IrishOldTo900,
        IetfLang.SignLanguages.code.lowercase() to IetfLang.SignLanguages,
        IetfLang.Shan.code.lowercase() to IetfLang.Shan,
        IetfLang.Sidamo.code.lowercase() to IetfLang.Sidamo,
        IetfLang.SinhalaSinhalese.code.lowercase() to IetfLang.SinhalaSinhalese,
            IetfLang.SinhalaSinhalese.LK.code.lowercase() to IetfLang.SinhalaSinhalese.LK,
        IetfLang.SiouanLanguages.code.lowercase() to IetfLang.SiouanLanguages,
        IetfLang.SinoTibetanLanguages.code.lowercase() to IetfLang.SinoTibetanLanguages,
        IetfLang.SlavicLanguages.code.lowercase() to IetfLang.SlavicLanguages,
        IetfLang.Slovak.code.lowercase() to IetfLang.Slovak,
            IetfLang.Slovak.SK.code.lowercase() to IetfLang.Slovak.SK,
        IetfLang.Slovenian.code.lowercase() to IetfLang.Slovenian,
            IetfLang.Slovenian.SI.code.lowercase() to IetfLang.Slovenian.SI,
        IetfLang.SouthernSami.code.lowercase() to IetfLang.SouthernSami,
        IetfLang.NorthernSami.code.lowercase() to IetfLang.NorthernSami,
            IetfLang.NorthernSami.FI.code.lowercase() to IetfLang.NorthernSami.FI,
            IetfLang.NorthernSami.NO.code.lowercase() to IetfLang.NorthernSami.NO,
            IetfLang.NorthernSami.SE.code.lowercase() to IetfLang.NorthernSami.SE,
        IetfLang.SamiLanguages.code.lowercase() to IetfLang.SamiLanguages,
        IetfLang.LuleSami.code.lowercase() to IetfLang.LuleSami,
        IetfLang.InariSami.code.lowercase() to IetfLang.InariSami,
            IetfLang.InariSami.FI.code.lowercase() to IetfLang.InariSami.FI,
        IetfLang.Samoan.code.lowercase() to IetfLang.Samoan,
        IetfLang.SkoltSami.code.lowercase() to IetfLang.SkoltSami,
        IetfLang.Shona.code.lowercase() to IetfLang.Shona,
            IetfLang.Shona.ZW.code.lowercase() to IetfLang.Shona.ZW,
        IetfLang.Sindhi.code.lowercase() to IetfLang.Sindhi,
        IetfLang.Soninke.code.lowercase() to IetfLang.Soninke,
        IetfLang.Sogdian.code.lowercase() to IetfLang.Sogdian,
        IetfLang.Somali.code.lowercase() to IetfLang.Somali,
            IetfLang.Somali.DJ.code.lowercase() to IetfLang.Somali.DJ,
            IetfLang.Somali.ET.code.lowercase() to IetfLang.Somali.ET,
            IetfLang.Somali.KE.code.lowercase() to IetfLang.Somali.KE,
            IetfLang.Somali.SO.code.lowercase() to IetfLang.Somali.SO,
        IetfLang.SonghaiLanguages.code.lowercase() to IetfLang.SonghaiLanguages,
        IetfLang.SothoSouthern.code.lowercase() to IetfLang.SothoSouthern,
        IetfLang.SpanishCastilian.code.lowercase() to IetfLang.SpanishCastilian,
            IetfLang.SpanishCastilian.L419.code.lowercase() to IetfLang.SpanishCastilian.L419,
            IetfLang.SpanishCastilian.AR.code.lowercase() to IetfLang.SpanishCastilian.AR,
            IetfLang.SpanishCastilian.BO.code.lowercase() to IetfLang.SpanishCastilian.BO,
            IetfLang.SpanishCastilian.BR.code.lowercase() to IetfLang.SpanishCastilian.BR,
            IetfLang.SpanishCastilian.BZ.code.lowercase() to IetfLang.SpanishCastilian.BZ,
            IetfLang.SpanishCastilian.CL.code.lowercase() to IetfLang.SpanishCastilian.CL,
            IetfLang.SpanishCastilian.CO.code.lowercase() to IetfLang.SpanishCastilian.CO,
            IetfLang.SpanishCastilian.CR.code.lowercase() to IetfLang.SpanishCastilian.CR,
            IetfLang.SpanishCastilian.CU.code.lowercase() to IetfLang.SpanishCastilian.CU,
            IetfLang.SpanishCastilian.DO.code.lowercase() to IetfLang.SpanishCastilian.DO,
            IetfLang.SpanishCastilian.EA.code.lowercase() to IetfLang.SpanishCastilian.EA,
            IetfLang.SpanishCastilian.EC.code.lowercase() to IetfLang.SpanishCastilian.EC,
            IetfLang.SpanishCastilian.ES.code.lowercase() to IetfLang.SpanishCastilian.ES,
            IetfLang.SpanishCastilian.GQ.code.lowercase() to IetfLang.SpanishCastilian.GQ,
            IetfLang.SpanishCastilian.GT.code.lowercase() to IetfLang.SpanishCastilian.GT,
            IetfLang.SpanishCastilian.HN.code.lowercase() to IetfLang.SpanishCastilian.HN,
            IetfLang.SpanishCastilian.IC.code.lowercase() to IetfLang.SpanishCastilian.IC,
            IetfLang.SpanishCastilian.MX.code.lowercase() to IetfLang.SpanishCastilian.MX,
            IetfLang.SpanishCastilian.NI.code.lowercase() to IetfLang.SpanishCastilian.NI,
            IetfLang.SpanishCastilian.PA.code.lowercase() to IetfLang.SpanishCastilian.PA,
            IetfLang.SpanishCastilian.PE.code.lowercase() to IetfLang.SpanishCastilian.PE,
            IetfLang.SpanishCastilian.PH.code.lowercase() to IetfLang.SpanishCastilian.PH,
            IetfLang.SpanishCastilian.PR.code.lowercase() to IetfLang.SpanishCastilian.PR,
            IetfLang.SpanishCastilian.PY.code.lowercase() to IetfLang.SpanishCastilian.PY,
            IetfLang.SpanishCastilian.SV.code.lowercase() to IetfLang.SpanishCastilian.SV,
            IetfLang.SpanishCastilian.US.code.lowercase() to IetfLang.SpanishCastilian.US,
            IetfLang.SpanishCastilian.UY.code.lowercase() to IetfLang.SpanishCastilian.UY,
            IetfLang.SpanishCastilian.VE.code.lowercase() to IetfLang.SpanishCastilian.VE,
        IetfLang.Sardinian.code.lowercase() to IetfLang.Sardinian,
        IetfLang.SrananTongo.code.lowercase() to IetfLang.SrananTongo,
        IetfLang.Serbian.code.lowercase() to IetfLang.Serbian,
            IetfLang.Serbian.Cyrl.code.lowercase() to IetfLang.Serbian.Cyrl,
                IetfLang.Serbian.Cyrl.BA.code.lowercase() to IetfLang.Serbian.Cyrl.BA,
                IetfLang.Serbian.Cyrl.ME.code.lowercase() to IetfLang.Serbian.Cyrl.ME,
                IetfLang.Serbian.Cyrl.RS.code.lowercase() to IetfLang.Serbian.Cyrl.RS,
                IetfLang.Serbian.Cyrl.XK.code.lowercase() to IetfLang.Serbian.Cyrl.XK,
            IetfLang.Serbian.Latn.code.lowercase() to IetfLang.Serbian.Latn,
                IetfLang.Serbian.Latn.BA.code.lowercase() to IetfLang.Serbian.Latn.BA,
                IetfLang.Serbian.Latn.ME.code.lowercase() to IetfLang.Serbian.Latn.ME,
                IetfLang.Serbian.Latn.RS.code.lowercase() to IetfLang.Serbian.Latn.RS,
                IetfLang.Serbian.Latn.XK.code.lowercase() to IetfLang.Serbian.Latn.XK,
        IetfLang.Serer.code.lowercase() to IetfLang.Serer,
        IetfLang.NiloSaharanLanguages.code.lowercase() to IetfLang.NiloSaharanLanguages,
        IetfLang.Swati.code.lowercase() to IetfLang.Swati,
        IetfLang.Sukuma.code.lowercase() to IetfLang.Sukuma,
        IetfLang.Sundanese.code.lowercase() to IetfLang.Sundanese,
        IetfLang.Susu.code.lowercase() to IetfLang.Susu,
        IetfLang.Sumerian.code.lowercase() to IetfLang.Sumerian,
        IetfLang.Swahili.code.lowercase() to IetfLang.Swahili,
            IetfLang.Swahili.CD.code.lowercase() to IetfLang.Swahili.CD,
            IetfLang.Swahili.KE.code.lowercase() to IetfLang.Swahili.KE,
            IetfLang.Swahili.TZ.code.lowercase() to IetfLang.Swahili.TZ,
            IetfLang.Swahili.UG.code.lowercase() to IetfLang.Swahili.UG,
        IetfLang.Swedish.code.lowercase() to IetfLang.Swedish,
            IetfLang.Swedish.AX.code.lowercase() to IetfLang.Swedish.AX,
            IetfLang.Swedish.FI.code.lowercase() to IetfLang.Swedish.FI,
            IetfLang.Swedish.SE.code.lowercase() to IetfLang.Swedish.SE,
        IetfLang.ClassicalSyriac.code.lowercase() to IetfLang.ClassicalSyriac,
        IetfLang.Syriac.code.lowercase() to IetfLang.Syriac,
        IetfLang.Tahitian.code.lowercase() to IetfLang.Tahitian,
        IetfLang.TaiLanguages.code.lowercase() to IetfLang.TaiLanguages,
        IetfLang.Tamil.code.lowercase() to IetfLang.Tamil,
            IetfLang.Tamil.IN.code.lowercase() to IetfLang.Tamil.IN,
            IetfLang.Tamil.LK.code.lowercase() to IetfLang.Tamil.LK,
            IetfLang.Tamil.MY.code.lowercase() to IetfLang.Tamil.MY,
            IetfLang.Tamil.SG.code.lowercase() to IetfLang.Tamil.SG,
        IetfLang.Tatar.code.lowercase() to IetfLang.Tatar,
        IetfLang.Telugu.code.lowercase() to IetfLang.Telugu,
            IetfLang.Telugu.IN.code.lowercase() to IetfLang.Telugu.IN,
        IetfLang.Timne.code.lowercase() to IetfLang.Timne,
        IetfLang.Tereno.code.lowercase() to IetfLang.Tereno,
        IetfLang.Tetum.code.lowercase() to IetfLang.Tetum,
        IetfLang.Tajik.code.lowercase() to IetfLang.Tajik,
        IetfLang.Tagalog.code.lowercase() to IetfLang.Tagalog,
        IetfLang.Thai.code.lowercase() to IetfLang.Thai,
            IetfLang.Thai.TH.code.lowercase() to IetfLang.Thai.TH,
        IetfLang.Tibetan.code.lowercase() to IetfLang.Tibetan,
            IetfLang.Tibetan.CN.code.lowercase() to IetfLang.Tibetan.CN,
            IetfLang.Tibetan.IN.code.lowercase() to IetfLang.Tibetan.IN,
        IetfLang.Tigre.code.lowercase() to IetfLang.Tigre,
        IetfLang.Tigrinya.code.lowercase() to IetfLang.Tigrinya,
            IetfLang.Tigrinya.ER.code.lowercase() to IetfLang.Tigrinya.ER,
            IetfLang.Tigrinya.ET.code.lowercase() to IetfLang.Tigrinya.ET,
        IetfLang.Tiv.code.lowercase() to IetfLang.Tiv,
        IetfLang.Tokelau.code.lowercase() to IetfLang.Tokelau,
        IetfLang.KlingonTlhInganHol.code.lowercase() to IetfLang.KlingonTlhInganHol,
        IetfLang.Tlingit.code.lowercase() to IetfLang.Tlingit,
        IetfLang.Tamashek.code.lowercase() to IetfLang.Tamashek,
        IetfLang.TongaNyasa.code.lowercase() to IetfLang.TongaNyasa,
        IetfLang.TongaTongaIslands.code.lowercase() to IetfLang.TongaTongaIslands,
            IetfLang.TongaTongaIslands.TO.code.lowercase() to IetfLang.TongaTongaIslands.TO,
        IetfLang.TokPisin.code.lowercase() to IetfLang.TokPisin,
        IetfLang.Tsimshian.code.lowercase() to IetfLang.Tsimshian,
        IetfLang.Tswana.code.lowercase() to IetfLang.Tswana,
        IetfLang.Tsonga.code.lowercase() to IetfLang.Tsonga,
        IetfLang.Turkmen.code.lowercase() to IetfLang.Turkmen,
            IetfLang.Turkmen.TM.code.lowercase() to IetfLang.Turkmen.TM,
        IetfLang.Tumbuka.code.lowercase() to IetfLang.Tumbuka,
        IetfLang.TupiLanguages.code.lowercase() to IetfLang.TupiLanguages,
        IetfLang.Turkish.code.lowercase() to IetfLang.Turkish,
            IetfLang.Turkish.CY.code.lowercase() to IetfLang.Turkish.CY,
            IetfLang.Turkish.TR.code.lowercase() to IetfLang.Turkish.TR,
        IetfLang.AltaicLanguages.code.lowercase() to IetfLang.AltaicLanguages,
        IetfLang.Tuvalu.code.lowercase() to IetfLang.Tuvalu,
        IetfLang.Twi.code.lowercase() to IetfLang.Twi,
        IetfLang.Tuvinian.code.lowercase() to IetfLang.Tuvinian,
        IetfLang.Udmurt.code.lowercase() to IetfLang.Udmurt,
        IetfLang.Ugaritic.code.lowercase() to IetfLang.Ugaritic,
        IetfLang.UighurUyghur.code.lowercase() to IetfLang.UighurUyghur,
            IetfLang.UighurUyghur.CN.code.lowercase() to IetfLang.UighurUyghur.CN,
        IetfLang.Ukrainian.code.lowercase() to IetfLang.Ukrainian,
            IetfLang.Ukrainian.UA.code.lowercase() to IetfLang.Ukrainian.UA,
        IetfLang.Umbundu.code.lowercase() to IetfLang.Umbundu,
        IetfLang.Undetermined.code.lowercase() to IetfLang.Undetermined,
        IetfLang.Urdu.code.lowercase() to IetfLang.Urdu,
            IetfLang.Urdu.IN.code.lowercase() to IetfLang.Urdu.IN,
            IetfLang.Urdu.PK.code.lowercase() to IetfLang.Urdu.PK,
        IetfLang.Uzbek.code.lowercase() to IetfLang.Uzbek,
            IetfLang.Uzbek.Arab.code.lowercase() to IetfLang.Uzbek.Arab,
                IetfLang.Uzbek.Arab.AF.code.lowercase() to IetfLang.Uzbek.Arab.AF,
            IetfLang.Uzbek.Cyrl.code.lowercase() to IetfLang.Uzbek.Cyrl,
                IetfLang.Uzbek.Cyrl.UZ.code.lowercase() to IetfLang.Uzbek.Cyrl.UZ,
            IetfLang.Uzbek.Latn.code.lowercase() to IetfLang.Uzbek.Latn,
                IetfLang.Uzbek.Latn.UZ.code.lowercase() to IetfLang.Uzbek.Latn.UZ,
        IetfLang.Vai.code.lowercase() to IetfLang.Vai,
            IetfLang.Vai.Latn.code.lowercase() to IetfLang.Vai.Latn,
                IetfLang.Vai.Latn.LR.code.lowercase() to IetfLang.Vai.Latn.LR,
            IetfLang.Vai.Vaii.code.lowercase() to IetfLang.Vai.Vaii,
                IetfLang.Vai.Vaii.LR.code.lowercase() to IetfLang.Vai.Vaii.LR,
        IetfLang.Venda.code.lowercase() to IetfLang.Venda,
        IetfLang.Vietnamese.code.lowercase() to IetfLang.Vietnamese,
            IetfLang.Vietnamese.VN.code.lowercase() to IetfLang.Vietnamese.VN,
        IetfLang.Volapuk.code.lowercase() to IetfLang.Volapuk,
            IetfLang.Volapuk.L001.code.lowercase() to IetfLang.Volapuk.L001,
        IetfLang.Votic.code.lowercase() to IetfLang.Votic,
        IetfLang.WakashanLanguages.code.lowercase() to IetfLang.WakashanLanguages,
        IetfLang.Walamo.code.lowercase() to IetfLang.Walamo,
        IetfLang.Waray.code.lowercase() to IetfLang.Waray,
        IetfLang.Washo.code.lowercase() to IetfLang.Washo,
        IetfLang.Welsh.code.lowercase() to IetfLang.Welsh,
            IetfLang.Welsh.GB.code.lowercase() to IetfLang.Welsh.GB,
        IetfLang.SorbianLanguages.code.lowercase() to IetfLang.SorbianLanguages,
        IetfLang.Walloon.code.lowercase() to IetfLang.Walloon,
        IetfLang.Wolof.code.lowercase() to IetfLang.Wolof,
        IetfLang.KalmykOirat.code.lowercase() to IetfLang.KalmykOirat,
        IetfLang.Xhosa.code.lowercase() to IetfLang.Xhosa,
        IetfLang.Yao.code.lowercase() to IetfLang.Yao,
        IetfLang.Yapese.code.lowercase() to IetfLang.Yapese,
        IetfLang.Yiddish.code.lowercase() to IetfLang.Yiddish,
            IetfLang.Yiddish.L001.code.lowercase() to IetfLang.Yiddish.L001,
        IetfLang.Yoruba.code.lowercase() to IetfLang.Yoruba,
            IetfLang.Yoruba.BJ.code.lowercase() to IetfLang.Yoruba.BJ,
            IetfLang.Yoruba.NG.code.lowercase() to IetfLang.Yoruba.NG,
        IetfLang.YupikLanguages.code.lowercase() to IetfLang.YupikLanguages,
        IetfLang.Zapotec.code.lowercase() to IetfLang.Zapotec,
        IetfLang.BlissymbolsBlissymbolicsBliss.code.lowercase() to IetfLang.BlissymbolsBlissymbolicsBliss,
        IetfLang.Zenaga.code.lowercase() to IetfLang.Zenaga,
        IetfLang.StandardMoroccanTamazight.code.lowercase() to IetfLang.StandardMoroccanTamazight,
            IetfLang.StandardMoroccanTamazight.MA.code.lowercase() to IetfLang.StandardMoroccanTamazight.MA,
        IetfLang.ZhuangChuang.code.lowercase() to IetfLang.ZhuangChuang,
        IetfLang.ZandeLanguages.code.lowercase() to IetfLang.ZandeLanguages,
        IetfLang.Zulu.code.lowercase() to IetfLang.Zulu,
            IetfLang.Zulu.ZA.code.lowercase() to IetfLang.Zulu.ZA,
        IetfLang.Zuni.code.lowercase() to IetfLang.Zuni,
        IetfLang.NoLinguisticContentNotApplicable.code.lowercase() to IetfLang.NoLinguisticContentNotApplicable,
        IetfLang.ZazaDimiliDimliKirdkiKirmanjkiZazaki.code.lowercase() to IetfLang.ZazaDimiliDimliKirdkiKirmanjkiZazaki
    )
}
val knownLanguageCodes: List<IetfLang> by lazy {
    knownLanguageCodesMap.values.toList()
}

fun String.asIetfLang(): IetfLang {
    return knownLanguageCodesMap[this] ?: IetfLang.UnknownIetfLang(this)
}
fun String.asIetfLangCaseInsensitive(): IetfLang {
    return knownLanguageCodesMapByLowerCasedKeys[this.lowercase()] ?: IetfLang.UnknownIetfLang(this)
}
@Deprecated("Renamed", ReplaceWith("this.asIetfLang()", "dev.inmo.micro_utils.language_codes.asIetfLang"))
fun String.asIetfLanguageCode(): IetfLang = asIetfLang()

fun convertToIetfLang(code: String) = code.asIetfLang()
fun convertToIetfLangCaseInsensitive(code: String) = code.asIetfLangCaseInsensitive()
@Deprecated("Renamed", ReplaceWith("convertToIetfLang(code)", "dev.inmo.micro_utils.language_codes.convertToIetfLang"))
fun convertToIetfLanguageCode(code: String) = convertToIetfLang(code)

fun IetfLang(code: String) = code.asIetfLang()
fun IetfLangCaseInsensitive(code: String) = code.asIetfLangCaseInsensitive()
@Deprecated("Renamed", ReplaceWith("IetfLang(code)", "dev.inmo.micro_utils.language_codes.IetfLang"))
fun IetfLanguageCode(code: String) = IetfLang(code)
