package dev.inmo.micro_utils.language_codes

fun String.asIetfLanguageCode(): IetfLanguageCode {
    return when (this) {
        IetfLanguageCode.Afar.code -> IetfLanguageCode.Afar
        IetfLanguageCode.Abkhazian.code -> IetfLanguageCode.Abkhazian
        IetfLanguageCode.Avestan.code -> IetfLanguageCode.Avestan
        IetfLanguageCode.Afrikaans.code -> IetfLanguageCode.Afrikaans
        IetfLanguageCode.Afrikaans.NA.code -> IetfLanguageCode.Afrikaans.NA
        IetfLanguageCode.Afrikaans.ZA.code -> IetfLanguageCode.Afrikaans.ZA
        IetfLanguageCode.Akan.code -> IetfLanguageCode.Akan
        IetfLanguageCode.Akan.GH.code -> IetfLanguageCode.Akan.GH
        IetfLanguageCode.Amharic.code -> IetfLanguageCode.Amharic
        IetfLanguageCode.Amharic.ET.code -> IetfLanguageCode.Amharic.ET
        IetfLanguageCode.Aragonese.code -> IetfLanguageCode.Aragonese
        IetfLanguageCode.Arabic.code -> IetfLanguageCode.Arabic
        IetfLanguageCode.Arabic.L001.code -> IetfLanguageCode.Arabic.L001
        IetfLanguageCode.Arabic.AE.code -> IetfLanguageCode.Arabic.AE
        IetfLanguageCode.Arabic.BH.code -> IetfLanguageCode.Arabic.BH
        IetfLanguageCode.Arabic.DJ.code -> IetfLanguageCode.Arabic.DJ
        IetfLanguageCode.Arabic.DZ.code -> IetfLanguageCode.Arabic.DZ
        IetfLanguageCode.Arabic.EG.code -> IetfLanguageCode.Arabic.EG
        IetfLanguageCode.Arabic.EH.code -> IetfLanguageCode.Arabic.EH
        IetfLanguageCode.Arabic.ER.code -> IetfLanguageCode.Arabic.ER
        IetfLanguageCode.Arabic.IL.code -> IetfLanguageCode.Arabic.IL
        IetfLanguageCode.Arabic.IQ.code -> IetfLanguageCode.Arabic.IQ
        IetfLanguageCode.Arabic.JO.code -> IetfLanguageCode.Arabic.JO
        IetfLanguageCode.Arabic.KM.code -> IetfLanguageCode.Arabic.KM
        IetfLanguageCode.Arabic.KW.code -> IetfLanguageCode.Arabic.KW
        IetfLanguageCode.Arabic.LB.code -> IetfLanguageCode.Arabic.LB
        IetfLanguageCode.Arabic.LY.code -> IetfLanguageCode.Arabic.LY
        IetfLanguageCode.Arabic.MA.code -> IetfLanguageCode.Arabic.MA
        IetfLanguageCode.Arabic.MR.code -> IetfLanguageCode.Arabic.MR
        IetfLanguageCode.Arabic.OM.code -> IetfLanguageCode.Arabic.OM
        IetfLanguageCode.Arabic.PS.code -> IetfLanguageCode.Arabic.PS
        IetfLanguageCode.Arabic.QA.code -> IetfLanguageCode.Arabic.QA
        IetfLanguageCode.Arabic.SA.code -> IetfLanguageCode.Arabic.SA
        IetfLanguageCode.Arabic.SD.code -> IetfLanguageCode.Arabic.SD
        IetfLanguageCode.Arabic.SO.code -> IetfLanguageCode.Arabic.SO
        IetfLanguageCode.Arabic.SS.code -> IetfLanguageCode.Arabic.SS
        IetfLanguageCode.Arabic.SY.code -> IetfLanguageCode.Arabic.SY
        IetfLanguageCode.Arabic.TD.code -> IetfLanguageCode.Arabic.TD
        IetfLanguageCode.Arabic.TN.code -> IetfLanguageCode.Arabic.TN
        IetfLanguageCode.Arabic.YE.code -> IetfLanguageCode.Arabic.YE
        IetfLanguageCode.Assamese.code -> IetfLanguageCode.Assamese
        IetfLanguageCode.Assamese.IN.code -> IetfLanguageCode.Assamese.IN
        IetfLanguageCode.Avaric.code -> IetfLanguageCode.Avaric
        IetfLanguageCode.Aymara.code -> IetfLanguageCode.Aymara
        IetfLanguageCode.Azerbaijani.code -> IetfLanguageCode.Azerbaijani
        IetfLanguageCode.Azerbaijani.Cyrl.code -> IetfLanguageCode.Azerbaijani.Cyrl
        IetfLanguageCode.Azerbaijani.Cyrl.AZ.code -> IetfLanguageCode.Azerbaijani.Cyrl.AZ
        IetfLanguageCode.Azerbaijani.Latn.code -> IetfLanguageCode.Azerbaijani.Latn
        IetfLanguageCode.Azerbaijani.Latn.AZ.code -> IetfLanguageCode.Azerbaijani.Latn.AZ
        IetfLanguageCode.Bashkir.code -> IetfLanguageCode.Bashkir
        IetfLanguageCode.Belarusian.code -> IetfLanguageCode.Belarusian
        IetfLanguageCode.Belarusian.BY.code -> IetfLanguageCode.Belarusian.BY
        IetfLanguageCode.Bulgarian.code -> IetfLanguageCode.Bulgarian
        IetfLanguageCode.Bulgarian.BG.code -> IetfLanguageCode.Bulgarian.BG
        IetfLanguageCode.BihariLanguages.code -> IetfLanguageCode.BihariLanguages
        IetfLanguageCode.Bislama.code -> IetfLanguageCode.Bislama
        IetfLanguageCode.Bambara.code -> IetfLanguageCode.Bambara
        IetfLanguageCode.Bambara.ML.code -> IetfLanguageCode.Bambara.ML
        IetfLanguageCode.Bengali.code -> IetfLanguageCode.Bengali
        IetfLanguageCode.Bengali.BD.code -> IetfLanguageCode.Bengali.BD
        IetfLanguageCode.Bengali.IN.code -> IetfLanguageCode.Bengali.IN
        IetfLanguageCode.Tibetan.code -> IetfLanguageCode.Tibetan
        IetfLanguageCode.Tibetan.CN.code -> IetfLanguageCode.Tibetan.CN
        IetfLanguageCode.Tibetan.IN.code -> IetfLanguageCode.Tibetan.IN
        IetfLanguageCode.Breton.code -> IetfLanguageCode.Breton
        IetfLanguageCode.Breton.FR.code -> IetfLanguageCode.Breton.FR
        IetfLanguageCode.Bosnian.code -> IetfLanguageCode.Bosnian
        IetfLanguageCode.Bosnian.Cyrl.code -> IetfLanguageCode.Bosnian.Cyrl
        IetfLanguageCode.Bosnian.Cyrl.BA.code -> IetfLanguageCode.Bosnian.Cyrl.BA
        IetfLanguageCode.Bosnian.Latn.code -> IetfLanguageCode.Bosnian.Latn
        IetfLanguageCode.Bosnian.Latn.BA.code -> IetfLanguageCode.Bosnian.Latn.BA
        IetfLanguageCode.CatalanValencian.code -> IetfLanguageCode.CatalanValencian
        IetfLanguageCode.CatalanValencian.AD.code -> IetfLanguageCode.CatalanValencian.AD
        IetfLanguageCode.CatalanValencian.ES.code -> IetfLanguageCode.CatalanValencian.ES
        IetfLanguageCode.CatalanValencian.ES.VALENCIA.code -> IetfLanguageCode.CatalanValencian.ES.VALENCIA
        IetfLanguageCode.CatalanValencian.FR.code -> IetfLanguageCode.CatalanValencian.FR
        IetfLanguageCode.CatalanValencian.IT.code -> IetfLanguageCode.CatalanValencian.IT
        IetfLanguageCode.Chechen.code -> IetfLanguageCode.Chechen
        IetfLanguageCode.Chechen.RU.code -> IetfLanguageCode.Chechen.RU
        IetfLanguageCode.Chamorro.code -> IetfLanguageCode.Chamorro
        IetfLanguageCode.Corsican.code -> IetfLanguageCode.Corsican
        IetfLanguageCode.Cree.code -> IetfLanguageCode.Cree
        IetfLanguageCode.Czech.code -> IetfLanguageCode.Czech
        IetfLanguageCode.Czech.CZ.code -> IetfLanguageCode.Czech.CZ
        IetfLanguageCode.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.code -> IetfLanguageCode.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic
        IetfLanguageCode.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.RU.code -> IetfLanguageCode.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.RU
        IetfLanguageCode.Chuvash.code -> IetfLanguageCode.Chuvash
        IetfLanguageCode.Welsh.code -> IetfLanguageCode.Welsh
        IetfLanguageCode.Welsh.GB.code -> IetfLanguageCode.Welsh.GB
        IetfLanguageCode.Danish.code -> IetfLanguageCode.Danish
        IetfLanguageCode.Danish.DK.code -> IetfLanguageCode.Danish.DK
        IetfLanguageCode.Danish.GL.code -> IetfLanguageCode.Danish.GL
        IetfLanguageCode.German.code -> IetfLanguageCode.German
        IetfLanguageCode.German.AT.code -> IetfLanguageCode.German.AT
        IetfLanguageCode.German.BE.code -> IetfLanguageCode.German.BE
        IetfLanguageCode.German.CH.code -> IetfLanguageCode.German.CH
        IetfLanguageCode.German.DE.code -> IetfLanguageCode.German.DE
        IetfLanguageCode.German.IT.code -> IetfLanguageCode.German.IT
        IetfLanguageCode.German.LI.code -> IetfLanguageCode.German.LI
        IetfLanguageCode.German.LU.code -> IetfLanguageCode.German.LU
        IetfLanguageCode.DivehiDhivehiMaldivian.code -> IetfLanguageCode.DivehiDhivehiMaldivian
        IetfLanguageCode.Dzongkha.code -> IetfLanguageCode.Dzongkha
        IetfLanguageCode.Dzongkha.BT.code -> IetfLanguageCode.Dzongkha.BT
        IetfLanguageCode.Ewe.code -> IetfLanguageCode.Ewe
        IetfLanguageCode.Ewe.GH.code -> IetfLanguageCode.Ewe.GH
        IetfLanguageCode.Ewe.TG.code -> IetfLanguageCode.Ewe.TG
        IetfLanguageCode.GreekModern1453.code -> IetfLanguageCode.GreekModern1453
        IetfLanguageCode.GreekModern1453.CY.code -> IetfLanguageCode.GreekModern1453.CY
        IetfLanguageCode.GreekModern1453.GR.code -> IetfLanguageCode.GreekModern1453.GR
        IetfLanguageCode.English.code -> IetfLanguageCode.English
        IetfLanguageCode.English.L001.code -> IetfLanguageCode.English.L001
        IetfLanguageCode.English.L150.code -> IetfLanguageCode.English.L150
        IetfLanguageCode.English.AE.code -> IetfLanguageCode.English.AE
        IetfLanguageCode.English.AG.code -> IetfLanguageCode.English.AG
        IetfLanguageCode.English.AI.code -> IetfLanguageCode.English.AI
        IetfLanguageCode.English.AS.code -> IetfLanguageCode.English.AS
        IetfLanguageCode.English.AT.code -> IetfLanguageCode.English.AT
        IetfLanguageCode.English.AU.code -> IetfLanguageCode.English.AU
        IetfLanguageCode.English.BB.code -> IetfLanguageCode.English.BB
        IetfLanguageCode.English.BE.code -> IetfLanguageCode.English.BE
        IetfLanguageCode.English.BI.code -> IetfLanguageCode.English.BI
        IetfLanguageCode.English.BM.code -> IetfLanguageCode.English.BM
        IetfLanguageCode.English.BS.code -> IetfLanguageCode.English.BS
        IetfLanguageCode.English.BW.code -> IetfLanguageCode.English.BW
        IetfLanguageCode.English.BZ.code -> IetfLanguageCode.English.BZ
        IetfLanguageCode.English.CA.code -> IetfLanguageCode.English.CA
        IetfLanguageCode.English.CC.code -> IetfLanguageCode.English.CC
        IetfLanguageCode.English.CH.code -> IetfLanguageCode.English.CH
        IetfLanguageCode.English.CK.code -> IetfLanguageCode.English.CK
        IetfLanguageCode.English.CM.code -> IetfLanguageCode.English.CM
        IetfLanguageCode.English.CX.code -> IetfLanguageCode.English.CX
        IetfLanguageCode.English.CY.code -> IetfLanguageCode.English.CY
        IetfLanguageCode.English.DE.code -> IetfLanguageCode.English.DE
        IetfLanguageCode.English.DG.code -> IetfLanguageCode.English.DG
        IetfLanguageCode.English.DK.code -> IetfLanguageCode.English.DK
        IetfLanguageCode.English.DM.code -> IetfLanguageCode.English.DM
        IetfLanguageCode.English.ER.code -> IetfLanguageCode.English.ER
        IetfLanguageCode.English.FI.code -> IetfLanguageCode.English.FI
        IetfLanguageCode.English.FJ.code -> IetfLanguageCode.English.FJ
        IetfLanguageCode.English.FK.code -> IetfLanguageCode.English.FK
        IetfLanguageCode.English.FM.code -> IetfLanguageCode.English.FM
        IetfLanguageCode.English.GB.code -> IetfLanguageCode.English.GB
        IetfLanguageCode.English.GD.code -> IetfLanguageCode.English.GD
        IetfLanguageCode.English.GG.code -> IetfLanguageCode.English.GG
        IetfLanguageCode.English.GH.code -> IetfLanguageCode.English.GH
        IetfLanguageCode.English.GI.code -> IetfLanguageCode.English.GI
        IetfLanguageCode.English.GM.code -> IetfLanguageCode.English.GM
        IetfLanguageCode.English.GU.code -> IetfLanguageCode.English.GU
        IetfLanguageCode.English.GY.code -> IetfLanguageCode.English.GY
        IetfLanguageCode.English.HK.code -> IetfLanguageCode.English.HK
        IetfLanguageCode.English.IE.code -> IetfLanguageCode.English.IE
        IetfLanguageCode.English.IL.code -> IetfLanguageCode.English.IL
        IetfLanguageCode.English.IM.code -> IetfLanguageCode.English.IM
        IetfLanguageCode.English.IN.code -> IetfLanguageCode.English.IN
        IetfLanguageCode.English.IO.code -> IetfLanguageCode.English.IO
        IetfLanguageCode.English.JE.code -> IetfLanguageCode.English.JE
        IetfLanguageCode.English.JM.code -> IetfLanguageCode.English.JM
        IetfLanguageCode.English.KE.code -> IetfLanguageCode.English.KE
        IetfLanguageCode.English.KI.code -> IetfLanguageCode.English.KI
        IetfLanguageCode.English.KN.code -> IetfLanguageCode.English.KN
        IetfLanguageCode.English.KY.code -> IetfLanguageCode.English.KY
        IetfLanguageCode.English.LC.code -> IetfLanguageCode.English.LC
        IetfLanguageCode.English.LR.code -> IetfLanguageCode.English.LR
        IetfLanguageCode.English.LS.code -> IetfLanguageCode.English.LS
        IetfLanguageCode.English.MG.code -> IetfLanguageCode.English.MG
        IetfLanguageCode.English.MH.code -> IetfLanguageCode.English.MH
        IetfLanguageCode.English.MO.code -> IetfLanguageCode.English.MO
        IetfLanguageCode.English.MP.code -> IetfLanguageCode.English.MP
        IetfLanguageCode.English.MS.code -> IetfLanguageCode.English.MS
        IetfLanguageCode.English.MT.code -> IetfLanguageCode.English.MT
        IetfLanguageCode.English.MU.code -> IetfLanguageCode.English.MU
        IetfLanguageCode.English.MW.code -> IetfLanguageCode.English.MW
        IetfLanguageCode.English.MY.code -> IetfLanguageCode.English.MY
        IetfLanguageCode.English.NA.code -> IetfLanguageCode.English.NA
        IetfLanguageCode.English.NF.code -> IetfLanguageCode.English.NF
        IetfLanguageCode.English.NG.code -> IetfLanguageCode.English.NG
        IetfLanguageCode.English.NL.code -> IetfLanguageCode.English.NL
        IetfLanguageCode.English.NR.code -> IetfLanguageCode.English.NR
        IetfLanguageCode.English.NU.code -> IetfLanguageCode.English.NU
        IetfLanguageCode.English.NZ.code -> IetfLanguageCode.English.NZ
        IetfLanguageCode.English.PG.code -> IetfLanguageCode.English.PG
        IetfLanguageCode.English.PH.code -> IetfLanguageCode.English.PH
        IetfLanguageCode.English.PK.code -> IetfLanguageCode.English.PK
        IetfLanguageCode.English.PN.code -> IetfLanguageCode.English.PN
        IetfLanguageCode.English.PR.code -> IetfLanguageCode.English.PR
        IetfLanguageCode.English.PW.code -> IetfLanguageCode.English.PW
        IetfLanguageCode.English.RW.code -> IetfLanguageCode.English.RW
        IetfLanguageCode.English.SB.code -> IetfLanguageCode.English.SB
        IetfLanguageCode.English.SC.code -> IetfLanguageCode.English.SC
        IetfLanguageCode.English.SD.code -> IetfLanguageCode.English.SD
        IetfLanguageCode.English.SE.code -> IetfLanguageCode.English.SE
        IetfLanguageCode.English.SG.code -> IetfLanguageCode.English.SG
        IetfLanguageCode.English.SH.code -> IetfLanguageCode.English.SH
        IetfLanguageCode.English.SI.code -> IetfLanguageCode.English.SI
        IetfLanguageCode.English.SL.code -> IetfLanguageCode.English.SL
        IetfLanguageCode.English.SS.code -> IetfLanguageCode.English.SS
        IetfLanguageCode.English.SX.code -> IetfLanguageCode.English.SX
        IetfLanguageCode.English.SZ.code -> IetfLanguageCode.English.SZ
        IetfLanguageCode.English.TC.code -> IetfLanguageCode.English.TC
        IetfLanguageCode.English.TK.code -> IetfLanguageCode.English.TK
        IetfLanguageCode.English.TO.code -> IetfLanguageCode.English.TO
        IetfLanguageCode.English.TT.code -> IetfLanguageCode.English.TT
        IetfLanguageCode.English.TV.code -> IetfLanguageCode.English.TV
        IetfLanguageCode.English.TZ.code -> IetfLanguageCode.English.TZ
        IetfLanguageCode.English.UG.code -> IetfLanguageCode.English.UG
        IetfLanguageCode.English.UM.code -> IetfLanguageCode.English.UM
        IetfLanguageCode.English.US.code -> IetfLanguageCode.English.US
        IetfLanguageCode.English.US.POSIX.code -> IetfLanguageCode.English.US.POSIX
        IetfLanguageCode.English.VC.code -> IetfLanguageCode.English.VC
        IetfLanguageCode.English.VG.code -> IetfLanguageCode.English.VG
        IetfLanguageCode.English.VI.code -> IetfLanguageCode.English.VI
        IetfLanguageCode.English.VU.code -> IetfLanguageCode.English.VU
        IetfLanguageCode.English.WS.code -> IetfLanguageCode.English.WS
        IetfLanguageCode.English.ZA.code -> IetfLanguageCode.English.ZA
        IetfLanguageCode.English.ZM.code -> IetfLanguageCode.English.ZM
        IetfLanguageCode.English.ZW.code -> IetfLanguageCode.English.ZW
        IetfLanguageCode.Esperanto.code -> IetfLanguageCode.Esperanto
        IetfLanguageCode.Esperanto.L001.code -> IetfLanguageCode.Esperanto.L001
        IetfLanguageCode.SpanishCastilian.code -> IetfLanguageCode.SpanishCastilian
        IetfLanguageCode.SpanishCastilian.L419.code -> IetfLanguageCode.SpanishCastilian.L419
        IetfLanguageCode.SpanishCastilian.AR.code -> IetfLanguageCode.SpanishCastilian.AR
        IetfLanguageCode.SpanishCastilian.BO.code -> IetfLanguageCode.SpanishCastilian.BO
        IetfLanguageCode.SpanishCastilian.BR.code -> IetfLanguageCode.SpanishCastilian.BR
        IetfLanguageCode.SpanishCastilian.BZ.code -> IetfLanguageCode.SpanishCastilian.BZ
        IetfLanguageCode.SpanishCastilian.CL.code -> IetfLanguageCode.SpanishCastilian.CL
        IetfLanguageCode.SpanishCastilian.CO.code -> IetfLanguageCode.SpanishCastilian.CO
        IetfLanguageCode.SpanishCastilian.CR.code -> IetfLanguageCode.SpanishCastilian.CR
        IetfLanguageCode.SpanishCastilian.CU.code -> IetfLanguageCode.SpanishCastilian.CU
        IetfLanguageCode.SpanishCastilian.DO.code -> IetfLanguageCode.SpanishCastilian.DO
        IetfLanguageCode.SpanishCastilian.EA.code -> IetfLanguageCode.SpanishCastilian.EA
        IetfLanguageCode.SpanishCastilian.EC.code -> IetfLanguageCode.SpanishCastilian.EC
        IetfLanguageCode.SpanishCastilian.ES.code -> IetfLanguageCode.SpanishCastilian.ES
        IetfLanguageCode.SpanishCastilian.GQ.code -> IetfLanguageCode.SpanishCastilian.GQ
        IetfLanguageCode.SpanishCastilian.GT.code -> IetfLanguageCode.SpanishCastilian.GT
        IetfLanguageCode.SpanishCastilian.HN.code -> IetfLanguageCode.SpanishCastilian.HN
        IetfLanguageCode.SpanishCastilian.IC.code -> IetfLanguageCode.SpanishCastilian.IC
        IetfLanguageCode.SpanishCastilian.MX.code -> IetfLanguageCode.SpanishCastilian.MX
        IetfLanguageCode.SpanishCastilian.NI.code -> IetfLanguageCode.SpanishCastilian.NI
        IetfLanguageCode.SpanishCastilian.PA.code -> IetfLanguageCode.SpanishCastilian.PA
        IetfLanguageCode.SpanishCastilian.PE.code -> IetfLanguageCode.SpanishCastilian.PE
        IetfLanguageCode.SpanishCastilian.PH.code -> IetfLanguageCode.SpanishCastilian.PH
        IetfLanguageCode.SpanishCastilian.PR.code -> IetfLanguageCode.SpanishCastilian.PR
        IetfLanguageCode.SpanishCastilian.PY.code -> IetfLanguageCode.SpanishCastilian.PY
        IetfLanguageCode.SpanishCastilian.SV.code -> IetfLanguageCode.SpanishCastilian.SV
        IetfLanguageCode.SpanishCastilian.US.code -> IetfLanguageCode.SpanishCastilian.US
        IetfLanguageCode.SpanishCastilian.UY.code -> IetfLanguageCode.SpanishCastilian.UY
        IetfLanguageCode.SpanishCastilian.VE.code -> IetfLanguageCode.SpanishCastilian.VE
        IetfLanguageCode.Estonian.code -> IetfLanguageCode.Estonian
        IetfLanguageCode.Estonian.EE.code -> IetfLanguageCode.Estonian.EE
        IetfLanguageCode.Basque.code -> IetfLanguageCode.Basque
        IetfLanguageCode.Basque.ES.code -> IetfLanguageCode.Basque.ES
        IetfLanguageCode.Persian.code -> IetfLanguageCode.Persian
        IetfLanguageCode.Persian.AF.code -> IetfLanguageCode.Persian.AF
        IetfLanguageCode.Persian.IR.code -> IetfLanguageCode.Persian.IR
        IetfLanguageCode.Fulah.code -> IetfLanguageCode.Fulah
        IetfLanguageCode.Fulah.Adlm.code -> IetfLanguageCode.Fulah.Adlm
        IetfLanguageCode.Fulah.Adlm.BF.code -> IetfLanguageCode.Fulah.Adlm.BF
        IetfLanguageCode.Fulah.Adlm.CM.code -> IetfLanguageCode.Fulah.Adlm.CM
        IetfLanguageCode.Fulah.Adlm.GH.code -> IetfLanguageCode.Fulah.Adlm.GH
        IetfLanguageCode.Fulah.Adlm.GM.code -> IetfLanguageCode.Fulah.Adlm.GM
        IetfLanguageCode.Fulah.Adlm.GN.code -> IetfLanguageCode.Fulah.Adlm.GN
        IetfLanguageCode.Fulah.Adlm.GW.code -> IetfLanguageCode.Fulah.Adlm.GW
        IetfLanguageCode.Fulah.Adlm.LR.code -> IetfLanguageCode.Fulah.Adlm.LR
        IetfLanguageCode.Fulah.Adlm.MR.code -> IetfLanguageCode.Fulah.Adlm.MR
        IetfLanguageCode.Fulah.Adlm.NE.code -> IetfLanguageCode.Fulah.Adlm.NE
        IetfLanguageCode.Fulah.Adlm.NG.code -> IetfLanguageCode.Fulah.Adlm.NG
        IetfLanguageCode.Fulah.Adlm.SL.code -> IetfLanguageCode.Fulah.Adlm.SL
        IetfLanguageCode.Fulah.Adlm.SN.code -> IetfLanguageCode.Fulah.Adlm.SN
        IetfLanguageCode.Fulah.Latn.code -> IetfLanguageCode.Fulah.Latn
        IetfLanguageCode.Fulah.Latn.BF.code -> IetfLanguageCode.Fulah.Latn.BF
        IetfLanguageCode.Fulah.Latn.CM.code -> IetfLanguageCode.Fulah.Latn.CM
        IetfLanguageCode.Fulah.Latn.GH.code -> IetfLanguageCode.Fulah.Latn.GH
        IetfLanguageCode.Fulah.Latn.GM.code -> IetfLanguageCode.Fulah.Latn.GM
        IetfLanguageCode.Fulah.Latn.GN.code -> IetfLanguageCode.Fulah.Latn.GN
        IetfLanguageCode.Fulah.Latn.GW.code -> IetfLanguageCode.Fulah.Latn.GW
        IetfLanguageCode.Fulah.Latn.LR.code -> IetfLanguageCode.Fulah.Latn.LR
        IetfLanguageCode.Fulah.Latn.MR.code -> IetfLanguageCode.Fulah.Latn.MR
        IetfLanguageCode.Fulah.Latn.NE.code -> IetfLanguageCode.Fulah.Latn.NE
        IetfLanguageCode.Fulah.Latn.NG.code -> IetfLanguageCode.Fulah.Latn.NG
        IetfLanguageCode.Fulah.Latn.SL.code -> IetfLanguageCode.Fulah.Latn.SL
        IetfLanguageCode.Fulah.Latn.SN.code -> IetfLanguageCode.Fulah.Latn.SN
        IetfLanguageCode.Finnish.code -> IetfLanguageCode.Finnish
        IetfLanguageCode.Finnish.FI.code -> IetfLanguageCode.Finnish.FI
        IetfLanguageCode.Fijian.code -> IetfLanguageCode.Fijian
        IetfLanguageCode.Faroese.code -> IetfLanguageCode.Faroese
        IetfLanguageCode.Faroese.DK.code -> IetfLanguageCode.Faroese.DK
        IetfLanguageCode.Faroese.FO.code -> IetfLanguageCode.Faroese.FO
        IetfLanguageCode.French.code -> IetfLanguageCode.French
        IetfLanguageCode.French.BE.code -> IetfLanguageCode.French.BE
        IetfLanguageCode.French.BF.code -> IetfLanguageCode.French.BF
        IetfLanguageCode.French.BI.code -> IetfLanguageCode.French.BI
        IetfLanguageCode.French.BJ.code -> IetfLanguageCode.French.BJ
        IetfLanguageCode.French.BL.code -> IetfLanguageCode.French.BL
        IetfLanguageCode.French.CA.code -> IetfLanguageCode.French.CA
        IetfLanguageCode.French.CD.code -> IetfLanguageCode.French.CD
        IetfLanguageCode.French.CF.code -> IetfLanguageCode.French.CF
        IetfLanguageCode.French.CG.code -> IetfLanguageCode.French.CG
        IetfLanguageCode.French.CH.code -> IetfLanguageCode.French.CH
        IetfLanguageCode.French.CI.code -> IetfLanguageCode.French.CI
        IetfLanguageCode.French.CM.code -> IetfLanguageCode.French.CM
        IetfLanguageCode.French.DJ.code -> IetfLanguageCode.French.DJ
        IetfLanguageCode.French.DZ.code -> IetfLanguageCode.French.DZ
        IetfLanguageCode.French.FR.code -> IetfLanguageCode.French.FR
        IetfLanguageCode.French.GA.code -> IetfLanguageCode.French.GA
        IetfLanguageCode.French.GF.code -> IetfLanguageCode.French.GF
        IetfLanguageCode.French.GN.code -> IetfLanguageCode.French.GN
        IetfLanguageCode.French.GP.code -> IetfLanguageCode.French.GP
        IetfLanguageCode.French.GQ.code -> IetfLanguageCode.French.GQ
        IetfLanguageCode.French.HT.code -> IetfLanguageCode.French.HT
        IetfLanguageCode.French.KM.code -> IetfLanguageCode.French.KM
        IetfLanguageCode.French.LU.code -> IetfLanguageCode.French.LU
        IetfLanguageCode.French.MA.code -> IetfLanguageCode.French.MA
        IetfLanguageCode.French.MC.code -> IetfLanguageCode.French.MC
        IetfLanguageCode.French.MF.code -> IetfLanguageCode.French.MF
        IetfLanguageCode.French.MG.code -> IetfLanguageCode.French.MG
        IetfLanguageCode.French.ML.code -> IetfLanguageCode.French.ML
        IetfLanguageCode.French.MQ.code -> IetfLanguageCode.French.MQ
        IetfLanguageCode.French.MR.code -> IetfLanguageCode.French.MR
        IetfLanguageCode.French.MU.code -> IetfLanguageCode.French.MU
        IetfLanguageCode.French.NC.code -> IetfLanguageCode.French.NC
        IetfLanguageCode.French.NE.code -> IetfLanguageCode.French.NE
        IetfLanguageCode.French.PF.code -> IetfLanguageCode.French.PF
        IetfLanguageCode.French.PM.code -> IetfLanguageCode.French.PM
        IetfLanguageCode.French.RE.code -> IetfLanguageCode.French.RE
        IetfLanguageCode.French.RW.code -> IetfLanguageCode.French.RW
        IetfLanguageCode.French.SC.code -> IetfLanguageCode.French.SC
        IetfLanguageCode.French.SN.code -> IetfLanguageCode.French.SN
        IetfLanguageCode.French.SY.code -> IetfLanguageCode.French.SY
        IetfLanguageCode.French.TD.code -> IetfLanguageCode.French.TD
        IetfLanguageCode.French.TG.code -> IetfLanguageCode.French.TG
        IetfLanguageCode.French.TN.code -> IetfLanguageCode.French.TN
        IetfLanguageCode.French.VU.code -> IetfLanguageCode.French.VU
        IetfLanguageCode.French.WF.code -> IetfLanguageCode.French.WF
        IetfLanguageCode.French.YT.code -> IetfLanguageCode.French.YT
        IetfLanguageCode.WesternFrisian.code -> IetfLanguageCode.WesternFrisian
        IetfLanguageCode.WesternFrisian.NL.code -> IetfLanguageCode.WesternFrisian.NL
        IetfLanguageCode.Irish.code -> IetfLanguageCode.Irish
        IetfLanguageCode.Irish.GB.code -> IetfLanguageCode.Irish.GB
        IetfLanguageCode.Irish.IE.code -> IetfLanguageCode.Irish.IE
        IetfLanguageCode.GaelicScottishGaelic.code -> IetfLanguageCode.GaelicScottishGaelic
        IetfLanguageCode.GaelicScottishGaelic.GB.code -> IetfLanguageCode.GaelicScottishGaelic.GB
        IetfLanguageCode.Galician.code -> IetfLanguageCode.Galician
        IetfLanguageCode.Galician.ES.code -> IetfLanguageCode.Galician.ES
        IetfLanguageCode.Guarani.code -> IetfLanguageCode.Guarani
        IetfLanguageCode.Gujarati.code -> IetfLanguageCode.Gujarati
        IetfLanguageCode.Gujarati.IN.code -> IetfLanguageCode.Gujarati.IN
        IetfLanguageCode.Manx.code -> IetfLanguageCode.Manx
        IetfLanguageCode.Manx.IM.code -> IetfLanguageCode.Manx.IM
        IetfLanguageCode.Hausa.code -> IetfLanguageCode.Hausa
        IetfLanguageCode.Hausa.GH.code -> IetfLanguageCode.Hausa.GH
        IetfLanguageCode.Hausa.NE.code -> IetfLanguageCode.Hausa.NE
        IetfLanguageCode.Hausa.NG.code -> IetfLanguageCode.Hausa.NG
        IetfLanguageCode.Hebrew.code -> IetfLanguageCode.Hebrew
        IetfLanguageCode.Hebrew.IL.code -> IetfLanguageCode.Hebrew.IL
        IetfLanguageCode.Hindi.code -> IetfLanguageCode.Hindi
        IetfLanguageCode.Hindi.IN.code -> IetfLanguageCode.Hindi.IN
        IetfLanguageCode.HiriMotu.code -> IetfLanguageCode.HiriMotu
        IetfLanguageCode.Croatian.code -> IetfLanguageCode.Croatian
        IetfLanguageCode.Croatian.BA.code -> IetfLanguageCode.Croatian.BA
        IetfLanguageCode.Croatian.HR.code -> IetfLanguageCode.Croatian.HR
        IetfLanguageCode.HaitianHaitianCreole.code -> IetfLanguageCode.HaitianHaitianCreole
        IetfLanguageCode.Hungarian.code -> IetfLanguageCode.Hungarian
        IetfLanguageCode.Hungarian.HU.code -> IetfLanguageCode.Hungarian.HU
        IetfLanguageCode.Armenian.code -> IetfLanguageCode.Armenian
        IetfLanguageCode.Armenian.AM.code -> IetfLanguageCode.Armenian.AM
        IetfLanguageCode.Herero.code -> IetfLanguageCode.Herero
        IetfLanguageCode.InterlinguaInternationalAuxiliaryLanguageAssociation.code -> IetfLanguageCode.InterlinguaInternationalAuxiliaryLanguageAssociation
        IetfLanguageCode.InterlinguaInternationalAuxiliaryLanguageAssociation.L001.code -> IetfLanguageCode.InterlinguaInternationalAuxiliaryLanguageAssociation.L001
        IetfLanguageCode.Indonesian.code -> IetfLanguageCode.Indonesian
        IetfLanguageCode.Indonesian.ID.code -> IetfLanguageCode.Indonesian.ID
        IetfLanguageCode.InterlingueOccidental.code -> IetfLanguageCode.InterlingueOccidental
        IetfLanguageCode.Igbo.code -> IetfLanguageCode.Igbo
        IetfLanguageCode.Igbo.NG.code -> IetfLanguageCode.Igbo.NG
        IetfLanguageCode.SichuanYiNuosu.code -> IetfLanguageCode.SichuanYiNuosu
        IetfLanguageCode.SichuanYiNuosu.CN.code -> IetfLanguageCode.SichuanYiNuosu.CN
        IetfLanguageCode.Inupiaq.code -> IetfLanguageCode.Inupiaq
        IetfLanguageCode.Ido.code -> IetfLanguageCode.Ido
        IetfLanguageCode.Icelandic.code -> IetfLanguageCode.Icelandic
        IetfLanguageCode.Icelandic.IS.code -> IetfLanguageCode.Icelandic.IS
        IetfLanguageCode.Italian.code -> IetfLanguageCode.Italian
        IetfLanguageCode.Italian.CH.code -> IetfLanguageCode.Italian.CH
        IetfLanguageCode.Italian.IT.code -> IetfLanguageCode.Italian.IT
        IetfLanguageCode.Italian.SM.code -> IetfLanguageCode.Italian.SM
        IetfLanguageCode.Italian.VA.code -> IetfLanguageCode.Italian.VA
        IetfLanguageCode.Inuktitut.code -> IetfLanguageCode.Inuktitut
        IetfLanguageCode.Japanese.code -> IetfLanguageCode.Japanese
        IetfLanguageCode.Japanese.JP.code -> IetfLanguageCode.Japanese.JP
        IetfLanguageCode.Javanese.code -> IetfLanguageCode.Javanese
        IetfLanguageCode.Javanese.ID.code -> IetfLanguageCode.Javanese.ID
        IetfLanguageCode.Georgian.code -> IetfLanguageCode.Georgian
        IetfLanguageCode.Georgian.GE.code -> IetfLanguageCode.Georgian.GE
        IetfLanguageCode.Kongo.code -> IetfLanguageCode.Kongo
        IetfLanguageCode.KikuyuGikuyu.code -> IetfLanguageCode.KikuyuGikuyu
        IetfLanguageCode.KikuyuGikuyu.KE.code -> IetfLanguageCode.KikuyuGikuyu.KE
        IetfLanguageCode.KuanyamaKwanyama.code -> IetfLanguageCode.KuanyamaKwanyama
        IetfLanguageCode.Kazakh.code -> IetfLanguageCode.Kazakh
        IetfLanguageCode.Kazakh.KZ.code -> IetfLanguageCode.Kazakh.KZ
        IetfLanguageCode.KalaallisutGreenlandic.code -> IetfLanguageCode.KalaallisutGreenlandic
        IetfLanguageCode.KalaallisutGreenlandic.GL.code -> IetfLanguageCode.KalaallisutGreenlandic.GL
        IetfLanguageCode.CentralKhmer.code -> IetfLanguageCode.CentralKhmer
        IetfLanguageCode.CentralKhmer.KH.code -> IetfLanguageCode.CentralKhmer.KH
        IetfLanguageCode.Kannada.code -> IetfLanguageCode.Kannada
        IetfLanguageCode.Kannada.IN.code -> IetfLanguageCode.Kannada.IN
        IetfLanguageCode.Korean.code -> IetfLanguageCode.Korean
        IetfLanguageCode.Korean.KP.code -> IetfLanguageCode.Korean.KP
        IetfLanguageCode.Korean.KR.code -> IetfLanguageCode.Korean.KR
        IetfLanguageCode.Kanuri.code -> IetfLanguageCode.Kanuri
        IetfLanguageCode.Kashmiri.code -> IetfLanguageCode.Kashmiri
        IetfLanguageCode.Kashmiri.Arab.code -> IetfLanguageCode.Kashmiri.Arab
        IetfLanguageCode.Kashmiri.Arab.IN.code -> IetfLanguageCode.Kashmiri.Arab.IN
        IetfLanguageCode.Kurdish.code -> IetfLanguageCode.Kurdish
        IetfLanguageCode.Kurdish.TR.code -> IetfLanguageCode.Kurdish.TR
        IetfLanguageCode.Komi.code -> IetfLanguageCode.Komi
        IetfLanguageCode.Cornish.code -> IetfLanguageCode.Cornish
        IetfLanguageCode.Cornish.GB.code -> IetfLanguageCode.Cornish.GB
        IetfLanguageCode.KirghizKyrgyz.code -> IetfLanguageCode.KirghizKyrgyz
        IetfLanguageCode.KirghizKyrgyz.KG.code -> IetfLanguageCode.KirghizKyrgyz.KG
        IetfLanguageCode.Latin.code -> IetfLanguageCode.Latin
        IetfLanguageCode.LuxembourgishLetzeburgesch.code -> IetfLanguageCode.LuxembourgishLetzeburgesch
        IetfLanguageCode.LuxembourgishLetzeburgesch.LU.code -> IetfLanguageCode.LuxembourgishLetzeburgesch.LU
        IetfLanguageCode.Ganda.code -> IetfLanguageCode.Ganda
        IetfLanguageCode.Ganda.UG.code -> IetfLanguageCode.Ganda.UG
        IetfLanguageCode.LimburganLimburgerLimburgish.code -> IetfLanguageCode.LimburganLimburgerLimburgish
        IetfLanguageCode.Lingala.code -> IetfLanguageCode.Lingala
        IetfLanguageCode.Lingala.AO.code -> IetfLanguageCode.Lingala.AO
        IetfLanguageCode.Lingala.CD.code -> IetfLanguageCode.Lingala.CD
        IetfLanguageCode.Lingala.CF.code -> IetfLanguageCode.Lingala.CF
        IetfLanguageCode.Lingala.CG.code -> IetfLanguageCode.Lingala.CG
        IetfLanguageCode.Lao.code -> IetfLanguageCode.Lao
        IetfLanguageCode.Lao.LA.code -> IetfLanguageCode.Lao.LA
        IetfLanguageCode.Lithuanian.code -> IetfLanguageCode.Lithuanian
        IetfLanguageCode.Lithuanian.LT.code -> IetfLanguageCode.Lithuanian.LT
        IetfLanguageCode.LubaKatanga.code -> IetfLanguageCode.LubaKatanga
        IetfLanguageCode.LubaKatanga.CD.code -> IetfLanguageCode.LubaKatanga.CD
        IetfLanguageCode.Latvian.code -> IetfLanguageCode.Latvian
        IetfLanguageCode.Latvian.LV.code -> IetfLanguageCode.Latvian.LV
        IetfLanguageCode.Malagasy.code -> IetfLanguageCode.Malagasy
        IetfLanguageCode.Malagasy.MG.code -> IetfLanguageCode.Malagasy.MG
        IetfLanguageCode.Marshallese.code -> IetfLanguageCode.Marshallese
        IetfLanguageCode.Maori.code -> IetfLanguageCode.Maori
        IetfLanguageCode.Maori.NZ.code -> IetfLanguageCode.Maori.NZ
        IetfLanguageCode.Macedonian.code -> IetfLanguageCode.Macedonian
        IetfLanguageCode.Macedonian.MK.code -> IetfLanguageCode.Macedonian.MK
        IetfLanguageCode.Malayalam.code -> IetfLanguageCode.Malayalam
        IetfLanguageCode.Malayalam.IN.code -> IetfLanguageCode.Malayalam.IN
        IetfLanguageCode.Mongolian.code -> IetfLanguageCode.Mongolian
        IetfLanguageCode.Mongolian.MN.code -> IetfLanguageCode.Mongolian.MN
        IetfLanguageCode.Marathi.code -> IetfLanguageCode.Marathi
        IetfLanguageCode.Marathi.IN.code -> IetfLanguageCode.Marathi.IN
        IetfLanguageCode.Malay.code -> IetfLanguageCode.Malay
        IetfLanguageCode.Malay.BN.code -> IetfLanguageCode.Malay.BN
        IetfLanguageCode.Malay.ID.code -> IetfLanguageCode.Malay.ID
        IetfLanguageCode.Malay.MY.code -> IetfLanguageCode.Malay.MY
        IetfLanguageCode.Malay.SG.code -> IetfLanguageCode.Malay.SG
        IetfLanguageCode.Maltese.code -> IetfLanguageCode.Maltese
        IetfLanguageCode.Maltese.MT.code -> IetfLanguageCode.Maltese.MT
        IetfLanguageCode.Burmese.code -> IetfLanguageCode.Burmese
        IetfLanguageCode.Burmese.MM.code -> IetfLanguageCode.Burmese.MM
        IetfLanguageCode.Nauru.code -> IetfLanguageCode.Nauru
        IetfLanguageCode.BokmalNorwegianNorwegianBokmal.code -> IetfLanguageCode.BokmalNorwegianNorwegianBokmal
        IetfLanguageCode.BokmalNorwegianNorwegianBokmal.NO.code -> IetfLanguageCode.BokmalNorwegianNorwegianBokmal.NO
        IetfLanguageCode.BokmalNorwegianNorwegianBokmal.SJ.code -> IetfLanguageCode.BokmalNorwegianNorwegianBokmal.SJ
        IetfLanguageCode.NdebeleNorthNorthNdebele.code -> IetfLanguageCode.NdebeleNorthNorthNdebele
        IetfLanguageCode.NdebeleNorthNorthNdebele.ZW.code -> IetfLanguageCode.NdebeleNorthNorthNdebele.ZW
        IetfLanguageCode.Nepali.code -> IetfLanguageCode.Nepali
        IetfLanguageCode.Nepali.IN.code -> IetfLanguageCode.Nepali.IN
        IetfLanguageCode.Nepali.NP.code -> IetfLanguageCode.Nepali.NP
        IetfLanguageCode.Ndonga.code -> IetfLanguageCode.Ndonga
        IetfLanguageCode.DutchFlemish.code -> IetfLanguageCode.DutchFlemish
        IetfLanguageCode.DutchFlemish.AW.code -> IetfLanguageCode.DutchFlemish.AW
        IetfLanguageCode.DutchFlemish.BE.code -> IetfLanguageCode.DutchFlemish.BE
        IetfLanguageCode.DutchFlemish.BQ.code -> IetfLanguageCode.DutchFlemish.BQ
        IetfLanguageCode.DutchFlemish.CW.code -> IetfLanguageCode.DutchFlemish.CW
        IetfLanguageCode.DutchFlemish.NL.code -> IetfLanguageCode.DutchFlemish.NL
        IetfLanguageCode.DutchFlemish.SR.code -> IetfLanguageCode.DutchFlemish.SR
        IetfLanguageCode.DutchFlemish.SX.code -> IetfLanguageCode.DutchFlemish.SX
        IetfLanguageCode.NorwegianNynorskNynorskNorwegian.code -> IetfLanguageCode.NorwegianNynorskNynorskNorwegian
        IetfLanguageCode.NorwegianNynorskNynorskNorwegian.NO.code -> IetfLanguageCode.NorwegianNynorskNynorskNorwegian.NO
        IetfLanguageCode.Norwegian.code -> IetfLanguageCode.Norwegian
        IetfLanguageCode.NdebeleSouthSouthNdebele.code -> IetfLanguageCode.NdebeleSouthSouthNdebele
        IetfLanguageCode.NavajoNavaho.code -> IetfLanguageCode.NavajoNavaho
        IetfLanguageCode.ChichewaChewaNyanja.code -> IetfLanguageCode.ChichewaChewaNyanja
        IetfLanguageCode.OccitanPost1500.code -> IetfLanguageCode.OccitanPost1500
        IetfLanguageCode.Ojibwa.code -> IetfLanguageCode.Ojibwa
        IetfLanguageCode.Oromo.code -> IetfLanguageCode.Oromo
        IetfLanguageCode.Oromo.ET.code -> IetfLanguageCode.Oromo.ET
        IetfLanguageCode.Oromo.KE.code -> IetfLanguageCode.Oromo.KE
        IetfLanguageCode.Oriya.code -> IetfLanguageCode.Oriya
        IetfLanguageCode.Oriya.IN.code -> IetfLanguageCode.Oriya.IN
        IetfLanguageCode.OssetianOssetic.code -> IetfLanguageCode.OssetianOssetic
        IetfLanguageCode.OssetianOssetic.GE.code -> IetfLanguageCode.OssetianOssetic.GE
        IetfLanguageCode.OssetianOssetic.RU.code -> IetfLanguageCode.OssetianOssetic.RU
        IetfLanguageCode.PanjabiPunjabi.code -> IetfLanguageCode.PanjabiPunjabi
        IetfLanguageCode.PanjabiPunjabi.Arab.code -> IetfLanguageCode.PanjabiPunjabi.Arab
        IetfLanguageCode.PanjabiPunjabi.Arab.PK.code -> IetfLanguageCode.PanjabiPunjabi.Arab.PK
        IetfLanguageCode.PanjabiPunjabi.Guru.code -> IetfLanguageCode.PanjabiPunjabi.Guru
        IetfLanguageCode.PanjabiPunjabi.Guru.IN.code -> IetfLanguageCode.PanjabiPunjabi.Guru.IN
        IetfLanguageCode.Pali.code -> IetfLanguageCode.Pali
        IetfLanguageCode.Polish.code -> IetfLanguageCode.Polish
        IetfLanguageCode.Polish.PL.code -> IetfLanguageCode.Polish.PL
        IetfLanguageCode.PushtoPashto.code -> IetfLanguageCode.PushtoPashto
        IetfLanguageCode.PushtoPashto.AF.code -> IetfLanguageCode.PushtoPashto.AF
        IetfLanguageCode.PushtoPashto.PK.code -> IetfLanguageCode.PushtoPashto.PK
        IetfLanguageCode.Portuguese.code -> IetfLanguageCode.Portuguese
        IetfLanguageCode.Portuguese.AO.code -> IetfLanguageCode.Portuguese.AO
        IetfLanguageCode.Portuguese.BR.code -> IetfLanguageCode.Portuguese.BR
        IetfLanguageCode.Portuguese.CH.code -> IetfLanguageCode.Portuguese.CH
        IetfLanguageCode.Portuguese.CV.code -> IetfLanguageCode.Portuguese.CV
        IetfLanguageCode.Portuguese.GQ.code -> IetfLanguageCode.Portuguese.GQ
        IetfLanguageCode.Portuguese.GW.code -> IetfLanguageCode.Portuguese.GW
        IetfLanguageCode.Portuguese.LU.code -> IetfLanguageCode.Portuguese.LU
        IetfLanguageCode.Portuguese.MO.code -> IetfLanguageCode.Portuguese.MO
        IetfLanguageCode.Portuguese.MZ.code -> IetfLanguageCode.Portuguese.MZ
        IetfLanguageCode.Portuguese.PT.code -> IetfLanguageCode.Portuguese.PT
        IetfLanguageCode.Portuguese.ST.code -> IetfLanguageCode.Portuguese.ST
        IetfLanguageCode.Portuguese.TL.code -> IetfLanguageCode.Portuguese.TL
        IetfLanguageCode.Quechua.code -> IetfLanguageCode.Quechua
        IetfLanguageCode.Quechua.BO.code -> IetfLanguageCode.Quechua.BO
        IetfLanguageCode.Quechua.EC.code -> IetfLanguageCode.Quechua.EC
        IetfLanguageCode.Quechua.PE.code -> IetfLanguageCode.Quechua.PE
        IetfLanguageCode.Romansh.code -> IetfLanguageCode.Romansh
        IetfLanguageCode.Romansh.CH.code -> IetfLanguageCode.Romansh.CH
        IetfLanguageCode.Rundi.code -> IetfLanguageCode.Rundi
        IetfLanguageCode.Rundi.BI.code -> IetfLanguageCode.Rundi.BI
        IetfLanguageCode.RomanianMoldavianMoldovan.code -> IetfLanguageCode.RomanianMoldavianMoldovan
        IetfLanguageCode.RomanianMoldavianMoldovan.MD.code -> IetfLanguageCode.RomanianMoldavianMoldovan.MD
        IetfLanguageCode.RomanianMoldavianMoldovan.RO.code -> IetfLanguageCode.RomanianMoldavianMoldovan.RO
        IetfLanguageCode.Russian.code -> IetfLanguageCode.Russian
        IetfLanguageCode.Russian.BY.code -> IetfLanguageCode.Russian.BY
        IetfLanguageCode.Russian.KG.code -> IetfLanguageCode.Russian.KG
        IetfLanguageCode.Russian.KZ.code -> IetfLanguageCode.Russian.KZ
        IetfLanguageCode.Russian.MD.code -> IetfLanguageCode.Russian.MD
        IetfLanguageCode.Russian.RU.code -> IetfLanguageCode.Russian.RU
        IetfLanguageCode.Russian.UA.code -> IetfLanguageCode.Russian.UA
        IetfLanguageCode.Kinyarwanda.code -> IetfLanguageCode.Kinyarwanda
        IetfLanguageCode.Kinyarwanda.RW.code -> IetfLanguageCode.Kinyarwanda.RW
        IetfLanguageCode.Sanskrit.code -> IetfLanguageCode.Sanskrit
        IetfLanguageCode.Sardinian.code -> IetfLanguageCode.Sardinian
        IetfLanguageCode.Sindhi.code -> IetfLanguageCode.Sindhi
        IetfLanguageCode.Sindhi.Arab.code -> IetfLanguageCode.Sindhi.Arab
        IetfLanguageCode.Sindhi.Arab.PK.code -> IetfLanguageCode.Sindhi.Arab.PK
        IetfLanguageCode.Sindhi.Deva.code -> IetfLanguageCode.Sindhi.Deva
        IetfLanguageCode.Sindhi.Deva.IN.code -> IetfLanguageCode.Sindhi.Deva.IN
        IetfLanguageCode.NorthernSami.code -> IetfLanguageCode.NorthernSami
        IetfLanguageCode.NorthernSami.FI.code -> IetfLanguageCode.NorthernSami.FI
        IetfLanguageCode.NorthernSami.NO.code -> IetfLanguageCode.NorthernSami.NO
        IetfLanguageCode.NorthernSami.SE.code -> IetfLanguageCode.NorthernSami.SE
        IetfLanguageCode.Sango.code -> IetfLanguageCode.Sango
        IetfLanguageCode.Sango.CF.code -> IetfLanguageCode.Sango.CF
        IetfLanguageCode.SinhalaSinhalese.code -> IetfLanguageCode.SinhalaSinhalese
        IetfLanguageCode.SinhalaSinhalese.LK.code -> IetfLanguageCode.SinhalaSinhalese.LK
        IetfLanguageCode.Slovak.code -> IetfLanguageCode.Slovak
        IetfLanguageCode.Slovak.SK.code -> IetfLanguageCode.Slovak.SK
        IetfLanguageCode.Slovenian.code -> IetfLanguageCode.Slovenian
        IetfLanguageCode.Slovenian.SI.code -> IetfLanguageCode.Slovenian.SI
        IetfLanguageCode.Samoan.code -> IetfLanguageCode.Samoan
        IetfLanguageCode.Shona.code -> IetfLanguageCode.Shona
        IetfLanguageCode.Shona.ZW.code -> IetfLanguageCode.Shona.ZW
        IetfLanguageCode.Somali.code -> IetfLanguageCode.Somali
        IetfLanguageCode.Somali.DJ.code -> IetfLanguageCode.Somali.DJ
        IetfLanguageCode.Somali.ET.code -> IetfLanguageCode.Somali.ET
        IetfLanguageCode.Somali.KE.code -> IetfLanguageCode.Somali.KE
        IetfLanguageCode.Somali.SO.code -> IetfLanguageCode.Somali.SO
        IetfLanguageCode.Albanian.code -> IetfLanguageCode.Albanian
        IetfLanguageCode.Albanian.AL.code -> IetfLanguageCode.Albanian.AL
        IetfLanguageCode.Albanian.MK.code -> IetfLanguageCode.Albanian.MK
        IetfLanguageCode.Albanian.XK.code -> IetfLanguageCode.Albanian.XK
        IetfLanguageCode.Serbian.code -> IetfLanguageCode.Serbian
        IetfLanguageCode.Serbian.Cyrl.code -> IetfLanguageCode.Serbian.Cyrl
        IetfLanguageCode.Serbian.Cyrl.BA.code -> IetfLanguageCode.Serbian.Cyrl.BA
        IetfLanguageCode.Serbian.Cyrl.ME.code -> IetfLanguageCode.Serbian.Cyrl.ME
        IetfLanguageCode.Serbian.Cyrl.RS.code -> IetfLanguageCode.Serbian.Cyrl.RS
        IetfLanguageCode.Serbian.Cyrl.XK.code -> IetfLanguageCode.Serbian.Cyrl.XK
        IetfLanguageCode.Serbian.Latn.code -> IetfLanguageCode.Serbian.Latn
        IetfLanguageCode.Serbian.Latn.BA.code -> IetfLanguageCode.Serbian.Latn.BA
        IetfLanguageCode.Serbian.Latn.ME.code -> IetfLanguageCode.Serbian.Latn.ME
        IetfLanguageCode.Serbian.Latn.RS.code -> IetfLanguageCode.Serbian.Latn.RS
        IetfLanguageCode.Serbian.Latn.XK.code -> IetfLanguageCode.Serbian.Latn.XK
        IetfLanguageCode.Swati.code -> IetfLanguageCode.Swati
        IetfLanguageCode.SothoSouthern.code -> IetfLanguageCode.SothoSouthern
        IetfLanguageCode.Sundanese.code -> IetfLanguageCode.Sundanese
        IetfLanguageCode.Sundanese.Latn.code -> IetfLanguageCode.Sundanese.Latn
        IetfLanguageCode.Sundanese.Latn.ID.code -> IetfLanguageCode.Sundanese.Latn.ID
        IetfLanguageCode.Swedish.code -> IetfLanguageCode.Swedish
        IetfLanguageCode.Swedish.AX.code -> IetfLanguageCode.Swedish.AX
        IetfLanguageCode.Swedish.FI.code -> IetfLanguageCode.Swedish.FI
        IetfLanguageCode.Swedish.SE.code -> IetfLanguageCode.Swedish.SE
        IetfLanguageCode.Swahili.code -> IetfLanguageCode.Swahili
        IetfLanguageCode.Swahili.CD.code -> IetfLanguageCode.Swahili.CD
        IetfLanguageCode.Swahili.KE.code -> IetfLanguageCode.Swahili.KE
        IetfLanguageCode.Swahili.TZ.code -> IetfLanguageCode.Swahili.TZ
        IetfLanguageCode.Swahili.UG.code -> IetfLanguageCode.Swahili.UG
        IetfLanguageCode.Tamil.code -> IetfLanguageCode.Tamil
        IetfLanguageCode.Tamil.IN.code -> IetfLanguageCode.Tamil.IN
        IetfLanguageCode.Tamil.LK.code -> IetfLanguageCode.Tamil.LK
        IetfLanguageCode.Tamil.MY.code -> IetfLanguageCode.Tamil.MY
        IetfLanguageCode.Tamil.SG.code -> IetfLanguageCode.Tamil.SG
        IetfLanguageCode.Telugu.code -> IetfLanguageCode.Telugu
        IetfLanguageCode.Telugu.IN.code -> IetfLanguageCode.Telugu.IN
        IetfLanguageCode.Tajik.code -> IetfLanguageCode.Tajik
        IetfLanguageCode.Tajik.TJ.code -> IetfLanguageCode.Tajik.TJ
        IetfLanguageCode.Thai.code -> IetfLanguageCode.Thai
        IetfLanguageCode.Thai.TH.code -> IetfLanguageCode.Thai.TH
        IetfLanguageCode.Tigrinya.code -> IetfLanguageCode.Tigrinya
        IetfLanguageCode.Tigrinya.ER.code -> IetfLanguageCode.Tigrinya.ER
        IetfLanguageCode.Tigrinya.ET.code -> IetfLanguageCode.Tigrinya.ET
        IetfLanguageCode.Turkmen.code -> IetfLanguageCode.Turkmen
        IetfLanguageCode.Turkmen.TM.code -> IetfLanguageCode.Turkmen.TM
        IetfLanguageCode.Tagalog.code -> IetfLanguageCode.Tagalog
        IetfLanguageCode.Tswana.code -> IetfLanguageCode.Tswana
        IetfLanguageCode.TongaTongaIslands.code -> IetfLanguageCode.TongaTongaIslands
        IetfLanguageCode.TongaTongaIslands.TO.code -> IetfLanguageCode.TongaTongaIslands.TO
        IetfLanguageCode.Turkish.code -> IetfLanguageCode.Turkish
        IetfLanguageCode.Turkish.CY.code -> IetfLanguageCode.Turkish.CY
        IetfLanguageCode.Turkish.TR.code -> IetfLanguageCode.Turkish.TR
        IetfLanguageCode.Tsonga.code -> IetfLanguageCode.Tsonga
        IetfLanguageCode.Tatar.code -> IetfLanguageCode.Tatar
        IetfLanguageCode.Tatar.RU.code -> IetfLanguageCode.Tatar.RU
        IetfLanguageCode.Twi.code -> IetfLanguageCode.Twi
        IetfLanguageCode.Tahitian.code -> IetfLanguageCode.Tahitian
        IetfLanguageCode.UighurUyghur.code -> IetfLanguageCode.UighurUyghur
        IetfLanguageCode.UighurUyghur.CN.code -> IetfLanguageCode.UighurUyghur.CN
        IetfLanguageCode.Ukrainian.code -> IetfLanguageCode.Ukrainian
        IetfLanguageCode.Ukrainian.UA.code -> IetfLanguageCode.Ukrainian.UA
        IetfLanguageCode.Urdu.code -> IetfLanguageCode.Urdu
        IetfLanguageCode.Urdu.IN.code -> IetfLanguageCode.Urdu.IN
        IetfLanguageCode.Urdu.PK.code -> IetfLanguageCode.Urdu.PK
        IetfLanguageCode.Uzbek.code -> IetfLanguageCode.Uzbek
        IetfLanguageCode.Uzbek.Arab.code -> IetfLanguageCode.Uzbek.Arab
        IetfLanguageCode.Uzbek.Arab.AF.code -> IetfLanguageCode.Uzbek.Arab.AF
        IetfLanguageCode.Uzbek.Cyrl.code -> IetfLanguageCode.Uzbek.Cyrl
        IetfLanguageCode.Uzbek.Cyrl.UZ.code -> IetfLanguageCode.Uzbek.Cyrl.UZ
        IetfLanguageCode.Uzbek.Latn.code -> IetfLanguageCode.Uzbek.Latn
        IetfLanguageCode.Uzbek.Latn.UZ.code -> IetfLanguageCode.Uzbek.Latn.UZ
        IetfLanguageCode.Venda.code -> IetfLanguageCode.Venda
        IetfLanguageCode.Vietnamese.code -> IetfLanguageCode.Vietnamese
        IetfLanguageCode.Vietnamese.VN.code -> IetfLanguageCode.Vietnamese.VN
        IetfLanguageCode.Volapuk.code -> IetfLanguageCode.Volapuk
        IetfLanguageCode.Volapuk.L001.code -> IetfLanguageCode.Volapuk.L001
        IetfLanguageCode.Walloon.code -> IetfLanguageCode.Walloon
        IetfLanguageCode.Wolof.code -> IetfLanguageCode.Wolof
        IetfLanguageCode.Wolof.SN.code -> IetfLanguageCode.Wolof.SN
        IetfLanguageCode.Xhosa.code -> IetfLanguageCode.Xhosa
        IetfLanguageCode.Xhosa.ZA.code -> IetfLanguageCode.Xhosa.ZA
        IetfLanguageCode.Yiddish.code -> IetfLanguageCode.Yiddish
        IetfLanguageCode.Yiddish.L001.code -> IetfLanguageCode.Yiddish.L001
        IetfLanguageCode.Yoruba.code -> IetfLanguageCode.Yoruba
        IetfLanguageCode.Yoruba.BJ.code -> IetfLanguageCode.Yoruba.BJ
        IetfLanguageCode.Yoruba.NG.code -> IetfLanguageCode.Yoruba.NG
        IetfLanguageCode.ZhuangChuang.code -> IetfLanguageCode.ZhuangChuang
        IetfLanguageCode.Chinese.code -> IetfLanguageCode.Chinese
        IetfLanguageCode.Chinese.Hans.code -> IetfLanguageCode.Chinese.Hans
        IetfLanguageCode.Chinese.Hans.CN.code -> IetfLanguageCode.Chinese.Hans.CN
        IetfLanguageCode.Chinese.Hans.HK.code -> IetfLanguageCode.Chinese.Hans.HK
        IetfLanguageCode.Chinese.Hans.MO.code -> IetfLanguageCode.Chinese.Hans.MO
        IetfLanguageCode.Chinese.Hans.SG.code -> IetfLanguageCode.Chinese.Hans.SG
        IetfLanguageCode.Chinese.Hant.code -> IetfLanguageCode.Chinese.Hant
        IetfLanguageCode.Chinese.Hant.HK.code -> IetfLanguageCode.Chinese.Hant.HK
        IetfLanguageCode.Chinese.Hant.MO.code -> IetfLanguageCode.Chinese.Hant.MO
        IetfLanguageCode.Chinese.Hant.TW.code -> IetfLanguageCode.Chinese.Hant.TW
        IetfLanguageCode.Zulu.code -> IetfLanguageCode.Zulu
        IetfLanguageCode.Zulu.ZA.code -> IetfLanguageCode.Zulu.ZA
        else -> IetfLanguageCode.UnknownIetfLanguageCode(this)
    }
}
fun convertToIetfLanguageCode(code: String) = code.asIetfLanguageCode()
fun IetfLanguageCode(code: String) = code.asIetfLanguageCode()
