package dev.inmo.micro_utils.language_codes

val knownLanguageCodesMap: Map<String, IetfLang> by lazy {
    mapOf(
        IetfLang.Afar.code to IetfLang.Afar,
        IetfLang.Abkhazian.code to IetfLang.Abkhazian,
        IetfLang.Avestan.code to IetfLang.Avestan,
        IetfLang.Afrikaans.code to IetfLang.Afrikaans,
            IetfLang.Afrikaans.NA.code to IetfLang.Afrikaans.NA,
            IetfLang.Afrikaans.ZA.code to IetfLang.Afrikaans.ZA,
        IetfLang.Akan.code to IetfLang.Akan,
            IetfLang.Akan.GH.code to IetfLang.Akan.GH,
        IetfLang.Amharic.code to IetfLang.Amharic,
            IetfLang.Amharic.ET.code to IetfLang.Amharic.ET,
        IetfLang.Aragonese.code to IetfLang.Aragonese,
        IetfLang.Arabic.code to IetfLang.Arabic,
            IetfLang.Arabic.L001.code to IetfLang.Arabic.L001,
            IetfLang.Arabic.AE.code to IetfLang.Arabic.AE,
            IetfLang.Arabic.BH.code to IetfLang.Arabic.BH,
            IetfLang.Arabic.DJ.code to IetfLang.Arabic.DJ,
            IetfLang.Arabic.DZ.code to IetfLang.Arabic.DZ,
            IetfLang.Arabic.EG.code to IetfLang.Arabic.EG,
            IetfLang.Arabic.EH.code to IetfLang.Arabic.EH,
            IetfLang.Arabic.ER.code to IetfLang.Arabic.ER,
            IetfLang.Arabic.IL.code to IetfLang.Arabic.IL,
            IetfLang.Arabic.IQ.code to IetfLang.Arabic.IQ,
            IetfLang.Arabic.JO.code to IetfLang.Arabic.JO,
            IetfLang.Arabic.KM.code to IetfLang.Arabic.KM,
            IetfLang.Arabic.KW.code to IetfLang.Arabic.KW,
            IetfLang.Arabic.LB.code to IetfLang.Arabic.LB,
            IetfLang.Arabic.LY.code to IetfLang.Arabic.LY,
            IetfLang.Arabic.MA.code to IetfLang.Arabic.MA,
            IetfLang.Arabic.MR.code to IetfLang.Arabic.MR,
            IetfLang.Arabic.OM.code to IetfLang.Arabic.OM,
            IetfLang.Arabic.PS.code to IetfLang.Arabic.PS,
            IetfLang.Arabic.QA.code to IetfLang.Arabic.QA,
            IetfLang.Arabic.SA.code to IetfLang.Arabic.SA,
            IetfLang.Arabic.SD.code to IetfLang.Arabic.SD,
            IetfLang.Arabic.SO.code to IetfLang.Arabic.SO,
            IetfLang.Arabic.SS.code to IetfLang.Arabic.SS,
            IetfLang.Arabic.SY.code to IetfLang.Arabic.SY,
            IetfLang.Arabic.TD.code to IetfLang.Arabic.TD,
            IetfLang.Arabic.TN.code to IetfLang.Arabic.TN,
            IetfLang.Arabic.YE.code to IetfLang.Arabic.YE,
        IetfLang.Assamese.code to IetfLang.Assamese,
            IetfLang.Assamese.IN.code to IetfLang.Assamese.IN,
        IetfLang.Avaric.code to IetfLang.Avaric,
        IetfLang.Aymara.code to IetfLang.Aymara,
        IetfLang.Azerbaijani.code to IetfLang.Azerbaijani,
            IetfLang.Azerbaijani.Cyrl.code to IetfLang.Azerbaijani.Cyrl,
                IetfLang.Azerbaijani.Cyrl.AZ.code to IetfLang.Azerbaijani.Cyrl.AZ,
            IetfLang.Azerbaijani.Latn.code to IetfLang.Azerbaijani.Latn,
                IetfLang.Azerbaijani.Latn.AZ.code to IetfLang.Azerbaijani.Latn.AZ,
        IetfLang.Bashkir.code to IetfLang.Bashkir,
        IetfLang.Belarusian.code to IetfLang.Belarusian,
            IetfLang.Belarusian.BY.code to IetfLang.Belarusian.BY,
        IetfLang.Bulgarian.code to IetfLang.Bulgarian,
            IetfLang.Bulgarian.BG.code to IetfLang.Bulgarian.BG,
        IetfLang.BihariLanguages.code to IetfLang.BihariLanguages,
        IetfLang.Bislama.code to IetfLang.Bislama,
        IetfLang.Bambara.code to IetfLang.Bambara,
            IetfLang.Bambara.ML.code to IetfLang.Bambara.ML,
        IetfLang.Bengali.code to IetfLang.Bengali,
            IetfLang.Bengali.BD.code to IetfLang.Bengali.BD,
            IetfLang.Bengali.IN.code to IetfLang.Bengali.IN,
        IetfLang.Tibetan.code to IetfLang.Tibetan,
            IetfLang.Tibetan.CN.code to IetfLang.Tibetan.CN,
            IetfLang.Tibetan.IN.code to IetfLang.Tibetan.IN,
        IetfLang.Breton.code to IetfLang.Breton,
            IetfLang.Breton.FR.code to IetfLang.Breton.FR,
        IetfLang.Bosnian.code to IetfLang.Bosnian,
            IetfLang.Bosnian.Cyrl.code to IetfLang.Bosnian.Cyrl,
                IetfLang.Bosnian.Cyrl.BA.code to IetfLang.Bosnian.Cyrl.BA,
            IetfLang.Bosnian.Latn.code to IetfLang.Bosnian.Latn,
                IetfLang.Bosnian.Latn.BA.code to IetfLang.Bosnian.Latn.BA,
        IetfLang.CatalanValencian.code to IetfLang.CatalanValencian,
            IetfLang.CatalanValencian.AD.code to IetfLang.CatalanValencian.AD,
            IetfLang.CatalanValencian.ES.code to IetfLang.CatalanValencian.ES,
                IetfLang.CatalanValencian.ES.VALENCIA.code to IetfLang.CatalanValencian.ES.VALENCIA,
            IetfLang.CatalanValencian.FR.code to IetfLang.CatalanValencian.FR,
            IetfLang.CatalanValencian.IT.code to IetfLang.CatalanValencian.IT,
        IetfLang.Chechen.code to IetfLang.Chechen,
            IetfLang.Chechen.RU.code to IetfLang.Chechen.RU,
        IetfLang.Chamorro.code to IetfLang.Chamorro,
        IetfLang.Corsican.code to IetfLang.Corsican,
        IetfLang.Cree.code to IetfLang.Cree,
        IetfLang.Czech.code to IetfLang.Czech,
            IetfLang.Czech.CZ.code to IetfLang.Czech.CZ,
        IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.code to IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic,
            IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.RU.code to IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.RU,
        IetfLang.Chuvash.code to IetfLang.Chuvash,
        IetfLang.Welsh.code to IetfLang.Welsh,
            IetfLang.Welsh.GB.code to IetfLang.Welsh.GB,
        IetfLang.Danish.code to IetfLang.Danish,
            IetfLang.Danish.DK.code to IetfLang.Danish.DK,
            IetfLang.Danish.GL.code to IetfLang.Danish.GL,
        IetfLang.German.code to IetfLang.German,
            IetfLang.German.AT.code to IetfLang.German.AT,
            IetfLang.German.BE.code to IetfLang.German.BE,
            IetfLang.German.CH.code to IetfLang.German.CH,
            IetfLang.German.DE.code to IetfLang.German.DE,
            IetfLang.German.IT.code to IetfLang.German.IT,
            IetfLang.German.LI.code to IetfLang.German.LI,
            IetfLang.German.LU.code to IetfLang.German.LU,
        IetfLang.DivehiDhivehiMaldivian.code to IetfLang.DivehiDhivehiMaldivian,
        IetfLang.Dzongkha.code to IetfLang.Dzongkha,
            IetfLang.Dzongkha.BT.code to IetfLang.Dzongkha.BT,
        IetfLang.Ewe.code to IetfLang.Ewe,
            IetfLang.Ewe.GH.code to IetfLang.Ewe.GH,
            IetfLang.Ewe.TG.code to IetfLang.Ewe.TG,
        IetfLang.GreekModern1453.code to IetfLang.GreekModern1453,
            IetfLang.GreekModern1453.CY.code to IetfLang.GreekModern1453.CY,
            IetfLang.GreekModern1453.GR.code to IetfLang.GreekModern1453.GR,
        IetfLang.English.code to IetfLang.English,
            IetfLang.English.L001.code to IetfLang.English.L001,
            IetfLang.English.L150.code to IetfLang.English.L150,
            IetfLang.English.AE.code to IetfLang.English.AE,
            IetfLang.English.AG.code to IetfLang.English.AG,
            IetfLang.English.AI.code to IetfLang.English.AI,
            IetfLang.English.AS.code to IetfLang.English.AS,
            IetfLang.English.AT.code to IetfLang.English.AT,
            IetfLang.English.AU.code to IetfLang.English.AU,
            IetfLang.English.BB.code to IetfLang.English.BB,
            IetfLang.English.BE.code to IetfLang.English.BE,
            IetfLang.English.BI.code to IetfLang.English.BI,
            IetfLang.English.BM.code to IetfLang.English.BM,
            IetfLang.English.BS.code to IetfLang.English.BS,
            IetfLang.English.BW.code to IetfLang.English.BW,
            IetfLang.English.BZ.code to IetfLang.English.BZ,
            IetfLang.English.CA.code to IetfLang.English.CA,
            IetfLang.English.CC.code to IetfLang.English.CC,
            IetfLang.English.CH.code to IetfLang.English.CH,
            IetfLang.English.CK.code to IetfLang.English.CK,
            IetfLang.English.CM.code to IetfLang.English.CM,
            IetfLang.English.CX.code to IetfLang.English.CX,
            IetfLang.English.CY.code to IetfLang.English.CY,
            IetfLang.English.DE.code to IetfLang.English.DE,
            IetfLang.English.DG.code to IetfLang.English.DG,
            IetfLang.English.DK.code to IetfLang.English.DK,
            IetfLang.English.DM.code to IetfLang.English.DM,
            IetfLang.English.ER.code to IetfLang.English.ER,
            IetfLang.English.FI.code to IetfLang.English.FI,
            IetfLang.English.FJ.code to IetfLang.English.FJ,
            IetfLang.English.FK.code to IetfLang.English.FK,
            IetfLang.English.FM.code to IetfLang.English.FM,
            IetfLang.English.GB.code to IetfLang.English.GB,
            IetfLang.English.GD.code to IetfLang.English.GD,
            IetfLang.English.GG.code to IetfLang.English.GG,
            IetfLang.English.GH.code to IetfLang.English.GH,
            IetfLang.English.GI.code to IetfLang.English.GI,
            IetfLang.English.GM.code to IetfLang.English.GM,
            IetfLang.English.GU.code to IetfLang.English.GU,
            IetfLang.English.GY.code to IetfLang.English.GY,
            IetfLang.English.HK.code to IetfLang.English.HK,
            IetfLang.English.IE.code to IetfLang.English.IE,
            IetfLang.English.IL.code to IetfLang.English.IL,
            IetfLang.English.IM.code to IetfLang.English.IM,
            IetfLang.English.IN.code to IetfLang.English.IN,
            IetfLang.English.IO.code to IetfLang.English.IO,
            IetfLang.English.JE.code to IetfLang.English.JE,
            IetfLang.English.JM.code to IetfLang.English.JM,
            IetfLang.English.KE.code to IetfLang.English.KE,
            IetfLang.English.KI.code to IetfLang.English.KI,
            IetfLang.English.KN.code to IetfLang.English.KN,
            IetfLang.English.KY.code to IetfLang.English.KY,
            IetfLang.English.LC.code to IetfLang.English.LC,
            IetfLang.English.LR.code to IetfLang.English.LR,
            IetfLang.English.LS.code to IetfLang.English.LS,
            IetfLang.English.MG.code to IetfLang.English.MG,
            IetfLang.English.MH.code to IetfLang.English.MH,
            IetfLang.English.MO.code to IetfLang.English.MO,
            IetfLang.English.MP.code to IetfLang.English.MP,
            IetfLang.English.MS.code to IetfLang.English.MS,
            IetfLang.English.MT.code to IetfLang.English.MT,
            IetfLang.English.MU.code to IetfLang.English.MU,
            IetfLang.English.MW.code to IetfLang.English.MW,
            IetfLang.English.MY.code to IetfLang.English.MY,
            IetfLang.English.NA.code to IetfLang.English.NA,
            IetfLang.English.NF.code to IetfLang.English.NF,
            IetfLang.English.NG.code to IetfLang.English.NG,
            IetfLang.English.NL.code to IetfLang.English.NL,
            IetfLang.English.NR.code to IetfLang.English.NR,
            IetfLang.English.NU.code to IetfLang.English.NU,
            IetfLang.English.NZ.code to IetfLang.English.NZ,
            IetfLang.English.PG.code to IetfLang.English.PG,
            IetfLang.English.PH.code to IetfLang.English.PH,
            IetfLang.English.PK.code to IetfLang.English.PK,
            IetfLang.English.PN.code to IetfLang.English.PN,
            IetfLang.English.PR.code to IetfLang.English.PR,
            IetfLang.English.PW.code to IetfLang.English.PW,
            IetfLang.English.RW.code to IetfLang.English.RW,
            IetfLang.English.SB.code to IetfLang.English.SB,
            IetfLang.English.SC.code to IetfLang.English.SC,
            IetfLang.English.SD.code to IetfLang.English.SD,
            IetfLang.English.SE.code to IetfLang.English.SE,
            IetfLang.English.SG.code to IetfLang.English.SG,
            IetfLang.English.SH.code to IetfLang.English.SH,
            IetfLang.English.SI.code to IetfLang.English.SI,
            IetfLang.English.SL.code to IetfLang.English.SL,
            IetfLang.English.SS.code to IetfLang.English.SS,
            IetfLang.English.SX.code to IetfLang.English.SX,
            IetfLang.English.SZ.code to IetfLang.English.SZ,
            IetfLang.English.TC.code to IetfLang.English.TC,
            IetfLang.English.TK.code to IetfLang.English.TK,
            IetfLang.English.TO.code to IetfLang.English.TO,
            IetfLang.English.TT.code to IetfLang.English.TT,
            IetfLang.English.TV.code to IetfLang.English.TV,
            IetfLang.English.TZ.code to IetfLang.English.TZ,
            IetfLang.English.UG.code to IetfLang.English.UG,
            IetfLang.English.UM.code to IetfLang.English.UM,
            IetfLang.English.US.code to IetfLang.English.US,
                IetfLang.English.US.POSIX.code to IetfLang.English.US.POSIX,
            IetfLang.English.VC.code to IetfLang.English.VC,
            IetfLang.English.VG.code to IetfLang.English.VG,
            IetfLang.English.VI.code to IetfLang.English.VI,
            IetfLang.English.VU.code to IetfLang.English.VU,
            IetfLang.English.WS.code to IetfLang.English.WS,
            IetfLang.English.ZA.code to IetfLang.English.ZA,
            IetfLang.English.ZM.code to IetfLang.English.ZM,
            IetfLang.English.ZW.code to IetfLang.English.ZW,
        IetfLang.Esperanto.code to IetfLang.Esperanto,
            IetfLang.Esperanto.L001.code to IetfLang.Esperanto.L001,
        IetfLang.SpanishCastilian.code to IetfLang.SpanishCastilian,
            IetfLang.SpanishCastilian.L419.code to IetfLang.SpanishCastilian.L419,
            IetfLang.SpanishCastilian.AR.code to IetfLang.SpanishCastilian.AR,
            IetfLang.SpanishCastilian.BO.code to IetfLang.SpanishCastilian.BO,
            IetfLang.SpanishCastilian.BR.code to IetfLang.SpanishCastilian.BR,
            IetfLang.SpanishCastilian.BZ.code to IetfLang.SpanishCastilian.BZ,
            IetfLang.SpanishCastilian.CL.code to IetfLang.SpanishCastilian.CL,
            IetfLang.SpanishCastilian.CO.code to IetfLang.SpanishCastilian.CO,
            IetfLang.SpanishCastilian.CR.code to IetfLang.SpanishCastilian.CR,
            IetfLang.SpanishCastilian.CU.code to IetfLang.SpanishCastilian.CU,
            IetfLang.SpanishCastilian.DO.code to IetfLang.SpanishCastilian.DO,
            IetfLang.SpanishCastilian.EA.code to IetfLang.SpanishCastilian.EA,
            IetfLang.SpanishCastilian.EC.code to IetfLang.SpanishCastilian.EC,
            IetfLang.SpanishCastilian.ES.code to IetfLang.SpanishCastilian.ES,
            IetfLang.SpanishCastilian.GQ.code to IetfLang.SpanishCastilian.GQ,
            IetfLang.SpanishCastilian.GT.code to IetfLang.SpanishCastilian.GT,
            IetfLang.SpanishCastilian.HN.code to IetfLang.SpanishCastilian.HN,
            IetfLang.SpanishCastilian.IC.code to IetfLang.SpanishCastilian.IC,
            IetfLang.SpanishCastilian.MX.code to IetfLang.SpanishCastilian.MX,
            IetfLang.SpanishCastilian.NI.code to IetfLang.SpanishCastilian.NI,
            IetfLang.SpanishCastilian.PA.code to IetfLang.SpanishCastilian.PA,
            IetfLang.SpanishCastilian.PE.code to IetfLang.SpanishCastilian.PE,
            IetfLang.SpanishCastilian.PH.code to IetfLang.SpanishCastilian.PH,
            IetfLang.SpanishCastilian.PR.code to IetfLang.SpanishCastilian.PR,
            IetfLang.SpanishCastilian.PY.code to IetfLang.SpanishCastilian.PY,
            IetfLang.SpanishCastilian.SV.code to IetfLang.SpanishCastilian.SV,
            IetfLang.SpanishCastilian.US.code to IetfLang.SpanishCastilian.US,
            IetfLang.SpanishCastilian.UY.code to IetfLang.SpanishCastilian.UY,
            IetfLang.SpanishCastilian.VE.code to IetfLang.SpanishCastilian.VE,
        IetfLang.Estonian.code to IetfLang.Estonian,
            IetfLang.Estonian.EE.code to IetfLang.Estonian.EE,
        IetfLang.Basque.code to IetfLang.Basque,
            IetfLang.Basque.ES.code to IetfLang.Basque.ES,
        IetfLang.Persian.code to IetfLang.Persian,
            IetfLang.Persian.AF.code to IetfLang.Persian.AF,
            IetfLang.Persian.IR.code to IetfLang.Persian.IR,
        IetfLang.Fulah.code to IetfLang.Fulah,
            IetfLang.Fulah.Adlm.code to IetfLang.Fulah.Adlm,
                IetfLang.Fulah.Adlm.BF.code to IetfLang.Fulah.Adlm.BF,
                IetfLang.Fulah.Adlm.CM.code to IetfLang.Fulah.Adlm.CM,
                IetfLang.Fulah.Adlm.GH.code to IetfLang.Fulah.Adlm.GH,
                IetfLang.Fulah.Adlm.GM.code to IetfLang.Fulah.Adlm.GM,
                IetfLang.Fulah.Adlm.GN.code to IetfLang.Fulah.Adlm.GN,
                IetfLang.Fulah.Adlm.GW.code to IetfLang.Fulah.Adlm.GW,
                IetfLang.Fulah.Adlm.LR.code to IetfLang.Fulah.Adlm.LR,
                IetfLang.Fulah.Adlm.MR.code to IetfLang.Fulah.Adlm.MR,
                IetfLang.Fulah.Adlm.NE.code to IetfLang.Fulah.Adlm.NE,
                IetfLang.Fulah.Adlm.NG.code to IetfLang.Fulah.Adlm.NG,
                IetfLang.Fulah.Adlm.SL.code to IetfLang.Fulah.Adlm.SL,
                IetfLang.Fulah.Adlm.SN.code to IetfLang.Fulah.Adlm.SN,
            IetfLang.Fulah.Latn.code to IetfLang.Fulah.Latn,
                IetfLang.Fulah.Latn.BF.code to IetfLang.Fulah.Latn.BF,
                IetfLang.Fulah.Latn.CM.code to IetfLang.Fulah.Latn.CM,
                IetfLang.Fulah.Latn.GH.code to IetfLang.Fulah.Latn.GH,
                IetfLang.Fulah.Latn.GM.code to IetfLang.Fulah.Latn.GM,
                IetfLang.Fulah.Latn.GN.code to IetfLang.Fulah.Latn.GN,
                IetfLang.Fulah.Latn.GW.code to IetfLang.Fulah.Latn.GW,
                IetfLang.Fulah.Latn.LR.code to IetfLang.Fulah.Latn.LR,
                IetfLang.Fulah.Latn.MR.code to IetfLang.Fulah.Latn.MR,
                IetfLang.Fulah.Latn.NE.code to IetfLang.Fulah.Latn.NE,
                IetfLang.Fulah.Latn.NG.code to IetfLang.Fulah.Latn.NG,
                IetfLang.Fulah.Latn.SL.code to IetfLang.Fulah.Latn.SL,
                IetfLang.Fulah.Latn.SN.code to IetfLang.Fulah.Latn.SN,
        IetfLang.Finnish.code to IetfLang.Finnish,
            IetfLang.Finnish.FI.code to IetfLang.Finnish.FI,
        IetfLang.Fijian.code to IetfLang.Fijian,
        IetfLang.Faroese.code to IetfLang.Faroese,
            IetfLang.Faroese.DK.code to IetfLang.Faroese.DK,
            IetfLang.Faroese.FO.code to IetfLang.Faroese.FO,
        IetfLang.French.code to IetfLang.French,
            IetfLang.French.BE.code to IetfLang.French.BE,
            IetfLang.French.BF.code to IetfLang.French.BF,
            IetfLang.French.BI.code to IetfLang.French.BI,
            IetfLang.French.BJ.code to IetfLang.French.BJ,
            IetfLang.French.BL.code to IetfLang.French.BL,
            IetfLang.French.CA.code to IetfLang.French.CA,
            IetfLang.French.CD.code to IetfLang.French.CD,
            IetfLang.French.CF.code to IetfLang.French.CF,
            IetfLang.French.CG.code to IetfLang.French.CG,
            IetfLang.French.CH.code to IetfLang.French.CH,
            IetfLang.French.CI.code to IetfLang.French.CI,
            IetfLang.French.CM.code to IetfLang.French.CM,
            IetfLang.French.DJ.code to IetfLang.French.DJ,
            IetfLang.French.DZ.code to IetfLang.French.DZ,
            IetfLang.French.FR.code to IetfLang.French.FR,
            IetfLang.French.GA.code to IetfLang.French.GA,
            IetfLang.French.GF.code to IetfLang.French.GF,
            IetfLang.French.GN.code to IetfLang.French.GN,
            IetfLang.French.GP.code to IetfLang.French.GP,
            IetfLang.French.GQ.code to IetfLang.French.GQ,
            IetfLang.French.HT.code to IetfLang.French.HT,
            IetfLang.French.KM.code to IetfLang.French.KM,
            IetfLang.French.LU.code to IetfLang.French.LU,
            IetfLang.French.MA.code to IetfLang.French.MA,
            IetfLang.French.MC.code to IetfLang.French.MC,
            IetfLang.French.MF.code to IetfLang.French.MF,
            IetfLang.French.MG.code to IetfLang.French.MG,
            IetfLang.French.ML.code to IetfLang.French.ML,
            IetfLang.French.MQ.code to IetfLang.French.MQ,
            IetfLang.French.MR.code to IetfLang.French.MR,
            IetfLang.French.MU.code to IetfLang.French.MU,
            IetfLang.French.NC.code to IetfLang.French.NC,
            IetfLang.French.NE.code to IetfLang.French.NE,
            IetfLang.French.PF.code to IetfLang.French.PF,
            IetfLang.French.PM.code to IetfLang.French.PM,
            IetfLang.French.RE.code to IetfLang.French.RE,
            IetfLang.French.RW.code to IetfLang.French.RW,
            IetfLang.French.SC.code to IetfLang.French.SC,
            IetfLang.French.SN.code to IetfLang.French.SN,
            IetfLang.French.SY.code to IetfLang.French.SY,
            IetfLang.French.TD.code to IetfLang.French.TD,
            IetfLang.French.TG.code to IetfLang.French.TG,
            IetfLang.French.TN.code to IetfLang.French.TN,
            IetfLang.French.VU.code to IetfLang.French.VU,
            IetfLang.French.WF.code to IetfLang.French.WF,
            IetfLang.French.YT.code to IetfLang.French.YT,
        IetfLang.WesternFrisian.code to IetfLang.WesternFrisian,
            IetfLang.WesternFrisian.NL.code to IetfLang.WesternFrisian.NL,
        IetfLang.Irish.code to IetfLang.Irish,
            IetfLang.Irish.GB.code to IetfLang.Irish.GB,
            IetfLang.Irish.IE.code to IetfLang.Irish.IE,
        IetfLang.GaelicScottishGaelic.code to IetfLang.GaelicScottishGaelic,
            IetfLang.GaelicScottishGaelic.GB.code to IetfLang.GaelicScottishGaelic.GB,
        IetfLang.Galician.code to IetfLang.Galician,
            IetfLang.Galician.ES.code to IetfLang.Galician.ES,
        IetfLang.Guarani.code to IetfLang.Guarani,
        IetfLang.Gujarati.code to IetfLang.Gujarati,
            IetfLang.Gujarati.IN.code to IetfLang.Gujarati.IN,
        IetfLang.Manx.code to IetfLang.Manx,
            IetfLang.Manx.IM.code to IetfLang.Manx.IM,
        IetfLang.Hausa.code to IetfLang.Hausa,
            IetfLang.Hausa.GH.code to IetfLang.Hausa.GH,
            IetfLang.Hausa.NE.code to IetfLang.Hausa.NE,
            IetfLang.Hausa.NG.code to IetfLang.Hausa.NG,
        IetfLang.Hebrew.code to IetfLang.Hebrew,
            IetfLang.Hebrew.IL.code to IetfLang.Hebrew.IL,
        IetfLang.Hindi.code to IetfLang.Hindi,
            IetfLang.Hindi.IN.code to IetfLang.Hindi.IN,
        IetfLang.HiriMotu.code to IetfLang.HiriMotu,
        IetfLang.Croatian.code to IetfLang.Croatian,
            IetfLang.Croatian.BA.code to IetfLang.Croatian.BA,
            IetfLang.Croatian.HR.code to IetfLang.Croatian.HR,
        IetfLang.HaitianHaitianCreole.code to IetfLang.HaitianHaitianCreole,
        IetfLang.Hungarian.code to IetfLang.Hungarian,
            IetfLang.Hungarian.HU.code to IetfLang.Hungarian.HU,
        IetfLang.Armenian.code to IetfLang.Armenian,
            IetfLang.Armenian.AM.code to IetfLang.Armenian.AM,
        IetfLang.Herero.code to IetfLang.Herero,
        IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation.code to IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation,
            IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation.L001.code to IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation.L001,
        IetfLang.Indonesian.code to IetfLang.Indonesian,
            IetfLang.Indonesian.ID.code to IetfLang.Indonesian.ID,
        IetfLang.InterlingueOccidental.code to IetfLang.InterlingueOccidental,
        IetfLang.Igbo.code to IetfLang.Igbo,
            IetfLang.Igbo.NG.code to IetfLang.Igbo.NG,
        IetfLang.SichuanYiNuosu.code to IetfLang.SichuanYiNuosu,
            IetfLang.SichuanYiNuosu.CN.code to IetfLang.SichuanYiNuosu.CN,
        IetfLang.Inupiaq.code to IetfLang.Inupiaq,
        IetfLang.Ido.code to IetfLang.Ido,
        IetfLang.Icelandic.code to IetfLang.Icelandic,
            IetfLang.Icelandic.IS.code to IetfLang.Icelandic.IS,
        IetfLang.Italian.code to IetfLang.Italian,
            IetfLang.Italian.CH.code to IetfLang.Italian.CH,
            IetfLang.Italian.IT.code to IetfLang.Italian.IT,
            IetfLang.Italian.SM.code to IetfLang.Italian.SM,
            IetfLang.Italian.VA.code to IetfLang.Italian.VA,
        IetfLang.Inuktitut.code to IetfLang.Inuktitut,
        IetfLang.Japanese.code to IetfLang.Japanese,
            IetfLang.Japanese.JP.code to IetfLang.Japanese.JP,
        IetfLang.Javanese.code to IetfLang.Javanese,
            IetfLang.Javanese.ID.code to IetfLang.Javanese.ID,
        IetfLang.Georgian.code to IetfLang.Georgian,
            IetfLang.Georgian.GE.code to IetfLang.Georgian.GE,
        IetfLang.Kongo.code to IetfLang.Kongo,
        IetfLang.KikuyuGikuyu.code to IetfLang.KikuyuGikuyu,
            IetfLang.KikuyuGikuyu.KE.code to IetfLang.KikuyuGikuyu.KE,
        IetfLang.KuanyamaKwanyama.code to IetfLang.KuanyamaKwanyama,
        IetfLang.Kazakh.code to IetfLang.Kazakh,
            IetfLang.Kazakh.KZ.code to IetfLang.Kazakh.KZ,
        IetfLang.KalaallisutGreenlandic.code to IetfLang.KalaallisutGreenlandic,
            IetfLang.KalaallisutGreenlandic.GL.code to IetfLang.KalaallisutGreenlandic.GL,
        IetfLang.CentralKhmer.code to IetfLang.CentralKhmer,
            IetfLang.CentralKhmer.KH.code to IetfLang.CentralKhmer.KH,
        IetfLang.Kannada.code to IetfLang.Kannada,
            IetfLang.Kannada.IN.code to IetfLang.Kannada.IN,
        IetfLang.Korean.code to IetfLang.Korean,
            IetfLang.Korean.KP.code to IetfLang.Korean.KP,
            IetfLang.Korean.KR.code to IetfLang.Korean.KR,
        IetfLang.Kanuri.code to IetfLang.Kanuri,
        IetfLang.Kashmiri.code to IetfLang.Kashmiri,
            IetfLang.Kashmiri.Arab.code to IetfLang.Kashmiri.Arab,
                IetfLang.Kashmiri.Arab.IN.code to IetfLang.Kashmiri.Arab.IN,
        IetfLang.Kurdish.code to IetfLang.Kurdish,
            IetfLang.Kurdish.TR.code to IetfLang.Kurdish.TR,
        IetfLang.Komi.code to IetfLang.Komi,
        IetfLang.Cornish.code to IetfLang.Cornish,
            IetfLang.Cornish.GB.code to IetfLang.Cornish.GB,
        IetfLang.KirghizKyrgyz.code to IetfLang.KirghizKyrgyz,
            IetfLang.KirghizKyrgyz.KG.code to IetfLang.KirghizKyrgyz.KG,
        IetfLang.Latin.code to IetfLang.Latin,
        IetfLang.LuxembourgishLetzeburgesch.code to IetfLang.LuxembourgishLetzeburgesch,
            IetfLang.LuxembourgishLetzeburgesch.LU.code to IetfLang.LuxembourgishLetzeburgesch.LU,
        IetfLang.Ganda.code to IetfLang.Ganda,
            IetfLang.Ganda.UG.code to IetfLang.Ganda.UG,
        IetfLang.LimburganLimburgerLimburgish.code to IetfLang.LimburganLimburgerLimburgish,
        IetfLang.Lingala.code to IetfLang.Lingala,
            IetfLang.Lingala.AO.code to IetfLang.Lingala.AO,
            IetfLang.Lingala.CD.code to IetfLang.Lingala.CD,
            IetfLang.Lingala.CF.code to IetfLang.Lingala.CF,
            IetfLang.Lingala.CG.code to IetfLang.Lingala.CG,
        IetfLang.Lao.code to IetfLang.Lao,
            IetfLang.Lao.LA.code to IetfLang.Lao.LA,
        IetfLang.Lithuanian.code to IetfLang.Lithuanian,
            IetfLang.Lithuanian.LT.code to IetfLang.Lithuanian.LT,
        IetfLang.LubaKatanga.code to IetfLang.LubaKatanga,
            IetfLang.LubaKatanga.CD.code to IetfLang.LubaKatanga.CD,
        IetfLang.Latvian.code to IetfLang.Latvian,
            IetfLang.Latvian.LV.code to IetfLang.Latvian.LV,
        IetfLang.Malagasy.code to IetfLang.Malagasy,
            IetfLang.Malagasy.MG.code to IetfLang.Malagasy.MG,
        IetfLang.Marshallese.code to IetfLang.Marshallese,
        IetfLang.Maori.code to IetfLang.Maori,
            IetfLang.Maori.NZ.code to IetfLang.Maori.NZ,
        IetfLang.Macedonian.code to IetfLang.Macedonian,
            IetfLang.Macedonian.MK.code to IetfLang.Macedonian.MK,
        IetfLang.Malayalam.code to IetfLang.Malayalam,
            IetfLang.Malayalam.IN.code to IetfLang.Malayalam.IN,
        IetfLang.Mongolian.code to IetfLang.Mongolian,
            IetfLang.Mongolian.MN.code to IetfLang.Mongolian.MN,
        IetfLang.Marathi.code to IetfLang.Marathi,
            IetfLang.Marathi.IN.code to IetfLang.Marathi.IN,
        IetfLang.Malay.code to IetfLang.Malay,
            IetfLang.Malay.BN.code to IetfLang.Malay.BN,
            IetfLang.Malay.ID.code to IetfLang.Malay.ID,
            IetfLang.Malay.MY.code to IetfLang.Malay.MY,
            IetfLang.Malay.SG.code to IetfLang.Malay.SG,
        IetfLang.Maltese.code to IetfLang.Maltese,
            IetfLang.Maltese.MT.code to IetfLang.Maltese.MT,
        IetfLang.Burmese.code to IetfLang.Burmese,
            IetfLang.Burmese.MM.code to IetfLang.Burmese.MM,
        IetfLang.Nauru.code to IetfLang.Nauru,
        IetfLang.BokmalNorwegianNorwegianBokmal.code to IetfLang.BokmalNorwegianNorwegianBokmal,
            IetfLang.BokmalNorwegianNorwegianBokmal.NO.code to IetfLang.BokmalNorwegianNorwegianBokmal.NO,
            IetfLang.BokmalNorwegianNorwegianBokmal.SJ.code to IetfLang.BokmalNorwegianNorwegianBokmal.SJ,
        IetfLang.NdebeleNorthNorthNdebele.code to IetfLang.NdebeleNorthNorthNdebele,
            IetfLang.NdebeleNorthNorthNdebele.ZW.code to IetfLang.NdebeleNorthNorthNdebele.ZW,
        IetfLang.Nepali.code to IetfLang.Nepali,
            IetfLang.Nepali.IN.code to IetfLang.Nepali.IN,
            IetfLang.Nepali.NP.code to IetfLang.Nepali.NP,
        IetfLang.Ndonga.code to IetfLang.Ndonga,
        IetfLang.DutchFlemish.code to IetfLang.DutchFlemish,
            IetfLang.DutchFlemish.AW.code to IetfLang.DutchFlemish.AW,
            IetfLang.DutchFlemish.BE.code to IetfLang.DutchFlemish.BE,
            IetfLang.DutchFlemish.BQ.code to IetfLang.DutchFlemish.BQ,
            IetfLang.DutchFlemish.CW.code to IetfLang.DutchFlemish.CW,
            IetfLang.DutchFlemish.NL.code to IetfLang.DutchFlemish.NL,
            IetfLang.DutchFlemish.SR.code to IetfLang.DutchFlemish.SR,
            IetfLang.DutchFlemish.SX.code to IetfLang.DutchFlemish.SX,
        IetfLang.NorwegianNynorskNynorskNorwegian.code to IetfLang.NorwegianNynorskNynorskNorwegian,
            IetfLang.NorwegianNynorskNynorskNorwegian.NO.code to IetfLang.NorwegianNynorskNynorskNorwegian.NO,
        IetfLang.Norwegian.code to IetfLang.Norwegian,
        IetfLang.NdebeleSouthSouthNdebele.code to IetfLang.NdebeleSouthSouthNdebele,
        IetfLang.NavajoNavaho.code to IetfLang.NavajoNavaho,
        IetfLang.ChichewaChewaNyanja.code to IetfLang.ChichewaChewaNyanja,
        IetfLang.OccitanPost1500.code to IetfLang.OccitanPost1500,
        IetfLang.Ojibwa.code to IetfLang.Ojibwa,
        IetfLang.Oromo.code to IetfLang.Oromo,
            IetfLang.Oromo.ET.code to IetfLang.Oromo.ET,
            IetfLang.Oromo.KE.code to IetfLang.Oromo.KE,
        IetfLang.Oriya.code to IetfLang.Oriya,
            IetfLang.Oriya.IN.code to IetfLang.Oriya.IN,
        IetfLang.OssetianOssetic.code to IetfLang.OssetianOssetic,
            IetfLang.OssetianOssetic.GE.code to IetfLang.OssetianOssetic.GE,
            IetfLang.OssetianOssetic.RU.code to IetfLang.OssetianOssetic.RU,
        IetfLang.PanjabiPunjabi.code to IetfLang.PanjabiPunjabi,
            IetfLang.PanjabiPunjabi.Arab.code to IetfLang.PanjabiPunjabi.Arab,
                IetfLang.PanjabiPunjabi.Arab.PK.code to IetfLang.PanjabiPunjabi.Arab.PK,
            IetfLang.PanjabiPunjabi.Guru.code to IetfLang.PanjabiPunjabi.Guru,
                IetfLang.PanjabiPunjabi.Guru.IN.code to IetfLang.PanjabiPunjabi.Guru.IN,
        IetfLang.Pali.code to IetfLang.Pali,
        IetfLang.Polish.code to IetfLang.Polish,
            IetfLang.Polish.PL.code to IetfLang.Polish.PL,
        IetfLang.PushtoPashto.code to IetfLang.PushtoPashto,
            IetfLang.PushtoPashto.AF.code to IetfLang.PushtoPashto.AF,
            IetfLang.PushtoPashto.PK.code to IetfLang.PushtoPashto.PK,
        IetfLang.Portuguese.code to IetfLang.Portuguese,
            IetfLang.Portuguese.AO.code to IetfLang.Portuguese.AO,
            IetfLang.Portuguese.BR.code to IetfLang.Portuguese.BR,
            IetfLang.Portuguese.CH.code to IetfLang.Portuguese.CH,
            IetfLang.Portuguese.CV.code to IetfLang.Portuguese.CV,
            IetfLang.Portuguese.GQ.code to IetfLang.Portuguese.GQ,
            IetfLang.Portuguese.GW.code to IetfLang.Portuguese.GW,
            IetfLang.Portuguese.LU.code to IetfLang.Portuguese.LU,
            IetfLang.Portuguese.MO.code to IetfLang.Portuguese.MO,
            IetfLang.Portuguese.MZ.code to IetfLang.Portuguese.MZ,
            IetfLang.Portuguese.PT.code to IetfLang.Portuguese.PT,
            IetfLang.Portuguese.ST.code to IetfLang.Portuguese.ST,
            IetfLang.Portuguese.TL.code to IetfLang.Portuguese.TL,
        IetfLang.Quechua.code to IetfLang.Quechua,
            IetfLang.Quechua.BO.code to IetfLang.Quechua.BO,
            IetfLang.Quechua.EC.code to IetfLang.Quechua.EC,
            IetfLang.Quechua.PE.code to IetfLang.Quechua.PE,
        IetfLang.Romansh.code to IetfLang.Romansh,
            IetfLang.Romansh.CH.code to IetfLang.Romansh.CH,
        IetfLang.Rundi.code to IetfLang.Rundi,
            IetfLang.Rundi.BI.code to IetfLang.Rundi.BI,
        IetfLang.RomanianMoldavianMoldovan.code to IetfLang.RomanianMoldavianMoldovan,
            IetfLang.RomanianMoldavianMoldovan.MD.code to IetfLang.RomanianMoldavianMoldovan.MD,
            IetfLang.RomanianMoldavianMoldovan.RO.code to IetfLang.RomanianMoldavianMoldovan.RO,
        IetfLang.Russian.code to IetfLang.Russian,
            IetfLang.Russian.BY.code to IetfLang.Russian.BY,
            IetfLang.Russian.KG.code to IetfLang.Russian.KG,
            IetfLang.Russian.KZ.code to IetfLang.Russian.KZ,
            IetfLang.Russian.MD.code to IetfLang.Russian.MD,
            IetfLang.Russian.RU.code to IetfLang.Russian.RU,
            IetfLang.Russian.UA.code to IetfLang.Russian.UA,
        IetfLang.Kinyarwanda.code to IetfLang.Kinyarwanda,
            IetfLang.Kinyarwanda.RW.code to IetfLang.Kinyarwanda.RW,
        IetfLang.Sanskrit.code to IetfLang.Sanskrit,
        IetfLang.Sardinian.code to IetfLang.Sardinian,
        IetfLang.Sindhi.code to IetfLang.Sindhi,
            IetfLang.Sindhi.Arab.code to IetfLang.Sindhi.Arab,
                IetfLang.Sindhi.Arab.PK.code to IetfLang.Sindhi.Arab.PK,
            IetfLang.Sindhi.Deva.code to IetfLang.Sindhi.Deva,
                IetfLang.Sindhi.Deva.IN.code to IetfLang.Sindhi.Deva.IN,
        IetfLang.NorthernSami.code to IetfLang.NorthernSami,
            IetfLang.NorthernSami.FI.code to IetfLang.NorthernSami.FI,
            IetfLang.NorthernSami.NO.code to IetfLang.NorthernSami.NO,
            IetfLang.NorthernSami.SE.code to IetfLang.NorthernSami.SE,
        IetfLang.Sango.code to IetfLang.Sango,
            IetfLang.Sango.CF.code to IetfLang.Sango.CF,
        IetfLang.SinhalaSinhalese.code to IetfLang.SinhalaSinhalese,
            IetfLang.SinhalaSinhalese.LK.code to IetfLang.SinhalaSinhalese.LK,
        IetfLang.Slovak.code to IetfLang.Slovak,
            IetfLang.Slovak.SK.code to IetfLang.Slovak.SK,
        IetfLang.Slovenian.code to IetfLang.Slovenian,
            IetfLang.Slovenian.SI.code to IetfLang.Slovenian.SI,
        IetfLang.Samoan.code to IetfLang.Samoan,
        IetfLang.Shona.code to IetfLang.Shona,
            IetfLang.Shona.ZW.code to IetfLang.Shona.ZW,
        IetfLang.Somali.code to IetfLang.Somali,
            IetfLang.Somali.DJ.code to IetfLang.Somali.DJ,
            IetfLang.Somali.ET.code to IetfLang.Somali.ET,
            IetfLang.Somali.KE.code to IetfLang.Somali.KE,
            IetfLang.Somali.SO.code to IetfLang.Somali.SO,
        IetfLang.Albanian.code to IetfLang.Albanian,
            IetfLang.Albanian.AL.code to IetfLang.Albanian.AL,
            IetfLang.Albanian.MK.code to IetfLang.Albanian.MK,
            IetfLang.Albanian.XK.code to IetfLang.Albanian.XK,
        IetfLang.Serbian.code to IetfLang.Serbian,
            IetfLang.Serbian.Cyrl.code to IetfLang.Serbian.Cyrl,
                IetfLang.Serbian.Cyrl.BA.code to IetfLang.Serbian.Cyrl.BA,
                IetfLang.Serbian.Cyrl.ME.code to IetfLang.Serbian.Cyrl.ME,
                IetfLang.Serbian.Cyrl.RS.code to IetfLang.Serbian.Cyrl.RS,
                IetfLang.Serbian.Cyrl.XK.code to IetfLang.Serbian.Cyrl.XK,
            IetfLang.Serbian.Latn.code to IetfLang.Serbian.Latn,
                IetfLang.Serbian.Latn.BA.code to IetfLang.Serbian.Latn.BA,
                IetfLang.Serbian.Latn.ME.code to IetfLang.Serbian.Latn.ME,
                IetfLang.Serbian.Latn.RS.code to IetfLang.Serbian.Latn.RS,
                IetfLang.Serbian.Latn.XK.code to IetfLang.Serbian.Latn.XK,
        IetfLang.Swati.code to IetfLang.Swati,
        IetfLang.SothoSouthern.code to IetfLang.SothoSouthern,
        IetfLang.Sundanese.code to IetfLang.Sundanese,
            IetfLang.Sundanese.Latn.code to IetfLang.Sundanese.Latn,
                IetfLang.Sundanese.Latn.ID.code to IetfLang.Sundanese.Latn.ID,
        IetfLang.Swedish.code to IetfLang.Swedish,
            IetfLang.Swedish.AX.code to IetfLang.Swedish.AX,
            IetfLang.Swedish.FI.code to IetfLang.Swedish.FI,
            IetfLang.Swedish.SE.code to IetfLang.Swedish.SE,
        IetfLang.Swahili.code to IetfLang.Swahili,
            IetfLang.Swahili.CD.code to IetfLang.Swahili.CD,
            IetfLang.Swahili.KE.code to IetfLang.Swahili.KE,
            IetfLang.Swahili.TZ.code to IetfLang.Swahili.TZ,
            IetfLang.Swahili.UG.code to IetfLang.Swahili.UG,
        IetfLang.Tamil.code to IetfLang.Tamil,
            IetfLang.Tamil.IN.code to IetfLang.Tamil.IN,
            IetfLang.Tamil.LK.code to IetfLang.Tamil.LK,
            IetfLang.Tamil.MY.code to IetfLang.Tamil.MY,
            IetfLang.Tamil.SG.code to IetfLang.Tamil.SG,
        IetfLang.Telugu.code to IetfLang.Telugu,
            IetfLang.Telugu.IN.code to IetfLang.Telugu.IN,
        IetfLang.Tajik.code to IetfLang.Tajik,
            IetfLang.Tajik.TJ.code to IetfLang.Tajik.TJ,
        IetfLang.Thai.code to IetfLang.Thai,
            IetfLang.Thai.TH.code to IetfLang.Thai.TH,
        IetfLang.Tigrinya.code to IetfLang.Tigrinya,
            IetfLang.Tigrinya.ER.code to IetfLang.Tigrinya.ER,
            IetfLang.Tigrinya.ET.code to IetfLang.Tigrinya.ET,
        IetfLang.Turkmen.code to IetfLang.Turkmen,
            IetfLang.Turkmen.TM.code to IetfLang.Turkmen.TM,
        IetfLang.Tagalog.code to IetfLang.Tagalog,
        IetfLang.Tswana.code to IetfLang.Tswana,
        IetfLang.TongaTongaIslands.code to IetfLang.TongaTongaIslands,
            IetfLang.TongaTongaIslands.TO.code to IetfLang.TongaTongaIslands.TO,
        IetfLang.Turkish.code to IetfLang.Turkish,
            IetfLang.Turkish.CY.code to IetfLang.Turkish.CY,
            IetfLang.Turkish.TR.code to IetfLang.Turkish.TR,
        IetfLang.Tsonga.code to IetfLang.Tsonga,
        IetfLang.Tatar.code to IetfLang.Tatar,
            IetfLang.Tatar.RU.code to IetfLang.Tatar.RU,
        IetfLang.Twi.code to IetfLang.Twi,
        IetfLang.Tahitian.code to IetfLang.Tahitian,
        IetfLang.UighurUyghur.code to IetfLang.UighurUyghur,
            IetfLang.UighurUyghur.CN.code to IetfLang.UighurUyghur.CN,
        IetfLang.Ukrainian.code to IetfLang.Ukrainian,
            IetfLang.Ukrainian.UA.code to IetfLang.Ukrainian.UA,
        IetfLang.Urdu.code to IetfLang.Urdu,
            IetfLang.Urdu.IN.code to IetfLang.Urdu.IN,
            IetfLang.Urdu.PK.code to IetfLang.Urdu.PK,
        IetfLang.Uzbek.code to IetfLang.Uzbek,
            IetfLang.Uzbek.Arab.code to IetfLang.Uzbek.Arab,
                IetfLang.Uzbek.Arab.AF.code to IetfLang.Uzbek.Arab.AF,
            IetfLang.Uzbek.Cyrl.code to IetfLang.Uzbek.Cyrl,
                IetfLang.Uzbek.Cyrl.UZ.code to IetfLang.Uzbek.Cyrl.UZ,
            IetfLang.Uzbek.Latn.code to IetfLang.Uzbek.Latn,
                IetfLang.Uzbek.Latn.UZ.code to IetfLang.Uzbek.Latn.UZ,
        IetfLang.Venda.code to IetfLang.Venda,
        IetfLang.Vietnamese.code to IetfLang.Vietnamese,
            IetfLang.Vietnamese.VN.code to IetfLang.Vietnamese.VN,
        IetfLang.Volapuk.code to IetfLang.Volapuk,
            IetfLang.Volapuk.L001.code to IetfLang.Volapuk.L001,
        IetfLang.Walloon.code to IetfLang.Walloon,
        IetfLang.Wolof.code to IetfLang.Wolof,
            IetfLang.Wolof.SN.code to IetfLang.Wolof.SN,
        IetfLang.Xhosa.code to IetfLang.Xhosa,
            IetfLang.Xhosa.ZA.code to IetfLang.Xhosa.ZA,
        IetfLang.Yiddish.code to IetfLang.Yiddish,
            IetfLang.Yiddish.L001.code to IetfLang.Yiddish.L001,
        IetfLang.Yoruba.code to IetfLang.Yoruba,
            IetfLang.Yoruba.BJ.code to IetfLang.Yoruba.BJ,
            IetfLang.Yoruba.NG.code to IetfLang.Yoruba.NG,
        IetfLang.ZhuangChuang.code to IetfLang.ZhuangChuang,
        IetfLang.Chinese.code to IetfLang.Chinese,
            IetfLang.Chinese.Hans.code to IetfLang.Chinese.Hans,
                IetfLang.Chinese.Hans.CN.code to IetfLang.Chinese.Hans.CN,
                IetfLang.Chinese.Hans.HK.code to IetfLang.Chinese.Hans.HK,
                IetfLang.Chinese.Hans.MO.code to IetfLang.Chinese.Hans.MO,
                IetfLang.Chinese.Hans.SG.code to IetfLang.Chinese.Hans.SG,
            IetfLang.Chinese.Hant.code to IetfLang.Chinese.Hant,
                IetfLang.Chinese.Hant.HK.code to IetfLang.Chinese.Hant.HK,
                IetfLang.Chinese.Hant.MO.code to IetfLang.Chinese.Hant.MO,
                IetfLang.Chinese.Hant.TW.code to IetfLang.Chinese.Hant.TW,
        IetfLang.Zulu.code to IetfLang.Zulu,
            IetfLang.Zulu.ZA.code to IetfLang.Zulu.ZA
    )
}
val knownLanguageCodesMapByLowerCasedKeys: Map<String, IetfLang> by lazy {
    mapOf(
        IetfLang.Afar.code.lowercase() to IetfLang.Afar,
        IetfLang.Abkhazian.code.lowercase() to IetfLang.Abkhazian,
        IetfLang.Avestan.code.lowercase() to IetfLang.Avestan,
        IetfLang.Afrikaans.code.lowercase() to IetfLang.Afrikaans,
            IetfLang.Afrikaans.NA.code.lowercase() to IetfLang.Afrikaans.NA,
            IetfLang.Afrikaans.ZA.code.lowercase() to IetfLang.Afrikaans.ZA,
        IetfLang.Akan.code.lowercase() to IetfLang.Akan,
            IetfLang.Akan.GH.code.lowercase() to IetfLang.Akan.GH,
        IetfLang.Amharic.code.lowercase() to IetfLang.Amharic,
            IetfLang.Amharic.ET.code.lowercase() to IetfLang.Amharic.ET,
        IetfLang.Aragonese.code.lowercase() to IetfLang.Aragonese,
        IetfLang.Arabic.code.lowercase() to IetfLang.Arabic,
            IetfLang.Arabic.L001.code.lowercase() to IetfLang.Arabic.L001,
            IetfLang.Arabic.AE.code.lowercase() to IetfLang.Arabic.AE,
            IetfLang.Arabic.BH.code.lowercase() to IetfLang.Arabic.BH,
            IetfLang.Arabic.DJ.code.lowercase() to IetfLang.Arabic.DJ,
            IetfLang.Arabic.DZ.code.lowercase() to IetfLang.Arabic.DZ,
            IetfLang.Arabic.EG.code.lowercase() to IetfLang.Arabic.EG,
            IetfLang.Arabic.EH.code.lowercase() to IetfLang.Arabic.EH,
            IetfLang.Arabic.ER.code.lowercase() to IetfLang.Arabic.ER,
            IetfLang.Arabic.IL.code.lowercase() to IetfLang.Arabic.IL,
            IetfLang.Arabic.IQ.code.lowercase() to IetfLang.Arabic.IQ,
            IetfLang.Arabic.JO.code.lowercase() to IetfLang.Arabic.JO,
            IetfLang.Arabic.KM.code.lowercase() to IetfLang.Arabic.KM,
            IetfLang.Arabic.KW.code.lowercase() to IetfLang.Arabic.KW,
            IetfLang.Arabic.LB.code.lowercase() to IetfLang.Arabic.LB,
            IetfLang.Arabic.LY.code.lowercase() to IetfLang.Arabic.LY,
            IetfLang.Arabic.MA.code.lowercase() to IetfLang.Arabic.MA,
            IetfLang.Arabic.MR.code.lowercase() to IetfLang.Arabic.MR,
            IetfLang.Arabic.OM.code.lowercase() to IetfLang.Arabic.OM,
            IetfLang.Arabic.PS.code.lowercase() to IetfLang.Arabic.PS,
            IetfLang.Arabic.QA.code.lowercase() to IetfLang.Arabic.QA,
            IetfLang.Arabic.SA.code.lowercase() to IetfLang.Arabic.SA,
            IetfLang.Arabic.SD.code.lowercase() to IetfLang.Arabic.SD,
            IetfLang.Arabic.SO.code.lowercase() to IetfLang.Arabic.SO,
            IetfLang.Arabic.SS.code.lowercase() to IetfLang.Arabic.SS,
            IetfLang.Arabic.SY.code.lowercase() to IetfLang.Arabic.SY,
            IetfLang.Arabic.TD.code.lowercase() to IetfLang.Arabic.TD,
            IetfLang.Arabic.TN.code.lowercase() to IetfLang.Arabic.TN,
            IetfLang.Arabic.YE.code.lowercase() to IetfLang.Arabic.YE,
        IetfLang.Assamese.code.lowercase() to IetfLang.Assamese,
            IetfLang.Assamese.IN.code.lowercase() to IetfLang.Assamese.IN,
        IetfLang.Avaric.code.lowercase() to IetfLang.Avaric,
        IetfLang.Aymara.code.lowercase() to IetfLang.Aymara,
        IetfLang.Azerbaijani.code.lowercase() to IetfLang.Azerbaijani,
            IetfLang.Azerbaijani.Cyrl.code.lowercase() to IetfLang.Azerbaijani.Cyrl,
                IetfLang.Azerbaijani.Cyrl.AZ.code.lowercase() to IetfLang.Azerbaijani.Cyrl.AZ,
            IetfLang.Azerbaijani.Latn.code.lowercase() to IetfLang.Azerbaijani.Latn,
                IetfLang.Azerbaijani.Latn.AZ.code.lowercase() to IetfLang.Azerbaijani.Latn.AZ,
        IetfLang.Bashkir.code.lowercase() to IetfLang.Bashkir,
        IetfLang.Belarusian.code.lowercase() to IetfLang.Belarusian,
            IetfLang.Belarusian.BY.code.lowercase() to IetfLang.Belarusian.BY,
        IetfLang.Bulgarian.code.lowercase() to IetfLang.Bulgarian,
            IetfLang.Bulgarian.BG.code.lowercase() to IetfLang.Bulgarian.BG,
        IetfLang.BihariLanguages.code.lowercase() to IetfLang.BihariLanguages,
        IetfLang.Bislama.code.lowercase() to IetfLang.Bislama,
        IetfLang.Bambara.code.lowercase() to IetfLang.Bambara,
            IetfLang.Bambara.ML.code.lowercase() to IetfLang.Bambara.ML,
        IetfLang.Bengali.code.lowercase() to IetfLang.Bengali,
            IetfLang.Bengali.BD.code.lowercase() to IetfLang.Bengali.BD,
            IetfLang.Bengali.IN.code.lowercase() to IetfLang.Bengali.IN,
        IetfLang.Tibetan.code.lowercase() to IetfLang.Tibetan,
            IetfLang.Tibetan.CN.code.lowercase() to IetfLang.Tibetan.CN,
            IetfLang.Tibetan.IN.code.lowercase() to IetfLang.Tibetan.IN,
        IetfLang.Breton.code.lowercase() to IetfLang.Breton,
            IetfLang.Breton.FR.code.lowercase() to IetfLang.Breton.FR,
        IetfLang.Bosnian.code.lowercase() to IetfLang.Bosnian,
            IetfLang.Bosnian.Cyrl.code.lowercase() to IetfLang.Bosnian.Cyrl,
                IetfLang.Bosnian.Cyrl.BA.code.lowercase() to IetfLang.Bosnian.Cyrl.BA,
            IetfLang.Bosnian.Latn.code.lowercase() to IetfLang.Bosnian.Latn,
                IetfLang.Bosnian.Latn.BA.code.lowercase() to IetfLang.Bosnian.Latn.BA,
        IetfLang.CatalanValencian.code.lowercase() to IetfLang.CatalanValencian,
            IetfLang.CatalanValencian.AD.code.lowercase() to IetfLang.CatalanValencian.AD,
            IetfLang.CatalanValencian.ES.code.lowercase() to IetfLang.CatalanValencian.ES,
                IetfLang.CatalanValencian.ES.VALENCIA.code.lowercase() to IetfLang.CatalanValencian.ES.VALENCIA,
            IetfLang.CatalanValencian.FR.code.lowercase() to IetfLang.CatalanValencian.FR,
            IetfLang.CatalanValencian.IT.code.lowercase() to IetfLang.CatalanValencian.IT,
        IetfLang.Chechen.code.lowercase() to IetfLang.Chechen,
            IetfLang.Chechen.RU.code.lowercase() to IetfLang.Chechen.RU,
        IetfLang.Chamorro.code.lowercase() to IetfLang.Chamorro,
        IetfLang.Corsican.code.lowercase() to IetfLang.Corsican,
        IetfLang.Cree.code.lowercase() to IetfLang.Cree,
        IetfLang.Czech.code.lowercase() to IetfLang.Czech,
            IetfLang.Czech.CZ.code.lowercase() to IetfLang.Czech.CZ,
        IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.code.lowercase() to IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic,
            IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.RU.code.lowercase() to IetfLang.ChurchSlavicOldSlavonicChurchSlavonicOldBulgarianOldChurchSlavonic.RU,
        IetfLang.Chuvash.code.lowercase() to IetfLang.Chuvash,
        IetfLang.Welsh.code.lowercase() to IetfLang.Welsh,
            IetfLang.Welsh.GB.code.lowercase() to IetfLang.Welsh.GB,
        IetfLang.Danish.code.lowercase() to IetfLang.Danish,
            IetfLang.Danish.DK.code.lowercase() to IetfLang.Danish.DK,
            IetfLang.Danish.GL.code.lowercase() to IetfLang.Danish.GL,
        IetfLang.German.code.lowercase() to IetfLang.German,
            IetfLang.German.AT.code.lowercase() to IetfLang.German.AT,
            IetfLang.German.BE.code.lowercase() to IetfLang.German.BE,
            IetfLang.German.CH.code.lowercase() to IetfLang.German.CH,
            IetfLang.German.DE.code.lowercase() to IetfLang.German.DE,
            IetfLang.German.IT.code.lowercase() to IetfLang.German.IT,
            IetfLang.German.LI.code.lowercase() to IetfLang.German.LI,
            IetfLang.German.LU.code.lowercase() to IetfLang.German.LU,
        IetfLang.DivehiDhivehiMaldivian.code.lowercase() to IetfLang.DivehiDhivehiMaldivian,
        IetfLang.Dzongkha.code.lowercase() to IetfLang.Dzongkha,
            IetfLang.Dzongkha.BT.code.lowercase() to IetfLang.Dzongkha.BT,
        IetfLang.Ewe.code.lowercase() to IetfLang.Ewe,
            IetfLang.Ewe.GH.code.lowercase() to IetfLang.Ewe.GH,
            IetfLang.Ewe.TG.code.lowercase() to IetfLang.Ewe.TG,
        IetfLang.GreekModern1453.code.lowercase() to IetfLang.GreekModern1453,
            IetfLang.GreekModern1453.CY.code.lowercase() to IetfLang.GreekModern1453.CY,
            IetfLang.GreekModern1453.GR.code.lowercase() to IetfLang.GreekModern1453.GR,
        IetfLang.English.code.lowercase() to IetfLang.English,
            IetfLang.English.L001.code.lowercase() to IetfLang.English.L001,
            IetfLang.English.L150.code.lowercase() to IetfLang.English.L150,
            IetfLang.English.AE.code.lowercase() to IetfLang.English.AE,
            IetfLang.English.AG.code.lowercase() to IetfLang.English.AG,
            IetfLang.English.AI.code.lowercase() to IetfLang.English.AI,
            IetfLang.English.AS.code.lowercase() to IetfLang.English.AS,
            IetfLang.English.AT.code.lowercase() to IetfLang.English.AT,
            IetfLang.English.AU.code.lowercase() to IetfLang.English.AU,
            IetfLang.English.BB.code.lowercase() to IetfLang.English.BB,
            IetfLang.English.BE.code.lowercase() to IetfLang.English.BE,
            IetfLang.English.BI.code.lowercase() to IetfLang.English.BI,
            IetfLang.English.BM.code.lowercase() to IetfLang.English.BM,
            IetfLang.English.BS.code.lowercase() to IetfLang.English.BS,
            IetfLang.English.BW.code.lowercase() to IetfLang.English.BW,
            IetfLang.English.BZ.code.lowercase() to IetfLang.English.BZ,
            IetfLang.English.CA.code.lowercase() to IetfLang.English.CA,
            IetfLang.English.CC.code.lowercase() to IetfLang.English.CC,
            IetfLang.English.CH.code.lowercase() to IetfLang.English.CH,
            IetfLang.English.CK.code.lowercase() to IetfLang.English.CK,
            IetfLang.English.CM.code.lowercase() to IetfLang.English.CM,
            IetfLang.English.CX.code.lowercase() to IetfLang.English.CX,
            IetfLang.English.CY.code.lowercase() to IetfLang.English.CY,
            IetfLang.English.DE.code.lowercase() to IetfLang.English.DE,
            IetfLang.English.DG.code.lowercase() to IetfLang.English.DG,
            IetfLang.English.DK.code.lowercase() to IetfLang.English.DK,
            IetfLang.English.DM.code.lowercase() to IetfLang.English.DM,
            IetfLang.English.ER.code.lowercase() to IetfLang.English.ER,
            IetfLang.English.FI.code.lowercase() to IetfLang.English.FI,
            IetfLang.English.FJ.code.lowercase() to IetfLang.English.FJ,
            IetfLang.English.FK.code.lowercase() to IetfLang.English.FK,
            IetfLang.English.FM.code.lowercase() to IetfLang.English.FM,
            IetfLang.English.GB.code.lowercase() to IetfLang.English.GB,
            IetfLang.English.GD.code.lowercase() to IetfLang.English.GD,
            IetfLang.English.GG.code.lowercase() to IetfLang.English.GG,
            IetfLang.English.GH.code.lowercase() to IetfLang.English.GH,
            IetfLang.English.GI.code.lowercase() to IetfLang.English.GI,
            IetfLang.English.GM.code.lowercase() to IetfLang.English.GM,
            IetfLang.English.GU.code.lowercase() to IetfLang.English.GU,
            IetfLang.English.GY.code.lowercase() to IetfLang.English.GY,
            IetfLang.English.HK.code.lowercase() to IetfLang.English.HK,
            IetfLang.English.IE.code.lowercase() to IetfLang.English.IE,
            IetfLang.English.IL.code.lowercase() to IetfLang.English.IL,
            IetfLang.English.IM.code.lowercase() to IetfLang.English.IM,
            IetfLang.English.IN.code.lowercase() to IetfLang.English.IN,
            IetfLang.English.IO.code.lowercase() to IetfLang.English.IO,
            IetfLang.English.JE.code.lowercase() to IetfLang.English.JE,
            IetfLang.English.JM.code.lowercase() to IetfLang.English.JM,
            IetfLang.English.KE.code.lowercase() to IetfLang.English.KE,
            IetfLang.English.KI.code.lowercase() to IetfLang.English.KI,
            IetfLang.English.KN.code.lowercase() to IetfLang.English.KN,
            IetfLang.English.KY.code.lowercase() to IetfLang.English.KY,
            IetfLang.English.LC.code.lowercase() to IetfLang.English.LC,
            IetfLang.English.LR.code.lowercase() to IetfLang.English.LR,
            IetfLang.English.LS.code.lowercase() to IetfLang.English.LS,
            IetfLang.English.MG.code.lowercase() to IetfLang.English.MG,
            IetfLang.English.MH.code.lowercase() to IetfLang.English.MH,
            IetfLang.English.MO.code.lowercase() to IetfLang.English.MO,
            IetfLang.English.MP.code.lowercase() to IetfLang.English.MP,
            IetfLang.English.MS.code.lowercase() to IetfLang.English.MS,
            IetfLang.English.MT.code.lowercase() to IetfLang.English.MT,
            IetfLang.English.MU.code.lowercase() to IetfLang.English.MU,
            IetfLang.English.MW.code.lowercase() to IetfLang.English.MW,
            IetfLang.English.MY.code.lowercase() to IetfLang.English.MY,
            IetfLang.English.NA.code.lowercase() to IetfLang.English.NA,
            IetfLang.English.NF.code.lowercase() to IetfLang.English.NF,
            IetfLang.English.NG.code.lowercase() to IetfLang.English.NG,
            IetfLang.English.NL.code.lowercase() to IetfLang.English.NL,
            IetfLang.English.NR.code.lowercase() to IetfLang.English.NR,
            IetfLang.English.NU.code.lowercase() to IetfLang.English.NU,
            IetfLang.English.NZ.code.lowercase() to IetfLang.English.NZ,
            IetfLang.English.PG.code.lowercase() to IetfLang.English.PG,
            IetfLang.English.PH.code.lowercase() to IetfLang.English.PH,
            IetfLang.English.PK.code.lowercase() to IetfLang.English.PK,
            IetfLang.English.PN.code.lowercase() to IetfLang.English.PN,
            IetfLang.English.PR.code.lowercase() to IetfLang.English.PR,
            IetfLang.English.PW.code.lowercase() to IetfLang.English.PW,
            IetfLang.English.RW.code.lowercase() to IetfLang.English.RW,
            IetfLang.English.SB.code.lowercase() to IetfLang.English.SB,
            IetfLang.English.SC.code.lowercase() to IetfLang.English.SC,
            IetfLang.English.SD.code.lowercase() to IetfLang.English.SD,
            IetfLang.English.SE.code.lowercase() to IetfLang.English.SE,
            IetfLang.English.SG.code.lowercase() to IetfLang.English.SG,
            IetfLang.English.SH.code.lowercase() to IetfLang.English.SH,
            IetfLang.English.SI.code.lowercase() to IetfLang.English.SI,
            IetfLang.English.SL.code.lowercase() to IetfLang.English.SL,
            IetfLang.English.SS.code.lowercase() to IetfLang.English.SS,
            IetfLang.English.SX.code.lowercase() to IetfLang.English.SX,
            IetfLang.English.SZ.code.lowercase() to IetfLang.English.SZ,
            IetfLang.English.TC.code.lowercase() to IetfLang.English.TC,
            IetfLang.English.TK.code.lowercase() to IetfLang.English.TK,
            IetfLang.English.TO.code.lowercase() to IetfLang.English.TO,
            IetfLang.English.TT.code.lowercase() to IetfLang.English.TT,
            IetfLang.English.TV.code.lowercase() to IetfLang.English.TV,
            IetfLang.English.TZ.code.lowercase() to IetfLang.English.TZ,
            IetfLang.English.UG.code.lowercase() to IetfLang.English.UG,
            IetfLang.English.UM.code.lowercase() to IetfLang.English.UM,
            IetfLang.English.US.code.lowercase() to IetfLang.English.US,
                IetfLang.English.US.POSIX.code.lowercase() to IetfLang.English.US.POSIX,
            IetfLang.English.VC.code.lowercase() to IetfLang.English.VC,
            IetfLang.English.VG.code.lowercase() to IetfLang.English.VG,
            IetfLang.English.VI.code.lowercase() to IetfLang.English.VI,
            IetfLang.English.VU.code.lowercase() to IetfLang.English.VU,
            IetfLang.English.WS.code.lowercase() to IetfLang.English.WS,
            IetfLang.English.ZA.code.lowercase() to IetfLang.English.ZA,
            IetfLang.English.ZM.code.lowercase() to IetfLang.English.ZM,
            IetfLang.English.ZW.code.lowercase() to IetfLang.English.ZW,
        IetfLang.Esperanto.code.lowercase() to IetfLang.Esperanto,
            IetfLang.Esperanto.L001.code.lowercase() to IetfLang.Esperanto.L001,
        IetfLang.SpanishCastilian.code.lowercase() to IetfLang.SpanishCastilian,
            IetfLang.SpanishCastilian.L419.code.lowercase() to IetfLang.SpanishCastilian.L419,
            IetfLang.SpanishCastilian.AR.code.lowercase() to IetfLang.SpanishCastilian.AR,
            IetfLang.SpanishCastilian.BO.code.lowercase() to IetfLang.SpanishCastilian.BO,
            IetfLang.SpanishCastilian.BR.code.lowercase() to IetfLang.SpanishCastilian.BR,
            IetfLang.SpanishCastilian.BZ.code.lowercase() to IetfLang.SpanishCastilian.BZ,
            IetfLang.SpanishCastilian.CL.code.lowercase() to IetfLang.SpanishCastilian.CL,
            IetfLang.SpanishCastilian.CO.code.lowercase() to IetfLang.SpanishCastilian.CO,
            IetfLang.SpanishCastilian.CR.code.lowercase() to IetfLang.SpanishCastilian.CR,
            IetfLang.SpanishCastilian.CU.code.lowercase() to IetfLang.SpanishCastilian.CU,
            IetfLang.SpanishCastilian.DO.code.lowercase() to IetfLang.SpanishCastilian.DO,
            IetfLang.SpanishCastilian.EA.code.lowercase() to IetfLang.SpanishCastilian.EA,
            IetfLang.SpanishCastilian.EC.code.lowercase() to IetfLang.SpanishCastilian.EC,
            IetfLang.SpanishCastilian.ES.code.lowercase() to IetfLang.SpanishCastilian.ES,
            IetfLang.SpanishCastilian.GQ.code.lowercase() to IetfLang.SpanishCastilian.GQ,
            IetfLang.SpanishCastilian.GT.code.lowercase() to IetfLang.SpanishCastilian.GT,
            IetfLang.SpanishCastilian.HN.code.lowercase() to IetfLang.SpanishCastilian.HN,
            IetfLang.SpanishCastilian.IC.code.lowercase() to IetfLang.SpanishCastilian.IC,
            IetfLang.SpanishCastilian.MX.code.lowercase() to IetfLang.SpanishCastilian.MX,
            IetfLang.SpanishCastilian.NI.code.lowercase() to IetfLang.SpanishCastilian.NI,
            IetfLang.SpanishCastilian.PA.code.lowercase() to IetfLang.SpanishCastilian.PA,
            IetfLang.SpanishCastilian.PE.code.lowercase() to IetfLang.SpanishCastilian.PE,
            IetfLang.SpanishCastilian.PH.code.lowercase() to IetfLang.SpanishCastilian.PH,
            IetfLang.SpanishCastilian.PR.code.lowercase() to IetfLang.SpanishCastilian.PR,
            IetfLang.SpanishCastilian.PY.code.lowercase() to IetfLang.SpanishCastilian.PY,
            IetfLang.SpanishCastilian.SV.code.lowercase() to IetfLang.SpanishCastilian.SV,
            IetfLang.SpanishCastilian.US.code.lowercase() to IetfLang.SpanishCastilian.US,
            IetfLang.SpanishCastilian.UY.code.lowercase() to IetfLang.SpanishCastilian.UY,
            IetfLang.SpanishCastilian.VE.code.lowercase() to IetfLang.SpanishCastilian.VE,
        IetfLang.Estonian.code.lowercase() to IetfLang.Estonian,
            IetfLang.Estonian.EE.code.lowercase() to IetfLang.Estonian.EE,
        IetfLang.Basque.code.lowercase() to IetfLang.Basque,
            IetfLang.Basque.ES.code.lowercase() to IetfLang.Basque.ES,
        IetfLang.Persian.code.lowercase() to IetfLang.Persian,
            IetfLang.Persian.AF.code.lowercase() to IetfLang.Persian.AF,
            IetfLang.Persian.IR.code.lowercase() to IetfLang.Persian.IR,
        IetfLang.Fulah.code.lowercase() to IetfLang.Fulah,
            IetfLang.Fulah.Adlm.code.lowercase() to IetfLang.Fulah.Adlm,
                IetfLang.Fulah.Adlm.BF.code.lowercase() to IetfLang.Fulah.Adlm.BF,
                IetfLang.Fulah.Adlm.CM.code.lowercase() to IetfLang.Fulah.Adlm.CM,
                IetfLang.Fulah.Adlm.GH.code.lowercase() to IetfLang.Fulah.Adlm.GH,
                IetfLang.Fulah.Adlm.GM.code.lowercase() to IetfLang.Fulah.Adlm.GM,
                IetfLang.Fulah.Adlm.GN.code.lowercase() to IetfLang.Fulah.Adlm.GN,
                IetfLang.Fulah.Adlm.GW.code.lowercase() to IetfLang.Fulah.Adlm.GW,
                IetfLang.Fulah.Adlm.LR.code.lowercase() to IetfLang.Fulah.Adlm.LR,
                IetfLang.Fulah.Adlm.MR.code.lowercase() to IetfLang.Fulah.Adlm.MR,
                IetfLang.Fulah.Adlm.NE.code.lowercase() to IetfLang.Fulah.Adlm.NE,
                IetfLang.Fulah.Adlm.NG.code.lowercase() to IetfLang.Fulah.Adlm.NG,
                IetfLang.Fulah.Adlm.SL.code.lowercase() to IetfLang.Fulah.Adlm.SL,
                IetfLang.Fulah.Adlm.SN.code.lowercase() to IetfLang.Fulah.Adlm.SN,
            IetfLang.Fulah.Latn.code.lowercase() to IetfLang.Fulah.Latn,
                IetfLang.Fulah.Latn.BF.code.lowercase() to IetfLang.Fulah.Latn.BF,
                IetfLang.Fulah.Latn.CM.code.lowercase() to IetfLang.Fulah.Latn.CM,
                IetfLang.Fulah.Latn.GH.code.lowercase() to IetfLang.Fulah.Latn.GH,
                IetfLang.Fulah.Latn.GM.code.lowercase() to IetfLang.Fulah.Latn.GM,
                IetfLang.Fulah.Latn.GN.code.lowercase() to IetfLang.Fulah.Latn.GN,
                IetfLang.Fulah.Latn.GW.code.lowercase() to IetfLang.Fulah.Latn.GW,
                IetfLang.Fulah.Latn.LR.code.lowercase() to IetfLang.Fulah.Latn.LR,
                IetfLang.Fulah.Latn.MR.code.lowercase() to IetfLang.Fulah.Latn.MR,
                IetfLang.Fulah.Latn.NE.code.lowercase() to IetfLang.Fulah.Latn.NE,
                IetfLang.Fulah.Latn.NG.code.lowercase() to IetfLang.Fulah.Latn.NG,
                IetfLang.Fulah.Latn.SL.code.lowercase() to IetfLang.Fulah.Latn.SL,
                IetfLang.Fulah.Latn.SN.code.lowercase() to IetfLang.Fulah.Latn.SN,
        IetfLang.Finnish.code.lowercase() to IetfLang.Finnish,
            IetfLang.Finnish.FI.code.lowercase() to IetfLang.Finnish.FI,
        IetfLang.Fijian.code.lowercase() to IetfLang.Fijian,
        IetfLang.Faroese.code.lowercase() to IetfLang.Faroese,
            IetfLang.Faroese.DK.code.lowercase() to IetfLang.Faroese.DK,
            IetfLang.Faroese.FO.code.lowercase() to IetfLang.Faroese.FO,
        IetfLang.French.code.lowercase() to IetfLang.French,
            IetfLang.French.BE.code.lowercase() to IetfLang.French.BE,
            IetfLang.French.BF.code.lowercase() to IetfLang.French.BF,
            IetfLang.French.BI.code.lowercase() to IetfLang.French.BI,
            IetfLang.French.BJ.code.lowercase() to IetfLang.French.BJ,
            IetfLang.French.BL.code.lowercase() to IetfLang.French.BL,
            IetfLang.French.CA.code.lowercase() to IetfLang.French.CA,
            IetfLang.French.CD.code.lowercase() to IetfLang.French.CD,
            IetfLang.French.CF.code.lowercase() to IetfLang.French.CF,
            IetfLang.French.CG.code.lowercase() to IetfLang.French.CG,
            IetfLang.French.CH.code.lowercase() to IetfLang.French.CH,
            IetfLang.French.CI.code.lowercase() to IetfLang.French.CI,
            IetfLang.French.CM.code.lowercase() to IetfLang.French.CM,
            IetfLang.French.DJ.code.lowercase() to IetfLang.French.DJ,
            IetfLang.French.DZ.code.lowercase() to IetfLang.French.DZ,
            IetfLang.French.FR.code.lowercase() to IetfLang.French.FR,
            IetfLang.French.GA.code.lowercase() to IetfLang.French.GA,
            IetfLang.French.GF.code.lowercase() to IetfLang.French.GF,
            IetfLang.French.GN.code.lowercase() to IetfLang.French.GN,
            IetfLang.French.GP.code.lowercase() to IetfLang.French.GP,
            IetfLang.French.GQ.code.lowercase() to IetfLang.French.GQ,
            IetfLang.French.HT.code.lowercase() to IetfLang.French.HT,
            IetfLang.French.KM.code.lowercase() to IetfLang.French.KM,
            IetfLang.French.LU.code.lowercase() to IetfLang.French.LU,
            IetfLang.French.MA.code.lowercase() to IetfLang.French.MA,
            IetfLang.French.MC.code.lowercase() to IetfLang.French.MC,
            IetfLang.French.MF.code.lowercase() to IetfLang.French.MF,
            IetfLang.French.MG.code.lowercase() to IetfLang.French.MG,
            IetfLang.French.ML.code.lowercase() to IetfLang.French.ML,
            IetfLang.French.MQ.code.lowercase() to IetfLang.French.MQ,
            IetfLang.French.MR.code.lowercase() to IetfLang.French.MR,
            IetfLang.French.MU.code.lowercase() to IetfLang.French.MU,
            IetfLang.French.NC.code.lowercase() to IetfLang.French.NC,
            IetfLang.French.NE.code.lowercase() to IetfLang.French.NE,
            IetfLang.French.PF.code.lowercase() to IetfLang.French.PF,
            IetfLang.French.PM.code.lowercase() to IetfLang.French.PM,
            IetfLang.French.RE.code.lowercase() to IetfLang.French.RE,
            IetfLang.French.RW.code.lowercase() to IetfLang.French.RW,
            IetfLang.French.SC.code.lowercase() to IetfLang.French.SC,
            IetfLang.French.SN.code.lowercase() to IetfLang.French.SN,
            IetfLang.French.SY.code.lowercase() to IetfLang.French.SY,
            IetfLang.French.TD.code.lowercase() to IetfLang.French.TD,
            IetfLang.French.TG.code.lowercase() to IetfLang.French.TG,
            IetfLang.French.TN.code.lowercase() to IetfLang.French.TN,
            IetfLang.French.VU.code.lowercase() to IetfLang.French.VU,
            IetfLang.French.WF.code.lowercase() to IetfLang.French.WF,
            IetfLang.French.YT.code.lowercase() to IetfLang.French.YT,
        IetfLang.WesternFrisian.code.lowercase() to IetfLang.WesternFrisian,
            IetfLang.WesternFrisian.NL.code.lowercase() to IetfLang.WesternFrisian.NL,
        IetfLang.Irish.code.lowercase() to IetfLang.Irish,
            IetfLang.Irish.GB.code.lowercase() to IetfLang.Irish.GB,
            IetfLang.Irish.IE.code.lowercase() to IetfLang.Irish.IE,
        IetfLang.GaelicScottishGaelic.code.lowercase() to IetfLang.GaelicScottishGaelic,
            IetfLang.GaelicScottishGaelic.GB.code.lowercase() to IetfLang.GaelicScottishGaelic.GB,
        IetfLang.Galician.code.lowercase() to IetfLang.Galician,
            IetfLang.Galician.ES.code.lowercase() to IetfLang.Galician.ES,
        IetfLang.Guarani.code.lowercase() to IetfLang.Guarani,
        IetfLang.Gujarati.code.lowercase() to IetfLang.Gujarati,
            IetfLang.Gujarati.IN.code.lowercase() to IetfLang.Gujarati.IN,
        IetfLang.Manx.code.lowercase() to IetfLang.Manx,
            IetfLang.Manx.IM.code.lowercase() to IetfLang.Manx.IM,
        IetfLang.Hausa.code.lowercase() to IetfLang.Hausa,
            IetfLang.Hausa.GH.code.lowercase() to IetfLang.Hausa.GH,
            IetfLang.Hausa.NE.code.lowercase() to IetfLang.Hausa.NE,
            IetfLang.Hausa.NG.code.lowercase() to IetfLang.Hausa.NG,
        IetfLang.Hebrew.code.lowercase() to IetfLang.Hebrew,
            IetfLang.Hebrew.IL.code.lowercase() to IetfLang.Hebrew.IL,
        IetfLang.Hindi.code.lowercase() to IetfLang.Hindi,
            IetfLang.Hindi.IN.code.lowercase() to IetfLang.Hindi.IN,
        IetfLang.HiriMotu.code.lowercase() to IetfLang.HiriMotu,
        IetfLang.Croatian.code.lowercase() to IetfLang.Croatian,
            IetfLang.Croatian.BA.code.lowercase() to IetfLang.Croatian.BA,
            IetfLang.Croatian.HR.code.lowercase() to IetfLang.Croatian.HR,
        IetfLang.HaitianHaitianCreole.code.lowercase() to IetfLang.HaitianHaitianCreole,
        IetfLang.Hungarian.code.lowercase() to IetfLang.Hungarian,
            IetfLang.Hungarian.HU.code.lowercase() to IetfLang.Hungarian.HU,
        IetfLang.Armenian.code.lowercase() to IetfLang.Armenian,
            IetfLang.Armenian.AM.code.lowercase() to IetfLang.Armenian.AM,
        IetfLang.Herero.code.lowercase() to IetfLang.Herero,
        IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation.code.lowercase() to IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation,
            IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation.L001.code.lowercase() to IetfLang.InterlinguaInternationalAuxiliaryLanguageAssociation.L001,
        IetfLang.Indonesian.code.lowercase() to IetfLang.Indonesian,
            IetfLang.Indonesian.ID.code.lowercase() to IetfLang.Indonesian.ID,
        IetfLang.InterlingueOccidental.code.lowercase() to IetfLang.InterlingueOccidental,
        IetfLang.Igbo.code.lowercase() to IetfLang.Igbo,
            IetfLang.Igbo.NG.code.lowercase() to IetfLang.Igbo.NG,
        IetfLang.SichuanYiNuosu.code.lowercase() to IetfLang.SichuanYiNuosu,
            IetfLang.SichuanYiNuosu.CN.code.lowercase() to IetfLang.SichuanYiNuosu.CN,
        IetfLang.Inupiaq.code.lowercase() to IetfLang.Inupiaq,
        IetfLang.Ido.code.lowercase() to IetfLang.Ido,
        IetfLang.Icelandic.code.lowercase() to IetfLang.Icelandic,
            IetfLang.Icelandic.IS.code.lowercase() to IetfLang.Icelandic.IS,
        IetfLang.Italian.code.lowercase() to IetfLang.Italian,
            IetfLang.Italian.CH.code.lowercase() to IetfLang.Italian.CH,
            IetfLang.Italian.IT.code.lowercase() to IetfLang.Italian.IT,
            IetfLang.Italian.SM.code.lowercase() to IetfLang.Italian.SM,
            IetfLang.Italian.VA.code.lowercase() to IetfLang.Italian.VA,
        IetfLang.Inuktitut.code.lowercase() to IetfLang.Inuktitut,
        IetfLang.Japanese.code.lowercase() to IetfLang.Japanese,
            IetfLang.Japanese.JP.code.lowercase() to IetfLang.Japanese.JP,
        IetfLang.Javanese.code.lowercase() to IetfLang.Javanese,
            IetfLang.Javanese.ID.code.lowercase() to IetfLang.Javanese.ID,
        IetfLang.Georgian.code.lowercase() to IetfLang.Georgian,
            IetfLang.Georgian.GE.code.lowercase() to IetfLang.Georgian.GE,
        IetfLang.Kongo.code.lowercase() to IetfLang.Kongo,
        IetfLang.KikuyuGikuyu.code.lowercase() to IetfLang.KikuyuGikuyu,
            IetfLang.KikuyuGikuyu.KE.code.lowercase() to IetfLang.KikuyuGikuyu.KE,
        IetfLang.KuanyamaKwanyama.code.lowercase() to IetfLang.KuanyamaKwanyama,
        IetfLang.Kazakh.code.lowercase() to IetfLang.Kazakh,
            IetfLang.Kazakh.KZ.code.lowercase() to IetfLang.Kazakh.KZ,
        IetfLang.KalaallisutGreenlandic.code.lowercase() to IetfLang.KalaallisutGreenlandic,
            IetfLang.KalaallisutGreenlandic.GL.code.lowercase() to IetfLang.KalaallisutGreenlandic.GL,
        IetfLang.CentralKhmer.code.lowercase() to IetfLang.CentralKhmer,
            IetfLang.CentralKhmer.KH.code.lowercase() to IetfLang.CentralKhmer.KH,
        IetfLang.Kannada.code.lowercase() to IetfLang.Kannada,
            IetfLang.Kannada.IN.code.lowercase() to IetfLang.Kannada.IN,
        IetfLang.Korean.code.lowercase() to IetfLang.Korean,
            IetfLang.Korean.KP.code.lowercase() to IetfLang.Korean.KP,
            IetfLang.Korean.KR.code.lowercase() to IetfLang.Korean.KR,
        IetfLang.Kanuri.code.lowercase() to IetfLang.Kanuri,
        IetfLang.Kashmiri.code.lowercase() to IetfLang.Kashmiri,
            IetfLang.Kashmiri.Arab.code.lowercase() to IetfLang.Kashmiri.Arab,
                IetfLang.Kashmiri.Arab.IN.code.lowercase() to IetfLang.Kashmiri.Arab.IN,
        IetfLang.Kurdish.code.lowercase() to IetfLang.Kurdish,
            IetfLang.Kurdish.TR.code.lowercase() to IetfLang.Kurdish.TR,
        IetfLang.Komi.code.lowercase() to IetfLang.Komi,
        IetfLang.Cornish.code.lowercase() to IetfLang.Cornish,
            IetfLang.Cornish.GB.code.lowercase() to IetfLang.Cornish.GB,
        IetfLang.KirghizKyrgyz.code.lowercase() to IetfLang.KirghizKyrgyz,
            IetfLang.KirghizKyrgyz.KG.code.lowercase() to IetfLang.KirghizKyrgyz.KG,
        IetfLang.Latin.code.lowercase() to IetfLang.Latin,
        IetfLang.LuxembourgishLetzeburgesch.code.lowercase() to IetfLang.LuxembourgishLetzeburgesch,
            IetfLang.LuxembourgishLetzeburgesch.LU.code.lowercase() to IetfLang.LuxembourgishLetzeburgesch.LU,
        IetfLang.Ganda.code.lowercase() to IetfLang.Ganda,
            IetfLang.Ganda.UG.code.lowercase() to IetfLang.Ganda.UG,
        IetfLang.LimburganLimburgerLimburgish.code.lowercase() to IetfLang.LimburganLimburgerLimburgish,
        IetfLang.Lingala.code.lowercase() to IetfLang.Lingala,
            IetfLang.Lingala.AO.code.lowercase() to IetfLang.Lingala.AO,
            IetfLang.Lingala.CD.code.lowercase() to IetfLang.Lingala.CD,
            IetfLang.Lingala.CF.code.lowercase() to IetfLang.Lingala.CF,
            IetfLang.Lingala.CG.code.lowercase() to IetfLang.Lingala.CG,
        IetfLang.Lao.code.lowercase() to IetfLang.Lao,
            IetfLang.Lao.LA.code.lowercase() to IetfLang.Lao.LA,
        IetfLang.Lithuanian.code.lowercase() to IetfLang.Lithuanian,
            IetfLang.Lithuanian.LT.code.lowercase() to IetfLang.Lithuanian.LT,
        IetfLang.LubaKatanga.code.lowercase() to IetfLang.LubaKatanga,
            IetfLang.LubaKatanga.CD.code.lowercase() to IetfLang.LubaKatanga.CD,
        IetfLang.Latvian.code.lowercase() to IetfLang.Latvian,
            IetfLang.Latvian.LV.code.lowercase() to IetfLang.Latvian.LV,
        IetfLang.Malagasy.code.lowercase() to IetfLang.Malagasy,
            IetfLang.Malagasy.MG.code.lowercase() to IetfLang.Malagasy.MG,
        IetfLang.Marshallese.code.lowercase() to IetfLang.Marshallese,
        IetfLang.Maori.code.lowercase() to IetfLang.Maori,
            IetfLang.Maori.NZ.code.lowercase() to IetfLang.Maori.NZ,
        IetfLang.Macedonian.code.lowercase() to IetfLang.Macedonian,
            IetfLang.Macedonian.MK.code.lowercase() to IetfLang.Macedonian.MK,
        IetfLang.Malayalam.code.lowercase() to IetfLang.Malayalam,
            IetfLang.Malayalam.IN.code.lowercase() to IetfLang.Malayalam.IN,
        IetfLang.Mongolian.code.lowercase() to IetfLang.Mongolian,
            IetfLang.Mongolian.MN.code.lowercase() to IetfLang.Mongolian.MN,
        IetfLang.Marathi.code.lowercase() to IetfLang.Marathi,
            IetfLang.Marathi.IN.code.lowercase() to IetfLang.Marathi.IN,
        IetfLang.Malay.code.lowercase() to IetfLang.Malay,
            IetfLang.Malay.BN.code.lowercase() to IetfLang.Malay.BN,
            IetfLang.Malay.ID.code.lowercase() to IetfLang.Malay.ID,
            IetfLang.Malay.MY.code.lowercase() to IetfLang.Malay.MY,
            IetfLang.Malay.SG.code.lowercase() to IetfLang.Malay.SG,
        IetfLang.Maltese.code.lowercase() to IetfLang.Maltese,
            IetfLang.Maltese.MT.code.lowercase() to IetfLang.Maltese.MT,
        IetfLang.Burmese.code.lowercase() to IetfLang.Burmese,
            IetfLang.Burmese.MM.code.lowercase() to IetfLang.Burmese.MM,
        IetfLang.Nauru.code.lowercase() to IetfLang.Nauru,
        IetfLang.BokmalNorwegianNorwegianBokmal.code.lowercase() to IetfLang.BokmalNorwegianNorwegianBokmal,
            IetfLang.BokmalNorwegianNorwegianBokmal.NO.code.lowercase() to IetfLang.BokmalNorwegianNorwegianBokmal.NO,
            IetfLang.BokmalNorwegianNorwegianBokmal.SJ.code.lowercase() to IetfLang.BokmalNorwegianNorwegianBokmal.SJ,
        IetfLang.NdebeleNorthNorthNdebele.code.lowercase() to IetfLang.NdebeleNorthNorthNdebele,
            IetfLang.NdebeleNorthNorthNdebele.ZW.code.lowercase() to IetfLang.NdebeleNorthNorthNdebele.ZW,
        IetfLang.Nepali.code.lowercase() to IetfLang.Nepali,
            IetfLang.Nepali.IN.code.lowercase() to IetfLang.Nepali.IN,
            IetfLang.Nepali.NP.code.lowercase() to IetfLang.Nepali.NP,
        IetfLang.Ndonga.code.lowercase() to IetfLang.Ndonga,
        IetfLang.DutchFlemish.code.lowercase() to IetfLang.DutchFlemish,
            IetfLang.DutchFlemish.AW.code.lowercase() to IetfLang.DutchFlemish.AW,
            IetfLang.DutchFlemish.BE.code.lowercase() to IetfLang.DutchFlemish.BE,
            IetfLang.DutchFlemish.BQ.code.lowercase() to IetfLang.DutchFlemish.BQ,
            IetfLang.DutchFlemish.CW.code.lowercase() to IetfLang.DutchFlemish.CW,
            IetfLang.DutchFlemish.NL.code.lowercase() to IetfLang.DutchFlemish.NL,
            IetfLang.DutchFlemish.SR.code.lowercase() to IetfLang.DutchFlemish.SR,
            IetfLang.DutchFlemish.SX.code.lowercase() to IetfLang.DutchFlemish.SX,
        IetfLang.NorwegianNynorskNynorskNorwegian.code.lowercase() to IetfLang.NorwegianNynorskNynorskNorwegian,
            IetfLang.NorwegianNynorskNynorskNorwegian.NO.code.lowercase() to IetfLang.NorwegianNynorskNynorskNorwegian.NO,
        IetfLang.Norwegian.code.lowercase() to IetfLang.Norwegian,
        IetfLang.NdebeleSouthSouthNdebele.code.lowercase() to IetfLang.NdebeleSouthSouthNdebele,
        IetfLang.NavajoNavaho.code.lowercase() to IetfLang.NavajoNavaho,
        IetfLang.ChichewaChewaNyanja.code.lowercase() to IetfLang.ChichewaChewaNyanja,
        IetfLang.OccitanPost1500.code.lowercase() to IetfLang.OccitanPost1500,
        IetfLang.Ojibwa.code.lowercase() to IetfLang.Ojibwa,
        IetfLang.Oromo.code.lowercase() to IetfLang.Oromo,
            IetfLang.Oromo.ET.code.lowercase() to IetfLang.Oromo.ET,
            IetfLang.Oromo.KE.code.lowercase() to IetfLang.Oromo.KE,
        IetfLang.Oriya.code.lowercase() to IetfLang.Oriya,
            IetfLang.Oriya.IN.code.lowercase() to IetfLang.Oriya.IN,
        IetfLang.OssetianOssetic.code.lowercase() to IetfLang.OssetianOssetic,
            IetfLang.OssetianOssetic.GE.code.lowercase() to IetfLang.OssetianOssetic.GE,
            IetfLang.OssetianOssetic.RU.code.lowercase() to IetfLang.OssetianOssetic.RU,
        IetfLang.PanjabiPunjabi.code.lowercase() to IetfLang.PanjabiPunjabi,
            IetfLang.PanjabiPunjabi.Arab.code.lowercase() to IetfLang.PanjabiPunjabi.Arab,
                IetfLang.PanjabiPunjabi.Arab.PK.code.lowercase() to IetfLang.PanjabiPunjabi.Arab.PK,
            IetfLang.PanjabiPunjabi.Guru.code.lowercase() to IetfLang.PanjabiPunjabi.Guru,
                IetfLang.PanjabiPunjabi.Guru.IN.code.lowercase() to IetfLang.PanjabiPunjabi.Guru.IN,
        IetfLang.Pali.code.lowercase() to IetfLang.Pali,
        IetfLang.Polish.code.lowercase() to IetfLang.Polish,
            IetfLang.Polish.PL.code.lowercase() to IetfLang.Polish.PL,
        IetfLang.PushtoPashto.code.lowercase() to IetfLang.PushtoPashto,
            IetfLang.PushtoPashto.AF.code.lowercase() to IetfLang.PushtoPashto.AF,
            IetfLang.PushtoPashto.PK.code.lowercase() to IetfLang.PushtoPashto.PK,
        IetfLang.Portuguese.code.lowercase() to IetfLang.Portuguese,
            IetfLang.Portuguese.AO.code.lowercase() to IetfLang.Portuguese.AO,
            IetfLang.Portuguese.BR.code.lowercase() to IetfLang.Portuguese.BR,
            IetfLang.Portuguese.CH.code.lowercase() to IetfLang.Portuguese.CH,
            IetfLang.Portuguese.CV.code.lowercase() to IetfLang.Portuguese.CV,
            IetfLang.Portuguese.GQ.code.lowercase() to IetfLang.Portuguese.GQ,
            IetfLang.Portuguese.GW.code.lowercase() to IetfLang.Portuguese.GW,
            IetfLang.Portuguese.LU.code.lowercase() to IetfLang.Portuguese.LU,
            IetfLang.Portuguese.MO.code.lowercase() to IetfLang.Portuguese.MO,
            IetfLang.Portuguese.MZ.code.lowercase() to IetfLang.Portuguese.MZ,
            IetfLang.Portuguese.PT.code.lowercase() to IetfLang.Portuguese.PT,
            IetfLang.Portuguese.ST.code.lowercase() to IetfLang.Portuguese.ST,
            IetfLang.Portuguese.TL.code.lowercase() to IetfLang.Portuguese.TL,
        IetfLang.Quechua.code.lowercase() to IetfLang.Quechua,
            IetfLang.Quechua.BO.code.lowercase() to IetfLang.Quechua.BO,
            IetfLang.Quechua.EC.code.lowercase() to IetfLang.Quechua.EC,
            IetfLang.Quechua.PE.code.lowercase() to IetfLang.Quechua.PE,
        IetfLang.Romansh.code.lowercase() to IetfLang.Romansh,
            IetfLang.Romansh.CH.code.lowercase() to IetfLang.Romansh.CH,
        IetfLang.Rundi.code.lowercase() to IetfLang.Rundi,
            IetfLang.Rundi.BI.code.lowercase() to IetfLang.Rundi.BI,
        IetfLang.RomanianMoldavianMoldovan.code.lowercase() to IetfLang.RomanianMoldavianMoldovan,
            IetfLang.RomanianMoldavianMoldovan.MD.code.lowercase() to IetfLang.RomanianMoldavianMoldovan.MD,
            IetfLang.RomanianMoldavianMoldovan.RO.code.lowercase() to IetfLang.RomanianMoldavianMoldovan.RO,
        IetfLang.Russian.code.lowercase() to IetfLang.Russian,
            IetfLang.Russian.BY.code.lowercase() to IetfLang.Russian.BY,
            IetfLang.Russian.KG.code.lowercase() to IetfLang.Russian.KG,
            IetfLang.Russian.KZ.code.lowercase() to IetfLang.Russian.KZ,
            IetfLang.Russian.MD.code.lowercase() to IetfLang.Russian.MD,
            IetfLang.Russian.RU.code.lowercase() to IetfLang.Russian.RU,
            IetfLang.Russian.UA.code.lowercase() to IetfLang.Russian.UA,
        IetfLang.Kinyarwanda.code.lowercase() to IetfLang.Kinyarwanda,
            IetfLang.Kinyarwanda.RW.code.lowercase() to IetfLang.Kinyarwanda.RW,
        IetfLang.Sanskrit.code.lowercase() to IetfLang.Sanskrit,
        IetfLang.Sardinian.code.lowercase() to IetfLang.Sardinian,
        IetfLang.Sindhi.code.lowercase() to IetfLang.Sindhi,
            IetfLang.Sindhi.Arab.code.lowercase() to IetfLang.Sindhi.Arab,
                IetfLang.Sindhi.Arab.PK.code.lowercase() to IetfLang.Sindhi.Arab.PK,
            IetfLang.Sindhi.Deva.code.lowercase() to IetfLang.Sindhi.Deva,
                IetfLang.Sindhi.Deva.IN.code.lowercase() to IetfLang.Sindhi.Deva.IN,
        IetfLang.NorthernSami.code.lowercase() to IetfLang.NorthernSami,
            IetfLang.NorthernSami.FI.code.lowercase() to IetfLang.NorthernSami.FI,
            IetfLang.NorthernSami.NO.code.lowercase() to IetfLang.NorthernSami.NO,
            IetfLang.NorthernSami.SE.code.lowercase() to IetfLang.NorthernSami.SE,
        IetfLang.Sango.code.lowercase() to IetfLang.Sango,
            IetfLang.Sango.CF.code.lowercase() to IetfLang.Sango.CF,
        IetfLang.SinhalaSinhalese.code.lowercase() to IetfLang.SinhalaSinhalese,
            IetfLang.SinhalaSinhalese.LK.code.lowercase() to IetfLang.SinhalaSinhalese.LK,
        IetfLang.Slovak.code.lowercase() to IetfLang.Slovak,
            IetfLang.Slovak.SK.code.lowercase() to IetfLang.Slovak.SK,
        IetfLang.Slovenian.code.lowercase() to IetfLang.Slovenian,
            IetfLang.Slovenian.SI.code.lowercase() to IetfLang.Slovenian.SI,
        IetfLang.Samoan.code.lowercase() to IetfLang.Samoan,
        IetfLang.Shona.code.lowercase() to IetfLang.Shona,
            IetfLang.Shona.ZW.code.lowercase() to IetfLang.Shona.ZW,
        IetfLang.Somali.code.lowercase() to IetfLang.Somali,
            IetfLang.Somali.DJ.code.lowercase() to IetfLang.Somali.DJ,
            IetfLang.Somali.ET.code.lowercase() to IetfLang.Somali.ET,
            IetfLang.Somali.KE.code.lowercase() to IetfLang.Somali.KE,
            IetfLang.Somali.SO.code.lowercase() to IetfLang.Somali.SO,
        IetfLang.Albanian.code.lowercase() to IetfLang.Albanian,
            IetfLang.Albanian.AL.code.lowercase() to IetfLang.Albanian.AL,
            IetfLang.Albanian.MK.code.lowercase() to IetfLang.Albanian.MK,
            IetfLang.Albanian.XK.code.lowercase() to IetfLang.Albanian.XK,
        IetfLang.Serbian.code.lowercase() to IetfLang.Serbian,
            IetfLang.Serbian.Cyrl.code.lowercase() to IetfLang.Serbian.Cyrl,
                IetfLang.Serbian.Cyrl.BA.code.lowercase() to IetfLang.Serbian.Cyrl.BA,
                IetfLang.Serbian.Cyrl.ME.code.lowercase() to IetfLang.Serbian.Cyrl.ME,
                IetfLang.Serbian.Cyrl.RS.code.lowercase() to IetfLang.Serbian.Cyrl.RS,
                IetfLang.Serbian.Cyrl.XK.code.lowercase() to IetfLang.Serbian.Cyrl.XK,
            IetfLang.Serbian.Latn.code.lowercase() to IetfLang.Serbian.Latn,
                IetfLang.Serbian.Latn.BA.code.lowercase() to IetfLang.Serbian.Latn.BA,
                IetfLang.Serbian.Latn.ME.code.lowercase() to IetfLang.Serbian.Latn.ME,
                IetfLang.Serbian.Latn.RS.code.lowercase() to IetfLang.Serbian.Latn.RS,
                IetfLang.Serbian.Latn.XK.code.lowercase() to IetfLang.Serbian.Latn.XK,
        IetfLang.Swati.code.lowercase() to IetfLang.Swati,
        IetfLang.SothoSouthern.code.lowercase() to IetfLang.SothoSouthern,
        IetfLang.Sundanese.code.lowercase() to IetfLang.Sundanese,
            IetfLang.Sundanese.Latn.code.lowercase() to IetfLang.Sundanese.Latn,
                IetfLang.Sundanese.Latn.ID.code.lowercase() to IetfLang.Sundanese.Latn.ID,
        IetfLang.Swedish.code.lowercase() to IetfLang.Swedish,
            IetfLang.Swedish.AX.code.lowercase() to IetfLang.Swedish.AX,
            IetfLang.Swedish.FI.code.lowercase() to IetfLang.Swedish.FI,
            IetfLang.Swedish.SE.code.lowercase() to IetfLang.Swedish.SE,
        IetfLang.Swahili.code.lowercase() to IetfLang.Swahili,
            IetfLang.Swahili.CD.code.lowercase() to IetfLang.Swahili.CD,
            IetfLang.Swahili.KE.code.lowercase() to IetfLang.Swahili.KE,
            IetfLang.Swahili.TZ.code.lowercase() to IetfLang.Swahili.TZ,
            IetfLang.Swahili.UG.code.lowercase() to IetfLang.Swahili.UG,
        IetfLang.Tamil.code.lowercase() to IetfLang.Tamil,
            IetfLang.Tamil.IN.code.lowercase() to IetfLang.Tamil.IN,
            IetfLang.Tamil.LK.code.lowercase() to IetfLang.Tamil.LK,
            IetfLang.Tamil.MY.code.lowercase() to IetfLang.Tamil.MY,
            IetfLang.Tamil.SG.code.lowercase() to IetfLang.Tamil.SG,
        IetfLang.Telugu.code.lowercase() to IetfLang.Telugu,
            IetfLang.Telugu.IN.code.lowercase() to IetfLang.Telugu.IN,
        IetfLang.Tajik.code.lowercase() to IetfLang.Tajik,
            IetfLang.Tajik.TJ.code.lowercase() to IetfLang.Tajik.TJ,
        IetfLang.Thai.code.lowercase() to IetfLang.Thai,
            IetfLang.Thai.TH.code.lowercase() to IetfLang.Thai.TH,
        IetfLang.Tigrinya.code.lowercase() to IetfLang.Tigrinya,
            IetfLang.Tigrinya.ER.code.lowercase() to IetfLang.Tigrinya.ER,
            IetfLang.Tigrinya.ET.code.lowercase() to IetfLang.Tigrinya.ET,
        IetfLang.Turkmen.code.lowercase() to IetfLang.Turkmen,
            IetfLang.Turkmen.TM.code.lowercase() to IetfLang.Turkmen.TM,
        IetfLang.Tagalog.code.lowercase() to IetfLang.Tagalog,
        IetfLang.Tswana.code.lowercase() to IetfLang.Tswana,
        IetfLang.TongaTongaIslands.code.lowercase() to IetfLang.TongaTongaIslands,
            IetfLang.TongaTongaIslands.TO.code.lowercase() to IetfLang.TongaTongaIslands.TO,
        IetfLang.Turkish.code.lowercase() to IetfLang.Turkish,
            IetfLang.Turkish.CY.code.lowercase() to IetfLang.Turkish.CY,
            IetfLang.Turkish.TR.code.lowercase() to IetfLang.Turkish.TR,
        IetfLang.Tsonga.code.lowercase() to IetfLang.Tsonga,
        IetfLang.Tatar.code.lowercase() to IetfLang.Tatar,
            IetfLang.Tatar.RU.code.lowercase() to IetfLang.Tatar.RU,
        IetfLang.Twi.code.lowercase() to IetfLang.Twi,
        IetfLang.Tahitian.code.lowercase() to IetfLang.Tahitian,
        IetfLang.UighurUyghur.code.lowercase() to IetfLang.UighurUyghur,
            IetfLang.UighurUyghur.CN.code.lowercase() to IetfLang.UighurUyghur.CN,
        IetfLang.Ukrainian.code.lowercase() to IetfLang.Ukrainian,
            IetfLang.Ukrainian.UA.code.lowercase() to IetfLang.Ukrainian.UA,
        IetfLang.Urdu.code.lowercase() to IetfLang.Urdu,
            IetfLang.Urdu.IN.code.lowercase() to IetfLang.Urdu.IN,
            IetfLang.Urdu.PK.code.lowercase() to IetfLang.Urdu.PK,
        IetfLang.Uzbek.code.lowercase() to IetfLang.Uzbek,
            IetfLang.Uzbek.Arab.code.lowercase() to IetfLang.Uzbek.Arab,
                IetfLang.Uzbek.Arab.AF.code.lowercase() to IetfLang.Uzbek.Arab.AF,
            IetfLang.Uzbek.Cyrl.code.lowercase() to IetfLang.Uzbek.Cyrl,
                IetfLang.Uzbek.Cyrl.UZ.code.lowercase() to IetfLang.Uzbek.Cyrl.UZ,
            IetfLang.Uzbek.Latn.code.lowercase() to IetfLang.Uzbek.Latn,
                IetfLang.Uzbek.Latn.UZ.code.lowercase() to IetfLang.Uzbek.Latn.UZ,
        IetfLang.Venda.code.lowercase() to IetfLang.Venda,
        IetfLang.Vietnamese.code.lowercase() to IetfLang.Vietnamese,
            IetfLang.Vietnamese.VN.code.lowercase() to IetfLang.Vietnamese.VN,
        IetfLang.Volapuk.code.lowercase() to IetfLang.Volapuk,
            IetfLang.Volapuk.L001.code.lowercase() to IetfLang.Volapuk.L001,
        IetfLang.Walloon.code.lowercase() to IetfLang.Walloon,
        IetfLang.Wolof.code.lowercase() to IetfLang.Wolof,
            IetfLang.Wolof.SN.code.lowercase() to IetfLang.Wolof.SN,
        IetfLang.Xhosa.code.lowercase() to IetfLang.Xhosa,
            IetfLang.Xhosa.ZA.code.lowercase() to IetfLang.Xhosa.ZA,
        IetfLang.Yiddish.code.lowercase() to IetfLang.Yiddish,
            IetfLang.Yiddish.L001.code.lowercase() to IetfLang.Yiddish.L001,
        IetfLang.Yoruba.code.lowercase() to IetfLang.Yoruba,
            IetfLang.Yoruba.BJ.code.lowercase() to IetfLang.Yoruba.BJ,
            IetfLang.Yoruba.NG.code.lowercase() to IetfLang.Yoruba.NG,
        IetfLang.ZhuangChuang.code.lowercase() to IetfLang.ZhuangChuang,
        IetfLang.Chinese.code.lowercase() to IetfLang.Chinese,
            IetfLang.Chinese.Hans.code.lowercase() to IetfLang.Chinese.Hans,
                IetfLang.Chinese.Hans.CN.code.lowercase() to IetfLang.Chinese.Hans.CN,
                IetfLang.Chinese.Hans.HK.code.lowercase() to IetfLang.Chinese.Hans.HK,
                IetfLang.Chinese.Hans.MO.code.lowercase() to IetfLang.Chinese.Hans.MO,
                IetfLang.Chinese.Hans.SG.code.lowercase() to IetfLang.Chinese.Hans.SG,
            IetfLang.Chinese.Hant.code.lowercase() to IetfLang.Chinese.Hant,
                IetfLang.Chinese.Hant.HK.code.lowercase() to IetfLang.Chinese.Hant.HK,
                IetfLang.Chinese.Hant.MO.code.lowercase() to IetfLang.Chinese.Hant.MO,
                IetfLang.Chinese.Hant.TW.code.lowercase() to IetfLang.Chinese.Hant.TW,
        IetfLang.Zulu.code.lowercase() to IetfLang.Zulu,
            IetfLang.Zulu.ZA.code.lowercase() to IetfLang.Zulu.ZA
    )
}
val knownLanguageCodes: List<IetfLang> by lazy {
    knownLanguageCodesMap.values.toList()
}

fun String.asIetfLang(): IetfLang {
    return knownLanguageCodesMap[this] ?: IetfLang.UnknownIetfLang(this)
}
fun String.asIetfLangCaseInsensitive(): IetfLang {
    return knownLanguageCodesMapByLowerCasedKeys[this.lowercase()] ?: IetfLang.UnknownIetfLang(this)
}
@Deprecated("Renamed", ReplaceWith("this.asIetfLang()", "dev.inmo.micro_utils.language_codes.asIetfLang"))
fun String.asIetfLanguageCode(): IetfLang = asIetfLang()

fun convertToIetfLang(code: String) = code.asIetfLang()
fun convertToIetfLangCaseInsensitive(code: String) = code.asIetfLangCaseInsensitive()
@Deprecated("Renamed", ReplaceWith("convertToIetfLang(code)", "dev.inmo.micro_utils.language_codes.convertToIetfLang"))
fun convertToIetfLanguageCode(code: String) = convertToIetfLang(code)

fun IetfLang(code: String) = code.asIetfLang()
fun IetfLangCaseInsensitive(code: String) = code.asIetfLangCaseInsensitive()
@Deprecated("Renamed", ReplaceWith("IetfLang(code)", "dev.inmo.micro_utils.language_codes.IetfLang"))
fun IetfLanguageCode(code: String) = IetfLang(code)
