(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlinx-serialization-kotlinx-serialization-core-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlinx-serialization-kotlinx-serialization-core-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'micro_utils-micro_utils.common-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'micro_utils-micro_utils.common-js-legacy'.");
    }if (typeof this['kotlinx-serialization-kotlinx-serialization-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'micro_utils-micro_utils.common-js-legacy'. Its dependency 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' is loaded prior to 'micro_utils-micro_utils.common-js-legacy'.");
    }root['micro_utils-micro_utils.common-js-legacy'] = factory(typeof this['micro_utils-micro_utils.common-js-legacy'] === 'undefined' ? {} : this['micro_utils-micro_utils.common-js-legacy'], kotlin, this['kotlinx-serialization-kotlinx-serialization-core-js-legacy']);
  }
}(this, function (_, Kotlin, $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Annotation = Kotlin.kotlin.Annotation;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var removeFirst = Kotlin.kotlin.collections.removeFirst_vvxzk3$;
  var wrapFunction = Kotlin.wrapFunction;
  var lastOrNull = Kotlin.kotlin.collections.lastOrNull_2p1efm$;
  var take = Kotlin.kotlin.collections.take_ba2ldo$;
  var equals = Kotlin.equals;
  var Pair = Kotlin.kotlin.Pair;
  var throwCCE = Kotlin.throwCCE;
  var drop = Kotlin.kotlin.collections.drop_ba2ldo$;
  var first = Kotlin.kotlin.collections.first_2p1efm$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var last = Kotlin.kotlin.collections.last_2p1efm$;
  var dropLast = Kotlin.kotlin.collections.dropLast_yzln2o$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var IndexedValue = Kotlin.kotlin.collections.IndexedValue;
  var toList = Kotlin.kotlin.collections.toList_7wnvza$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var ByteArraySerializer = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.builtins.ByteArraySerializer;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var KSerializer = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.KSerializer;
  Visible.prototype = Object.create(Visibility.prototype);
  Visible.prototype.constructor = Visible;
  Invisible.prototype = Object.create(Visibility.prototype);
  Invisible.prototype.constructor = Invisible;
  Gone.prototype = Object.create(Visibility.prototype);
  Gone.prototype.constructor = Gone;
  function PreviewFeature() {
  }
  PreviewFeature.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PreviewFeature',
    interfaces: [Annotation]
  };
  function Warning(message) {
    this.message = message;
  }
  Warning.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Warning',
    interfaces: [Annotation]
  };
  var clamp = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.clamp_99j3dd$', function ($receiver, min, max) {
    var tmp$;
    if (Kotlin.compareTo($receiver, min) < 0)
      tmp$ = min;
    else if (Kotlin.compareTo($receiver, max) > 0)
      tmp$ = max;
    else
      tmp$ = $receiver;
    return tmp$;
  });
  function getObject(additional, iterator) {
    if (!additional.isEmpty())
      return removeFirst(additional);
    else if (iterator.hasNext())
      return iterator.next();
    else
      return null;
  }
  function Diff(removed, replaced, added) {
    this.removed = removed;
    this.replaced = replaced;
    this.added = added;
  }
  Diff.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Diff',
    interfaces: []
  };
  Diff.prototype.component1 = function () {
    return this.removed;
  };
  Diff.prototype.component2 = function () {
    return this.replaced;
  };
  Diff.prototype.component3 = function () {
    return this.added;
  };
  Diff.prototype.copy_oclcws$ = function (removed, replaced, added) {
    return new Diff(removed === void 0 ? this.removed : removed, replaced === void 0 ? this.replaced : replaced, added === void 0 ? this.added : added);
  };
  Diff.prototype.toString = function () {
    return 'Diff(removed=' + Kotlin.toString(this.removed) + (', replaced=' + Kotlin.toString(this.replaced)) + (', added=' + Kotlin.toString(this.added)) + ')';
  };
  Diff.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.removed) | 0;
    result = result * 31 + Kotlin.hashCode(this.replaced) | 0;
    result = result * 31 + Kotlin.hashCode(this.added) | 0;
    return result;
  };
  Diff.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.removed, other.removed) && Kotlin.equals(this.replaced, other.replaced) && Kotlin.equals(this.added, other.added)))));
  };
  var performChanges = wrapFunction(function () {
    var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
    return function (potentialChanges, additionalsInOld, additionalsInNew, changedList, removedList, addedList, strictComparison) {
      var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6;
      var i = -1;
      tmp$ = lastOrNull(potentialChanges);
      if (tmp$ == null) {
        return;
      }var oldObject = tmp$.component1()
      , newObject = tmp$.component2();
      tmp$_0 = take(potentialChanges, potentialChanges.size - 1 | 0).iterator();
      while (tmp$_0.hasNext()) {
        var tmp$_7 = tmp$_0.next();
        var old = tmp$_7.component1()
        , new_0 = tmp$_7.component2();
        i = i + 1 | 0;
        var oldOneEqualToNewObject = (old != null ? old.value : null) === (newObject != null ? newObject.value : null) || (equals(old != null ? old.value : null, newObject != null ? newObject.value : null) && !strictComparison);
        var newOneEqualToOldObject = (new_0 != null ? new_0.value : null) === (oldObject != null ? oldObject.value : null) || (equals(new_0 != null ? new_0.value : null, oldObject != null ? oldObject.value : null) && !strictComparison);
        if (oldOneEqualToNewObject || newOneEqualToOldObject) {
          var $receiver = take(potentialChanges, i);
          var destination = ArrayList_init();
          var tmp$_8;
          tmp$_8 = $receiver.iterator();
          while (tmp$_8.hasNext()) {
            var element = tmp$_8.next();
            var tmp$_0_0;
            var tmp$_9;
            if ((tmp$_0_0 = element.first != null && element.second != null ? Kotlin.isType(tmp$_9 = element, Pair) ? tmp$_9 : throwCCE() : null) != null) {
              destination.add_11rb$(tmp$_0_0);
            }}
          changedList.addAll_brywnq$(destination);
          var newPotentials = take(drop(potentialChanges, i), potentialChanges.size - i | 0);
          if (oldOneEqualToNewObject) {
            if ((tmp$_1 = first(newPotentials).second) != null) {
              addedList.add_11rb$(tmp$_1);
            }var tmp$_10;
            tmp$_10 = take(drop(newPotentials, 1), newPotentials.size - 2 | 0).iterator();
            while (tmp$_10.hasNext()) {
              var element_0 = tmp$_10.next();
              var oldOne = element_0.component1()
              , newOne = element_0.component2();
              addedList.add_11rb$(ensureNotNull(newOne));
              if (oldOne != null) {
                additionalsInOld.add_11rb$(oldOne.value);
              }}
            if (newPotentials.size > 1) {
              if ((tmp$_3 = (tmp$_2 = last(newPotentials).first) != null ? tmp$_2.value : null) != null) {
                additionalsInOld.add_11rb$(tmp$_3);
              }}} else if (newOneEqualToOldObject) {
            if ((tmp$_4 = first(newPotentials).first) != null) {
              removedList.add_11rb$(tmp$_4);
            }var tmp$_11;
            tmp$_11 = take(drop(newPotentials, 1), newPotentials.size - 2 | 0).iterator();
            while (tmp$_11.hasNext()) {
              var element_1 = tmp$_11.next();
              var oldOne_0 = element_1.component1()
              , newOne_0 = element_1.component2();
              removedList.add_11rb$(ensureNotNull(oldOne_0));
              if (newOne_0 != null) {
                additionalsInNew.add_11rb$(newOne_0.value);
              }}
            if (newPotentials.size > 1) {
              if ((tmp$_6 = (tmp$_5 = last(newPotentials).second) != null ? tmp$_5.value : null) != null) {
                additionalsInNew.add_11rb$(tmp$_6);
              }}}potentialChanges.clear();
          return;
        }}
      var tmp$_12 = !potentialChanges.isEmpty();
      if (tmp$_12) {
        var it = last(potentialChanges);
        tmp$_12 = (it.first == null && it.second == null);
      }if (tmp$_12) {
        var tmp$_13;
        tmp$_13 = dropLast(potentialChanges, 1).iterator();
        while (tmp$_13.hasNext()) {
          var element_2 = tmp$_13.next();
          var old_0 = element_2.component1()
          , new_1 = element_2.component2();
          if (old_0 != null && new_1 != null)
            changedList.add_11rb$(to(old_0, new_1));
          else if (old_0 != null)
            removedList.add_11rb$(old_0);
          else if (new_1 != null)
            addedList.add_11rb$(new_1);
        }
      }};
  });
  function calculateDiff($receiver, other, strictComparison) {
    if (strictComparison === void 0)
      strictComparison = false;
    var i = {v: -1};
    var j = {v: -1};
    var additionalInOld = ArrayList_init();
    var additionalInNew = ArrayList_init();
    var oldIterator = $receiver.iterator();
    var newIterator = other.iterator();
    var potentiallyChangedObjects = ArrayList_init();
    var changedObjects = ArrayList_init();
    var addedObjects = ArrayList_init();
    var removedObjects = ArrayList_init();
    loop_label: while (true) {
      i.v = i.v + 1 | 0;
      j.v = j.v + 1 | 0;
      var getObject$result;
      if (!additionalInOld.isEmpty()) {
        getObject$result = removeFirst(additionalInOld);
      } else if (oldIterator.hasNext()) {
        getObject$result = oldIterator.next();
      } else {
        getObject$result = null;
      }
      var oldObject = getObject$result;
      var getObject$result_0;
      if (!additionalInNew.isEmpty()) {
        getObject$result_0 = removeFirst(additionalInNew);
      } else if (newIterator.hasNext()) {
        getObject$result_0 = newIterator.next();
      } else {
        getObject$result_0 = null;
      }
      var newObject = getObject$result_0;
      if (oldObject == null && newObject == null) {
        break loop_label;
      }if (oldObject === newObject || (equals(oldObject, newObject) && !strictComparison)) {
        var destination = ArrayList_init_0(collectionSizeOrDefault(potentiallyChangedObjects, 10));
        var tmp$;
        tmp$ = potentiallyChangedObjects.iterator();
        while (tmp$.hasNext()) {
          var item = tmp$.next();
          var tmp$_0;
          destination.add_11rb$(Kotlin.isType(tmp$_0 = item, Pair) ? tmp$_0 : throwCCE());
        }
        changedObjects.addAll_brywnq$(destination);
        potentiallyChangedObjects.clear();
      } else {
        potentiallyChangedObjects.add_11rb$(to(oldObject != null ? new IndexedValue(i.v, oldObject) : null, newObject != null ? new IndexedValue(j.v, newObject) : null));
        var previousOldsAdditionsSize = additionalInOld.size;
        var previousNewsAdditionsSize = additionalInNew.size;
        performChanges$break: do {
          var tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8;
          var i_0 = -1;
          tmp$_1 = lastOrNull(potentiallyChangedObjects);
          if (tmp$_1 == null) {
            break performChanges$break;
          }var oldObject_0 = tmp$_1.component1()
          , newObject_0 = tmp$_1.component2();
          tmp$_2 = take(potentiallyChangedObjects, potentiallyChangedObjects.size - 1 | 0).iterator();
          while (tmp$_2.hasNext()) {
            var tmp$_9 = tmp$_2.next();
            var old = tmp$_9.component1()
            , new_0 = tmp$_9.component2();
            i_0 = i_0 + 1 | 0;
            var oldOneEqualToNewObject = (old != null ? old.value : null) === (newObject_0 != null ? newObject_0.value : null) || (equals(old != null ? old.value : null, newObject_0 != null ? newObject_0.value : null) && !strictComparison);
            var newOneEqualToOldObject = (new_0 != null ? new_0.value : null) === (oldObject_0 != null ? oldObject_0.value : null) || (equals(new_0 != null ? new_0.value : null, oldObject_0 != null ? oldObject_0.value : null) && !strictComparison);
            if (oldOneEqualToNewObject || newOneEqualToOldObject) {
              var $receiver_0 = take(potentiallyChangedObjects, i_0);
              var destination_0 = ArrayList_init();
              var tmp$_10;
              tmp$_10 = $receiver_0.iterator();
              while (tmp$_10.hasNext()) {
                var element = tmp$_10.next();
                var tmp$_0_0;
                var tmp$_11;
                if ((tmp$_0_0 = element.first != null && element.second != null ? Kotlin.isType(tmp$_11 = element, Pair) ? tmp$_11 : throwCCE() : null) != null) {
                  destination_0.add_11rb$(tmp$_0_0);
                }}
              changedObjects.addAll_brywnq$(destination_0);
              var newPotentials = take(drop(potentiallyChangedObjects, i_0), potentiallyChangedObjects.size - i_0 | 0);
              if (oldOneEqualToNewObject) {
                if ((tmp$_3 = first(newPotentials).second) != null) {
                  addedObjects.add_11rb$(tmp$_3);
                }var tmp$_12;
                tmp$_12 = take(drop(newPotentials, 1), newPotentials.size - 2 | 0).iterator();
                while (tmp$_12.hasNext()) {
                  var element_0 = tmp$_12.next();
                  var oldOne = element_0.component1()
                  , newOne = element_0.component2();
                  addedObjects.add_11rb$(ensureNotNull(newOne));
                  if (oldOne != null) {
                    additionalInOld.add_11rb$(oldOne.value);
                  }}
                if (newPotentials.size > 1) {
                  if ((tmp$_5 = (tmp$_4 = last(newPotentials).first) != null ? tmp$_4.value : null) != null) {
                    additionalInOld.add_11rb$(tmp$_5);
                  }}} else if (newOneEqualToOldObject) {
                if ((tmp$_6 = first(newPotentials).first) != null) {
                  removedObjects.add_11rb$(tmp$_6);
                }var tmp$_13;
                tmp$_13 = take(drop(newPotentials, 1), newPotentials.size - 2 | 0).iterator();
                while (tmp$_13.hasNext()) {
                  var element_1 = tmp$_13.next();
                  var oldOne_0 = element_1.component1()
                  , newOne_0 = element_1.component2();
                  removedObjects.add_11rb$(ensureNotNull(oldOne_0));
                  if (newOne_0 != null) {
                    additionalInNew.add_11rb$(newOne_0.value);
                  }}
                if (newPotentials.size > 1) {
                  if ((tmp$_8 = (tmp$_7 = last(newPotentials).second) != null ? tmp$_7.value : null) != null) {
                    additionalInNew.add_11rb$(tmp$_8);
                  }}}potentiallyChangedObjects.clear();
              break performChanges$break;
            }}
          var tmp$_14 = !potentiallyChangedObjects.isEmpty();
          if (tmp$_14) {
            var it = last(potentiallyChangedObjects);
            tmp$_14 = (it.first == null && it.second == null);
          }if (tmp$_14) {
            var tmp$_15;
            tmp$_15 = dropLast(potentiallyChangedObjects, 1).iterator();
            while (tmp$_15.hasNext()) {
              var element_2 = tmp$_15.next();
              var old_0 = element_2.component1()
              , new_1 = element_2.component2();
              if (old_0 != null && new_1 != null)
                changedObjects.add_11rb$(to(old_0, new_1));
              else if (old_0 != null)
                removedObjects.add_11rb$(old_0);
              else if (new_1 != null)
                addedObjects.add_11rb$(new_1);
            }
          }}
         while (false);
        i.v = i.v - (additionalInOld.size - previousOldsAdditionsSize) | 0;
        j.v = j.v - (additionalInNew.size - previousNewsAdditionsSize) | 0;
      }
    }
    potentiallyChangedObjects.add_11rb$(to(null, null));
    performChanges$break: do {
      var tmp$_16, tmp$_17, tmp$_18, tmp$_19, tmp$_20, tmp$_21, tmp$_22, tmp$_23;
      var i_1 = -1;
      tmp$_16 = lastOrNull(potentiallyChangedObjects);
      if (tmp$_16 == null) {
        break performChanges$break;
      }var oldObject_1 = tmp$_16.component1()
      , newObject_1 = tmp$_16.component2();
      tmp$_17 = take(potentiallyChangedObjects, potentiallyChangedObjects.size - 1 | 0).iterator();
      while (tmp$_17.hasNext()) {
        var tmp$_24 = tmp$_17.next();
        var old_1 = tmp$_24.component1()
        , new_2 = tmp$_24.component2();
        i_1 = i_1 + 1 | 0;
        var oldOneEqualToNewObject_0 = (old_1 != null ? old_1.value : null) === (newObject_1 != null ? newObject_1.value : null) || (equals(old_1 != null ? old_1.value : null, newObject_1 != null ? newObject_1.value : null) && !strictComparison);
        var newOneEqualToOldObject_0 = (new_2 != null ? new_2.value : null) === (oldObject_1 != null ? oldObject_1.value : null) || (equals(new_2 != null ? new_2.value : null, oldObject_1 != null ? oldObject_1.value : null) && !strictComparison);
        if (oldOneEqualToNewObject_0 || newOneEqualToOldObject_0) {
          var $receiver_1 = take(potentiallyChangedObjects, i_1);
          var destination_1 = ArrayList_init();
          var tmp$_25;
          tmp$_25 = $receiver_1.iterator();
          while (tmp$_25.hasNext()) {
            var element_3 = tmp$_25.next();
            var tmp$_0_1;
            var tmp$_26;
            if ((tmp$_0_1 = element_3.first != null && element_3.second != null ? Kotlin.isType(tmp$_26 = element_3, Pair) ? tmp$_26 : throwCCE() : null) != null) {
              destination_1.add_11rb$(tmp$_0_1);
            }}
          changedObjects.addAll_brywnq$(destination_1);
          var newPotentials_0 = take(drop(potentiallyChangedObjects, i_1), potentiallyChangedObjects.size - i_1 | 0);
          if (oldOneEqualToNewObject_0) {
            if ((tmp$_18 = first(newPotentials_0).second) != null) {
              addedObjects.add_11rb$(tmp$_18);
            }var tmp$_27;
            tmp$_27 = take(drop(newPotentials_0, 1), newPotentials_0.size - 2 | 0).iterator();
            while (tmp$_27.hasNext()) {
              var element_4 = tmp$_27.next();
              var oldOne_1 = element_4.component1()
              , newOne_1 = element_4.component2();
              addedObjects.add_11rb$(ensureNotNull(newOne_1));
              if (oldOne_1 != null) {
                additionalInOld.add_11rb$(oldOne_1.value);
              }}
            if (newPotentials_0.size > 1) {
              if ((tmp$_20 = (tmp$_19 = last(newPotentials_0).first) != null ? tmp$_19.value : null) != null) {
                additionalInOld.add_11rb$(tmp$_20);
              }}} else if (newOneEqualToOldObject_0) {
            if ((tmp$_21 = first(newPotentials_0).first) != null) {
              removedObjects.add_11rb$(tmp$_21);
            }var tmp$_28;
            tmp$_28 = take(drop(newPotentials_0, 1), newPotentials_0.size - 2 | 0).iterator();
            while (tmp$_28.hasNext()) {
              var element_5 = tmp$_28.next();
              var oldOne_2 = element_5.component1()
              , newOne_2 = element_5.component2();
              removedObjects.add_11rb$(ensureNotNull(oldOne_2));
              if (newOne_2 != null) {
                additionalInNew.add_11rb$(newOne_2.value);
              }}
            if (newPotentials_0.size > 1) {
              if ((tmp$_23 = (tmp$_22 = last(newPotentials_0).second) != null ? tmp$_22.value : null) != null) {
                additionalInNew.add_11rb$(tmp$_23);
              }}}potentiallyChangedObjects.clear();
          break performChanges$break;
        }}
      var tmp$_29 = !potentiallyChangedObjects.isEmpty();
      if (tmp$_29) {
        var it_0 = last(potentiallyChangedObjects);
        tmp$_29 = (it_0.first == null && it_0.second == null);
      }if (tmp$_29) {
        var tmp$_30;
        tmp$_30 = dropLast(potentiallyChangedObjects, 1).iterator();
        while (tmp$_30.hasNext()) {
          var element_6 = tmp$_30.next();
          var old_2 = element_6.component1()
          , new_3 = element_6.component2();
          if (old_2 != null && new_3 != null)
            changedObjects.add_11rb$(to(old_2, new_3));
          else if (old_2 != null)
            removedObjects.add_11rb$(old_2);
          else if (new_3 != null)
            addedObjects.add_11rb$(new_3);
        }
      }}
     while (false);
    return new Diff(toList(removedObjects), toList(changedObjects), toList(addedObjects));
  }
  var Diff_0 = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.Diff_yxozss$', wrapFunction(function () {
    var calculateDiff = _.dev.inmo.micro_utils.common.calculateDiff_gv9mea$;
    return function (old, new_0) {
      return calculateDiff(old, new_0);
    };
  }));
  var StrictDiff = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.StrictDiff_yxozss$', wrapFunction(function () {
    var calculateDiff = _.dev.inmo.micro_utils.common.calculateDiff_gv9mea$;
    return function (old, new_0) {
      return calculateDiff(old, new_0, true);
    };
  }));
  var calculateStrictDiff = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.calculateStrictDiff_q4559j$', wrapFunction(function () {
    var calculateDiff = _.dev.inmo.micro_utils.common.calculateDiff_gv9mea$;
    return function ($receiver, other) {
      return calculateDiff($receiver, other, true);
    };
  }));
  function get_asAllocator$lambda(this$asAllocator) {
    return function () {
      return this$asAllocator;
    };
  }
  function get_asAllocator($receiver) {
    return get_asAllocator$lambda($receiver);
  }
  function ByteArrayAllocatorSerializer() {
    ByteArrayAllocatorSerializer_instance = this;
    this.realSerializer_0 = ByteArraySerializer();
    this.descriptor_eas4py$_0 = this.realSerializer_0.descriptor;
  }
  Object.defineProperty(ByteArrayAllocatorSerializer.prototype, 'descriptor', {
    configurable: true,
    get: function () {
      return this.descriptor_eas4py$_0;
    }
  });
  function ByteArrayAllocatorSerializer$deserialize$lambda(closure$bytes) {
    return function () {
      return closure$bytes;
    };
  }
  ByteArrayAllocatorSerializer.prototype.deserialize_bq71mq$ = function (decoder) {
    var bytes = this.realSerializer_0.deserialize_bq71mq$(decoder);
    return ByteArrayAllocatorSerializer$deserialize$lambda(bytes);
  };
  ByteArrayAllocatorSerializer.prototype.serialize_55azsf$ = function (encoder, value) {
    this.realSerializer_0.serialize_55azsf$(encoder, value());
  };
  ByteArrayAllocatorSerializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ByteArrayAllocatorSerializer',
    interfaces: [KSerializer]
  };
  var ByteArrayAllocatorSerializer_instance = null;
  function ByteArrayAllocatorSerializer_getInstance() {
    if (ByteArrayAllocatorSerializer_instance === null) {
      new ByteArrayAllocatorSerializer();
    }return ByteArrayAllocatorSerializer_instance;
  }
  function toByteArray($receiver) {
    var array = new Int8Array($receiver.byteLength);
    var tmp$;
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      array[i] = $receiver.getInt8(i);
    }
    return array;
  }
  function toByteArray_0($receiver) {
    var tmp$;
    return Kotlin.isByteArray(tmp$ = new Int8Array($receiver)) ? tmp$ : throwCCE();
  }
  function toDataView($receiver) {
    var $receiver_0 = new DataView(new ArrayBuffer($receiver.length));
    var tmp$, tmp$_0;
    var index = 0;
    for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
      var item = $receiver[tmp$];
      $receiver_0.setInt8((tmp$_0 = index, index = tmp$_0 + 1 | 0, tmp$_0), item);
    }
    return $receiver_0;
  }
  function toArrayBuffer($receiver) {
    return toDataView($receiver).buffer;
  }
  function get_isOnScreenByLeftEdge($receiver) {
    return $receiver.left >= 0 && $receiver.left <= window.innerWidth;
  }
  var get_isOnScreenByLeftEdge_0 = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.get_isOnScreenByLeftEdge_ejp6nk$', wrapFunction(function () {
    var get_isOnScreenByLeftEdge = _.dev.inmo.micro_utils.common.get_isOnScreenByLeftEdge_gf0w06$;
    return function ($receiver) {
      return get_isOnScreenByLeftEdge($receiver.getBoundingClientRect());
    };
  }));
  function get_isOnScreenByRightEdge($receiver) {
    return $receiver.right >= 0 && $receiver.right <= window.innerWidth;
  }
  var get_isOnScreenByRightEdge_0 = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.get_isOnScreenByRightEdge_ejp6nk$', wrapFunction(function () {
    var get_isOnScreenByRightEdge = _.dev.inmo.micro_utils.common.get_isOnScreenByRightEdge_gf0w06$;
    return function ($receiver) {
      return get_isOnScreenByRightEdge($receiver.getBoundingClientRect());
    };
  }));
  function get_isOnScreenHorizontally($receiver) {
    return get_isOnScreenByLeftEdge($receiver) || get_isOnScreenByRightEdge($receiver);
  }
  function get_isOnScreenByTopEdge($receiver) {
    return $receiver.top >= 0 && $receiver.top <= window.innerHeight;
  }
  var get_isOnScreenByTopEdge_0 = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.get_isOnScreenByTopEdge_ejp6nk$', wrapFunction(function () {
    var get_isOnScreenByTopEdge = _.dev.inmo.micro_utils.common.get_isOnScreenByTopEdge_gf0w06$;
    return function ($receiver) {
      return get_isOnScreenByTopEdge($receiver.getBoundingClientRect());
    };
  }));
  function get_isOnScreenByBottomEdge($receiver) {
    return $receiver.bottom >= 0 && $receiver.bottom <= window.innerHeight;
  }
  var get_isOnScreenByBottomEdge_0 = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.get_isOnScreenByBottomEdge_ejp6nk$', wrapFunction(function () {
    var get_isOnScreenByBottomEdge = _.dev.inmo.micro_utils.common.get_isOnScreenByBottomEdge_gf0w06$;
    return function ($receiver) {
      return get_isOnScreenByBottomEdge($receiver.getBoundingClientRect());
    };
  }));
  function get_isOnScreenVertically($receiver) {
    return get_isOnScreenByLeftEdge($receiver) || get_isOnScreenByRightEdge($receiver);
  }
  function get_isOnScreenFully($receiver) {
    return get_isOnScreenByLeftEdge($receiver) && get_isOnScreenByTopEdge($receiver) && get_isOnScreenByRightEdge($receiver) && get_isOnScreenByBottomEdge($receiver);
  }
  function get_isOnScreenFully_0($receiver) {
    return get_isOnScreenFully($receiver.getBoundingClientRect());
  }
  function get_isOnScreen($receiver) {
    return get_isOnScreenFully($receiver) || (get_isOnScreenHorizontally($receiver) && get_isOnScreenVertically($receiver));
  }
  var get_isOnScreen_0 = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.get_isOnScreen_ejp6nk$', wrapFunction(function () {
    var get_isOnScreen = _.dev.inmo.micro_utils.common.get_isOnScreen_gf0w06$;
    return function ($receiver) {
      return get_isOnScreen($receiver.getBoundingClientRect());
    };
  }));
  function Visibility() {
  }
  Visibility.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Visibility',
    interfaces: []
  };
  function Visible() {
    Visible_instance = this;
    Visibility.call(this);
  }
  Visible.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Visible',
    interfaces: [Visibility]
  };
  var Visible_instance = null;
  function Visible_getInstance() {
    if (Visible_instance === null) {
      new Visible();
    }return Visible_instance;
  }
  function Invisible() {
    Invisible_instance = this;
    Visibility.call(this);
  }
  Invisible.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Invisible',
    interfaces: [Visibility]
  };
  var Invisible_instance = null;
  function Invisible_getInstance() {
    if (Invisible_instance === null) {
      new Invisible();
    }return Invisible_instance;
  }
  function Gone() {
    Gone_instance = this;
    Visibility.call(this);
  }
  Gone.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Gone',
    interfaces: [Visibility]
  };
  var Gone_instance = null;
  function Gone_getInstance() {
    if (Gone_instance === null) {
      new Gone();
    }return Gone_instance;
  }
  function get_visibilityState($receiver) {
    if (equals($receiver.display, 'none'))
      return Gone_getInstance();
    else if (equals($receiver.visibility, 'hidden'))
      return Invisible_getInstance();
    else
      return Visible_getInstance();
  }
  function set_visibilityState($receiver, value) {
    if (equals(value, Visible_getInstance())) {
      if (equals($receiver.display, 'none')) {
        $receiver.display = 'initial';
      }$receiver.visibility = 'visible';
    } else if (equals(value, Invisible_getInstance())) {
      if (equals($receiver.display, 'none')) {
        $receiver.display = 'initial';
      }$receiver.visibility = 'hidden';
    } else if (equals(value, Gone_getInstance()))
      $receiver.display = 'none';
  }
  var get_visibilityState_0 = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.get_visibilityState_ejp6nk$', wrapFunction(function () {
    var get_visibilityState = _.dev.inmo.micro_utils.common.get_visibilityState_b8w5wr$;
    return function ($receiver) {
      return get_visibilityState(window.getComputedStyle($receiver));
    };
  }));
  var set_visibilityState_0 = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.set_visibilityState_85r5z5$', wrapFunction(function () {
    var set_visibilityState = _.dev.inmo.micro_utils.common.set_visibilityState_thre5i$;
    return function ($receiver, value) {
      set_visibilityState(window.getComputedStyle($receiver), value);
    };
  }));
  var get_isVisible = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.get_isVisible_ejp6nk$', wrapFunction(function () {
    var common = _.dev.inmo.micro_utils.common;
    var equals = Kotlin.equals;
    var get_visibilityState = _.dev.inmo.micro_utils.common.get_visibilityState_b8w5wr$;
    return function ($receiver) {
      return equals(get_visibilityState(window.getComputedStyle($receiver)), common.Visible);
    };
  }));
  var get_isInvisible = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.get_isInvisible_ejp6nk$', wrapFunction(function () {
    var common = _.dev.inmo.micro_utils.common;
    var equals = Kotlin.equals;
    var get_visibilityState = _.dev.inmo.micro_utils.common.get_visibilityState_b8w5wr$;
    return function ($receiver) {
      return equals(get_visibilityState(window.getComputedStyle($receiver)), common.Invisible);
    };
  }));
  var get_isGone = defineInlineFunction('micro_utils-micro_utils.common-js-legacy.dev.inmo.micro_utils.common.get_isGone_ejp6nk$', wrapFunction(function () {
    var common = _.dev.inmo.micro_utils.common;
    var equals = Kotlin.equals;
    var get_visibilityState = _.dev.inmo.micro_utils.common.get_visibilityState_b8w5wr$;
    return function ($receiver) {
      return equals(get_visibilityState(window.getComputedStyle($receiver)), common.Gone);
    };
  }));
  var package$dev = _.dev || (_.dev = {});
  var package$inmo = package$dev.inmo || (package$dev.inmo = {});
  var package$micro_utils = package$inmo.micro_utils || (package$inmo.micro_utils = {});
  var package$common = package$micro_utils.common || (package$micro_utils.common = {});
  package$common.PreviewFeature = PreviewFeature;
  package$common.Warning = Warning;
  package$common.clamp_99j3dd$ = clamp;
  package$common.Diff = Diff;
  $$importsForInline$$['micro_utils-micro_utils.common-js-legacy'] = _;
  package$common.calculateDiff_gv9mea$ = calculateDiff;
  package$common.Diff_yxozss$ = Diff_0;
  package$common.StrictDiff_yxozss$ = StrictDiff;
  package$common.calculateStrictDiff_q4559j$ = calculateStrictDiff;
  package$common.get_asAllocator_964n91$ = get_asAllocator;
  Object.defineProperty(package$common, 'ByteArrayAllocatorSerializer', {
    get: ByteArrayAllocatorSerializer_getInstance
  });
  package$common.toByteArray_t4ci45$ = toByteArray;
  package$common.toByteArray_qfdq9h$ = toByteArray_0;
  package$common.toDataView_964n91$ = toDataView;
  package$common.toArrayBuffer_964n91$ = toArrayBuffer;
  package$common.get_isOnScreenByLeftEdge_gf0w06$ = get_isOnScreenByLeftEdge;
  package$common.get_isOnScreenByLeftEdge_ejp6nk$ = get_isOnScreenByLeftEdge_0;
  package$common.get_isOnScreenByRightEdge_gf0w06$ = get_isOnScreenByRightEdge;
  package$common.get_isOnScreenByRightEdge_ejp6nk$ = get_isOnScreenByRightEdge_0;
  package$common.get_isOnScreenHorizontally_fm35pf$ = get_isOnScreenHorizontally;
  package$common.get_isOnScreenByTopEdge_gf0w06$ = get_isOnScreenByTopEdge;
  package$common.get_isOnScreenByTopEdge_ejp6nk$ = get_isOnScreenByTopEdge_0;
  package$common.get_isOnScreenByBottomEdge_gf0w06$ = get_isOnScreenByBottomEdge;
  package$common.get_isOnScreenByBottomEdge_ejp6nk$ = get_isOnScreenByBottomEdge_0;
  package$common.get_isOnScreenVertically_fm35pf$ = get_isOnScreenVertically;
  package$common.get_isOnScreenFully_gf0w06$ = get_isOnScreenFully;
  package$common.get_isOnScreenFully_ejp6nk$ = get_isOnScreenFully_0;
  package$common.get_isOnScreen_gf0w06$ = get_isOnScreen;
  package$common.get_isOnScreen_ejp6nk$ = get_isOnScreen_0;
  package$common.Visibility = Visibility;
  Object.defineProperty(package$common, 'Visible', {
    get: Visible_getInstance
  });
  Object.defineProperty(package$common, 'Invisible', {
    get: Invisible_getInstance
  });
  Object.defineProperty(package$common, 'Gone', {
    get: Gone_getInstance
  });
  package$common.get_visibilityState_b8w5wr$ = get_visibilityState;
  package$common.set_visibilityState_thre5i$ = set_visibilityState;
  package$common.get_visibilityState_ejp6nk$ = get_visibilityState_0;
  package$common.set_visibilityState_85r5z5$ = set_visibilityState_0;
  package$common.get_isVisible_ejp6nk$ = get_isVisible;
  package$common.get_isInvisible_ejp6nk$ = get_isInvisible;
  package$common.get_isGone_ejp6nk$ = get_isGone;
  Kotlin.defineModule('micro_utils-micro_utils.common-js-legacy', _);
  return _;
}));

//# sourceMappingURL=micro_utils-micro_utils.common-js-legacy.js.map
