/*
 * Decompiled with CFR 0.152.
 */
package dev.id2r.api.spigot.plugin;

import dev.id2r.api.common.platform.Platform;
import dev.id2r.api.common.plugin.bootstrap.ID2RPluginBootstrap;
import dev.id2r.api.common.plugin.bootstrap.LoaderBootstrap;
import dev.id2r.api.common.plugin.logging.JUtilPluginLogger;
import dev.id2r.api.common.plugin.logging.PluginLogger;
import dev.id2r.api.common.plugin.task.AbstractJavaTask;
import dev.id2r.api.common.plugin.task.TaskFactory;
import dev.id2r.api.spigot.plugin.SpigotPlugin;
import dev.id2r.api.spigot.plugin.SpigotTaskAdapter;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SpigotBootstrap
implements ID2RPluginBootstrap,
LoaderBootstrap {
    private final Plugin loader;
    private final SpigotPlugin plugin;
    private final AbstractJavaTask taskAdapter;
    private PluginLogger logger;
    private Instant startTime;

    public SpigotBootstrap(Plugin loader, SpigotPlugin plugin) {
        this.loader = loader;
        this.plugin = plugin;
        this.taskAdapter = new SpigotTaskAdapter(this);
    }

    public Plugin getLoader() {
        return this.loader;
    }

    public Server getServer() {
        return this.loader.getServer();
    }

    public void load() {
        this.logger = new JUtilPluginLogger(this.loader.getLogger());
        this.startTime = Instant.now();
        this.plugin.onLoad();
    }

    public void enable() {
        this.plugin.onEnable();
    }

    public void disable() {
        this.plugin.onDisable();
    }

    public PluginLogger getLogger() {
        return this.logger;
    }

    public TaskFactory getTaskFactory() {
        return this.taskAdapter;
    }

    public String getVersion() {
        return this.getServer().getVersion();
    }

    public Instant getStartupTime() {
        return this.startTime;
    }

    public Platform.Type getPlatformType() {
        return Platform.Type.BUKKIT;
    }

    public Path getDataDirectory() {
        return this.loader.getDataFolder().toPath().toAbsolutePath();
    }

    public int getPlayerCount() {
        return this.getServer().getOnlinePlayers().size();
    }

    public Collection<String> getPlayerList() {
        Collection players = this.getServer().getOnlinePlayers();
        ArrayList<String> list = new ArrayList<String>(players.size());
        for (Player player : players) {
            list.add(player.getName());
        }
        return list;
    }

    public Collection<UUID> getOnlinePlayers() {
        Collection players = this.getServer().getOnlinePlayers();
        ArrayList<UUID> list = new ArrayList<UUID>(players.size());
        for (Player player : players) {
            list.add(player.getUniqueId());
        }
        return list;
    }

    public boolean isPlayerOnline(UUID uniqueId) {
        Player player = this.getServer().getPlayer(uniqueId);
        return player != null && player.isOnline();
    }

    public Optional<Player> getPlayer(UUID uuid) {
        return Optional.ofNullable(this.getServer().getPlayer(uuid));
    }
}

