/*
 * Decompiled with CFR 0.152.
 */
package dev.id2r.api.common.placeholder.replacer;

import dev.id2r.api.common.placeholder.Placeholder;
import dev.id2r.api.common.placeholder.replacer.Replacer;
import java.util.function.Function;

public class CharsReplacer
implements Replacer {
    @Override
    public String apply(String text, Function<String, Placeholder> lookup) {
        char[] chars = text.toCharArray();
        StringBuilder builder = new StringBuilder();
        StringBuilder identifier = new StringBuilder();
        StringBuilder parameter = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char l = chars[i];
            if (l == '&' && ++i < chars.length) {
                char color = chars[i];
                if ("0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(i) > -1) {
                    builder.append('\u00a7').append(color);
                    continue;
                }
                builder.append(l).append(color);
                continue;
            }
            if (l == '%') {
                boolean detect = false;
                boolean hadSpace = false;
                boolean hasClosure = false;
                while (++i < chars.length) {
                    char n = chars[i];
                    if (n == '%') {
                        hasClosure = true;
                        break;
                    }
                    if (n == ' ' && !detect) {
                        hadSpace = true;
                        break;
                    }
                    if (n != '_') {
                        if (!detect) {
                            identifier.append(n);
                            continue;
                        }
                        parameter.append(n);
                        continue;
                    }
                    detect = true;
                }
                if (!hasClosure) {
                    builder.append("%").append((CharSequence)identifier);
                    if (detect) {
                        builder.append('_').append((CharSequence)parameter);
                    }
                    if (hadSpace) {
                        builder.append(' ');
                    }
                } else {
                    Placeholder placeholder = lookup.apply(identifier.toString());
                    if (placeholder != null) {
                        builder.append(placeholder.onRequest(parameter.toString()));
                    } else {
                        builder.append("%").append((CharSequence)identifier).append("_").append((CharSequence)parameter).append("%");
                    }
                }
                identifier.setLength(0);
                parameter.setLength(0);
                continue;
            }
            builder.append(l);
        }
        return builder.toString();
    }
}

