/*
 * Decompiled with CFR 0.152.
 */
package dev.id2r.api.common.plugin.bootstrap;

import com.google.common.collect.ImmutableSet;
import dev.id2r.api.common.dependency.Dependencies;
import dev.id2r.api.common.dependency.DynamicDependency;
import dev.id2r.api.common.platform.Platform;
import dev.id2r.api.common.plugin.logging.PluginLogger;
import dev.id2r.api.common.plugin.task.TaskFactory;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;

public interface ID2RPluginBootstrap {
    public PluginLogger getLogger();

    public TaskFactory getTaskFactory();

    default public ImmutableSet<DynamicDependency> getRequiredDependencies() {
        return ImmutableSet.builder().add((Object)Dependencies.CONFIGME.create()).add((Object)Dependencies.SLF4J.create()).add((Object)Dependencies.HIKARICP.create()).add((Object)Dependencies.GSON.create()).add((Object)Dependencies.AGRONA.create()).add((Object)Dependencies.MONGODB_DRIVER.create()).add((Object)Dependencies.HIKARICP.create()).build();
    }

    public String getVersion();

    public Instant getStartupTime();

    public Platform.Type getPlatformType();

    public Path getDataDirectory();

    default public InputStream getResourceStream(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    public int getPlayerCount();

    public Collection<String> getPlayerList();

    public Collection<UUID> getOnlinePlayers();

    public boolean isPlayerOnline(UUID var1);

    public Optional<?> getPlayer(UUID var1);
}

