/*
 * Decompiled with CFR 0.152.
 */
package dev.id2r.api.common.dependency;

import dev.id2r.api.common.dependency.Vendors;
import dev.id2r.api.common.dependency.relocation.Relocation;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;

public class DynamicDependency {
    private final String artifactId;
    private final String groupId;
    private final String version;
    private final String vendor;
    private final String path;
    private final String relocatedPath;
    private final Collection<Relocation> relocations;
    private final byte[] checkSum;

    private DynamicDependency(Builder builder) {
        this.artifactId = builder.artifactId;
        this.groupId = builder.groupId;
        this.version = builder.version;
        this.vendor = builder.vendor;
        this.checkSum = Base64.getDecoder().decode(builder.checkSum);
        this.relocations = !builder.relocations.isEmpty() ? Collections.unmodifiableList(new LinkedList(builder.relocations)) : Collections.emptyList();
        String path = this.groupId.replace('.', '/') + '/' + this.artifactId + '/' + this.version + '/' + this.artifactId + '-' + this.version;
        if (builder.classifier != null) {
            path = path + '-' + builder.classifier;
        }
        this.path = path + ".jar";
        this.relocatedPath = this.hasRelocations() ? path + "-relocated.jar" : null;
    }

    public String getVendor() {
        return this.vendor;
    }

    public boolean hasRelocations() {
        return !this.relocations.isEmpty();
    }

    public String getRelocatedPath() {
        return this.relocatedPath;
    }

    public byte[] getCheckSum() {
        return this.checkSum;
    }

    public String getPath() {
        return this.path;
    }

    public Collection<Relocation> getRelocations() {
        return this.relocations;
    }

    public String url() {
        return String.format("%s%s/%s/%s/%s-%s.jar", this.vendor.endsWith("/") ? this.vendor : this.vendor + "/", this.rewriteEscaping(this.groupId).replace(".", "/"), this.rewriteEscaping(this.artifactId), this.version, this.rewriteEscaping(this.artifactId), this.version);
    }

    private String rewriteEscaping(String s) {
        return s.replace("{}", ".");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String artifactId;
        private String groupId;
        private String version;
        private String vendor;
        private String checkSum;
        private String classifier;
        private final Collection<Relocation> relocations = new LinkedList<Relocation>();

        private Builder() {
            this.vendor(Vendors.MAVEN);
        }

        public Builder info(String group, String artifact, String ver) {
            this.groupId = group;
            this.artifactId = artifact;
            this.version = ver;
            return this;
        }

        public Builder classifier(String val) {
            this.classifier = val;
            return this;
        }

        public Builder vendor(Vendors predefined) {
            this.vendor = predefined.getUrl();
            return this;
        }

        public Builder vendor(String url) {
            this.vendor = url;
            return this;
        }

        public Builder checkSum(String val) {
            this.checkSum = val;
            return this;
        }

        public Builder relocate(Relocation relocation) {
            this.relocations.add(Objects.requireNonNull(relocation, "relocation"));
            return this;
        }

        public Builder relocate(String pattern, String relocatedPattern) {
            return this.relocate(new Relocation(pattern, relocatedPattern));
        }

        public DynamicDependency create() {
            return new DynamicDependency(this);
        }
    }
}

